/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.jdbc;

import com.esproc.dql.Request;
import com.esproc.dql.Response;
import com.esproc.dql.jdbc.DQLUtil;
import com.esproc.dql.server.RemoteCursor;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Sequence;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DQLClient {
    private String[] _$8;
    private int[] _$7;
    private boolean _$6 = false;
    private String _$5 = null;
    private String _$4 = null;
    private String _$3 = null;
    ArrayList<RemoteCursor> _$2 = new ArrayList();
    HashMap<Integer, Integer> _$1 = new HashMap();

    public DQLClient(String host, int port) {
        this._$8 = new String[]{host};
        this._$7 = new int[]{port};
    }

    public DQLClient(String[] hosts, int[] ports) {
        this._$8 = hosts;
        this._$7 = ports;
    }

    public static void writeInt(OutputStream out, int size) throws Exception {
        out.write(size >>> 24);
        out.write(size >>> 16);
        out.write(size >>> 8);
        out.write(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAlive(String host, int port) {
        Socket s = null;
        try {
            s = new Socket(host, port);
            OutputStream os = s.getOutputStream();
            DQLClient.writeInt(os, -2);
            boolean bl = true;
            return bl;
        }
        catch (Exception x) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private Socket _$1(int hIndex) throws Exception {
        int index = hIndex >= 0 ? hIndex : this._$3();
        if (index < 0) {
            throw new SQLException("Can not establish a connection to [" + this + "]");
        }
        return new Socket(this._$8[index], this._$7[index]);
    }

    private int _$3() {
        int c = this._$8.length;
        if (c == 1) {
            return 0;
        }
        Request r = new Request();
        r.setGetConnectionCount(true);
        int index = -1;
        int min = 0;
        for (int i = 0; i < c; ++i) {
            try {
                Socket s = new Socket(this._$8[i], this._$7[i]);
                Response res = this._$1(r, s);
                int num = ((Number)res.getAttr(Request.CONNECTION_COUNT)).intValue();
                if (min != 0 && num >= min) continue;
                index = i;
                min = num;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return index;
    }

    private Response _$1(Request req) {
        int c = this._$8.length;
        StringBuffer err_buff = new StringBuffer();
        for (int i = 0; i < c; ++i) {
            if (!DQLClient.isAlive(this._$8[i], this._$7[i])) {
                err_buff.append(this._$8[i] + ":" + this._$7[i] + " is not on service." + DQLUtil.getLineSeparator());
                continue;
            }
            try {
                Socket s = new Socket(this._$8[i], this._$7[i]);
                Response res = this._$1(req, s);
                if (res.getException() == null) continue;
                throw res.getException();
            }
            catch (Exception e) {
                err_buff.append(" An exception occurred on " + this._$8[i] + ":" + this._$7[i] + ": " + e.getMessage() + DQLUtil.getLineSeparator());
            }
        }
        Response res = new Response();
        if (err_buff.length() != 0) {
            res.setException(new Exception(err_buff.toString()));
        }
        return res;
    }

    public Response ask(Request req) throws Exception {
        Socket s = this._$1(-1);
        return this._$1(req, s);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._$8.length; ++i) {
            if (i > 0) {
                sb.append(";");
            }
            sb.append(this._$8[i] + ":" + this._$7[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response _$1(Request req, Socket s) throws Exception {
        if (this._$6) {
            throw new SQLException("The client is closed.");
        }
        Socket skt = s;
        ObjectOutputStream out = null;
        ObjectInputStream is = null;
        try {
            Response res;
            OutputStream os = skt.getOutputStream();
            int head = 0;
            if (req.isShutDown()) {
                head = -1;
                DQLClient.writeInt(os, head);
                Response response = null;
                return response;
            }
            DQLClient.writeInt(os, head);
            out = new ObjectOutputStream(os);
            out.writeUnshared(req);
            out.flush();
            is = new ObjectInputStream(skt.getInputStream());
            Response response = res = (Response)is.readUnshared();
            return response;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.close();
            }
            if (skt != null) {
                skt.close();
            }
        }
    }

    void _$2() {
        this._$6 = true;
    }

    public void setLoginInfo(String user, String pwd, String svName) {
        this._$5 = user;
        this._$4 = pwd;
        this._$3 = svName;
    }

    public boolean check() throws Exception {
        if (this._$3 == null) {
            return false;
        }
        Request req = this._$1();
        req.setCheck(true);
        Socket s = this._$1(-1);
        Response res = this._$1(req, s);
        if (res.getException() != null) {
            throw res.getException();
        }
        Object checkResult = res.getResult();
        return (Boolean)checkResult;
    }

    private Request _$1() {
        Request req = new Request();
        req.setUser(this._$5);
        req.setPassword(this._$4);
        req.setServiceName(this._$3);
        return req;
    }

    public int prepare(String dql, List<Object> args, boolean isDqlMode) throws Exception {
        int hostIndex = this._$3();
        Request req = this._$1();
        req.setAction(10001);
        req.setAttr("dql", dql);
        req.setAttr("Arg list", args);
        req.setAttr("Dql mode", new Boolean(isDqlMode));
        Socket s = this._$1(hostIndex);
        Response res = this._$1(req, s);
        if (res.getException() != null) {
            throw res.getException();
        }
        int taskId = (Integer)res.getResult();
        this._$1.put(taskId, hostIndex);
        return taskId;
    }

    public int execute(int statementId) throws Exception {
        Request req = this._$1();
        req = this._$1();
        req.setAction(10002);
        req.setAttr("Task id", statementId);
        Integer hi = this._$1.get(statementId);
        if (hi == null) {
            Set<Integer> ks = this._$1.keySet();
            throw new Exception("Invalid statementId: " + statementId + ". All statementIds: " + ks);
        }
        int hostIndex = hi;
        Socket s = this._$1(hostIndex);
        Response res = this._$1(req, s);
        if (res.getException() != null) {
            throw res.getException();
        }
        RemoteCursor remoteCursor = (RemoteCursor)res.getResult();
        this._$2.add(remoteCursor);
        return remoteCursor.getProxyId();
    }

    public RemoteCursor getCursor(int queryId) {
        RemoteCursor rc = null;
        for (int i = 0; i < this._$2.size() && (rc = this._$2.get(i)).getProxyId() != queryId; ++i) {
        }
        if (rc == null) {
            throw new RuntimeException("Can not find the remote cursor of queryId: " + queryId + ".");
        }
        return rc;
    }

    public Object[][] fetch(int queryId, int fetchSize, boolean hasName) throws Exception {
        RemoteCursor rc = this.getCursor(queryId);
        Sequence table = rc.fetch(fetchSize);
        if (table == null) {
            return null;
        }
        int row = table.length();
        if (hasName) {
            ++row;
        }
        int col = table.dataStruct().getFieldCount();
        Object[][] data = new Object[row][col];
        if (hasName) {
            String[] colNames = table.dataStruct().getFieldNames();
            data[0] = colNames;
        }
        for (int r = 1; r <= table.length(); ++r) {
            Object[] rowData = ((BaseRecord)table.get(r)).getFieldValues();
            if (hasName) {
                data[r] = rowData;
                continue;
            }
            data[r - 1] = rowData;
        }
        return data;
    }

    public void cancel(int statementId) {
    }

    public void close(int[] queryIds) throws Exception {
        for (int i = 0; i < queryIds.length; ++i) {
            int queryId = queryIds[i];
            RemoteCursor rc = this.getCursor(queryId);
            rc.close();
        }
    }
}

