/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.jdbc;

import com.esproc.dql.Request;
import com.esproc.dql.Response;
import com.esproc.dql.jdbc.DQLCallableStatement;
import com.esproc.dql.jdbc.DQLClient;
import com.esproc.dql.jdbc.DQLDatabaseMetaData;
import com.esproc.dql.jdbc.DQLDriver;
import com.esproc.dql.jdbc.DQLPreparedStatement;
import com.esproc.dql.jdbc.DQLStatement;
import com.esproc.dql.jdbc.DQLUtil;
import com.esproc.dql.jdbc.FieldAttr;
import com.esproc.dql.jdbc.lIIIlIlIIlIlIIII;
import com.esproc.dql.server.RemoteCursor;
import com.esproc.dql.server.ServiceImpl;
import com.esproc.jdbc.JDBCMessage;
import com.esproc.jdbc.JDBCUtil;
import com.scudata.app.common.Section;
import com.scudata.app.config.RaqsoftConfig;
import com.scudata.common.ISessionFactory;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.common.UUID;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.query.dql.DQL;
import com.scudata.dm.query.dql.User;
import com.scudata.dm.query.metadata.Dictionary;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.FieldList;
import com.scudata.dm.query.metadata.ForeignKey;
import com.scudata.dm.query.metadata.ForeignKeyList;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Table;
import com.scudata.dm.query.metadata.TableList;
import com.scudata.dm.query.metadata.TableVisibility;
import com.scudata.dm.query.metadata.Visibility;
import com.scudata.ide.common.resources.IdeCommonMessage;
import com.scudata.ide.spl.control.SplEditorSE;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DQLConnection
implements Connection {
    private String[] _$19;
    private int[] _$18;
    private String _$17;
    private String _$16;
    private String _$15;
    private boolean _$14 = true;
    private DQLDatabaseMetaData _$13;
    private DQLClient _$12 = null;
    private Properties _$11 = null;
    private boolean _$10 = false;
    public static final String KEY_USER = "user";
    public static final String KEY_PASSWORD = "password";
    private Map<String, Class<?>> _$9;
    protected boolean clearWarnings = false;
    private Set<Statement> _$8 = null;
    protected boolean isRemote = true;
    private LogicMetaData _$7 = null;
    private Dictionary _$6 = null;
    private Visibility _$5 = null;
    protected String url;
    protected String driverName;
    protected int driverMajorVersion;
    protected int driverMinorVersion;
    private RaqsoftConfig _$4 = null;
    private Context _$3 = new Context();
    private JobSpace _$2 = null;
    private long _$1 = System.currentTimeMillis();

    public DQLConnection(DQLDriver driver, String[] host, int[] port, String serviceName, String userName, String password, boolean isDqlMode, String url) throws Exception {
        JDBCUtil.log((String)"DQLConnection-1");
        this._$19 = host;
        this._$18 = port;
        this._$17 = serviceName;
        this._$15 = password;
        this._$14 = isDqlMode;
        this.url = url;
        this.isRemote = true;
        this._$1(driver, url, userName);
        DQLClient c = this._$1(host, port);
        c.setLoginInfo(userName, password, serviceName);
        if (!c.check()) {
            throw new SQLException(JDBCMessage.get().getMessage("dqlconnection.connectfaild"));
        }
    }

    public DQLConnection(DQLDriver driver, String url, String user, boolean isDqlMode, LogicMetaData lmd, Dictionary dct, Visibility vsb, RaqsoftConfig config) throws Exception {
        JDBCUtil.log((String)"DQLConnection-1");
        this._$14 = isDqlMode;
        this._$7 = lmd;
        this._$5 = vsb;
        this.isRemote = false;
        this._$1(driver, url, user);
        this._$1(this._$3);
        lmd.prepare(this._$3);
    }

    public Context getParentContext() {
        return this._$3;
    }

    private void _$1(Context ctx) {
        ctx.setJobSpace(this._$4());
        if (this._$4 != null) {
            this._$1(this._$4.getAutoConnectList(), ctx);
        }
    }

    private void _$1(List<String> autoList, Context ctx) {
        if (autoList == null) {
            return;
        }
        for (int i = 0; i < autoList.size(); ++i) {
            String name = autoList.get(i);
            try {
                Logger.debug((Object)("Auto connect database [" + name + "]"));
                ISessionFactory isf = Env.getDBSessionFactory((String)name);
                if (isf == null) {
                    isf = ctx.getDBSessionFactory(name);
                }
                if (isf == null) continue;
                ctx.setDBSession(name, isf.getSession());
                continue;
            }
            catch (Exception e) {
                Logger.error((Object)("Auto connect database [" + name + "] failed: " + e.getMessage()));
                Logger.error((Object)e);
            }
        }
    }

    public void check() throws SQLException {
        if (DQLDriver.overTime <= 0L) {
            return;
        }
        long usedTime = System.currentTimeMillis() - DQLDriver.START_TIME;
        if (usedTime > DQLDriver.overTime) {
            throw new SQLException(IdeCommonMessage.get().getMessage("sn.runtimeover", (Object)"QJDBC"));
        }
        if (System.currentTimeMillis() - this._$1 > 172800000L) {
            try {
                SplEditorSE.checkSerialNo();
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
    }

    private synchronized JobSpace _$4() {
        if (this._$2 == null) {
            String uuid = UUID.randomUUID().toString();
            this._$2 = JobSpaceManager.getSpace((String)uuid);
        }
        return this._$2;
    }

    private void _$1(DQLDriver driver, String url, String userName) {
        this.url = url;
        this._$16 = userName;
        this.driverName = driver.getClass().getName();
        this.driverMajorVersion = driver.getMajorVersion();
        this.driverMinorVersion = driver.getMinorVersion();
    }

    private DQLClient _$1(String[] hosts, int[] ports) {
        if (this._$12 == null) {
            this._$12 = new DQLClient(hosts, ports);
        }
        return this._$12;
    }

    private Request _$3() {
        Request req = new Request();
        req.setUser(this._$16);
        req.setPassword(this._$15);
        req.setServiceName(this._$17);
        return req;
    }

    private Response _$1(String[] reqTypes, Object[] values) throws Exception {
        return this._$1(reqTypes, values, this._$19, this._$18);
    }

    private Response _$1(String[] reqTypes, Object[] values, String[] hosts, int[] ports) throws Exception {
        if (reqTypes == null) {
            return null;
        }
        Request req = this._$3();
        for (int i = 0; i < reqTypes.length; ++i) {
            req.setParam(reqTypes[i], values == null ? null : values[i]);
        }
        DQLClient c = this._$1(hosts, ports);
        Response res = c.ask(req);
        if (res.getException() != null) {
            throw res.getException();
        }
        return res;
    }

    public com.scudata.dm.Table getData(String reqType, Object reqParams) throws SQLException {
        try {
            if (this.isRemote) {
                Response res = this._$1(new String[]{reqType}, new Object[]{reqParams});
                return (com.scudata.dm.Table)res.getAttr(reqType);
            }
            if (reqType.equals(Request.GET_TABLES)) {
                Object[] params = (Object[])reqParams;
                String catalog = params[0] == null ? null : (String)params[0];
                String schemaPattern = params[1] == null ? null : (String)params[1];
                String tableNamePattern = params[2] == null ? null : (String)params[2];
                String[] types = (String[])params[3];
                return DQLUtil.getTables(schemaPattern, tableNamePattern, this._$7, this._$5);
            }
            if (reqType.equals(Request.GET_COLUMNS)) {
                Object[] params = (Object[])reqParams;
                String schemaPattern = params[1] == null ? null : (String)params[1];
                String tableNamePattern = params[2] == null ? null : (String)params[2];
                String columnNamePattern = params[3] == null ? null : (String)params[3];
                return DQLUtil.getColumns(schemaPattern, tableNamePattern, columnNamePattern, this._$7, this._$5);
            }
            if (reqType.equals(Request.GET_PRIMARY_KEYS)) {
                Object[] params = (Object[])reqParams;
                String tableNamePattern = params[2] == null ? null : (String)params[2];
                return DQLUtil.getPrimaryKeys(tableNamePattern, this._$7, this._$5);
            }
            if (reqType.equals(Request.GET_EXPORTED_KEYS)) {
                Object[] params = (Object[])reqParams;
                String tableNamePattern = params[2] == null ? null : (String)params[2];
                return DQLUtil.getExportedKeys(tableNamePattern, this._$7, this._$5);
            }
            if (reqType.equals(Request.GET_IMPORTED_KEYS)) {
                Object[] params = (Object[])reqParams;
                String tableNamePattern = params[2] == null ? null : (String)params[2];
                return DQLUtil.getImportedKeys(tableNamePattern, this._$7, this._$5);
            }
            return null;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    private Object[][] _$1(Object[][] datas) {
        if (datas != null && datas.length > 0) {
            Object[][] convertDatas = new Object[datas[0].length][datas.length];
            for (int i = 0; i < datas.length; ++i) {
                if (datas[i] == null) continue;
                for (int j = 0; j < datas[i].length; ++j) {
                    convertDatas[j][i] = datas[i][j];
                }
            }
            return convertDatas;
        }
        return datas;
    }

    private Object[][] _$5(Object requestParam) {
        Object[] params = (Object[])requestParam;
        String catalog = params[0] == null ? null : (String)params[0];
        String schemaPattern = params[1] == null ? null : (String)params[1];
        String tableNamePattern = params[2] == null ? null : (String)params[2];
        String[] types = (String[])params[3];
        int columnCount = 10;
        Object[][] datas = new Object[10][];
        String[] tableNames = this._$1(schemaPattern, tableNamePattern, types);
        if (tableNames != null) {
            datas[2] = tableNames;
            int dataSize = tableNames.length;
            String[] catalogs = new String[dataSize];
            String[] schemas = new String[dataSize];
            for (int i = 0; i < dataSize; ++i) {
                catalogs[i] = null;
                schemas[i] = null;
            }
            datas[0] = catalogs;
            datas[1] = schemas;
        }
        return datas;
    }

    private Pattern _$1(String filter) {
        if (!StringUtils.isValidString((Object)filter)) {
            return null;
        }
        filter = filter.trim();
        filter = filter.replaceAll("%", ".*");
        filter = filter.replaceAll("_", ".");
        return Pattern.compile(filter);
    }

    private String[] _$1(String schemaPattern, String tableNamePattern, String[] types) {
        if (this._$7 == null) {
            return null;
        }
        TableList tl = this._$7.getTableList();
        List<TableVisibility> tvl = null;
        if (this._$5 != null) {
            tvl = this._$5.getTableVisibilityList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < tl.size(); ++i) {
            Matcher m;
            Pattern p;
            Table table = tl.getTable(i);
            String tableName = table.getName();
            if (StringUtils.isValidString((Object)tableNamePattern) && (p = this._$1(tableNamePattern)) != null && !(m = p.matcher(tableName)).matches()) continue;
            TableVisibility tv = null;
            if (this._$5 != null) {
                tv = this._$5.getTableVisibility(tableName);
            }
            if (tv != null && tv.isVisible() == 0) continue;
            list.add(tableName);
        }
        if (list.isEmpty()) {
            return null;
        }
        int size = list.size();
        String[] tableNames = new String[size];
        for (int i = 0; i < size; ++i) {
            tableNames[i] = (String)list.get(i);
        }
        return tableNames;
    }

    private Object[][] _$4(Object requestParam) {
        Object[] params = (Object[])requestParam;
        String schemaPattern = params[1] == null ? null : (String)params[1];
        String tableNamePattern = params[2] == null ? null : (String)params[2];
        String columnNamePattern = params[3] == null ? null : (String)params[3];
        int columnCount = 23;
        Object[][] datas = new Object[23][];
        Object[] tableColumns = this._$1(schemaPattern, tableNamePattern, columnNamePattern);
        if (tableColumns != null) {
            datas[2] = (Object[])tableColumns[0];
            datas[3] = (Object[])tableColumns[1];
            int size = datas[2].length;
            String[] catalogs = new String[size];
            String[] schemas = new String[size];
            for (int i = 0; i < size; ++i) {
                catalogs[i] = null;
                schemas[i] = null;
            }
            datas[0] = catalogs;
            datas[1] = schemas;
        }
        return datas;
    }

    private Object[] _$1(String schemaPattern, String tableNamePattern, String columnNamePattern) {
        if (this._$7 == null) {
            return null;
        }
        TableList tl = this._$7.getTableList();
        if (tl == null) {
            return null;
        }
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String> columns = new ArrayList<String>();
        int size = tl.size();
        for (int i = 0; i < size; ++i) {
            Matcher m;
            Pattern p;
            Table t = tl.getTable(i);
            String tableName = t.getName();
            if (StringUtils.isValidString((Object)tableNamePattern) && (p = this._$1(tableNamePattern)) != null && !(m = p.matcher(tableName)).matches()) continue;
            TableVisibility tv = null;
            if (this._$5 != null && (tv = this._$5.getTableVisibility(tableName)) != null && tv.isVisible() == 0) continue;
            FieldList fl = t.getFieldList();
            List<String> ifList = tv == null ? null : tv.getInvisibleFieldList();
            for (int j = 0; j < fl.size(); ++j) {
                Matcher m2;
                Pattern p2;
                Field f = fl.getField(j);
                String fieldName = f.getName();
                if (StringUtils.isValidString((Object)columnNamePattern) && (p2 = this._$1(columnNamePattern)) != null && !(m2 = p2.matcher(fieldName)).matches() || ifList != null && ifList.contains(fieldName)) continue;
                tables.add(tableName);
                columns.add(fieldName);
            }
        }
        if (tables.isEmpty()) {
            return null;
        }
        int size2 = tables.size();
        String[] tableNames = new String[size2];
        String[] colNames = new String[size2];
        for (int i = 0; i < size2; ++i) {
            tableNames[i] = (String)tables.get(i);
            colNames[i] = (String)columns.get(i);
        }
        return new Object[]{tableNames, colNames};
    }

    private Object[][] _$3(Object requestParam) {
        TableList tl;
        Object[] params = (Object[])requestParam;
        String tableNamePattern = params[2] == null ? null : (String)params[2];
        int columnCount = 6;
        Object[][] datas = new Object[6][];
        if (this._$7 != null && (tl = this._$7.getTableList()) != null) {
            ArrayList<String> tables = new ArrayList<String>();
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<Integer> seqs = new ArrayList<Integer>();
            for (int i = 0; i < tl.size(); ++i) {
                FieldList fl;
                Matcher m;
                Pattern p;
                Table t = tl.getTable(i);
                String tableName = t.getName();
                if (StringUtils.isValidString((Object)tableNamePattern) && (p = this._$1(tableNamePattern)) != null && !(m = p.matcher(tableName)).matches()) continue;
                TableVisibility tv = null;
                if (this._$5 != null && (tv = this._$5.getTableVisibility(tableName)) != null && tv.isVisible() == 0 || (fl = t.getFieldList()) == null) continue;
                List<String> ifList = tv == null ? null : tv.getInvisibleFieldList();
                for (int j = 0; j < fl.size(); ++j) {
                    Field f = fl.getField(j);
                    if (ifList != null && ifList.contains(f.getName()) || !f.isPrimary()) continue;
                    tables.add(tableName);
                    columns.add(f.getName());
                    seqs.add(new Integer(j + 1));
                }
            }
            if (!tables.isEmpty()) {
                int size = tables.size();
                String[] catalogs = new String[size];
                String[] schemas = new String[size];
                Object[] tableNames = new Object[size];
                Object[] columnNames = new Object[size];
                Object[] seq = new Object[size];
                for (int i = 0; i < size; ++i) {
                    catalogs[i] = null;
                    schemas[i] = null;
                    tableNames[i] = tables.get(i);
                    columnNames[i] = columns.get(i);
                    seq[i] = seqs.get(i);
                }
                datas[0] = catalogs;
                datas[1] = schemas;
                datas[2] = tableNames;
                datas[3] = columnNames;
                datas[4] = seq;
            }
        }
        return datas;
    }

    private Object[][] _$2(Object requestParam) {
        TableList tl;
        Object[] params = (Object[])requestParam;
        String tableNamePattern = params[2] == null ? null : (String)params[2];
        int columnCount = 14;
        Object[][] datas = new Object[14][];
        if (this._$7 != null && (tl = this._$7.getTableList()) != null) {
            Section pkTables = new Section(true);
            Section pkCols = new Section(true);
            Section fkTables = new Section(true);
            Section fkCols = new Section(true);
            Section fkNames = new Section(true);
            for (int i = 0; i < tl.size(); ++i) {
                ForeignKeyList fkl;
                Table t = tl.getTable(i);
                String tableName = t.getName();
                TableVisibility tv = null;
                if (this._$5 != null && (tv = this._$5.getTableVisibility(tableName)) != null && tv.isVisible() == 0 || (fkl = t.getForeignKeyList()) == null) continue;
                List<String> ifList = tv == null ? null : tv.getInvisibleFieldList();
                for (int f = 0; f < fkl.size(); ++f) {
                    Matcher m;
                    ForeignKey fk = fkl.getForeignKey(f);
                    if (ifList != null && ifList.contains(fk.getName())) continue;
                    String refTable = fk.getRefTableName();
                    Pattern p = this._$1(tableNamePattern);
                    if (p != null && !(m = p.matcher(refTable)).matches()) continue;
                    List<String> fList = fk.getFieldNameList();
                    List<String> refList = fk.getRefFieldNameList();
                    for (int k = 0; k < fList.size(); ++k) {
                        pkTables.addSection(t.getName());
                        pkCols.addSection(refList.get(k));
                        fkTables.addSection(fk.getRefTableName());
                        fkCols.addSection(fList.get(k));
                        fkNames.addSection(fk.getName());
                    }
                }
            }
            int size = pkTables.size();
            if (size > 0) {
                String[] catalogs = new String[size];
                String[] schemas = new String[size];
                for (int i = 0; i < size; ++i) {
                    catalogs[i] = null;
                    schemas[i] = null;
                }
                datas[0] = catalogs;
                datas[1] = schemas;
                datas[2] = pkTables.toStringArray();
                datas[3] = pkCols.toStringArray();
                datas[4] = catalogs;
                datas[5] = schemas;
                datas[6] = fkTables.toStringArray();
                datas[7] = fkCols.toStringArray();
                datas[11] = fkNames.toStringArray();
            }
        }
        return datas;
    }

    private Object[][] _$1(Object requestParam) {
        TableList tl;
        Object[] params = (Object[])requestParam;
        String tableNamePattern = params[2] == null ? null : (String)params[2];
        int columnCount = 14;
        Object[][] datas = new Object[14][];
        if (this._$7 != null && (tl = this._$7.getTableList()) != null) {
            Section pkTables = new Section(true);
            Section pkCols = new Section(true);
            Section fkTables = new Section(true);
            Section fkCols = new Section(true);
            Section fkNames = new Section(true);
            for (int l = 0; l < tl.size(); ++l) {
                ForeignKeyList fkl;
                Matcher m;
                Table t = (Table)tl.get(l);
                Pattern p = this._$1(tableNamePattern);
                if (p != null && !(m = p.matcher(t.getName())).matches()) continue;
                TableVisibility tv = null;
                if (this._$5 != null && (tv = this._$5.getTableVisibility(t.getName())) != null && tv.isVisible() == 0 || (fkl = t.getForeignKeyList()) == null) continue;
                List<String> ifList = tv == null ? null : tv.getInvisibleFieldList();
                for (int f = 0; f < fkl.size(); ++f) {
                    ForeignKey fk = fkl.getForeignKey(f);
                    if (ifList != null && ifList.contains(fk.getName())) continue;
                    String refTable = fk.getRefTableName();
                    List<String> fList = fk.getFieldNameList();
                    List<String> refList = fk.getRefFieldNameList();
                    for (int k = 0; k < fList.size(); ++k) {
                        pkTables.addSection(refTable);
                        pkCols.addSection(refList.get(k));
                        fkTables.addSection(t.getName());
                        fkCols.addSection(fList.get(k));
                        fkNames.addSection(fk.getName());
                    }
                }
            }
            int size = pkTables.size();
            if (size > 0) {
                String[] catalogs = new String[size];
                String[] schemas = new String[size];
                for (int i = 0; i < size; ++i) {
                    catalogs[i] = null;
                    schemas[i] = null;
                }
                datas[0] = catalogs;
                datas[1] = schemas;
                datas[2] = pkTables.toStringArray();
                datas[3] = pkCols.toStringArray();
                datas[4] = catalogs;
                datas[5] = schemas;
                datas[6] = fkTables.toStringArray();
                datas[7] = fkCols.toStringArray();
                datas[11] = fkNames.toStringArray();
            }
        }
        return datas;
    }

    public com.scudata.dm.Table listMetaData(String dql) throws SQLException {
        try {
            if (this.isRemote) {
                Response res = this._$1(new String[]{Request.LIST_META_DATA}, new Object[]{dql});
                return (com.scudata.dm.Table)res.getAttr(Request.LIST_META_DATA);
            }
            this.check();
            return DQLUtil.listMetaData(this._$7, dql);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    public Object executeDql(String dql, List<Object> parameters, Context ctx) throws SQLException {
        if (dql == null) {
            throw new SQLException("DQL is empty.");
        }
        try {
            if (this.isRemote) {
                DQLClient c = this._$1(this._$19, this._$18);
                int taskId = c.prepare(dql, parameters, this._$14);
                int remoteCursorId = c.execute(taskId);
                RemoteCursor rc = c.getCursor(remoteCursorId);
                return rc;
            }
            this.check();
            if (!this._$14) {
                dql = DQLUtil.translateToDQL(this._$7, dql);
            }
            User user = new User();
            user.setLmd(this._$7);
            user.setVisibility(this._$5);
            user.setContext(ctx);
            DQL dqlQuery = new DQL(user, dql, parameters);
            Object result = dqlQuery.execute();
            return result;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    public String metaData() throws SQLException {
        try {
            if (this.isRemote) {
                Response res = this._$1(new String[]{Request.METADATA}, (Object[])null);
                return (String)res.getAttr(Request.METADATA);
            }
            return ServiceImpl.getMetaDataJSON(this._$7, this._$5, this._$6);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage(), ex);
        }
    }

    public Boolean uploadFile(String requestType, String filePath) throws SQLException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            Response res = this._$1(new String[]{requestType}, new Object[]{this._$1(fis)});
            res.getAttr(requestType);
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _$1(InputStream is) throws Exception {
        if (is == null) {
            return new byte[0];
        }
        byte[] bytes = new byte[65536];
        ByteArrayOutputStream baos = null;
        try {
            int len;
            baos = new ByteArrayOutputStream();
            while ((len = is.read(bytes)) != -1) {
                baos.write(bytes, 0, len);
            }
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception e1) {}
            }
        }
        return baos.toByteArray();
    }

    public String getDimValues(String sql) throws SQLException {
        return FieldAttr.queryDispTableStr(this, sql);
    }

    public void cancelTask(int taskId) throws SQLException {
        try {
            DQLClient c = this._$1(this._$19, this._$18);
            c.setLoginInfo(this._$16, this._$15, this._$17);
            c.cancel(taskId);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e);
        }
    }

    @Override
    public void close() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-14");
        this._$10 = true;
        this._$1();
    }

    @Override
    public void clearWarnings() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-28");
    }

    @Override
    public void commit() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-12");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"commit()"));
    }

    private synchronized void _$2(Statement lst) {
        if (this._$8 == null) {
            this._$8 = new HashSet<Statement>();
        }
        this._$8.add(lst);
        this._$2();
    }

    private void _$2() {
        if (this._$8 == null || this._$8.size() < 2) {
            return;
        }
        lIIIlIlIIlIlIIII t = new lIIIlIlIIlIlIIII(this);
        t.setPriority(1);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1() throws SQLException {
        if (this._$8 != null) {
            Set<Statement> set = this._$8;
            synchronized (set) {
                if (this._$8 != null) {
                    for (Statement lst : this._$8) {
                        if (lst == null) continue;
                        lst.close();
                    }
                }
            }
        }
    }

    void _$1(Statement lst) {
        if (this._$10) {
            return;
        }
        if (this._$8 == null || lst == null) {
            return;
        }
        this._$8.remove(lst);
    }

    @Override
    public Statement createStatement() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-4");
        DQLStatement lst = new DQLStatement(this);
        this._$2(lst);
        return lst;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-5");
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-6");
        return this.createStatement();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-7");
        if (this._$10) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        DQLCallableStatement lst = new DQLCallableStatement(this, sql);
        this._$2(lst);
        return lst;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-8");
        return this.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-9");
        return this.prepareCall(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-40");
        DQLPreparedStatement lst = new DQLPreparedStatement(this, sql);
        this._$2(lst);
        return lst;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-41");
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-42");
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-43");
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-44");
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-45");
        return this.prepareStatement(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-10");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-11");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"getAutoCommit()"));
        return false;
    }

    @Override
    public int getHoldability() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-34");
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this._$13 == null) {
            this._$13 = new DQLDatabaseMetaData(this, this.url, this._$16, this.driverName, this.driverMajorVersion, this.driverMinorVersion);
        }
        return this._$13;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-26");
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-32");
        return this._$9;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-27");
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-15");
        return this._$10;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-22");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"isReadOnly()"));
        return true;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-9");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"nativeSQL(String sql)"));
        return null;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-38");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"releaseSavepoint(Savepoint savepoint)"));
    }

    @Override
    public void rollback() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-13");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"rollback()"));
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-37");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"rollback(Savepoint savepoint)"));
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-23");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setCatalog(String catalog)"));
    }

    @Override
    public String getCatalog() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-24");
        return null;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-33");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setHoldability(int holdability)"));
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-21");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setReadOnly(boolean readOnly)"));
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-35");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setSavepoint()"));
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-36");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setSavepoint(String name)"));
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-25");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setTransactionIsolation(int level)"));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-66");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"isWrapperFor(Class<?> iface)"));
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-67");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"unwrap(Class<T> iface)"));
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this._$9 = map;
    }

    @Override
    public Blob createBlob() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-55");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"createBlob()"));
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-56");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"createClob()"));
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-57");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"createNClob()"));
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-58");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"createSQLXML()"));
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-62");
        return !this.isClosed();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-60");
        return this._$11;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-61");
        if (this._$11 == null) {
            return null;
        }
        return this._$11.getProperty(name);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        JDBCUtil.log((String)"DQLConnection-63");
        this._$11 = properties;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        JDBCUtil.log((String)"DQLConnection-64");
        if (this._$11 == null) {
            this._$11 = new Properties();
        }
        this._$11.put(name, value);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-54");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"createArrayOf(String typeName, Object[] elements)"));
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-59");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"createStruct(String typeName, Object[] attributes)"));
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-68");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setSchema(String schema)"));
    }

    @Override
    public String getSchema() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-69");
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-70");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"abort(Executor executor)"));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        JDBCUtil.log((String)"DQLConnection-71");
        Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setNetworkTimeout(Executor executor, int milliseconds)"));
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        JDBCUtil.log((String)"DQLConnection-72");
        return 0;
    }

    static /* synthetic */ Set _$1(DQLConnection x0) {
        return x0._$8;
    }
}

