/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.jdbc;

import com.esproc.dql.jdbc.DQLConnection;
import com.esproc.dql.jdbc.DQLResultSet;
import com.esproc.dql.jdbc.DQLUtil;
import com.esproc.dql.jdbc.llllIllIIlIIlIII;
import com.esproc.jdbc.JDBCMessage;
import com.scudata.common.DBSession;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.JobSpace;
import com.scudata.dm.Table;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DQLStatement
implements Statement {
    protected DQLConnection con;
    private int _$4 = 0;
    private int _$3 = 1000;
    protected ResultSet resultSet;
    protected boolean clearWarnings = false;
    protected Context context;
    private boolean _$2 = false;
    private Set<DQLResultSet> _$1;

    public DQLStatement(DQLConnection con) {
        DQLUtil.log("DQLStatement-1");
        this.con = con;
        this.initContext();
    }

    public void initContext() {
        this.context = new Context();
        try {
            if (this.con == null || this.con.isClosed()) {
                return;
            }
        }
        catch (SQLException e) {
            return;
        }
        Context parentCtx = this.con.getParentContext();
        if (parentCtx != null) {
            Map dbSessionMap = parentCtx.getDBSessionMap();
            if (dbSessionMap != null) {
                try {
                    for (String dbName : dbSessionMap.keySet()) {
                        DBSession dbSession = (DBSession)dbSessionMap.get(dbName);
                        this.context.setDBSession(dbName, dbSession);
                    }
                }
                catch (Exception ex) {
                    Logger.error((Object)ex);
                }
            }
            JobSpace jobSpace = parentCtx.getJobSpace();
            this.context.setJobSpace(jobSpace);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        DQLUtil.log("DQLStatement-2");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"addBatch(String sql)"));
        }
    }

    @Override
    public void cancel() throws SQLException {
        DQLUtil.log("DQLStatement-3");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"cancel()"));
        }
        this.cancelTask();
    }

    @Override
    public void clearBatch() throws SQLException {
        DQLUtil.log("DQLStatement-4");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"clearBatch()"));
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        DQLUtil.log("DQLStatement-5");
        this.clearWarnings = true;
    }

    @Override
    public void close() throws SQLException {
        DQLUtil.log("DQLStatement-6");
        this._$2 = true;
        this._$2();
        this.con._$1(this);
    }

    @Override
    public boolean isClosed() {
        DQLUtil.log("DQLStatement-7");
        return this._$2;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        DQLUtil.log("DQLStatement-8");
        try {
            this.dqlQuery(sql);
            return true;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        DQLUtil.log("DQLStatement-9");
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        DQLUtil.log("DQLStatement-10");
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        DQLUtil.log("DQLStatement-11");
        return this.execute(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        DQLUtil.log("DQLStatement-12");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"executeBatch()"));
        }
        return null;
    }

    public void cancelTask() throws SQLException {
        DQLUtil.log("DQLStatement-13");
        this.con.cancelTask(this._$4);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        DQLUtil.log("DQLStatement-14");
        try {
            return this.dqlQuery(sql);
        }
        catch (SQLException ex) {
            Logger.debug((Object)("SQL: " + sql));
            throw ex;
        }
    }

    protected ResultSet dqlQuery(String dql) throws SQLException {
        DQLUtil.log("DQLStatement-15");
        return this.dqlQuery(dql, null);
    }

    protected ResultSet dqlQuery(String dql, List<Object> parameters) throws SQLException {
        DQLUtil.log("DQLStatement-16");
        if (!StringUtils.isValidString((Object)dql)) {
            return DQLUtil.getEmptyResultSet();
        }
        if ((dql = dql.trim()).toLowerCase().trim().startsWith("list ")) {
            Table t = this.con.listMetaData(dql);
            DQLResultSet lrs = DQLUtil.generateResultSet(t, this._$3);
            this.addLogicResultSet(lrs);
            return lrs;
        }
        if (dql.toLowerCase().trim().equals("metadata")) {
            String metadataJson = this.con.metaData();
            DQLResultSet lrs = DQLUtil.generateResultSet(metadataJson, this._$3);
            this.addLogicResultSet(lrs);
            return lrs;
        }
        Object result = this.con.executeDql(dql, parameters, this.context);
        DQLResultSet lrs = DQLUtil.generateResultSet(result, this._$3);
        this.addLogicResultSet(lrs);
        return lrs;
    }

    protected synchronized void addLogicResultSet(DQLResultSet lrs) {
        DQLUtil.log("DQLStatement-17");
        if (this._$1 == null) {
            this._$1 = new HashSet<DQLResultSet>();
        }
        this._$1.add(lrs);
        this._$3();
    }

    private void _$3() {
        DQLUtil.log("DQLStatement-18");
        if (this._$1 == null || this._$1.isEmpty()) {
            return;
        }
        llllIllIIlIIlIII t = new llllIllIIlIIlIII(this);
        t.setPriority(1);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$2() throws SQLException {
        DQLUtil.log("DQLStatement-19");
        if (this._$1 == null || this._$1.isEmpty()) {
            return;
        }
        Set<DQLResultSet> set = this._$1;
        synchronized (set) {
            for (DQLResultSet lrs : this._$1) {
                if (lrs == null) continue;
                lrs.close();
            }
        }
    }

    synchronized void _$1(DQLResultSet lrs) {
        DQLUtil.log("DQLStatement-20");
        if (this._$2) {
            return;
        }
        if (this._$1 == null || lrs == null) {
            return;
        }
        this._$1.remove(lrs);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        DQLUtil.log("DQLStatement-21");
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        DQLUtil.log("DQLStatement-22");
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        DQLUtil.log("DQLStatement-23");
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        DQLUtil.log("DQLStatement-24");
        return this.executeUpdate(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        DQLUtil.log("DQLStatement-25");
        return this.con;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        DQLUtil.log("DQLStatement-26");
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        DQLUtil.log("DQLStatement-27");
        return this._$3;
    }

    private ResultSet _$1() throws SQLException {
        DQLUtil.log("DQLStatement-28");
        return new DQLResultSet(0, null);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        DQLUtil.log("DQLStatement-29");
        return this._$1();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        DQLUtil.log("DQLStatement-30");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"getMaxFieldSize()"));
        }
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        DQLUtil.log("DQLStatement-31");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"getMaxRows()"));
        }
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        DQLUtil.log("DQLStatement-32");
        this.resultSet = null;
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        DQLUtil.log("DQLStatement-33");
        return this.getMoreResults();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        DQLUtil.log("DQLStatement-34");
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        DQLUtil.log("DQLStatement-35");
        if (this.con.isClosed()) {
            throw new SQLException(JDBCMessage.get().getMessage("error.conclosed"));
        }
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        DQLUtil.log("DQLStatement-36");
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        DQLUtil.log("DQLStatement-37");
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        DQLUtil.log("DQLStatement-38");
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        DQLUtil.log("DQLStatement-39");
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        DQLUtil.log("DQLStatement-40");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"getWarnings()"));
        }
        return null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        DQLUtil.log("DQLStatement-41");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setCursorName(String name)"));
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        DQLUtil.log("DQLStatement-42");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setEscapeProcessing(boolean enable)"));
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        DQLUtil.log("DQLStatement-43");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setFetchDirection(int direction)"));
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        DQLUtil.log("DQLStatement-44");
        this._$3 = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        DQLUtil.log("DQLStatement-45");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setMaxFieldSize(int max)"));
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        DQLUtil.log("DQLStatement-46");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setMaxRows(int max)"));
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        DQLUtil.log("DQLStatement-47");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setQueryTimeout(int seconds)"));
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        DQLUtil.log("DQLStatement-48");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"unwrap(Class<T> iface)"));
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        DQLUtil.log("DQLStatement-49");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"isWrapperFor(Class<?> iface)"));
        }
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        DQLUtil.log("DQLStatement-50");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"setPoolable(boolean poolable)"));
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        DQLUtil.log("DQLStatement-51");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"isPoolable()"));
        }
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        DQLUtil.log("DQLStatement-52");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"closeOnCompletion()"));
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        DQLUtil.log("DQLStatement-53");
        if (!this.clearWarnings) {
            Logger.debug((Object)JDBCMessage.get().getMessage("error.methodnotimpl", (Object)"isCloseOnCompletion()"));
        }
        return false;
    }

    static /* synthetic */ Set _$1(DQLStatement x0) {
        return x0._$1;
    }
}

