/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.server;

import com.esproc.dql.server.JSONUtils;
import com.scudata.common.Escape;
import com.scudata.common.StringUtils;
import com.scudata.common.Types;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IJSONObject {
    void _$1() {
    }

    public String getJsonString() {
        return this.getJson().toString();
    }

    public JSONObject getJson() {
        JSONObject jo = new JSONObject();
        Class<?> c1 = this.getClass();
        try {
            jo.put("class", (Object)c1.getName());
            this.getClassJson(c1, jo);
            return jo;
        }
        catch (Exception x) {
            throw new RuntimeException(x.getMessage(), x);
        }
    }

    private JSONArray _$1(List<?> list) {
        Object[] objs = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objs[i] = list.get(i);
        }
        return this._$1(objs);
    }

    private JSONArray _$1(Object[] al) {
        JSONArray array = new JSONArray();
        if (al == null) {
            return array;
        }
        for (Object ijo : al) {
            JSONArray subArr;
            if (ijo == null) {
                array.put((Object)null);
                continue;
            }
            if (ijo instanceof IJSONObject) {
                array.put((Object)((IJSONObject)ijo).getJson());
                continue;
            }
            if (ijo instanceof Object[]) {
                subArr = this._$1((Object[])ijo);
                array.put((Object)subArr);
                continue;
            }
            if (ijo instanceof List) {
                subArr = this._$1((List)ijo);
                array.put((Object)subArr);
                continue;
            }
            array.put(ijo);
        }
        return array;
    }

    public void getClassJson(Class clazz, JSONObject jo) {
        if (clazz.getName().endsWith("IJSONObject")) {
            return;
        }
        this.getClassJson(clazz.getSuperclass(), jo);
        try {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Object obj;
                JSONArray array;
                Object al;
                Field f = fields[i];
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
                f.setAccessible(true);
                String name = f.getName();
                Class<?> classType = f.getType();
                if (classType.isArray()) {
                    Object arrData = f.get(this);
                    if (arrData == null) continue;
                    if (arrData instanceof Object[]) {
                        al = (Object[])arrData;
                        array = this._$1((Object[])al);
                        jo.put(name, (Object)array);
                        continue;
                    }
                    if (!(arrData instanceof byte[])) continue;
                    al = (byte[])arrData;
                    array = new JSONArray();
                    for (int n = 0; n < ((Object[])al).length; ++n) {
                        array.put((int)al[n]);
                    }
                    jo.put(name, (Object)array);
                    continue;
                }
                String className = classType.getName().toLowerCase();
                if (className.endsWith("boolean")) {
                    jo.put(name, f.getBoolean(this));
                    continue;
                }
                if (className.endsWith("byte")) {
                    jo.put(name, f.getInt(this));
                    continue;
                }
                if (className.endsWith("int") || className.endsWith("integer")) {
                    jo.put(name, f.getInt(this));
                    continue;
                }
                if (className.endsWith("short")) {
                    jo.put(name, (int)f.getShort(this));
                    continue;
                }
                if (className.endsWith("long")) {
                    jo.put(name, f.getLong(this));
                    continue;
                }
                if (className.endsWith("float")) {
                    jo.put(name, f.getDouble(this));
                    continue;
                }
                if (className.endsWith("double")) {
                    jo.put(name, f.getDouble(this));
                    continue;
                }
                if (className.endsWith("string")) {
                    jo.put(name, f.get(this));
                    continue;
                }
                if (className.endsWith("char")) {
                    jo.put(name, (int)f.getChar(this));
                    continue;
                }
                if (className.endsWith("list")) {
                    al = (ArrayList)f.get(this);
                    if (al == null) continue;
                    array = this._$1((List<?>)al);
                    jo.put(name, (Object)array);
                    continue;
                }
                if (this._$1(f.getType()) || className.endsWith("ibytemap") || className.endsWith("object")) {
                    obj = f.get(this);
                    if (obj == null) continue;
                    if (obj instanceof IJSONObject) {
                        IJSONObject ijo = (IJSONObject)obj;
                        jo.put(name, (Object)ijo.getJson());
                        continue;
                    }
                    jo.put(name, obj);
                    continue;
                }
                if (className.endsWith("hashmap")) {
                    HashMap m = null;
                    if (className.endsWith("hashmap")) {
                        m = (HashMap)f.get(this);
                    }
                    if (m == null) continue;
                    JSONObject subObj = new JSONObject();
                    for (String key : m.keySet()) {
                        Object value = m.get(key);
                        if (value instanceof String) {
                            String txt = (String)value;
                            value = Escape.removeEscAndQuote((String)txt);
                        } else if (value instanceof List) {
                            value = this._$1((List)value);
                        }
                        subObj.put(key, value);
                    }
                    jo.put(name, (Object)subObj);
                    continue;
                }
                obj = f.get(this);
                if (obj == null) {
                    return;
                }
                System.out.println("\u672a\u77e5\u7c7b\u578b\uff1a" + obj.getClass().getName());
            }
        }
        catch (Exception x) {
            throw new RuntimeException(x.getMessage(), x);
        }
    }

    private void _$1(Class clazz, IJSONObject jsonObject, JSONObject jsonProperties) {
        if (clazz.getName().endsWith("IJSONObject")) {
            return;
        }
        this._$1(clazz.getSuperclass(), jsonObject, jsonProperties);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
            f.setAccessible(true);
            String name = f.getName();
            Class<?> classType = f.getType();
            try {
                JSONObject jsonObj;
                String str;
                Object pValue = jsonProperties.get(name);
                String valClazz = pValue.getClass().getName();
                if (valClazz.equals("org.json.JSONObject$Null")) continue;
                String className = classType.getName().toLowerCase();
                if (classType.isArray()) {
                    JSONArray jsonArr = jsonProperties.getJSONArray(name);
                    Object[] value = new Object[jsonArr.length()];
                    byte dataType = this._$1(className);
                    for (int n = 0; n < jsonArr.length(); ++n) {
                        str = jsonArr.getString(n);
                        value[n] = Types.getProperData((byte)dataType, (String)str);
                    }
                    f.set(jsonObject, this._$1(dataType, value));
                    continue;
                }
                if (className.endsWith("boolean")) {
                    f.set(jsonObject, new Boolean(jsonProperties.getBoolean(name)));
                    continue;
                }
                if (className.endsWith("byte")) {
                    f.set(jsonObject, new Byte((byte)jsonProperties.getInt(name)));
                    continue;
                }
                if (className.endsWith("int") || className.endsWith("integer")) {
                    f.set(jsonObject, new Integer(jsonProperties.getInt(name)));
                    continue;
                }
                if (className.endsWith("short")) {
                    f.set(jsonObject, new Short((short)jsonProperties.getInt(name)));
                    continue;
                }
                if (className.endsWith("long")) {
                    f.set(jsonObject, new Long(jsonProperties.getLong(name)));
                    continue;
                }
                if (className.endsWith("float")) {
                    f.set(jsonObject, new Float(jsonProperties.getDouble(name)));
                    continue;
                }
                if (className.endsWith("double")) {
                    f.set(jsonObject, new Double(jsonProperties.getDouble(name)));
                    continue;
                }
                if (className.endsWith("string")) {
                    f.set(jsonObject, pValue);
                    continue;
                }
                if (className.endsWith("char")) {
                    f.set(jsonObject, Character.valueOf((char)jsonProperties.getInt(name)));
                    continue;
                }
                if (className.endsWith("list")) {
                    JSONArray array = jsonProperties.getJSONArray(name);
                    ArrayList<Object> al = new ArrayList<Object>();
                    for (int n = 0; n < array.length(); ++n) {
                        Object itemObj = array.get(n);
                        if (itemObj instanceof JSONObject) {
                            JSONObject jsonObj2 = (JSONObject)itemObj;
                            IJSONObject ijo = JSONUtils.parseObject(jsonObj2);
                            al.add(ijo);
                            continue;
                        }
                        if (itemObj instanceof String) {
                            str = (String)itemObj;
                            try {
                                JSONObject jsonObj3 = new JSONObject(str);
                                IJSONObject ijo = JSONUtils.parseObject(jsonObj3);
                                al.add(ijo);
                            }
                            catch (Exception x) {
                                al.add(str);
                            }
                            continue;
                        }
                        if (itemObj instanceof Number) {
                            Type genericType = f.getGenericType();
                            String genericDesc = genericType.toString();
                            if (genericDesc.indexOf("java.lang.Byte") > 0) {
                                al.add(((Number)itemObj).byteValue());
                                continue;
                            }
                            if (genericDesc.indexOf("java.lang.Short") > 0) {
                                al.add(((Number)itemObj).shortValue());
                                continue;
                            }
                            if (genericDesc.indexOf("java.lang.Long") > 0) {
                                al.add(((Number)itemObj).longValue());
                                continue;
                            }
                            if (genericDesc.indexOf("java.lang.Float") > 0) {
                                al.add(Float.valueOf(((Number)itemObj).floatValue()));
                                continue;
                            }
                            if (genericDesc.indexOf("java.lang.Double") > 0) {
                                al.add(((Number)itemObj).doubleValue());
                                continue;
                            }
                            al.add(itemObj);
                            continue;
                        }
                        String tmpClazz = itemObj.getClass().getName();
                        if (tmpClazz.equals("org.json.JSONObject$Null")) {
                            itemObj = null;
                        }
                        al.add(itemObj);
                    }
                    f.set(jsonObject, al);
                    continue;
                }
                if (this._$1(f.getType()) || className.endsWith("ibytemap") || className.endsWith("object")) {
                    if (pValue instanceof JSONObject) {
                        jsonObj = (JSONObject)pValue;
                    } else {
                        String json = (String)pValue;
                        jsonObj = new JSONObject(json);
                    }
                    IJSONObject ijo = JSONUtils.parseObject(jsonObj);
                    f.set(jsonObject, ijo);
                    continue;
                }
                if (!className.endsWith("hashmap")) continue;
                jsonObj = jsonProperties.getJSONObject(name);
                HashMap map = new HashMap();
                Iterator keys = jsonObj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    JSONArray val = jsonObj.getJSONArray(key);
                    ArrayList<IJSONObject> ijsons = new ArrayList<IJSONObject>();
                    for (int n = 0; n < val.length(); ++n) {
                        JSONObject tmp = val.getJSONObject(n);
                        IJSONObject ijson = JSONUtils.parseObject(tmp);
                        ijsons.add(ijson);
                    }
                    map.put(key, ijsons);
                }
                f.set(jsonObject, map);
                continue;
            }
            catch (NoSuchFieldException nField) {
                continue;
            }
            catch (JSONException jse) {
                continue;
            }
            catch (RuntimeException rqe) {
                throw rqe;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private Object[] _$1(byte type, Object[] value) {
        switch (type) {
            case 11: {
                Object[] strArr = new String[value.length];
                for (int i = 0; i < value.length; ++i) {
                    strArr[i] = (String)value[i];
                }
                return strArr;
            }
        }
        return null;
    }

    private byte _$1(String className) {
        if (className.endsWith("boolean")) {
            return 12;
        }
        if (className.endsWith("byte")) {
            return 1;
        }
        if (className.endsWith("int") || className.endsWith("integer")) {
            return 1;
        }
        if (className.endsWith("float")) {
            return 5;
        }
        if (className.endsWith("double")) {
            return 6;
        }
        return 11;
    }

    public String toString() {
        try {
            return this.getJson().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setJson(JSONObject jsonProperties) {
        this._$1(this.getClass(), this, jsonProperties);
        this._$1();
    }

    public void loadProperties(String json) throws JSONException {
        this.setJson(new JSONObject(json));
    }

    private boolean _$1(Class c) {
        if (c == null) {
            return false;
        }
        String cName = c.getSimpleName();
        if (cName.equals("IJSONObject")) {
            return true;
        }
        return this._$1(c.getSuperclass());
    }

    protected boolean getBitByPos(long value, byte pos) {
        return (value & 1L << pos) != 0L;
    }

    public static boolean isStringEqual(String str1, String str2) {
        boolean is2Invalid;
        boolean is1Invalid = !StringUtils.isValidString((Object)str1);
        boolean bl = is2Invalid = !StringUtils.isValidString((Object)str2);
        if (is1Invalid && is2Invalid) {
            return true;
        }
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean isStrListEqual(List<String> lst1, List<String> lst2) {
        if (lst1 == null) {
            return lst2 == null;
        }
        if (lst2 == null) {
            return false;
        }
        if (lst1.size() != lst2.size()) {
            return false;
        }
        int size = lst1.size();
        for (int i = 0; i < size; ++i) {
            String str2;
            String str1 = lst1.get(i);
            if (IJSONObject.isStringEqual(str1, str2 = lst2.get(i))) continue;
            return false;
        }
        return true;
    }
}

