/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.server;

import com.esproc.dql.server.IJSONObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtils {
    public static String list2String(List<String> list) {
        if (list == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(list.get(i));
        }
        return buf.toString();
    }

    public static List<String> string2List(String listStr) {
        if (listStr == null || listStr.trim().length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(listStr, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static IJSONObject readObject(InputStream is) throws Exception {
        String json = JSONUtils.readJson(is);
        return JSONUtils.parseObject(json);
    }

    public static IJSONObject parseObject(String jsonStr) throws Exception {
        return JSONUtils.parseObject(new JSONObject(jsonStr));
    }

    public static IJSONObject parseObject(JSONObject jsonObj) throws Exception {
        String className = null;
        try {
            className = jsonObj.getString("class");
        }
        catch (Exception x) {
            // empty catch block
        }
        if (className == null) {
            throw new Exception("Unknown json format!");
        }
        Class<?> c = Class.forName(className);
        Object o = c.newInstance();
        if (!(o instanceof IJSONObject)) {
            throw new Exception(className + " is not a sub class of IJSONObject.");
        }
        IJSONObject jsonO = (IJSONObject)o;
        jsonO.setJson(jsonObj);
        return jsonO;
    }

    public static void writeObject(OutputStream os, IJSONObject obj) throws Exception {
        String json = obj.getJson().toString();
        JSONUtils._$1(os, json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void _$1(OutputStream os, String json) throws IOException {
        OutputStreamWriter ow = null;
        BufferedWriter bw = null;
        try {
            ow = new OutputStreamWriter(os, "UTF-8");
            bw = new BufferedWriter(ow);
            bw.write(json);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
            if (ow != null) {
                try {
                    ow.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readJson(InputStream is) throws IOException {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String s;
            byte[] BOM = new byte[3];
            is.read(BOM);
            StringBuffer buf = new StringBuffer();
            if (BOM[0] == -17 && BOM[1] == -69 && BOM[2] == -65) {
                System.err.println("BOM encountered.");
            } else {
                buf.append(new String(BOM, "UTF-8"));
            }
            isr = new InputStreamReader(is, "UTF-8");
            br = new BufferedReader(isr);
            while ((s = br.readLine()) != null) {
                buf.append(s);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String getString(JSONObject obj, String key) {
        try {
            return obj.getString(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Integer getInteger(JSONObject obj, String key) {
        try {
            return new Integer(obj.getInt(key));
        }
        catch (Exception exception) {
            return new Integer(0);
        }
    }

    public static Field getField(Object obj, String fieldName) {
        Class<?> clazz = obj.getClass();
        Field f = JSONUtils._$1(clazz, fieldName, obj);
        if (f == null) {
            throw new RuntimeException("Field " + fieldName + " is not exist.");
        }
        return f;
    }

    private static Field _$1(Class clazz, String field, Object obj) {
        if (clazz.getName().endsWith("IJSONObject")) {
            return null;
        }
        Field f = JSONUtils._$1(clazz.getSuperclass(), field, obj);
        if (f != null) {
            return f;
        }
        try {
            f = clazz.getDeclaredField(field);
            f.setAccessible(true);
            return f;
        }
        catch (Exception x) {
            return null;
        }
    }
}

