/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.server;

import com.esproc.dql.Request;
import com.esproc.dql.Response;
import com.esproc.dql.jdbc.DQLUtil;
import com.esproc.dql.server.JSONUtils;
import com.esproc.dql.server.Server;
import com.esproc.dql.server.ServerMsg;
import com.esproc.dql.server.Service;
import com.esproc.dql.server.ServiceManager;
import com.esproc.dql.server.TaskManager;
import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.query.metadata.AggrItem;
import com.scudata.dm.query.metadata.ClassItem;
import com.scudata.dm.query.metadata.DataItem;
import com.scudata.dm.query.metadata.Dictionary;
import com.scudata.dm.query.metadata.DimItem;
import com.scudata.dm.query.metadata.ErrorData;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.FieldList;
import com.scudata.dm.query.metadata.ForeignKey;
import com.scudata.dm.query.metadata.ForeignKeyList;
import com.scudata.dm.query.metadata.IField;
import com.scudata.dm.query.metadata.IJSONObject;
import com.scudata.dm.query.metadata.LevelFunction;
import com.scudata.dm.query.metadata.LevelFunctionList;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Table;
import com.scudata.dm.query.metadata.TableItem;
import com.scudata.dm.query.metadata.TableList;
import com.scudata.dm.query.metadata.TableVisibility;
import com.scudata.dm.query.metadata.Visibility;
import com.scudata.dm.query.utils.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl
extends Service {
    public static final int FILE_TYPE_LMD = 1;
    public static final int FILE_TYPE_DCT = 2;
    public static final int FILE_TYPE_VSB = 3;
    public static final int FILE_TYPE_LEX = 4;
    String _$13;
    String _$12;
    private LogicMetaData _$11;
    HashMap<String, Visibility> _$10 = new HashMap();
    HashMap<String, String> _$9 = new HashMap();
    HashMap<String, Boolean> _$8 = new HashMap();
    HashMap _$7 = new HashMap();
    Dictionary _$6;
    private HashMap<File, Visibility> _$5 = new HashMap();
    transient Context _$4 = new Context();
    boolean _$3 = false;
    private Timer _$2 = null;
    int _$1;

    public void setUserInJson(boolean uij) {
        this._$3 = uij;
    }

    public void setServiceName(String name) {
        this._$13 = name;
    }

    @Override
    public String getServiceName() {
        return this._$13;
    }

    public LogicMetaData loadLogicMetaData(File lmdFile, Context ctx) throws Exception {
        LogicMetaData lmd = IOUtil.readLogicMetaData(lmdFile.getAbsolutePath());
        if (lmd == null) {
            throw new Exception(ServerMsg.get().getMessage("ServiceImpl.invalidlmd", (Object)lmdFile.getAbsolutePath()));
        }
        List<ErrorData> errors = lmd.prepare(ctx);
        if (!lmd.getReady()) {
            throw new Exception(DQLUtil.getErrorString(errors));
        }
        return lmd;
    }

    public LogicMetaData getLogicMetaData() {
        if (this._$11 == null) {
            try {
                this._$11 = this.loadLogicMetaData(new File(this._$12), this._$4);
            }
            catch (Exception x) {
                Logger.severe((Object)x);
            }
        }
        return this._$11;
    }

    public Context getContext() {
        return this._$4;
    }

    public Context getContext(String user) {
        return this._$4;
    }

    public void putVisibility(String user, File tmpFile) throws Exception {
        Visibility v = this._$5.get(tmpFile);
        if (v == null) {
            v = IOUtil.readVisibility(tmpFile.getAbsolutePath());
            this._$5.put(tmpFile, v);
        }
        this._$10.put(user, v);
    }

    @Override
    public Visibility getVisibility(String user) {
        return this._$10.get(user);
    }

    public void putStrict(String user, Boolean strict) {
        this._$7.put(user, strict);
    }

    public boolean isStrict(String user) {
        return (Boolean)this._$7.get(user);
    }

    public void putPassword(String user, String pwd) {
        this._$9.put(user, pwd);
    }

    public void putAdmin(String user, String admin) {
        if (StringUtils.isValidString((Object)admin)) {
            this._$8.put(user, new Boolean(admin));
        }
    }

    @Override
    public boolean isUserExist(String user) {
        String userpwd = this._$9.get(user);
        return userpwd != null;
    }

    public boolean isAdminUser(String user) {
        Boolean B = this._$8.get(user);
        if (B == null) {
            return false;
        }
        return B;
    }

    @Override
    public boolean check(String user, String pwd) {
        if (this._$9.isEmpty()) {
            return true;
        }
        String userpwd = this._$9.get(user);
        if (userpwd == null) {
            return false;
        }
        return userpwd.equals(pwd);
    }

    public void setDictionary(File tmpFile) throws Exception {
        this._$6 = IOUtil.readDictionary(tmpFile.getAbsolutePath());
    }

    public Dictionary getDictionary() {
        return this._$6;
    }

    @Override
    public void stopFrequenceWriter() {
        if (this._$2 != null) {
            this._$2.cancel();
        }
    }

    public Response executeDQL(Request req) {
        return TaskManager.execute(req, this);
    }

    public boolean modifyDefaultFile(String user, int type, byte[] fileContents) throws Exception {
        if (!this.writeDefaultFileContents(user, type, fileContents)) {
            return false;
        }
        String path = this.getDefaultFilePath(user, type);
        File tmpFile = new File(path);
        switch (type) {
            case 1: {
                this._$11 = this.loadLogicMetaData(tmpFile, this._$4);
                break;
            }
            case 2: {
                this.setDictionary(tmpFile);
                break;
            }
            case 3: {
                this.putVisibility(user, tmpFile);
            }
        }
        return true;
    }

    public boolean writeDefaultFileContents(String user, int type, byte[] fileContents) throws Exception {
        String filePath = this.getDefaultFilePath(user, type);
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            fos.write(fileContents);
            Logger.debug((Object)ServerMsg.get().getMessage("ServiceImpl.update", (Object)filePath));
            fos.close();
        }
        catch (FileNotFoundException x) {
            x.printStackTrace();
            return false;
        }
        return true;
    }

    public String getDefaultFilePath(String user, int type) {
        String defaultName = null;
        switch (type) {
            case 1: {
                defaultName = "logicmetadata.glmd";
                break;
            }
            case 2: {
                defaultName = "dictionary.gdct";
                break;
            }
            case 3: {
                defaultName = user + ".visibility.gvsb";
                break;
            }
            case 4: {
                defaultName = "le.gvsb";
            }
        }
        if (defaultName == null) {
            return null;
        }
        String tmpPath = Server.getAbsolutePath(ServiceManager.ESPROC_SERVICES + this._$13 + "/conf/" + defaultName);
        return tmpPath;
    }

    private void _$1() throws Exception {
        String path = Server.getAbsolutePath(ServiceManager.ESPROC_SERVICES + this._$13 + "/users.json");
        File file = new File(path);
        if (!file.exists()) {
            throw new Exception(ServerMsg.get().getMessage("ServiceImpl.nofile", (Object)path));
        }
        FileInputStream in = new FileInputStream(file);
        String json = JSONUtils.readJson(in);
        JSONArray userArray = new JSONArray(json);
        for (int u = 0; u < userArray.length(); ++u) {
            String tmpPath;
            JSONObject user = (JSONObject)userArray.get(u);
            String userName = JSONUtils.getString(user, "name");
            this.putPassword(userName, JSONUtils.getString(user, "password"));
            this.putAdmin(userName, JSONUtils.getString(user, "admin"));
            String buff = this.getDefaultFilePath(userName, 3);
            File tmpFile = new File(buff);
            if (!tmpFile.exists() && StringUtils.isValidString((Object)(buff = JSONUtils.getString(user, "visibility"))) && !(tmpFile = new File(tmpPath = Server.getAbsolutePath(ServiceManager.ESPROC_SERVICES + this._$13 + "/conf/" + buff))).exists()) {
                throw new Exception(ServerMsg.get().getMessage("ServiceImpl.nofile", (Object)tmpPath));
            }
            if (tmpFile.exists()) {
                this.putVisibility(userName, tmpFile);
            }
            if (StringUtils.isValidString((Object)(buff = JSONUtils.getString(user, "strict")))) {
                this.putStrict(userName, new Boolean(buff));
                continue;
            }
            this.putStrict(userName, Boolean.FALSE);
        }
    }

    public void load() throws Exception {
        String tmpPath;
        String buff;
        String path = Server.getAbsolutePath(ServiceManager.ESPROC_SERVICES + this._$13 + "/service.xml");
        File file = new File(path);
        if (!file.exists()) {
            throw new Exception(ServerMsg.get().getMessage("ServiceImpl.nofile", (Object)path));
        }
        FileInputStream is = new FileInputStream(file);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document xmlDocument = docBuilder.parse(is);
        NodeList nl = xmlDocument.getChildNodes();
        Node root = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equalsIgnoreCase("SERVICE")) continue;
            root = n;
        }
        if (root == null) {
            throw new Exception(ServerMsg.get().getMessage("ServiceImpl.errxml"));
        }
        this._$12 = buff = this.getDefaultFilePath(null, 1);
        File tmpFile = new File(buff);
        if (!tmpFile.exists()) {
            buff = ServiceManager.getAttribute(root, "logicmetadata");
            if (!StringUtils.isValidString((Object)buff)) {
                throw new Exception(ServerMsg.get().getMessage("ServiceImpl.invalidattr", (Object)"logicmetadata"));
            }
            tmpPath = Server.getAbsolutePath(ServiceManager.ESPROC_SERVICES + this._$13 + "/conf/" + buff);
            tmpFile = new File(tmpPath);
            if (!tmpFile.exists()) {
                throw new Exception(ServerMsg.get().getMessage("ServiceImpl.nofile", (Object)tmpPath));
            }
        }
        this._$11 = this.loadLogicMetaData(tmpFile, this._$4);
        buff = this.getDefaultFilePath(null, 2);
        tmpFile = new File(buff);
        if (!tmpFile.exists() && StringUtils.isValidString((Object)(buff = ServiceManager.getAttribute(root, "dictionary"))) && !(tmpFile = new File(tmpPath = Server.getAbsolutePath(ServiceManager.ESPROC_SERVICES + this._$13 + "/conf/" + buff))).exists()) {
            throw new Exception(ServerMsg.get().getMessage("ServiceImpl.nofile", (Object)tmpPath));
        }
        try {
            if (tmpFile.exists()) {
                this.setDictionary(tmpFile);
            }
        }
        catch (Exception ex) {
            Logger.error((Object)ServerMsg.get().getMessage("ServiceImpl.loadfileerror", (Object)tmpFile));
        }
        buff = this.getDefaultFilePath(null, 4);
        tmpFile = new File(buff);
        if (!tmpFile.exists() && StringUtils.isValidString((Object)(buff = ServiceManager.getAttribute(root, "lexicon"))) && !(tmpFile = new File(tmpPath = Server.getAbsolutePath(ServiceManager.ESPROC_SERVICES + this._$13 + "/conf/" + buff))).exists()) {
            throw new Exception(ServerMsg.get().getMessage("ServiceImpl.nofile", (Object)tmpPath));
        }
        if (this._$3) {
            path = Server.getAbsolutePath(ServiceManager.ESPROC_SERVICES + this._$13 + "/users.json");
            this._$1();
        } else {
            Node users = ServiceImpl._$1(root, "USERS");
            NodeList userList = users.getChildNodes();
            for (int u = 0; u < userList.getLength(); ++u) {
                String tmpPath2;
                Node user = userList.item(u);
                if (user.getNodeType() != 1) continue;
                String userName = ServiceManager.getAttribute(user, "name");
                this.putPassword(userName, ServiceManager.getAttribute(user, "password"));
                this.putAdmin(userName, ServiceManager.getAttribute(user, "admin"));
                buff = this.getDefaultFilePath(userName, 3);
                tmpFile = new File(buff);
                if (!tmpFile.exists() && StringUtils.isValidString((Object)(buff = ServiceManager.getAttribute(user, "visibility"))) && !(tmpFile = new File(tmpPath2 = Server.getAbsolutePath(ServiceManager.ESPROC_SERVICES + this._$13 + "/conf/" + buff))).exists()) {
                    throw new Exception(ServerMsg.get().getMessage("ServiceImpl.nofile", (Object)tmpPath2));
                }
                if (tmpFile.exists()) {
                    this.putVisibility(userName, tmpFile);
                }
                if (StringUtils.isValidString((Object)(buff = ServiceManager.getAttribute(user, "strict")))) {
                    this.putStrict(userName, new Boolean(buff));
                    continue;
                }
                this.putStrict(userName, Boolean.FALSE);
            }
        }
    }

    private static Node _$1(Node pNode, String sonName) {
        NodeList list = pNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node subNode = list.item(i);
            if (!subNode.getNodeName().equalsIgnoreCase(sonName)) continue;
            return subNode;
        }
        return null;
    }

    @Override
    public com.scudata.dm.Table listMetaData(String dql, String user) {
        return DQLUtil.listMetaData(this._$11, dql);
    }

    @Override
    public com.scudata.dm.Table getTables(Object requestParam, String user) {
        Object[] params = (Object[])requestParam;
        String schemaPattern = params[1] == null ? null : (String)params[1];
        String tableNamePattern = params[2] == null ? null : (String)params[2];
        LogicMetaData lmd = this.getLogicMetaData();
        Visibility vis = this.getVisibility(user);
        com.scudata.dm.Table t = DQLUtil.getTables(schemaPattern, tableNamePattern, lmd, vis);
        return t;
    }

    @Override
    public com.scudata.dm.Table getColumns(Object requestParam, String user) {
        Object[] params = (Object[])requestParam;
        String schemaPattern = params[1] == null ? null : (String)params[1];
        String tableNamePattern = params[2] == null ? null : (String)params[2];
        String columnNamePattern = params[3] == null ? null : (String)params[3];
        LogicMetaData lmd = this.getLogicMetaData();
        Visibility vis = this.getVisibility(user);
        com.scudata.dm.Table t = DQLUtil.getColumns(schemaPattern, tableNamePattern, columnNamePattern, lmd, vis);
        return t;
    }

    @Override
    public com.scudata.dm.Table getPrimaryKeys(Object requestParam, String user) {
        Object[] params = (Object[])requestParam;
        String tableNamePattern = params[2] == null ? null : (String)params[2];
        LogicMetaData lmd = this.getLogicMetaData();
        Visibility vis = this.getVisibility(user);
        com.scudata.dm.Table table = DQLUtil.getPrimaryKeys(tableNamePattern, lmd, vis);
        return table;
    }

    @Override
    public com.scudata.dm.Table getExportedKeys(Object requestParam, String user) {
        Object[] params = (Object[])requestParam;
        String tableNamePattern = params[2] == null ? null : (String)params[2];
        LogicMetaData lmd = this.getLogicMetaData();
        Visibility vis = this.getVisibility(user);
        com.scudata.dm.Table table = DQLUtil.getExportedKeys(tableNamePattern, lmd, vis);
        return table;
    }

    @Override
    public com.scudata.dm.Table getImportedKeys(Object requestParam, String user) {
        Object[] params = (Object[])requestParam;
        String tableNamePattern = params[2] == null ? null : (String)params[2];
        LogicMetaData lmd = this.getLogicMetaData();
        Visibility vis = this.getVisibility(user);
        com.scudata.dm.Table table = DQLUtil.getImportedKeys(tableNamePattern, lmd, vis);
        return table;
    }

    public Object result(String dql, String user) {
        LogicMetaData lmd = this.getLogicMetaData();
        Visibility vis = this.getVisibility(user);
        Dictionary dct = this.getDictionary();
        return null;
    }

    public String metaData() {
        return null;
    }

    private static int _$1(Visibility vis, String t, LogicMetaData lmd) {
        if (vis == null) {
            return 2;
        }
        Table to = lmd.getTableByName(t);
        if (to == null) {
            Logger.warn((Object)ServerMsg.get().getMessage("ServiceImpl.notable", (Object)t));
            return 2;
        }
        List<TableVisibility> tvl = vis.getTableVisibilityList();
        for (int i = 0; i < tvl.size(); ++i) {
            TableVisibility tv = tvl.get(i);
            if (!t.equals(tv.getName())) continue;
            if (tv.isVisible() == 0) {
                return 0;
            }
            return 2;
        }
        return 2;
    }

    private static TableItem _$1(Dictionary dict, String t) {
        if (dict == null) {
            return null;
        }
        List<TableItem> til = dict.getTableItemList();
        for (int i = 0; i < til.size(); ++i) {
            TableItem tv = til.get(i);
            if (!t.equals(tv.getObjectName())) continue;
            return tv;
        }
        return null;
    }

    private static DataItem _$1(TableItem ti, String f) {
        if (ti == null) {
            return null;
        }
        List<DataItem> fil = ti.getDataItemList();
        if (fil != null) {
            for (int j = 0; j < fil.size(); ++j) {
                DataItem fi = fil.get(j);
                if (!f.equals(fi.getObjectName())) continue;
                return fi;
            }
        }
        return null;
    }

    private static DimItem _$1(Dictionary dict, String dim, String src) {
        if (dict == null) {
            return null;
        }
        List<DimItem> fil = dict.getDimItemList();
        if (fil == null) {
            return null;
        }
        for (int j = 0; j < fil.size(); ++j) {
            DimItem fi = fil.get(j);
            if (!fi.getDimName().equals(dim) && !fi.getDimName().equals(src)) continue;
            return fi;
        }
        return null;
    }

    private static byte _$1(int t) {
        switch (t) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
            case 8: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
        }
        return 2;
    }

    private static String _$1(Visibility vis, IField f, LogicMetaData lmd) {
        Table t1 = f.getRefTable();
        if (t1 != null && !t1.getName().equals(f.getTable().getName())) {
            return t1.getName();
        }
        TableList tl = null;
        try {
            tl = f.getTable().getAnnexTableList();
        }
        catch (Exception e) {
            return null;
        }
        if (tl == null || tl.size() == 0) {
            // empty if block
        }
        for (int i = 0; i < tl.size(); ++i) {
            Table t = (Table)tl.get(i);
            if (ServiceImpl._$1(vis, t.getName(), lmd) == 0) continue;
            if (t.getType() == 1) {
                return null;
            }
            return t.getName();
        }
        return null;
    }

    private static String _$1(Visibility vis, IField f) {
        TableList tl = f.getTable().getAnnexTableList();
        if (tl == null) {
            return null;
        }
        for (int i = 0; i < tl.size(); ++i) {
            Table t = (Table)tl.get(i);
            if (t.getType() != 1) continue;
            return t.getName();
        }
        return null;
    }

    private static Object _$1(List<?> objs, String name) {
        for (Object obj : objs) {
            TableItem ti;
            DataItem di;
            if (obj instanceof DataItem && (di = (DataItem)obj).getName().equals(name)) {
                return di;
            }
            if (!(obj instanceof TableItem) || !(ti = (TableItem)obj).getName().equals(name)) continue;
            return ti;
        }
        return null;
    }

    private static String[] _$1(LogicMetaData lmd, Dictionary dict, String exp) {
        if (dict == null || exp == null) {
            return null;
        }
        String[] alias = exp.split("\\.");
        if (alias.length != 2) {
            return null;
        }
        Object o = ServiceImpl._$1(dict.getTableItemList(), alias[0]);
        if (o == null) {
            return null;
        }
        TableItem ti = (TableItem)o;
        if ((o = ServiceImpl._$1(ti.getDataItemList(), alias[1])) == null) {
            return null;
        }
        DataItem fi = (DataItem)o;
        Table t = lmd.getTableByName(ti.getObjectName());
        Field f = t.getFieldByName(fi.getObjectName());
        return new String[]{t.getName(), f.getName()};
    }

    public void setDBType(int dbType) {
        this._$1 = dbType;
    }

    public int getDBType() {
        return this._$1;
    }

    @Override
    public String getDQLFieldsAttr(String dql, String user) {
        return null;
    }

    private static String _$1(LevelFunction l) {
        if (l.getDestDim() == null) {
            return null;
        }
        return l.getDestDim().getTable().getName() + "." + l.getDestDim().getName();
    }

    @Override
    public String getMetaDataJSON(String user) throws Exception {
        LogicMetaData lmd = this.getLogicMetaData();
        Visibility vis = this.getVisibility(user);
        Dictionary dict = this.getDictionary();
        return ServiceImpl.getMetaDataJSON(lmd, vis, dict);
    }

    public static String getMetaDataJSON(LogicMetaData lmd, Visibility vis, Dictionary dict) throws Exception {
        List<ClassItem> cil;
        IJSONObject ti;
        boolean isDQL = true;
        TableList dims = lmd.getDimList();
        ArrayList hideDims = new ArrayList();
        if (isDQL && dims != null) {
            for (int i = 0; i < dims.size(); ++i) {
                Table l = (Table)dims.get(i);
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{<d_q>tables<d_q>:[");
        ArrayList tl = new ArrayList();
        TableList tl1 = lmd.getTableList();
        if (tl1 != null) {
            for (int i = 0; i < tl1.size(); ++i) {
                tl.add(tl1.get(i));
            }
        }
        int tCount = 0;
        for (int i = 0; i < tl.size(); ++i) {
            Table t = (Table)tl.get(i);
            int tvis = ServiceImpl._$1(vis, t.getName(), lmd);
            if (tCount > 0) {
                sb.append(",");
            }
            ++tCount;
            ti = ServiceImpl._$1(dict, t.getName());
            sb.append("{<d_q>name<d_q>:<d_q>").append(t.getName() + "<d_q>");
            sb.append(",<d_q>dispName<d_q>:<d_q>" + (ti == null ? t.getName() : ((TableItem)ti).getName()) + "<d_q>");
            sb.append(",<d_q>type<d_q>:<d_q>" + t.getType());
            sb.append("<d_q>,<d_q>desc<d_q>:<d_q><d_q>");
            sb.append(tvis == 1 ? ",<d_q>hide<d_q>:1" : "");
            sb.append(",<d_q>fields<d_q>:[");
            FieldList fl = t.getFieldList();
            int fCount = 0;
            if (fl != null) {
                for (int j = 0; j < fl.size(); ++j) {
                    Field f = (Field)fl.get(j);
                    int fvis = ServiceImpl._$1(vis, t.getName(), f.getName(), lmd);
                    if (i < tl1.size() && fvis == 0) continue;
                    if (fCount > 0) {
                        sb.append(",");
                    }
                    ++fCount;
                    DataItem fi = ServiceImpl._$1((TableItem)ti, f.getName());
                    String dim = "";
                    if (f.getDim() != null && isDQL && ((dim = f.getDim().getTable().getName()) == null || dim.length() == 0)) {
                        dim = f.getDim().getTable().getName() + "." + f.getDim().getName();
                    }
                    sb.append("{<d_q>name<d_q>:<d_q>" + f.getName() + "<d_q>");
                    sb.append(",<d_q>type<d_q>:" + ServiceImpl._$1(f.getDataType()));
                    if (fi != null) {
                        sb.append(",<d_q>dispName<d_q>:<d_q>" + fi.getName() + "<d_q>,<d_q>aliases<d_q>:<d_q>" + (fi.alias == null ? "" : fi.alias) + "<d_q>");
                        sb.append(",<d_q>aggrs<d_q>:[");
                        List<AggrItem> aggrs = fi.getAggrItemList();
                        if (aggrs != null) {
                            for (int p = 0; p < aggrs.size(); ++p) {
                                if (p > 0) {
                                    sb.append(",");
                                }
                                String mm = "";
                                int m = aggrs.get(p).getMode();
                                if (m == 1) {
                                    mm = "avg";
                                } else if (m == 4) {
                                    mm = "count";
                                } else if (m == 5) {
                                    mm = "countd";
                                } else if (m == 0) {
                                    mm = "sum";
                                } else if (m == 2) {
                                    mm = "max";
                                } else if (m == 3) {
                                    mm = "min";
                                }
                                String aa = aggrs.get(p).getAlias();
                                if (aa == null) {
                                    aa = "";
                                }
                                sb.append("{<d_q>aggr<d_q>:<d_q>" + mm + "<d_q>,<d_q>name<d_q>:<d_q>" + aggrs.get(p).getName() + "<d_q>,<d_q>aliases<d_q>:<d_q>" + aa + "<d_q>}");
                            }
                        }
                        sb.append("]");
                        sb.append(",<d_q>edit<d_q>:<d_q><d_q>");
                        sb.append(",<d_q>format<d_q>:<d_q>" + (fi.getFormat() == null ? "" : fi.getFormat()) + "<d_q>");
                    }
                    sb.append(",<d_q>pk<d_q>:" + (f.isPrimary() ? 1 : 0) + ",<d_q>dim<d_q>:<d_q>" + dim + "<d_q>");
                    String dt = ServiceImpl._$1(vis, f, lmd);
                    if (dt != null) {
                        sb.append(",<d_q>destTable<d_q>:<d_q>" + dim + "<d_q>");
                    }
                    LevelFunctionList ll = f.getLevelFunctionList();
                    if (isDQL && (ll == null || ll.size() == 0) && f.getDim() != null) {
                        ll = f.getDim().getLevelFunctionList();
                    }
                    if (ll != null && ll.size() > 0) {
                        Field d1 = f.getDim();
                        sb.append(",<d_q>destLevels<d_q>:[");
                        boolean first = true;
                        for (int k = 0; k < ll.size(); ++k) {
                            String[] dest;
                            LevelFunction l = (LevelFunction)ll.get(k);
                            if (l.getDestDim() == null) continue;
                            String d2 = l.getDestDim().getName();
                            String destSrc = ServiceImpl._$1(l);
                            if (destSrc == null || (dest = destSrc.split("\\.")).length != 2) continue;
                            if (!first) {
                                sb.append(",");
                            }
                            sb.append("{<d_q>name<d_q>:<d_q>" + l.getName() + "<d_q>");
                            if (d1 != null && d1.getName().equals(d2)) {
                                sb.append(",<d_q>type<d_q>:1");
                            }
                            sb.append(",<d_q>dest<d_q>:<d_q>" + destSrc + "<d_q>}");
                            first = false;
                        }
                        sb.append("]");
                    }
                    sb.append("}");
                }
            }
            ForeignKeyList fkl = t.getForeignKeyList();
            sb.append("],<d_q>fks<d_q>:[");
            if (isDQL && fkl != null) {
                fCount = 0;
                for (int j = 0; j < fkl.size(); ++j) {
                    ForeignKey fk = (ForeignKey)fkl.get(j);
                    boolean pseud = false;
                    String dt = ServiceImpl._$1(vis, fk, lmd);
                    if (dt == null) {
                        dt = ServiceImpl._$1(vis, fk);
                        if (dt == null) continue;
                        pseud = true;
                    }
                    if (fCount > 0) {
                        sb.append(",");
                    }
                    ++fCount;
                    sb.append("{<d_q>name<d_q>:<d_q>").append(fk.getName() + "<d_q>,<d_q>hide<d_q>:" + (pseud ? 1 : 0));
                    if (dt != null) {
                        sb.append(",<d_q>destTable<d_q>:<d_q>" + dt + "<d_q>");
                    }
                    sb.append(",<d_q>desc<d_q>:<d_q><d_q>");
                    DataItem fi = ServiceImpl._$1((TableItem)ti, fk.getName());
                    if (fi != null) {
                        sb.append(",<d_q>dispName<d_q>:<d_q>" + fi.getName() + "<d_q>,<d_q>aliases<d_q>:<d_q>" + (fi.alias == null ? "" : fi.alias) + "<d_q>");
                        sb.append(",<d_q>aggrs<d_q>:[");
                        List<AggrItem> aggrs = fi.getAggrItemList();
                        if (aggrs != null) {
                            for (int p = 0; p < aggrs.size(); ++p) {
                                if (p > 0) {
                                    sb.append(",");
                                }
                                String mm = "";
                                int m = aggrs.get(p).getMode();
                                if (m == 1) {
                                    mm = "avg";
                                } else if (m == 4) {
                                    mm = "count";
                                } else if (m == 5) {
                                    mm = "countd";
                                } else if (m == 0) {
                                    mm = "sum";
                                } else if (m == 2) {
                                    mm = "max";
                                } else if (m == 3) {
                                    mm = "min";
                                }
                                String aa = aggrs.get(p).getAlias();
                                if (aa == null) {
                                    aa = "";
                                }
                                sb.append("{<d_q>aggr<d_q>:<d_q>" + mm + "<d_q>,<d_q>name<d_q>:<d_q>" + aggrs.get(p).getName() + "<d_q>,<d_q>aliases<d_q>:<d_q>" + aa + "<d_q>}");
                            }
                        }
                        sb.append("]");
                        sb.append(",<d_q>format<d_q>:<d_q>" + (fi.getFormat() == null ? "" : fi.getFormat()) + "<d_q>");
                    }
                    sb.append(",<d_q>fields<d_q>:[");
                    List<String> fkfl = fk.getFieldNameList();
                    for (int k = 0; k < fkfl.size(); ++k) {
                        if (k > 0) {
                            sb.append(",");
                        }
                        sb.append("<d_q>" + fkfl.get(k).toString() + "<d_q>");
                    }
                    sb.append("]}");
                }
            }
            sb.append("],<d_q>subTables<d_q>:[");
            TableList mdList = t.getDetailTableList();
            if (mdList != null) {
                for (int j = 0; j < mdList.size(); ++j) {
                    Table md = (Table)mdList.get(j);
                    if (j > 0) {
                        sb.append(",");
                    }
                    ForeignKeyList fks = md.getForeignKeyList();
                    String fkss = "";
                    for (int z = 0; z < fks.size(); ++z) {
                        if (z > 0) {
                            fkss = fkss + ",";
                        }
                        fkss = fkss + ((ForeignKey)fks.get(z)).getName();
                    }
                    sb.append("{<d_q>table<d_q>:<d_q>" + md.getName() + "<d_q>,<d_q>fk<d_q>:<d_q>" + fkss + "<d_q>}");
                }
            }
            sb.append("]}");
        }
        sb.append("],<d_q>dims<d_q>:[");
        if (isDQL && dims != null) {
            boolean first = true;
            for (int i = 0; i < dims.size(); ++i) {
                DimItem di;
                Table l = (Table)dims.get(i);
                if (l.getPK().size() != 1) continue;
                Field pkf = l.getPKFieldByName(l.getPK().get(0));
                if (!first) {
                    sb.append(",");
                }
                first = false;
                String dn = l.getName();
                sb.append("{<d_q>name<d_q>:<d_q>").append(dn).append("<d_q>");
                if (l.getDimType() != 0) {
                    sb.append(",<d_q>dt<d_q>:<d_q>" + l.getDimType() + "<d_q>,<d_q>exp<d_q>:<d_q>" + "" + "<d_q>");
                }
                if ((di = ServiceImpl._$1(dict, dn, l.getName() + "." + l.getName())) != null) {
                    sb.append(",<d_q>dispName<d_q>:<d_q>" + di.getName() + "<d_q>");
                    String[] cc = ServiceImpl._$1(lmd, dict, l.getName() + "." + di.getCodeCol());
                    String[] dc = ServiceImpl._$1(lmd, dict, l.getName() + "." + di.getDispCol());
                    String ct = di.getCodeTitle();
                    String dt = di.getDispTitle();
                    if (cc != null) {
                        String d = "";
                        ct = ct == null || ct.trim().length() == 0 ? cc[1] : ct.trim();
                        String sql = "SELECT t1." + cc[1] + " AS " + ct + "";
                        boolean hasDisp = false;
                        if (dc != null) {
                            d = dc[1];
                            dt = dt == null || dt.trim().length() == 0 ? dc[1] : dt.trim();
                            sql = sql + ", t1." + dc[1] + " AS " + dt;
                            hasDisp = true;
                        }
                        sb.append(",<d_q>item<d_q>:{<d_q>table<d_q>:<d_q>" + cc[0] + "<d_q>,<d_q>code<d_q>:<d_q>" + cc[1] + "<d_q>,<d_q>disp<d_q>:<d_q>" + d + "<d_q>}");
                        if (cc[0].toLowerCase().indexOf("select") >= 0) {
                            cc[0] = "(" + cc[0] + ")";
                        }
                        cc[0] = cc[0].replaceAll("'", "<sq>").replaceAll("\"", "<dq>");
                        sql = sql + " FROM " + cc[0] + " t1 ORDER BY t1." + cc[1] + " ASC";
                        Logger.debug((Object)("DIM SQL : " + sql));
                        if (hasDisp) {
                            sb.append(",<d_q>sql<d_q>:<d_q>" + sql + "<d_q>,<d_q>code<d_q>:<d_q>" + cc[1] + "<d_q>");
                        }
                    } else {
                        List<Object> consts = di.getConstList();
                        if (consts != null && consts.size() > 0) {
                            sb.append(",<d_q>vs<d_q>:<d_q>");
                            for (int a = 0; a < consts.size(); ++a) {
                                if (a > 0) {
                                    sb.append("r,q");
                                }
                                sb.append(consts.get(a).toString());
                            }
                            sb.append("<d_q>");
                        }
                    }
                }
                sb.append(",<d_q>table<d_q>:<d_q>" + l.getName() + "<d_q>,<d_q>field<d_q>:<d_q>" + l.getPK().get(0) + "<d_q>");
                LevelFunctionList ll = pkf.getLevelFunctionList();
                if (ll != null && ll.size() > 0) {
                    sb.append(",<d_q>destLevels<d_q>:[");
                    boolean f = true;
                    for (int k = 0; k < ll.size(); ++k) {
                        String[] dest;
                        LevelFunction lvl = (LevelFunction)ll.get(k);
                        String destSrc = ServiceImpl._$1(lvl);
                        if (destSrc == null || (dest = destSrc.split("\\.")).length != 2) continue;
                        if (!f) {
                            sb.append(",");
                        }
                        sb.append("{<d_q>name<d_q>:<d_q>" + lvl.getName() + "<d_q>,<d_q>dest<d_q>:<d_q>" + destSrc + "<d_q>,<d_q>formula<d_q>:<d_q>" + lvl.getFormula().replaceAll("'", "<sq>").replaceAll("\"", "<dq>") + "<d_q>}");
                        f = false;
                    }
                    sb.append("]");
                }
                sb.append("}");
            }
        }
        sb.append("],<d_q>levels<d_q>:[");
        sb.append("],<d_q>annexTables<d_q>:[");
        boolean firstT = true;
        ArrayList<String> dealTables = new ArrayList<String>();
        for (int i = 0; i < tl.size(); ++i) {
            ti = (Table)tl.get(i);
            TableList l = ((Table)ti).getAnnexTableList();
            if (l == null || l.size() < 2 || dealTables.indexOf(((Table)ti).getName()) >= 0) continue;
            if (!firstT) {
                sb.append(",");
            }
            firstT = false;
            sb.append("[");
            boolean first = true;
            for (int j = 0; j < l.size(); ++j) {
                String t = ((Table)l.get(j)).getName();
                if (ServiceImpl._$1(vis, t, lmd) == 0) continue;
                if (!first) {
                    sb.append(",");
                }
                first = false;
                Table table = lmd.getTableByName(t);
                FieldList fl = table.getPKFieldList();
                dealTables.add(t);
                sb.append("{<d_q>name<d_q>:<d_q>" + t + "<d_q>,<d_q>pks<d_q>:[");
                if (fl != null) {
                    for (int k = 0; k < fl.size(); ++k) {
                        if (k > 0) {
                            sb.append(",");
                        }
                        sb.append("<d_q>" + ((Field)fl.get(k)).getName() + "<d_q>");
                    }
                }
                sb.append("]}");
            }
            sb.append("]");
        }
        sb.append("],<d_q>classTables<d_q>:[");
        if (dict != null && (cil = dict.getClassItemList()) != null) {
            for (int i = 0; i < cil.size(); ++i) {
                StringBuffer sb1 = new StringBuffer();
                ClassItem ci = cil.get(i);
                sb1.append("{<d_q>name<d_q>:<d_q>" + ci.getName() + "<d_q>,<d_q>tables<d_q>:[");
                List<TableItem> ts1 = ci.getTableItemList();
                boolean first = true;
                if (ts1 != null) {
                    for (int j = 0; j < ts1.size(); ++j) {
                        TableItem t1 = ts1.get(j);
                        TableItem t2 = ServiceImpl.getTableItemByName(dict, t1.getName());
                        if (t2 == null || ServiceImpl._$1(vis, t2.getObjectName(), lmd) != 2) continue;
                        if (!first) {
                            sb1.append(",");
                        }
                        first = false;
                        sb1.append("{<d_q>name<d_q>:<d_q>" + t2.getObjectName() + "<d_q>,<d_q>fields<d_q>:[");
                        List<DataItem> f1 = t1.getDataItemList();
                        List<DataItem> f2 = t2.getDataItemList();
                        if (f1 != null) {
                            boolean ffirst = true;
                            for (int k = 0; k < f1.size(); ++k) {
                                DataItem d1 = f1.get(k);
                                DataItem d2 = ServiceImpl.getDataItemByName(f2, d1.getName());
                                if (d2 == null || ServiceImpl._$1(vis, t2.getObjectName(), d2.getObjectName(), lmd) == 0) continue;
                                if (!ffirst) {
                                    sb1.append(",");
                                } else {
                                    ffirst = false;
                                }
                                sb1.append("<d_q>" + d2.getObjectName() + "<d_q>");
                            }
                        }
                        sb1.append("],<d_q>locators<d_q>:[");
                        sb1.append("]}");
                    }
                }
                sb1.append("],<d_q>dims<d_q>:[");
                List<String> dis = ci.getDimItemNameList();
                List<DimItem> fil = dict.getDimItemList();
                if (isDQL && dis != null) {
                    for (int j = 0; j < dis.size(); ++j) {
                        DimItem dij = ServiceImpl.getDimItemByName(fil, dis.get(j));
                        if (j > 0) {
                            sb1.append(",");
                        }
                        sb1.append("<d_q>" + dij.getDimName().toString() + "<d_q>");
                    }
                }
                sb1.append("]}");
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(sb1.toString());
            }
        }
        sb.append("],<d_q>editStyles<d_q>:[");
        sb.append("]}");
        return sb.toString();
    }

    private static int _$1(Visibility vis, String t, String f, LogicMetaData lmd) {
        if (vis == null) {
            return 2;
        }
        List<TableVisibility> tvl = vis.getTableVisibilityList();
        for (int i = 0; i < tvl.size(); ++i) {
            TableVisibility tv = tvl.get(i);
            if (!t.equals(tv.getName())) continue;
            List<String> inv = tv.getInvisibleFieldList();
            if (inv == null) {
                return 2;
            }
            if (inv.contains(f)) {
                return 0;
            }
            return 2;
        }
        return 0;
    }

    public static TableItem getTableItemByName(Dictionary d, String name) {
        List<TableItem> l = d.getTableItemList();
        for (int i = 0; i < l.size(); ++i) {
            if (!l.get(i).getName().equals(name)) continue;
            return l.get(i);
        }
        return null;
    }

    public static DataItem getDataItemByName(List<DataItem> ds, String name) {
        for (int i = 0; i < ds.size(); ++i) {
            if (!ds.get(i).getName().equals(name)) continue;
            return ds.get(i);
        }
        return null;
    }

    public static DimItem getDimItemByName(List<DimItem> ds, String name) {
        for (int i = 0; i < ds.size(); ++i) {
            if (!ds.get(i).getName().equals(name)) continue;
            return ds.get(i);
        }
        return null;
    }
}

