/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.server;

import com.esproc.dql.Request;
import com.esproc.dql.Response;
import com.esproc.dql.server.Server;
import com.esproc.dql.server.ServerMsg;
import com.esproc.dql.server.ServiceImpl;
import com.esproc.dql.server.Task;
import com.scudata.common.MessageManager;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManager {
    static ArrayList<Task> _$2 = new ArrayList();
    static MessageManager _$1 = ServerMsg.get();

    public static Response execute(Request req, ServiceImpl si) {
        int cmd = req.getAction();
        Response res = new Response();
        try {
            switch (cmd) {
                case 10001: {
                    String dql = (String)req.getAttr("dql");
                    List args = (List)req.getAttr("Arg list");
                    boolean isDqlMode = (Boolean)req.getAttr("Dql mode");
                    int taskId = Server.nextId();
                    Task task = new Task(dql, args, isDqlMode, taskId);
                    String user = req.getUser();
                    task.setEnv(si.getLogicMetaData(), si.getVisibility(user), si.getContext());
                    TaskManager.addTask(task);
                    res.setResult(new Integer(taskId));
                    break;
                }
                case 10002: {
                    int taskId = ((Number)req.getAttr("Task id")).intValue();
                    Task task = TaskManager.getTask(taskId);
                    res = task.execute();
                    break;
                }
                case 10003: {
                    int taskId = ((Number)req.getAttr("Task id")).intValue();
                    Task task = TaskManager.getTask(taskId);
                    res = task.cancel();
                }
            }
        }
        catch (Exception x) {
            res.setException(x);
        }
        return res;
    }

    public static synchronized void addTask(Task t) {
        _$2.add(t);
    }

    public static synchronized void delTask(int taskId) {
        for (int i = 0; i < _$2.size(); ++i) {
            Task t = _$2.get(i);
            if (t.getTaskID() != taskId) continue;
            _$2.remove(i);
            break;
        }
    }

    public static synchronized Task getTask(int taskId) throws Exception {
        for (int i = 0; i < _$2.size(); ++i) {
            Task t = _$2.get(i);
            if (t.getTaskID() != taskId) continue;
            return t;
        }
        throw new Exception(_$1.getMessage("Task.timeout", (Object)taskId));
    }

    public static synchronized List<Task> getTaskList() {
        ArrayList<Task> al = new ArrayList<Task>();
        al.addAll(_$2);
        return al;
    }

    public static synchronized void checkTimeOut(int proxyTimeOut) {
        for (int i = _$2.size() - 1; i >= 0; --i) {
            Task t = _$2.get(i);
            if (!t.checkTimeOut(proxyTimeOut)) continue;
            _$2.remove(t);
        }
    }
}

