/*
 * Decompiled with CFR 0.152.
 */
package com.esproc.dql.server;

import com.esproc.dql.Request;
import com.esproc.dql.Response;
import com.esproc.dql.server.RemoteCursor;
import com.esproc.dql.server.RemoteCursorProxy;
import com.esproc.dql.server.RemoteCursorProxyManager;
import com.esproc.dql.server.Server;
import com.esproc.dql.server.ServerMsg;
import com.esproc.dql.server.Service;
import com.esproc.dql.server.ServiceImpl;
import com.esproc.dql.server.ServiceManager;
import com.esproc.dql.server.Task;
import com.esproc.dql.server.TaskManager;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.dm.Sequence;
import com.scudata.server.odbc.DataTypes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class lllIlIIllIllIlll
extends Thread {
    static final int _$9 = 8192;
    private Socket _$8;
    private volatile boolean _$7 = false;
    OutputStream _$6;
    InputStream _$5;
    MessageManager _$4 = ServerMsg.get();
    private Service _$3 = null;
    private String _$2 = null;
    private HashMap<Integer, Integer> _$1 = new HashMap();

    public lllIlIIllIllIlll(ThreadGroup tg, String name) {
        super(tg, name);
        ServiceManager.incrementConn();
    }

    public void setSocket(Socket socket) throws Exception {
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
        socket.setReceiveBufferSize(8192);
        socket.setSendBufferSize(8192);
        socket.setSoLinger(true, 1);
        socket.setReuseAddress(true);
        socket.setSoTimeout(3000);
        this._$8 = socket;
        this._$1();
    }

    private void _$1() throws IOException {
        OutputStream os = this._$8.getOutputStream();
        this._$6 = new BufferedOutputStream(os);
        this._$6.flush();
        InputStream is = this._$8.getInputStream();
        this._$5 = new BufferedInputStream(is);
    }

    Object _$1(String svrType, Object svrValue, Service service, String user) throws Exception {
        if (svrType.equals(Request.GET_TABLES)) {
            return service.getTables(svrValue, user);
        }
        if (svrType.equals(Request.GET_COLUMNS)) {
            return service.getColumns(svrValue, user);
        }
        if (svrType.equals(Request.GET_PRIMARY_KEYS)) {
            return service.getPrimaryKeys(svrValue, user);
        }
        if (svrType.equals(Request.GET_EXPORTED_KEYS)) {
            return service.getExportedKeys(svrValue, user);
        }
        if (svrType.equals(Request.GET_IMPORTED_KEYS)) {
            return service.getImportedKeys(svrValue, user);
        }
        if (svrType.equals(Request.METADATA)) {
            return service.getMetaDataJSON(user);
        }
        if (svrType.equals(Request.RESULT)) {
            return service.getDQLFieldsAttr((String)svrValue, user);
        }
        if (svrType.equals(Request.LIST_META_DATA)) {
            return service.listMetaData((String)svrValue, user);
        }
        if (svrType.equals(Request.MODIFY_LMD)) {
            return new Boolean(((ServiceImpl)service).modifyDefaultFile(user, 1, (byte[])svrValue));
        }
        if (svrType.equals(Request.MODIFY_DCT)) {
            return new Boolean(((ServiceImpl)service).modifyDefaultFile(user, 2, (byte[])svrValue));
        }
        if (svrType.equals(Request.MODIFY_VSB)) {
            return new Boolean(((ServiceImpl)service).modifyDefaultFile(user, 3, (byte[])svrValue));
        }
        return null;
    }

    private boolean _$2(int reqType, InputStream is, OutputStream os) {
        try {
            switch (reqType) {
                case 1000: {
                    this._$2 = DataTypes.readString((InputStream)is);
                    String password = DataTypes.readString((InputStream)is);
                    String svcName = DataTypes.readString((InputStream)is);
                    this._$3 = ServiceManager.getServiceByName(svcName);
                    if (this._$3 == null) {
                        DataTypes.writeInt((OutputStream)os, (int)-102);
                        Logger.info((Object)this._$4.getMessage("Connection.loginerror", (Object)svcName));
                        break;
                    }
                    if (!this._$3.isUserExist(this._$2)) {
                        DataTypes.writeInt((OutputStream)os, (int)-103);
                        this._$3 = null;
                        Logger.info((Object)this._$4.getMessage("Connection.invalidusr", (Object)this._$2));
                        break;
                    }
                    if (this._$3.check(this._$2, password)) {
                        DataTypes.writeInt((OutputStream)os, (int)0);
                        Logger.info((Object)this._$4.getMessage("Connection.loginok", (Object)svcName));
                        break;
                    }
                    DataTypes.writeInt((OutputStream)os, (int)-104);
                    this._$3 = null;
                    Logger.info((Object)this._$4.getMessage("Connection.invalidpwd", (Object)this._$2));
                    break;
                }
                case 1001: {
                    String dql = DataTypes.readString((InputStream)is);
                    Object[] args = DataTypes.readRowData((InputStream)is);
                    ArrayList<Object> argList = new ArrayList<Object>();
                    if (args != null) {
                        for (int n = 0; n < args.length; ++n) {
                            argList.add(args[n]);
                            Logger.debug((Object)this._$4.getMessage("Connection.args", (Object)n, args[n]));
                        }
                    }
                    if (this._$3 == null) {
                        DataTypes.writeInt((OutputStream)os, (int)-102);
                        DataTypes.writeString((OutputStream)os, (String)this._$4.getMessage("Connection.notlogin"));
                        break;
                    }
                    try {
                        Request req = new Request();
                        req.setUser(this._$2);
                        req.setAction(10001);
                        req.setAttr("dql", dql);
                        req.setAttr("Arg list", argList);
                        Response res = null;
                        if (res.getException() != null) {
                            throw res.getException();
                        }
                        int cServiceTaskId = (Integer)res.getResult();
                        req = new Request();
                        req.setUser(this._$2);
                        req.setAction(10002);
                        req.setAttr("Task id", cServiceTaskId);
                        res = null;
                        if (res.getException() != null) {
                            throw res.getException();
                        }
                        RemoteCursor remoteCursor = (RemoteCursor)res.getResult();
                        int queryId = remoteCursor.getProxyId();
                        this._$1.put(queryId, cServiceTaskId);
                        DataTypes.writeInt((OutputStream)os, (int)0);
                        DataTypes.writeInt((OutputStream)os, (int)queryId);
                        Object[] columns = null;
                        DataTypes.writeRowData((OutputStream)os, columns);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        DataTypes.writeInt((OutputStream)os, (int)-102);
                        DataTypes.writeString((OutputStream)os, (String)x.getMessage());
                    }
                    break;
                }
                case 1002: {
                    int queryId = DataTypes.readInt((InputStream)is);
                    int fetchSize = DataTypes.readInt((InputStream)is);
                    if (this._$3 == null) {
                        DataTypes.writeInt((OutputStream)os, (int)-102);
                        DataTypes.writeString((OutputStream)os, (String)this._$4.getMessage("Connection.notlogin"));
                        break;
                    }
                    try {
                        int cServiceTaskId = this._$1.get(queryId);
                        Task t = TaskManager.getTask(cServiceTaskId);
                        RemoteCursorProxyManager rcpm = t.getCursorManager();
                        String methodName = "fetch";
                        Object[] argValues = new Object[]{new Integer(fetchSize)};
                        Request req = new Request(20001);
                        req.setAttr("Task id", new Integer(cServiceTaskId));
                        req.setAttr("Proxy id", new Integer(queryId));
                        req.setAttr("Method name", methodName);
                        req.setAttr("Arg values", argValues);
                        Response res = rcpm.execute(req);
                        if (res.getException() != null) {
                            throw res.getException();
                        }
                        Sequence table = (Sequence)res.getResult();
                        DataTypes.writeInt((OutputStream)os, (int)0);
                        DataTypes.writeTable((OutputStream)os, (Sequence)table);
                    }
                    catch (Exception x) {
                        DataTypes.writeInt((OutputStream)os, (int)-102);
                        DataTypes.writeString((OutputStream)os, (String)x.getMessage());
                    }
                    break;
                }
                case 1003: {
                    try {
                        int queryId = DataTypes.readInt((InputStream)is);
                        this._$1(queryId);
                        DataTypes.writeInt((OutputStream)os, (int)0);
                    }
                    catch (Exception x) {
                        DataTypes.writeInt((OutputStream)os, (int)-102);
                        DataTypes.writeString((OutputStream)os, (String)x.getMessage());
                    }
                    break;
                }
                case 1010: {
                    if (this._$3 != null) {
                        for (int cursorId : this._$1.keySet()) {
                            this._$1(cursorId);
                        }
                        this._$3 = null;
                        DataTypes.writeInt((OutputStream)os, (int)0);
                        Logger.info((Object)this._$4.getMessage("Connection.logout"));
                    } else {
                        DataTypes.writeInt((OutputStream)os, (int)-101);
                        Logger.info((Object)this._$4.getMessage("Connection.duplogout"));
                    }
                    return false;
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean _$1(int queryId) throws Exception {
        int taskId = this._$1.get(queryId);
        Task t = TaskManager.getTask(taskId);
        RemoteCursorProxy rcp = t.getCursorManager().getProxy(queryId);
        rcp.close();
        this._$1.remove(queryId);
        return true;
    }

    private boolean _$1(int reqType, InputStream is, OutputStream os) {
        if (reqType >= 1000) {
            return this._$2(reqType, is, os);
        }
        try {
            switch (reqType) {
                case 1: {
                    this._$2 = DataTypes.readString((InputStream)is);
                    String password = DataTypes.readString((InputStream)is);
                    String svcName = DataTypes.readString((InputStream)is);
                    this._$3 = ServiceManager.getServiceByName(svcName);
                    if (this._$3 == null) {
                        DataTypes.writeInt((OutputStream)os, (int)-102);
                        Logger.info((Object)this._$4.getMessage("Connection.loginerror", (Object)svcName));
                        break;
                    }
                    if (!this._$3.isUserExist(this._$2)) {
                        DataTypes.writeInt((OutputStream)os, (int)-103);
                        this._$3 = null;
                        Logger.info((Object)this._$4.getMessage("Connection.invalidusr", (Object)this._$2));
                        break;
                    }
                    if (this._$3.check(this._$2, password)) {
                        DataTypes.writeInt((OutputStream)os, (int)0);
                        Logger.info((Object)this._$4.getMessage("Connection.loginok", (Object)svcName));
                        break;
                    }
                    DataTypes.writeInt((OutputStream)os, (int)-104);
                    this._$3 = null;
                    Logger.info((Object)this._$4.getMessage("Connection.invalidpwd", (Object)this._$2));
                    break;
                }
                case 2: {
                    String dql = DataTypes.readString((InputStream)is);
                    if (this._$3 == null) {
                        DataTypes.writeInt((OutputStream)os, (int)-102);
                        DataTypes.writeString((OutputStream)os, (String)this._$4.getMessage("Connection.notlogin"));
                    }
                    break;
                }
                case 3: {
                    if (this._$3 != null) {
                        this._$3 = null;
                        DataTypes.writeInt((OutputStream)os, (int)0);
                        Logger.info((Object)this._$4.getMessage("Connection.logout"));
                    } else {
                        DataTypes.writeInt((OutputStream)os, (int)-101);
                        Logger.info((Object)this._$4.getMessage("Connection.duplogout"));
                    }
                    return false;
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return false;
        }
        return true;
    }

    public void shutDown() {
        this._$7 = true;
    }

    public void run() {
        try {
            InputStream is = this._$5;
            OutputStream os = this._$6;
            while (!this._$7) {
                int reqType = 0;
                try {
                    reqType = DataTypes.readInt((InputStream)is);
                }
                catch (SocketTimeoutException e) {
                    continue;
                }
                if (reqType == -1) {
                    Server.getInstance().stopService(false);
                    return;
                }
                if (reqType == -100) {
                    Server.getInstance().stopService(true);
                    return;
                }
                if (reqType != -2) {
                    if (reqType > 0) {
                        if (this._$1(reqType, is, os)) {
                            os.flush();
                            continue;
                        }
                    } else {
                        ObjectInputStream ois = new ObjectInputStream(is);
                        Object msgObj = ois.readUnshared();
                        if (!(msgObj instanceof Request)) continue;
                        Request request = (Request)msgObj;
                        boolean isCursorRequest = request.getActionType() == 20000;
                        Response response = new Response();
                        if (request.isGetConnectionCount()) {
                            response.setAttr(Request.CONNECTION_COUNT, ServiceManager.getConnNum());
                        } else if (request.isCheck()) {
                            String svcName = request.getServiceName();
                            Service service = ServiceManager.getServiceByName(svcName);
                            if (service == null) {
                                response.setException(new Exception(this._$4.getMessage("Connection.invalidservice", (Object)svcName)));
                            } else {
                                String user = request.getUser();
                                String pwd = request.getPassword();
                                response.setResult(service.check(user, pwd));
                            }
                        } else if (isCursorRequest) {
                            int taskId = ((Number)request.getAttr("Task id")).intValue();
                            try {
                                Task t = TaskManager.getTask(taskId);
                                RemoteCursorProxyManager rcpm = t.getCursorManager();
                                response = rcpm.execute(request);
                            }
                            catch (Exception x) {
                                response = new Response();
                                response.setException(x);
                            }
                        } else {
                            String svcName = request.getServiceName();
                            Service service = ServiceManager.getServiceByName(svcName);
                            if (service == null) {
                                response.setException(new Exception(this._$4.getMessage("Connection.invalidservice", (Object)svcName)));
                            } else {
                                String pwd;
                                String user = request.getUser();
                                if (!service.check(user, pwd = request.getPassword())) {
                                    response.setException(new Exception(this._$4.getMessage("Connection.invalidusrpwd", (Object)user)));
                                } else if (request.getActionType() == 10000) {
                                    Server.increaseCalculateCount();
                                    response = ((ServiceImpl)service).executeDQL(request);
                                } else {
                                    Map map = request.getParams();
                                    for (String key : map.keySet()) {
                                        try {
                                            response.setAttr(key, this._$1(key, map.get(key), service, user));
                                        }
                                        catch (Exception x) {
                                            x.printStackTrace();
                                            response.setException(x);
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        ObjectOutputStream oos = new ObjectOutputStream(os);
                        oos.writeUnshared(response);
                        oos.flush();
                    }
                }
                break;
            }
        }
        catch (SocketException e) {
            Logger.info((Object)this._$4.getMessage("Connection.socketerror", (Object)this.getName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this._$8.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ServiceManager.decrementConn();
    }
}

