/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.compile.CodeItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;

public class AssignItem
extends CodeItem {
    private CodeItem left;
    private CodeItem right;

    public AssignItem(CodeItem left, CodeItem right) {
        super(left.getType());
        this.left = left;
        this.right = right;
    }

    @Override
    public CodeItem makeAssign(CodeItem value) throws ParseNodeException {
        throw new RuntimeException();
    }

    public CodeItem getLeft() {
        return this.left;
    }

    public CodeItem getRight() {
        return this.right;
    }

    public void setLeft(CodeItem left) {
        this.left = left;
    }

    public void setRight(CodeItem right) {
        this.right = right;
    }

    @Override
    public boolean isAssigned() {
        return false;
    }

    public String toString() {
        CodeItem left = this.left;
        String assignStr = left.assignStr;
        DataType type = left.type;
        CodeItem value = this.right.cast(type.getTypeName());
        if (assignStr == null) {
            String valueStr = value.toString();
            return left.makeAssignString(valueStr);
        }
        return String.format(assignStr, value.toString());
    }

    @Override
    public CodeItem cast() {
        String type = this.type.getTypeName();
        if (!this.left.type.isType(type)) {
            return new LineItem("(" + type + ")(" + this.toString() + ")", new DataType(type));
        }
        return this;
    }

    @Override
    public CodeItem cast(String type) {
        if (!this.left.type.isType(type)) {
            return new LineItem("(" + type + ")(" + this.toString() + ")", new DataType(type));
        }
        return this;
    }

    @Override
    public String makeAssignString(String value) {
        throw new RuntimeException();
    }
}

