/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.compile.DataType;
import com.scudata.compile.RunMethodMaker;
import com.scudata.compile.VarItem;
import java.util.Map;

public class CalcMethodMaker
extends RunMethodMaker {
    public CalcMethodMaker(String name, String option, String retType) {
        super(name, option, retType);
    }

    @Override
    protected void startCycle(StringBuffer out) {
        String arrType;
        if (this.seqType == null) {
            arrType = "null";
        } else if (this.seqType.equals("int")) {
            arrType = "int";
        } else if (this.seqType.equals("long")) {
            arrType = "long";
        } else if (this.seqType.equals("double")) {
            arrType = "double";
        } else if (this.seqType.equals("boolean")) {
            arrType = "boolean";
        } else {
            throw new RuntimeException();
        }
        out.append(arrType + "[] datas = new " + arrType + "[len + 1];");
        out.append(System.lineSeparator());
        out.append("for (int i = 1; i <= len; i++) {");
        out.append(System.lineSeparator());
    }

    @Override
    protected void endCycle(StringBuffer out) {
        String arrType;
        if (this.seqType == null) {
            arrType = "null";
        } else if (this.seqType.equals("int")) {
            arrType = "com.scudata.array.IntArray";
        } else if (this.seqType.equals("long")) {
            arrType = "com.scudata.array.LongArray";
        } else if (this.seqType.equals("double")) {
            arrType = "com.scudata.array.DoubleArray";
        } else if (this.seqType.equals("boolean")) {
            arrType = "com.scudata.array.BooleanArray";
        } else {
            throw new RuntimeException();
        }
        out.append("}");
        out.append(System.lineSeparator());
        out.append(String.valueOf(arrType) + " arr = new " + arrType + "(datas, null, len);");
        out.append(System.lineSeparator());
    }

    @Override
    public String finish() {
        VarItem item;
        StringBuffer result = new StringBuffer();
        if (this.option == null) {
            this.option = "public ";
        }
        if (this.retType == null) {
            this.retType = "void ";
        }
        result.append(this.option);
        result.append(this.retType);
        result.append(this.name);
        result.append("{");
        result.append(System.lineSeparator());
        result.append("Random random = ctx.getRandom();");
        result.append(System.lineSeparator());
        result.append("int len = ((Sequence)getSrcObj()).length();");
        result.append(System.lineSeparator());
        for (Map.Entry entry : this.vars.entrySet()) {
            item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("SeqDefaultType")) {
                type = new DataType(type);
                type.setTypeName(this.seqType);
            }
            if (type != null && type.isType("UnknownType")) {
                type = new DataType(type);
                type.setTypeName(this.seqType);
            }
            result.append(type);
            result.append(" ");
            result.append(item.getName());
            if (item.isGlobal()) {
                if (item.isCell()) {
                    if (!item.getType().isArray()) {
                        result.append(" = (" + type + ")getObject(" + item.getR() + "," + item.getC() + ")");
                    } else {
                        String str = "getObject(" + item.getR() + "," + item.getC() + ")";
                        result.append(" = (" + type + ")getDatas(" + str + ")");
                    }
                } else if (!item.getType().isArray()) {
                    result.append(" = (" + type + ")ctx.getParam(\"" + item.getName() + "\").getValue()");
                } else {
                    result.append(" = (" + type + ")getDatas(\"" + item.getName() + "\", ctx)");
                }
            }
            result.append(";");
            result.append(System.lineSeparator());
        }
        this.startCycle(result);
        result.append(this.code);
        this.endCycle(result);
        for (Map.Entry entry : this.vars.entrySet()) {
            item = (VarItem)entry.getValue();
            if (!item.isGlobal()) continue;
            if (item.isCell()) {
                if (item.getType().isArray()) continue;
                result.append("setObject(" + item.getR() + "," + item.getC() + "," + item.getName() + ")");
                result.append(";");
                result.append(System.lineSeparator());
                continue;
            }
            if (item.getType().isArray()) continue;
            result.append("ctx.getParam(\"" + item.getName() + "\").setValue(" + item.getName() + ")");
            result.append(";");
            result.append(System.lineSeparator());
        }
        result.append("return new Sequence(arr);");
        result.append(System.lineSeparator());
        result.append("}");
        return result.toString();
    }
}

