/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.DES;
import com.scudata.common.IOUtils;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.common.StringUtils;
import com.scudata.compile.PgmCellSet2;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.KeyWord;
import com.scudata.dm.LineImporter;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class CellSetUtil2 {
    private static final byte Type_PgmCellSet = 1;
    private static final String KEY = "rqqrrqqr";
    private static final byte ENCRYPTED = 1;

    public static PgmCellSet2 readCellSet(String filePath) throws Exception {
        if ((filePath = AppUtil.searchSplFilePath((String)filePath)) == null) {
            return null;
        }
        PgmCellSet2 cs = null;
        BufferedInputStream bis = null;
        InputStream is = null;
        try {
            FileObject fo = new FileObject(filePath, "s");
            is = fo.getInputStream();
            bis = new BufferedInputStream(is);
            cs = filePath.toLowerCase().endsWith(".spl") ? CellSetUtil2.readSPL(bis) : CellSetUtil2.readPgmCellSet(bis, null);
            if (cs != null) {
                cs.setName(filePath);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return cs;
    }

    public static PgmCellSet2 readPgmCellSet(InputStream is, String psw) throws Exception {
        int mapLen;
        if (is.read() != 82 || is.read() != 81 || is.read() != 81 || is.read() != 82) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        int type = is.read();
        if (type != 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        PgmCellSet2 cs = new PgmCellSet2();
        int ver = is.read();
        if (ver == 1) {
            int mapLen2 = IOUtils.readInt((InputStream)is);
            if (mapLen2 > 0) {
                is.skip(mapLen2);
            }
            int csLen = IOUtils.readInt((InputStream)is);
            byte[] csBytes = new byte[csLen];
            IOUtils.readFully((InputStream)is, (byte[])csBytes);
            is.read();
            is.read();
            is.read();
            is.read();
            cs.fillRecord(csBytes);
            CellSetUtil2.changeOldVersionParam(cs);
            return cs;
        }
        int pswLen = IOUtils.readInt((InputStream)is);
        byte[] pswBytes = new byte[pswLen];
        IOUtils.readFully((InputStream)is, (byte[])pswBytes);
        if (ver > 2) {
            DES pswDes = new DES(KEY);
            pswBytes = pswDes.decrypt(pswBytes);
            ByteArrayInputRecord bi = new ByteArrayInputRecord(pswBytes);
            String pswHash = bi.readString();
            int nullPswPrivilege = bi.readInt();
            PgmCellSet.getPrivilege((String)pswHash, (String)psw, (int)nullPswPrivilege);
        }
        if ((mapLen = IOUtils.readInt((InputStream)is)) > 0) {
            is.skip(mapLen);
        }
        int isEncrypted = is.read() & 1;
        int csLen = IOUtils.readInt((InputStream)is);
        byte[] csBytes = new byte[csLen];
        IOUtils.readFully((InputStream)is, (byte[])csBytes);
        is.read();
        is.read();
        is.read();
        is.read();
        if (isEncrypted == 1) {
            DES des = new DES(KEY);
            csBytes = des.decrypt(csBytes);
        }
        cs.fillRecord(csBytes);
        cs.setCurrentPassword(psw);
        if (ver < 4) {
            CellSetUtil2.changeOldVersionParam(cs);
        }
        return cs;
    }

    private static void changeOldVersionParam(PgmCellSet2 pcs) {
        ParamList paramList = pcs.getParamList();
        if (paramList == null) {
            return;
        }
        int i = 0;
        int size = paramList.count();
        while (i < size) {
            Param param = paramList.get(i);
            Object value = param.getValue();
            if (value instanceof String) {
                String old = (String)value;
                value = Variant.parse((String)old);
                param.setValue(value);
                if (value instanceof String) {
                    int match = Sentence.scanQuotation((String)old, (int)0);
                    if (match == old.length() - 1) {
                        param.setEditValue((Object)(String.valueOf('\'') + (String)value));
                    } else if (old.charAt(0) == '\'') {
                        param.setEditValue((Object)(String.valueOf('\'') + old));
                    } else {
                        param.setEditValue((Object)old);
                    }
                } else {
                    param.setEditValue((Object)old);
                }
            }
            ++i;
        }
    }

    public static PgmCellSet2 readSPL(InputStream in) throws Exception {
        String spl = CellSetUtil2.readSPLString(in);
        return CellSetUtil2.spl2CellSet(spl);
    }

    private static String readSPLString(InputStream is) throws Exception {
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuffer buf = new StringBuffer();
        try {
            isr = new InputStreamReader(is, Env.getDefaultCharsetName());
            br = new BufferedReader(isr);
            String rowStr = br.readLine();
            boolean isFirst = true;
            while (rowStr != null) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append('\n');
                }
                buf.append(rowStr);
                rowStr = br.readLine();
            }
            String string = buf.toString();
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static PgmCellSet2 spl2CellSet(String spl) {
        ParamList pl;
        if (!StringUtils.isValidString((Object)spl)) {
            return null;
        }
        PgmCellSet2 cellSet = CellSetUtil2.toPgmCellSet(spl);
        if (cellSet != null && (pl = cellSet.getParamList()) != null) {
            int i = 0;
            while (i < pl.count()) {
                Object value;
                Param p = pl.get(i);
                if (p != null && (value = p.getValue()) != null && p.getEditValue() == null) {
                    Object editValue = value;
                    if (editValue instanceof String) {
                        if (!StringUtils.isValidString((Object)editValue)) {
                            editValue = null;
                        }
                    } else {
                        editValue = Variant.toString((Object)value);
                    }
                    p.setEditValue(editValue);
                }
                ++i;
            }
        }
        return cellSet;
    }

    public static PgmCellSet toPgmCellSet(String[][] expStrs) {
        if (expStrs == null || expStrs.length == 0) {
            return null;
        }
        int rowCount = expStrs.length;
        int colCount = 0;
        int r = 0;
        while (r < rowCount) {
            if (expStrs[r] != null && expStrs[r].length > colCount) {
                colCount = expStrs[r].length;
            }
            ++r;
        }
        if (colCount == 0) {
            return null;
        }
        PgmCellSet pcs = new PgmCellSet(rowCount, colCount);
        int r2 = 1;
        while (r2 <= rowCount) {
            String[] row = expStrs[r2 - 1];
            int count = row != null ? row.length : 0;
            int c = 1;
            while (c <= count) {
                PgmNormalCell cell = pcs.getPgmNormalCell(r2, c);
                cell.setExpString(row[c - 1]);
                ++c;
            }
            ++r2;
        }
        return pcs;
    }

    public static PgmCellSet2 toPgmCellSet(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        char[] buffer = src.toCharArray();
        int len = buffer.length;
        int index = 0;
        ParamList paramList = new ParamList();
        while (index < len && buffer[index] == '#') {
            String paramName;
            String strParam = null;
            int i = ++index;
            while (i < len) {
                if (buffer[i] == '\n') {
                    strParam = buffer[i - 1] == '\r' ? new String(buffer, index, i - index - 1) : new String(buffer, index, i - index);
                    index = i + 1;
                    break;
                }
                ++i;
            }
            if (strParam == null) {
                strParam = new String(buffer, index, len - index);
                index = len;
            }
            int s = strParam.indexOf(61);
            Object paramValue = null;
            if (s != -1) {
                paramName = strParam.substring(0, s);
                paramValue = Variant.parse((String)strParam.substring(s + 1), (boolean)false);
            } else {
                paramName = strParam;
            }
            paramList.add(paramName, (byte)0, paramValue);
        }
        int colSeparator = 9;
        ArrayList line = new ArrayList();
        int rowCount = 10;
        int colCount = 1;
        PgmCellSet2 pcs = new PgmCellSet2(rowCount, colCount);
        int curRow = 1;
        if (paramList.count() > 0) {
            pcs.setParamList(paramList);
        }
        while (index != -1) {
            index = LineImporter.readLine((char[])buffer, (int)index, (char)'\t', line);
            int curColCount = line.size();
            if (curColCount > colCount) {
                pcs.addCol(curColCount - colCount);
                colCount = curColCount;
            }
            if (curRow > rowCount) {
                rowCount += 10;
                pcs.addRow(10);
            }
            int f = 0;
            while (f < curColCount) {
                String exp = (String)line.get(f);
                if (exp != null && exp.length() > 0) {
                    PgmNormalCell cell = pcs.getPgmNormalCell(curRow, f + 1);
                    cell.setExpString(exp);
                }
                ++f;
            }
            ++curRow;
            line.clear();
        }
        pcs.removeRow(curRow, rowCount - curRow + 1);
        CellSetUtil2.changeAliasNameToCell(pcs);
        return pcs;
    }

    private static void changeAliasNameToCell(PgmCellSet2 pcs) {
        int rowCount = pcs.getRowCount();
        int colCount = pcs.getColCount();
        int r = 1;
        while (r <= rowCount) {
            int c = 1;
            while (c <= colCount) {
                String aliasName;
                int end;
                PgmNormalCell cell = pcs.getPgmNormalCell(r, c);
                String expStr = cell.getExpString();
                if (expStr != null && expStr.length() > 1 && expStr.charAt(0) == '@' && (end = expStr.indexOf(58)) != -1 && (aliasName = expStr.substring(1, end).trim()).length() > 0) {
                    if (end + 1 < expStr.length()) {
                        expStr = expStr.substring(end + 1);
                        cell.setExpString(expStr);
                    } else {
                        cell.setExpString(null);
                    }
                    CellSetUtil2.changeAliasNameToCell(pcs, aliasName, cell.getCellId());
                }
                ++c;
            }
            ++r;
        }
    }

    private static void changeAliasNameToCell(PgmCellSet2 pcs, String aliasName, String cellId) {
        int rowCount = pcs.getRowCount();
        int colCount = pcs.getColCount();
        int aliasNameLen = aliasName.length();
        int r = 1;
        while (r <= rowCount) {
            int c = 1;
            while (c <= colCount) {
                PgmNormalCell cell = pcs.getPgmNormalCell(r, c);
                String expStr = cell.getExpString();
                if (expStr != null && expStr.length() > aliasNameLen) {
                    expStr = CellSetUtil2.changeAliasNameToCell(expStr, aliasName, cellId);
                    cell.setExpString(expStr);
                }
                ++c;
            }
            ++r;
        }
    }

    private static String changeAliasNameToCell(String expStr, String aliasName, String cellId) {
        int aliasLen = aliasName.length();
        if (expStr == null || expStr.length() < aliasLen) {
            return expStr;
        }
        StringBuffer sb = null;
        int len = expStr.length();
        int i = 0;
        while (i < len) {
            char c = expStr.charAt(i);
            if (c == '\"' || c == '\'') {
                int match = Sentence.scanQuotation((String)expStr, (int)i);
                if (match == -1) {
                    if (sb == null) break;
                    sb.append(expStr.substring(i));
                    break;
                }
                if (sb != null) {
                    sb.append(expStr.substring(i, match + 1));
                }
                i = match + 1;
                continue;
            }
            if (KeyWord.isSymbol((char)c) || c == '#') {
                if (sb != null) {
                    sb.append(c);
                }
                ++i;
                continue;
            }
            int end = KeyWord.scanId((String)expStr, (int)(i + 1));
            if (end - i == aliasLen && aliasName.equals(expStr.substring(i, end))) {
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append(expStr.substring(0, i));
                }
                sb.append(cellId);
            } else if (sb != null) {
                sb.append(expStr.substring(i, end));
            }
            i = end;
        }
        if (sb == null) {
            return expStr;
        }
        return sb.toString();
    }

    public static Object execute(PgmCellSet set) {
        set.setParamToContext();
        return set.execute();
    }
}

