/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.compile.DataType;
import com.scudata.compile.ParseNodeException;
import java.util.ArrayList;
import java.util.List;

public abstract class CodeItem {
    protected DataType type;
    protected CodeItem relatedVar;
    protected CodeItem preItem;
    protected String assignStr;

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        if (this.type.isType("Long") && (type.isType("Integer") || type.isType("int"))) {
            return;
        }
        if (this.type.isType("long")) {
            if (type.isType("int")) {
                return;
            }
            if (type.isType("Integer")) {
                this.type = DataType.LongTypeNullable;
                return;
            }
        }
        if (type.isType("UnknownType")) {
            return;
        }
        if (!this.type.isType("Object") && !this.type.isType("UnknownType") && type.isType("Object")) {
            return;
        }
        this.type = type;
    }

    public CodeItem(DataType type) {
        if (type == null) {
            type = new DataType();
        }
        this.type = type;
    }

    public CodeItem getRelatedVar() {
        return this.relatedVar;
    }

    public void setRelatedVar(CodeItem relatedVar) {
        this.relatedVar = relatedVar;
    }

    public void adjustType(DataType newType) {
        if (this.type != null && this.type.isType("UnknownType")) {
            this.type.setTypeName(newType.getTypeName());
        }
    }

    public CodeItem getPreItem() {
        return this.preItem;
    }

    public void setPreItem(CodeItem preItem) {
        this.preItem = preItem;
    }

    private void seekPreItems(List<CodeItem> list) {
        if (this.preItem != null) {
            this.preItem.seekPreItems(list);
            list.add(this.preItem);
        }
    }

    public List<CodeItem> getPreItems() {
        ArrayList<CodeItem> list = new ArrayList<CodeItem>();
        this.seekPreItems(list);
        return list;
    }

    public String getPreLine() {
        String preLine = "";
        if (this.getPreItems() != null && this.getPreItems().size() > 0) {
            for (CodeItem citem : this.getPreItems()) {
                preLine = String.valueOf(preLine) + citem.toString() + ";";
            }
        }
        return preLine;
    }

    public void setAssignStr(String assignStr) {
        this.assignStr = assignStr;
    }

    public abstract CodeItem makeAssign(CodeItem var1) throws ParseNodeException;

    public abstract String makeAssignString(String var1);

    public abstract boolean isAssigned();

    public abstract CodeItem cast();

    public abstract CodeItem cast(String var1);
}

