/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.compile.CodeItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;

public class ConstItem
extends CodeItem {
    public static final ConstItem TRUE = new ConstItem("true", DataType.BooleanType, Boolean.TRUE);
    public static final ConstItem FALSE = new ConstItem("false", DataType.BooleanType, Boolean.FALSE);
    public static final ConstItem NEGATIVE_INFINITY = new ConstItem("Double.NEGATIVE_INFINITY", DataType.DoubleType, Double.NEGATIVE_INFINITY);
    public static final ConstItem POSITIVE_INFINITY = new ConstItem("Double.POSITIVE_INFINITY", DataType.DoubleType, Double.POSITIVE_INFINITY);
    public static final ConstItem NaN = new ConstItem("Double.NaN", DataType.DoubleType, Double.NaN);
    private String name;
    private Object value;

    public ConstItem(String name, DataType type, Object value) {
        super(type);
        this.value = value;
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        if (this.value instanceof Double && this.name.equals("Infinity")) {
            return "Double.POSITIVE_INFINITY";
        }
        return this.name;
    }

    @Override
    public CodeItem makeAssign(CodeItem value) {
        throw new RuntimeException();
    }

    @Override
    public boolean isAssigned() {
        throw new RuntimeException();
    }

    @Override
    public CodeItem cast() {
        return this;
    }

    @Override
    public CodeItem cast(String type) {
        if (this.value == null) {
            return this;
        }
        if (!this.type.isType(type)) {
            if (type.equals("Integer") || type.equals("int")) {
                String line = "" + Integer.parseInt(this.value.toString());
                return new LineItem(line, new DataType(type));
            }
            if (type.equals("Long") || type.equals("long")) {
                String line = Long.parseLong(this.value.toString()) + "L";
                return new LineItem(line, new DataType(type));
            }
            if (type.equals("Double") || type.equals("double")) {
                String line = "" + Double.parseDouble(this.value.toString());
                return new LineItem(line, new DataType(type));
            }
            return new LineItem("(" + type + ")" + this.value, new DataType(type));
        }
        return this;
    }

    @Override
    public String makeAssignString(String value) {
        throw new RuntimeException();
    }
}

