/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.compile.CodeItem;
import com.scudata.compile.DataType;
import com.scudata.compile.StructType;

public class CurContext {
    protected String cellName;
    protected String seqName;
    protected String recName;
    protected String iStr;
    protected DataType memberType;
    protected int stackLevel;
    protected StructType structType;
    protected CurContext parentCur;

    public CurContext() {
    }

    public CurContext(String cellName, String seqName, String iStr, DataType memberType) {
        this.cellName = cellName;
        this.seqName = seqName;
        this.iStr = iStr;
        this.memberType = memberType;
    }

    public static CurContext newRecordCurItem(String cellName, String recName, DataType recordType) {
        CurContext cur = new CurContext();
        cur.cellName = cellName;
        cur.recName = recName;
        cur.structType = recordType.getStructType();
        return cur;
    }

    public static CurContext newSequenceCurItem(String cellName, String seqName, String recName, String iStr, DataType memberType) {
        CurContext cur = new CurContext();
        cur.cellName = cellName;
        cur.seqName = seqName;
        cur.recName = recName;
        cur.iStr = iStr;
        cur.memberType = memberType;
        cur.structType = memberType.getStructType();
        return cur;
    }

    public static CurContext newTableCurItem(String cellName, String seqName, String recName, String iStr, StructType structType) {
        CurContext cur = new CurContext();
        cur.cellName = cellName;
        cur.seqName = seqName;
        cur.recName = recName;
        cur.iStr = iStr;
        cur.structType = structType;
        cur.memberType = DataType.newRecordType(structType);
        return cur;
    }

    public String getSeq() {
        return this.iStr;
    }

    public void setSeq(String seq) {
        this.iStr = seq;
    }

    public StructType getStructType() {
        return this.structType;
    }

    public void setStructType(StructType structType) {
        this.structType = structType;
    }

    public DataType getMemberType() {
        return this.memberType;
    }

    public void setMemberType(DataType memberType) {
        this.memberType = memberType;
    }

    public CurContext getParentCur() {
        return this.parentCur;
    }

    public void setParentCur(CurContext parentCur) {
        this.parentCur = parentCur;
    }

    public int getStackLevel() {
        return this.stackLevel;
    }

    public void setStackLevel(int stackLevel) {
        this.stackLevel = stackLevel;
    }

    public String getCellName() {
        return this.cellName;
    }

    public String formatCur() {
        if (this.recName != null) {
            return this.recName;
        }
        String line = String.valueOf(this.seqName) + ".get(" + this.iStr + ")";
        return line;
    }

    public String formatCurAssign(CodeItem value) {
        String line = String.valueOf(this.seqName) + ".set(" + this.iStr + ", %s)";
        this.memberType = value.getType();
        return String.format(line, value);
    }

    public String formatCurAssignString(String value) {
        String line = String.valueOf(this.seqName) + ".set(" + this.iStr + ", %s)";
        return String.format(line, value);
    }

    public String formatCurMove(String posStr) {
        String recIdx = String.valueOf(this.getSeq()) + "+" + posStr;
        String line = String.format("SequenceLib.getNullable(%s, %s)", this.seqName, recIdx);
        return line;
    }

    public String formatCurMoves(String start, String end) {
        String line = String.format("SequenceLib.getNullable(%s, %s, %s, %s)", this.seqName, this.iStr, start, end);
        return line;
    }

    public String formatCurMoveAssign(String posStr, String value) {
        String recIdx = String.valueOf(this.getSeq()) + "+" + posStr;
        String line = String.format("SequenceLib.setNullable(%s, %s, %s)", this.seqName, recIdx, value);
        return line;
    }

    public String formatFieldRef(String fieldName) {
        String line;
        if (this.structType == null) {
            throw new RuntimeException();
        }
        int idx = this.structType.dataStruct().getFieldIndex(fieldName);
        if (idx == -1) {
            throw new RuntimeException();
        }
        String idxStr = this.structType.getFieldIndexStr(fieldName);
        String type = this.structType.getFieldType(fieldName).getTypeName();
        type = type.equals("Object") ? "" : "(" + type + ")";
        if (this.recName == null) {
            String rec = "(BaseRecord)" + this.formatCur();
            line = String.format("%sFunLib.getField(%s, %s)", type, rec, idxStr);
        } else {
            line = String.format("%sFunLib.getField(%s, %s)", type, this.recName, idxStr);
        }
        return line;
    }

    public String formatFieldRefAssign(String fieldName, CodeItem value) {
        String line;
        if (this.structType == null) {
            return null;
        }
        int idx = this.structType.dataStruct().getFieldIndex(fieldName);
        if (idx == -1) {
            throw new RuntimeException();
        }
        String idxStr = this.structType.getFieldIndexStr(fieldName);
        if (this.recName == null) {
            String rec = "(BaseRecord)" + this.formatCur();
            line = String.format("FunLib.setField(%s, %s, %s)", rec, idxStr, value);
        } else {
            line = String.format("FunLib.setField(%s, %s, %s)", this.recName, idxStr, value);
        }
        this.structType.setFieldType(idx, value.getType());
        return line;
    }

    public String formatFieldMove(String fieldName, String posStr) {
        if (this.structType == null) {
            return null;
        }
        int idx = this.structType.dataStruct().getFieldIndex(fieldName);
        if (idx == -1) {
            return null;
        }
        String idxStr = this.structType.getFieldIndexStr(fieldName);
        String type = this.structType.getFieldType(fieldName).getTypeName();
        String recIdx = String.valueOf(this.getSeq()) + "+" + posStr;
        String line = String.format("(%s)SequenceLib.getNullable(%s, %s, %s)", type, this.seqName, recIdx, idxStr);
        return line;
    }

    public String formatFieldMoves(String fieldName, String start, String end) {
        if (this.structType == null) {
            return null;
        }
        int idx = this.structType.dataStruct().getFieldIndex(fieldName);
        if (idx == -1) {
            return null;
        }
        String idxStr = this.structType.getFieldIndexStr(fieldName);
        String line = String.format("SequenceLib.getNullable(%s, %s, %s, %s, %s)", this.seqName, this.iStr, idxStr, start, end);
        return line;
    }

    public String formatFieldMoveAssign(String fieldName, String posStr, String value) {
        if (this.structType == null) {
            return null;
        }
        int idx = this.structType.dataStruct().getFieldIndex(fieldName);
        if (idx == -1) {
            return null;
        }
        String recIdx = String.valueOf(this.getSeq()) + "+" + posStr;
        String line = String.format("SequenceLib.setNullable(%s, %s, %d, %s)", this.seqName, recIdx, idx, value);
        return line;
    }
}

