/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.compile.StructType;
import java.util.Objects;

public class DataType {
    public static final String UnknownType = "UnknownType";
    public static final DataType VoidType = new DataType("void");
    public static final DataType DateType = new DataType("Date");
    public static final DataType ObjectType = new DataType("Object");
    public static final DataType ObjectTypeFixed = new DataType("Object");
    public static final DataType BooleanType = new DataType("boolean");
    public static final DataType IntType = new DataType("int");
    public static final DataType LongType = new DataType("long");
    public static final DataType DoubleType = new DataType("double");
    public static final DataType BooleanTypeNullable = new DataType("Boolean");
    public static final DataType IntTypeNullable = new DataType("Integer");
    public static final DataType LongTypeNullable = new DataType("Long");
    public static final DataType DoubleTypeNullable = new DataType("Double");
    public static final DataType StringType = new DataType("String");
    public static final DataType NumberType = new DataType("Number");
    public static final DataType ByteArray = new DataType("byte[]");
    public static final DataType FileObjectType = new DataType("FileObject");
    public static final DataType ICURSOR = new DataType("ICursor");
    private String type;
    private boolean isArray;
    private DataType memberType;
    private StructType structType;

    public String getTypeName() {
        return this.type;
    }

    public void setTypeName(String type) {
        this.type = type;
    }

    public void setType(DataType type) {
        this.type = type.type;
        this.memberType = type.memberType;
        this.structType = type.structType;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public String toString() {
        String ret;
        String string = ret = this.type == null ? "null" : this.type;
        if (this.isArray) {
            ret = String.valueOf(ret) + "[]";
        }
        return ret;
    }

    public boolean equalTo(DataType other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return Objects.equals(this.type, other.type);
    }

    public boolean isType(String typeName) {
        return this.type == null ? false : this.type.equals(typeName);
    }

    public DataType() {
        this.type = UnknownType;
        this.isArray = false;
    }

    public DataType(String type) {
        this.type = type;
        this.isArray = false;
    }

    public DataType(DataType dataType) {
        this.type = dataType.type;
        this.isArray = dataType.isArray;
    }

    public DataType(String type, boolean isArray) {
        this.type = type;
        this.isArray = isArray;
    }

    public DataType(String type, String memberType) {
        this.type = type;
        this.memberType = new DataType(memberType);
    }

    public DataType(String type, DataType memberType) {
        this.type = type;
        this.memberType = memberType;
    }

    public DataType(String type, StructType structType) {
        this.type = type;
        this.structType = structType;
    }

    public static DataType newSequenceType() {
        return new DataType("Sequence");
    }

    public static DataType newTableType() {
        DataType type = new DataType("Table");
        type.setMemberType(DataType.newRecordType(null));
        return type;
    }

    public static DataType newSequenceType(String subType) {
        return new DataType("Sequence", subType);
    }

    public static DataType newSequenceType(DataType subType) {
        DataType type = new DataType("Sequence", subType);
        if (subType.isType("BaseRecord")) {
            type.setStructType(subType.getStructType());
        }
        return type;
    }

    public static DataType newTableType(StructType structType) {
        DataType type = new DataType("Table", structType);
        type.setMemberType(DataType.newRecordType(structType));
        return type;
    }

    public static DataType newRecordType(StructType structType) {
        DataType type = new DataType("BaseRecord", structType);
        type.setStructType(structType);
        return type;
    }

    public static DataType newCursorType(StructType structType) {
        DataType type = new DataType("ICursor", structType);
        type.setMemberType(DataType.newRecordType(structType));
        return type;
    }

    public static DataType toNullable(DataType type) {
        if (type.isType("int")) {
            return IntTypeNullable;
        }
        if (type.isType("long")) {
            return LongTypeNullable;
        }
        if (type.isType("boolean")) {
            return BooleanTypeNullable;
        }
        if (type.isType("double")) {
            return DoubleTypeNullable;
        }
        return type;
    }

    public static DataType ifIntToLong(DataType type) {
        if (type.isType("int")) {
            return LongType;
        }
        if (type.isType("Integer")) {
            return LongTypeNullable;
        }
        return type;
    }

    public String prefixWithTypeName(String line) {
        String typeName = this.type;
        if ("Object".equals(typeName)) {
            return line;
        }
        if (line != null && line.startsWith("(" + typeName + ")")) {
            return line;
        }
        return "(" + typeName + ")" + line;
    }

    public DataType getMemberType() {
        return this.memberType;
    }

    public void setMemberType(DataType memberType) {
        this.memberType = memberType;
    }

    public StructType getStructType() {
        return this.structType;
    }

    public void setStructType(StructType structType) {
        this.structType = structType;
    }

    public String getInitStr() {
        String typeName = this.type;
        if (typeName == null || typeName.isEmpty()) {
            return "";
        }
        if (this.isNullable() && this.isNumber()) {
            return "=null";
        }
        if ("int".equals(typeName)) {
            return "=0";
        }
        if ("long".equals(typeName)) {
            return "=0L";
        }
        if ("double".equals(typeName)) {
            return "=0.0";
        }
        if ("float".equals(typeName)) {
            return "=0.0f";
        }
        if ("boolean".equals(typeName)) {
            return "=false";
        }
        if ("String".equals(typeName)) {
            return "=null";
        }
        if ("Date".equals(typeName)) {
            return "=new java.util.Date()";
        }
        if ("Sequence".equals(typeName)) {
            return "=null";
        }
        if ("Table".equals(typeName)) {
            return "=new Table()";
        }
        return "";
    }

    public String getDefaultValueStr() {
        String typeName = this.type;
        if (typeName == null || typeName.isEmpty()) {
            return "null";
        }
        if ("int".equals(typeName) || "Integer".equals(typeName)) {
            return "0";
        }
        if ("long".equals(typeName)) {
            return "0L";
        }
        if ("double".equals(typeName)) {
            return "0.0";
        }
        if ("float".equals(typeName)) {
            return "0.0f";
        }
        if ("boolean".equals(typeName)) {
            return "false";
        }
        if ("String".equals(typeName)) {
            return "\"\"";
        }
        if ("Date".equals(typeName)) {
            return "new java.util.Date()";
        }
        if ("Sequence".equals(typeName)) {
            return "new Sequence()";
        }
        if ("Table".equals(typeName)) {
            return "new Table()";
        }
        return "null";
    }

    public boolean isNullable() {
        String typeName = this.type;
        if (typeName == null || typeName.isEmpty()) {
            return true;
        }
        return !"int".equals(typeName) && !"long".equals(typeName) && !"boolean".equals(typeName) && !"double".equals(typeName);
    }

    public boolean isNumber() {
        String typeName = this.type;
        if (typeName == null || typeName.isEmpty()) {
            return false;
        }
        return "int".equals(typeName) || "long".equals(typeName) || "double".equals(typeName) || "Integer".equals(typeName) || "Long".equals(typeName) || "Double".equals(typeName) || "Number".equals(typeName);
    }

    public String getBaseTypeName() {
        String typeName = this.type;
        if ("Integer".equals(typeName)) {
            return "int";
        }
        if ("Long".equals(typeName)) {
            return "long";
        }
        if ("Boolean".equals(typeName)) {
            return "boolean";
        }
        if ("Double".equals(typeName)) {
            return "double";
        }
        return typeName;
    }
}

