/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.array.IArray;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.compile.CodeItem;
import com.scudata.compile.CompilerUtil;
import com.scudata.compile.CurrentSeqItem;
import com.scudata.compile.CurrentVarItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.MethodMaker;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.RunMethodMaker;
import com.scudata.compile.VarItem;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Table;
import com.scudata.expression.CSVariable;
import com.scudata.expression.Constant;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.CurrentSeq;
import com.scudata.expression.ElementRef;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.ValueList;
import com.scudata.expression.VarParam;
import com.scudata.expression.fn.If;
import com.scudata.expression.fn.math.Rand;
import com.scudata.expression.mfn.sequence.Len;
import com.scudata.expression.mfn.sequence.PMin;
import com.scudata.expression.operator.Add;
import com.scudata.expression.operator.AddAssign;
import com.scudata.expression.operator.Assign;
import com.scudata.expression.operator.Comma;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.Multiply;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Or;
import com.scudata.expression.operator.Smaller;
import com.scudata.expression.operator.Subtract;
import com.scudata.pdm.PureTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DeriveMethodMaker
extends RunMethodMaker {
    protected Table table;
    protected DataStruct ds;
    protected List<VarItem> assignVars;
    protected boolean hasUnknownExp;
    protected boolean isSequenceDerive;
    private String initCode;

    public DeriveMethodMaker(Table table, String name, String option, String retType) {
        super(name, option, retType);
        this.table = table;
        if (table != null) {
            this.ds = table.dataStruct();
        }
    }

    public static String defaultRunMethod() {
        throw new RuntimeException();
    }

    public String constructorMethod(String clsName) {
        return "public " + clsName + "() {\r\n" + "\t\tsuper(null);\r\n" + "\t}";
    }

    public String duplicateMethod(String clsName) {
        return "\tpublic Operation duplicate(Context ctx) {\r\n\t\treturn new " + clsName + "();\r\n" + "\t}";
    }

    public String newDataStructMethod() {
        int oldColCount = this.ds.getFieldCount();
        int newColCount = oldColCount + this.assignVars.size();
        String names = "";
        for (VarItem v : this.assignVars) {
            names = String.valueOf(names) + "\"";
            names = String.valueOf(names) + v.getName();
            names = String.valueOf(names) + "\",";
        }
        return "protected String[] names = {" + names + "};\r\n" + "\tprotected DataStruct newDs;\r\n" + "\tprotected DataStruct getNewDataStruct(Sequence seq) {\r\n" + "\t\tif (newDs == null) {\r\n" + "\t\t\tDataStruct ds = seq.dataStruct();\r\n" + "\t\t\tString []oldNames = ds.getFieldNames();\r\n" + "\t\t\tString []totalNames = new String[" + newColCount + "];\r\n" + "\t\t\tSystem.arraycopy(oldNames, 0, totalNames, 0, " + oldColCount + ");\r\n" + "\t\t\tSystem.arraycopy(names, 0, totalNames, " + oldColCount + ", names.length);\r\n" + "\t\t\tnewDs = ds.create(totalNames);\r\n" + "\t\t}\r\n" + "\t\treturn newDs;\r\n" + "\t}";
    }

    @Override
    protected void startCycle(StringBuffer out) {
        out.append("int len = seq.length();");
        out.append(System.lineSeparator());
        out.append("for (int i = 1; i <= len; i++) {");
        out.append(System.lineSeparator());
    }

    @Override
    protected void endCycle(StringBuffer out) {
        out.append("}");
        out.append(System.lineSeparator());
    }

    private CodeItem parseIf(If node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param.isLeaf()) {
            return this.parse(param.getLeafExpression().getHome());
        }
        IParam sub0 = param.getSub(0);
        IParam sub1 = param.getSub(1);
        IParam sub2 = param.getSub(2);
        CodeItem item0 = this.parse(sub0.getLeafExpression().getHome());
        String tempVar = "ifVar" + this.ifVarId;
        String line = "if (" + item0.toString() + "){";
        this.addLine2(line);
        CodeItem item1 = this.parse(sub1.getLeafExpression().getHome());
        line = String.valueOf(tempVar) + "=" + item1 + ";}else{";
        this.addLine2(line);
        CodeItem item2 = this.parse(sub2.getLeafExpression().getHome());
        line = String.valueOf(tempVar) + "=" + item2 + ";}";
        this.addLine2(line);
        this.addVar(tempVar, item1.getType(), null);
        ++this.ifVarId;
        return new LineItem(tempVar, item1.getType());
    }

    @Override
    protected CodeItem parse(Node node) throws ParseNodeException {
        Node left = node.getLeft();
        Node right = node.getRight();
        if (node instanceof DotOperator) {
            if (right instanceof PMin) {
                return this.parsePMin((PMin)right, this.parse(left));
            }
            throw new ParseNodeException(right.toString());
        }
        if (node instanceof Assign) {
            String leftName;
            if (left instanceof UnknownSymbol) {
                leftName = DeriveMethodMaker.getVarName((UnknownSymbol)left);
            } else if (left instanceof CSVariable) {
                leftName = DeriveMethodMaker.getVarName((CSVariable)left);
            } else {
                if (left instanceof CurrentElement) {
                    CodeItem rightItem = this.parse(right);
                    String line = String.valueOf(this.currentVar) + "=" + rightItem;
                    this.setSeqType(rightItem.getType().getTypeName());
                    return new LineItem(line, rightItem.getType());
                }
                if (left instanceof ElementRef) {
                    CodeItem rightItem = this.parse(right);
                    CodeItem leftItem = this.parseElementRef((ElementRef)left);
                    if (rightItem.getType() != null) {
                        this.adjustType(leftItem, rightItem.getType());
                    }
                    String leftName2 = leftItem.toString();
                    String line = String.valueOf(leftName2) + "=" + rightItem;
                    return new LineItem(line, rightItem.getType());
                }
                throw new ParseNodeException(node.toString());
            }
            CodeItem rightItem = this.parse(right);
            this.setVar(leftName, rightItem.getType(), null);
            String line = this.getFieldIndex(leftName) >= 0 ? String.valueOf(leftName) + "=" + leftName + "_arr[i]=" + rightItem : String.valueOf(leftName) + "=" + rightItem;
            return new LineItem(line, rightItem.getType());
        }
        if (node instanceof UnknownSymbol) {
            String var = DeriveMethodMaker.getVarName((UnknownSymbol)node);
            DataType type = this.getVarType(var);
            VarItem varItem = new VarItem(var, type, null);
            if (!this.hasVar(var)) {
                this.addVar(varItem);
            }
            return varItem;
        }
        if (node instanceof VarParam) {
            String var = DeriveMethodMaker.getVarName((VarParam)node);
            DataType type = this.getVarType(var);
            VarItem varItem = new VarItem(var, type, null);
            if (!this.hasVar(var)) {
                this.addVar(varItem);
            }
            return varItem;
        }
        if (node instanceof CSVariable) {
            String var = DeriveMethodMaker.getVarName((CSVariable)node);
            DataType type = this.getVarType(var);
            if (!this.hasVar(var)) {
                this.setVar(var, type, null);
            }
            VarItem item = new VarItem(var, type, null);
            item.setCell(true);
            item.setGlobal(true);
            this.addVar(item);
            return item;
        }
        if (node instanceof Greater) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + ">" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Smaller) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "<" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Add) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "+" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof AddAssign) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "+=" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Subtract) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "-" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Multiply) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "*" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Equals) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "==" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Or) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem("(" + leftItem + ")||(" + rightItem + ")", MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof NotSmaller) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + ">=" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof CurrentElement) {
            return new CurrentVarItem(new DataType("SeqDefaultType"), this);
        }
        if (node instanceof CurrentSeq) {
            return new CurrentSeqItem(this);
        }
        if (node instanceof Constant) {
            Object obj = node.calculate(null);
            return new LineItem(obj.toString(), MethodMaker.getObjectType(obj));
        }
        if (node instanceof If) {
            return this.parseIf((If)node);
        }
        if (node instanceof Comma) {
            this.addLine(this.parse(node.getLeft()).toString());
            return this.parse(node.getRight());
        }
        if (node instanceof ValueList) {
            return this.parseValueList((ValueList)node);
        }
        if (node instanceof ElementRef) {
            return this.parseElementRef((ElementRef)node);
        }
        if (node instanceof Rand) {
            return this.parseRand((Rand)node);
        }
        throw new ParseNodeException(node.toString());
    }

    private CodeItem parseRand(Rand rand) throws ParseNodeException {
        if (rand.getParam() == null && rand.getOption() == null) {
            return new LineItem("random.nextDouble()", new DataType("double"));
        }
        throw new ParseNodeException(rand.toString());
    }

    private CodeItem parsePMin(PMin node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            String line = "pmin(" + left + ")";
            return new LineItem(line, new DataType("int"));
        }
        throw new ParseNodeException(node.toString());
    }

    private CodeItem parseElementRef(ElementRef node) throws ParseNodeException {
        LineItem ret;
        CodeItem idxNode;
        DataType type;
        CodeItem datas = this.parse(node.getLeft());
        datas.getType().setArray(true);
        String line = datas.toString();
        if (datas.getType() == null) {
            datas.setType(new DataType("UnknownType", true));
        }
        if ((type = (idxNode = this.parse(node.getExp().getHome())).getType()) != null && type.isArray()) {
            line = "getElments(" + line + "," + idxNode + ")";
            return new LineItem(line, datas.getType());
        }
        line = String.valueOf(line) + "[" + idxNode + "]";
        type = datas.getType();
        if (type != null) {
            type = new DataType(type.getTypeName(), false);
            ret = new LineItem(line, type);
        } else {
            ret = new LineItem(line, null);
        }
        ret.setRelatedVar(datas);
        return ret;
    }

    private CodeItem parseValueList(ValueList node) throws ParseNodeException {
        IParam param = node.getParam();
        char type = param.getType();
        if (type == '\u0000') {
            Expression exp = param.getLeafExpression();
            CodeItem item = this.parse(exp.getHome());
            DataType ty = item.getType();
            String line = "new " + ty + "[]{0," + item + "}";
            return new LineItem(line, ty);
        }
        if (type == ',') {
            int size = param.getSubSize();
            DataType ty = null;
            String line = "[]{0,";
            int i = 0;
            while (i < size) {
                IParam sub = param.getSub(i);
                if (sub == null) {
                    throw new ParseNodeException(node.toString());
                }
                if (!sub.isLeaf()) {
                    throw new ParseNodeException(node.toString());
                }
                Expression exp = sub.getLeafExpression();
                CodeItem item = this.parse(exp.getHome());
                ty = MethodMaker.calcMaxType(ty, item.getType());
                line = String.valueOf(line) + item.toString() + ",";
                ++i;
            }
            line = "new " + ty + line + "}";
            ty.setArray(true);
            return new LineItem(line, ty);
        }
        if (type == ':') {
            throw new ParseNodeException(node.toString());
        }
        throw new ParseNodeException(node.toString());
    }

    @Override
    public void addExp(int col, int row, Expression exp, String expStr) throws ParseNodeException {
        if (exp == null) {
            return;
        }
        CodeItem item = this.parse(exp.getHome());
        this.addLine(item.toString());
    }

    public void addExp(int index, String leftName) {
        this.hasUnknownExp = true;
        this.setVar(leftName, new DataType("Object"), null);
        String right = "exps[" + index + "].calculate(ctx)";
        String line = this.getFieldIndex(leftName) >= 0 ? String.valueOf(leftName) + "=" + leftName + "_arr[i]=" + right : String.valueOf(leftName) + "=" + right;
        this.addLine(line);
    }

    private int getFieldIndex(String name) {
        return this.ds.getFieldIndex(name);
    }

    private String[] getFieldType(String name) {
        String[] types;
        String type;
        Class<?> cls;
        if (this.types != null && this.types.containsKey(name) && (cls = CompilerUtil.toJavaType(type = ((String)this.types.get(name)).toLowerCase())) != null) {
            types = new String[2];
            types[0] = cls.getName();
            try {
                types[1] = DeriveMethodMaker.getType(cls.newInstance());
            }
            catch (Exception e) {
                types = null;
            }
            if (types != null) {
                return types;
            }
        }
        if (this.table instanceof PureTable) {
            int idx = this.ds.getFieldIndex(name);
            if (idx < 0) {
                return null;
            }
            IArray arr = ((PureTable)this.table).getFieldValueArray(idx);
            String[] types2 = new String[]{arr.getClass().getName(), DeriveMethodMaker.getType(arr)};
            return types2;
        }
        BaseRecord rec = this.table.getRecord(1);
        Object obj = rec.getFieldValue(name);
        types = new String[]{obj.getClass().getName(), DeriveMethodMaker.getType(obj)};
        return types;
    }

    private String[] getAssignVarType(String name) {
        int i = 0;
        int len = this.assignVars.size();
        while (i < len) {
            VarItem v = this.assignVars.get(i);
            if (v.getName().equals(name)) {
                String[] types = new String[3];
                types[1] = v.getType().getTypeName();
                types[0] = DeriveMethodMaker.getArrayType(types[1]);
                types[2] = "" + (i + this.ds.getFieldCount());
                return types;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String finish() {
        if (this.table == null) {
            return null;
        }
        if (this.table instanceof PureTable) {
            return this.finishPureTable();
        }
        return this.finishTable();
    }

    public String finishPureTable() {
        VarItem item;
        int idx;
        String name;
        VarItem v;
        StringBuffer result = new StringBuffer();
        if (this.option == null) {
            this.option = "public ";
        }
        if (this.retType == null) {
            this.retType = "void ";
        }
        result.append(this.option);
        result.append(this.retType);
        result.append(this.name);
        result.append(System.lineSeparator());
        if (this.isSequenceDerive) {
            result.append("Sequence seq = srcSequence;");
            result.append(System.lineSeparator());
        }
        result.append("if (seq == null) return seq;");
        result.append(System.lineSeparator());
        result.append("PureTable ptable = (PureTable)seq;");
        result.append(System.lineSeparator());
        result.append("int size = seq.length();");
        result.append(System.lineSeparator());
        result.append("IArray[] arrays = ptable.getColDatas();");
        result.append(System.lineSeparator());
        int newColCount = this.ds.getFieldCount() + this.assignVars.size();
        int oldColCount = this.ds.getFieldCount();
        result.append("IArray []resultDatas = new IArray[" + newColCount + "];");
        result.append(System.lineSeparator());
        result.append("System.arraycopy(arrays, 0, resultDatas, 0, " + oldColCount + ");");
        result.append(System.lineSeparator());
        int i = 0;
        int len = this.assignVars.size();
        while (i < len) {
            v = this.assignVars.get(i);
            name = v.getName();
            String[] types = this.getAssignVarType(name);
            idx = oldColCount + i;
            result.append("resultDatas[" + idx + "] = new " + types[0] + "(size);");
            result.append("resultDatas[" + idx + "].setSize(size);");
            result.append(System.lineSeparator());
            ++i;
        }
        result.append("ptable.setColDatas(resultDatas);");
        result.append(System.lineSeparator());
        result.append("ptable.setDataStruct(getNewDataStruct(seq));");
        result.append(System.lineSeparator());
        result.append("arrays = resultDatas;");
        result.append(System.lineSeparator());
        for (Map.Entry entry : this.vars.entrySet()) {
            String define;
            String[] types;
            String name2;
            item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("SeqDefaultType")) {
                type = new DataType(type);
                type.setTypeName(this.seqType);
            }
            if (type != null && type.isType("UnknownType")) {
                type = new DataType(type);
                type.setTypeName(this.seqType);
            }
            if ((idx = this.getFieldIndex(name2 = item.getName())) >= 0) {
                types = this.getFieldType(name2);
                define = String.valueOf(types[1]) + "[] " + name2 + "_arr = ((" + types[0] + ")arrays[" + idx + "]).getDatas();";
                result.append(define);
                result.append(System.lineSeparator());
                result.append(types[1]);
                result.append(" ");
                result.append(item.getName());
            } else {
                types = this.getAssignVarType(name2);
                if (types != null) {
                    define = String.valueOf(types[1]) + "[] " + name2 + "_arr = ((" + types[0] + ")arrays[" + types[2] + "]).getDatas();";
                    result.append(define);
                    result.append(System.lineSeparator());
                    result.append(types[1]);
                    result.append(" ");
                    result.append(item.getName());
                } else {
                    result.append(type);
                    result.append(" ");
                    result.append(item.getName());
                }
            }
            if (item.isGlobal()) {
                if (item.isCell()) {
                    if (!item.getType().isArray()) {
                        result.append(" = (" + type + ")getObject(\"" + item.getName() + "\")");
                    } else {
                        String str = "getObject(\"" + item.getName() + "\")";
                        result.append(" = (" + type + ")getDatas(" + str + ")");
                    }
                } else if (!item.getType().isArray()) {
                    result.append(" = (" + type + ")ctx.getParam(\"" + item.getName() + "\").getValue()");
                } else {
                    result.append(" = (" + type + ")getDatas(\"" + item.getName() + "\", ctx)");
                }
            }
            result.append(";");
            result.append(System.lineSeparator());
        }
        this.startCycle(result);
        for (Map.Entry entry : this.vars.entrySet()) {
            item = (VarItem)entry.getValue();
            name = item.getName();
            int idx2 = this.getFieldIndex(name);
            if (idx2 >= 0) {
                result.append(String.valueOf(name) + " = " + name + "_arr[i];");
                result.append(System.lineSeparator());
                continue;
            }
            String[] types = this.getAssignVarType(name);
            if (types == null) continue;
            result.append(String.valueOf(name) + " = " + name + "_arr[i];");
            result.append(System.lineSeparator());
        }
        result.append(this.code);
        i = 0;
        len = this.assignVars.size();
        while (i < len) {
            v = this.assignVars.get(i);
            name = v.getName();
            result.append(String.valueOf(name) + "_arr[i] = " + name + ";");
            result.append(System.lineSeparator());
            ++i;
        }
        this.endCycle(result);
        for (Map.Entry entry : this.vars.entrySet()) {
            item = (VarItem)entry.getValue();
            if (!item.isGlobal()) continue;
            if (item.isCell()) {
                if (item.getType().isArray()) continue;
                result.append("setObject(" + item.getR() + "," + item.getC() + "," + item.getName() + ")");
                result.append(";");
                result.append(System.lineSeparator());
                continue;
            }
            if (item.getType().isArray()) continue;
            result.append("ctx.getParam(\"" + item.getName() + "\").setValue(" + item.getName() + ")");
            result.append(";");
            result.append(System.lineSeparator());
        }
        result.append("return seq;");
        result.append(System.lineSeparator());
        result.append("}");
        return result.toString();
    }

    public String finishTable() {
        String name;
        int idx;
        VarItem item;
        StringBuffer result = new StringBuffer();
        if (this.option == null) {
            this.option = "public ";
        }
        if (this.retType == null) {
            this.retType = "void ";
        }
        result.append(this.option);
        result.append(this.retType);
        result.append(this.name);
        result.append(System.lineSeparator());
        result.append("if (seq == null) return;");
        result.append(System.lineSeparator());
        result.append("IArray mems = seq.getMems();");
        result.append(System.lineSeparator());
        result.append("int len = mems.size();");
        result.append(System.lineSeparator());
        int oldColCount = this.ds.getFieldCount();
        if (this.initCode != null) {
            result.append(this.initCode);
            result.append(System.lineSeparator());
        }
        for (Map.Entry entry : this.vars.entrySet()) {
            String define;
            String[] types;
            item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("SeqDefaultType")) {
                type = new DataType(type);
                type.setTypeName(this.seqType);
            }
            if (type != null && type.isType("UnknownType")) {
                type = new DataType(type);
                type.setTypeName(this.seqType);
            }
            if ((idx = this.getFieldIndex(name = item.getName())) >= 0) {
                types = this.getFieldType(name);
                define = String.valueOf(types[1]) + " " + name;
                result.append(define);
            } else {
                types = this.getAssignVarType(name);
                if (types != null) {
                    define = String.valueOf(types[1]) + " " + name;
                    result.append(define);
                } else if (item.isGlobal()) {
                    result.append(type);
                    result.append(" ");
                    result.append(item.getName());
                    if (item.isCell()) {
                        result.append(" = (" + type + ")getObject(\"" + item.getName() + "\")");
                    } else {
                        result.append(" = (" + type + ")ctx.getParam(\"" + item.getName() + "\").getValue()");
                    }
                } else {
                    result.append(type);
                    result.append(" ");
                    result.append(item.getName());
                    if (item.isCell()) {
                        result.append(" = (" + type + ")getObject(\"" + item.getName() + "\")");
                    } else {
                        result.append(" = (" + type + ")ctx.getParam(\"" + item.getName() + "\").getValue()");
                    }
                }
            }
            result.append(";");
            result.append(System.lineSeparator());
        }
        result.append("IArray resultMems = table.getMems();");
        result.append(System.lineSeparator());
        if (this.hasUnknownExp) {
            DeriveMethodMaker.appendLine(result, "ComputeStack stack = ctx.getComputeStack();");
            DeriveMethodMaker.appendLine(result, "Current newCurrent = new Current(table);");
            DeriveMethodMaker.appendLine(result, "stack.push(newCurrent);");
            DeriveMethodMaker.appendLine(result, "Current current = new Current(seq);");
            DeriveMethodMaker.appendLine(result, "stack.push(current);");
        }
        result.append("for (int i = 1; start < end; ++start) {");
        result.append(System.lineSeparator());
        result.append("Record r = new Record(newDs);");
        result.append(System.lineSeparator());
        result.append("resultMems.add(r);");
        result.append(System.lineSeparator());
        result.append("r.set((BaseRecord)mems.get(start));");
        result.append(System.lineSeparator());
        if (this.hasUnknownExp) {
            result.append("newCurrent.setCurrent(i);");
            result.append(System.lineSeparator());
            result.append("current.setCurrent(start);");
            result.append(System.lineSeparator());
        }
        for (Map.Entry entry : this.vars.entrySet()) {
            item = (VarItem)entry.getValue();
            String name2 = item.getName();
            DataType type = item.getType();
            idx = this.getFieldIndex(name2);
            if (idx >= 0) {
                result.append(String.valueOf(name2) + " = (" + type + ")r.getNormalFieldValue(" + idx + ");");
                result.append(System.lineSeparator());
                continue;
            }
            this.assignVars.contains(item);
        }
        String[] codes = this.code.toString().split(System.lineSeparator());
        int i = 0;
        int len = this.assignVars.size();
        while (i < len) {
            VarItem v = this.assignVars.get(i);
            name = v.getName();
            idx = oldColCount + i;
            result.append(codes[i]);
            result.append("r.setNormalFieldValue(" + idx + ", " + name + ");");
            result.append(System.lineSeparator());
            ++i;
        }
        DeriveMethodMaker.appendLine(result, "i++;");
        this.endCycle(result);
        for (Map.Entry entry : this.vars.entrySet()) {
            VarItem item2 = (VarItem)entry.getValue();
            if (!item2.isGlobal()) continue;
            if (item2.isCell()) {
                if (item2.getType().isArray()) continue;
                result.append("setObject(" + item2.getR() + "," + item2.getC() + "," + item2.getName() + ")");
                result.append(";");
                result.append(System.lineSeparator());
                continue;
            }
            if (item2.getType().isArray()) continue;
            result.append("ctx.getParam(\"" + item2.getName() + "\").setValue(" + item2.getName() + ")");
            result.append(";");
            result.append(System.lineSeparator());
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public String getSeqType() {
        return this.seqType;
    }

    @Override
    public void setSeqType(String seqType) {
        this.seqType = seqType;
    }

    private static void parseAssinNode(Node node, DataType type, ConcurrentHashMap<String, VarItem> vars) {
        VarItem var;
        String name;
        Node left = node.getLeft();
        Node right = node.getRight();
        if (node instanceof Assign) {
            DeriveMethodMaker.parseAssinNode(left, type, vars);
            DeriveMethodMaker.parseAssinNode(right, type, vars);
            return;
        }
        if (node instanceof UnknownSymbol) {
            name = DeriveMethodMaker.getVarName((UnknownSymbol)node);
        } else if (node instanceof CSVariable) {
            name = DeriveMethodMaker.getVarName((CSVariable)node);
        } else {
            return;
        }
        if (vars.containsKey(name)) {
            var = vars.get(name);
            var.setType(type);
        } else {
            var = new VarItem(name, type, null);
        }
        vars.put(name, var);
    }

    public static void searchVar(Node node, ConcurrentHashMap<String, VarItem> vars) {
        Node left = node.getLeft();
        Node right = node.getRight();
        if (node instanceof Assign) {
            DataType rightType = null;
            if (right instanceof DotOperator) {
                if ((right = right.getRight()) instanceof Len) {
                    rightType = new DataType("int");
                }
            } else if (right instanceof Constant) {
                Object obj = right.calculate(null);
                rightType = MethodMaker.getObjectType(obj);
            }
            DeriveMethodMaker.parseAssinNode(left, rightType, vars);
        }
    }

    private void adjustType(CodeItem item, DataType newType) {
        if (item == null) {
            return;
        }
        item.adjustType(newType);
        if (item instanceof VarItem && !item.getType().getTypeName().equals("UnknownType")) {
            VarItem var = (VarItem)item;
            this.addVar(var);
        }
        if (item.getRelatedVar() != null) {
            this.adjustType(item.getRelatedVar(), newType);
        }
    }

    @Override
    public void adjustVarTypeByTip(ConcurrentHashMap<String, String> types) {
        String name;
        if (this.vars != null) {
            for (Map.Entry entry : this.vars.entrySet()) {
                name = (String)entry.getKey();
                VarItem item = (VarItem)entry.getValue();
                DataType type = item.getType();
                if (type == null || !type.isType("UnknownType")) continue;
                if (types.containsKey(name)) {
                    String ty = types.get(name);
                    type.setTypeName(ty);
                    continue;
                }
                type.setTypeName(this.seqType);
            }
        }
        if (this.assignVars != null) {
            for (VarItem varItem : this.assignVars) {
                name = varItem.getName();
                DataType type = varItem.getType();
                if (type == null || !type.isType("UnknownType")) continue;
                if (types.containsKey(name)) {
                    String ty = types.get(name);
                    type.setTypeName(ty);
                    continue;
                }
                type.setTypeName(this.seqType);
            }
        }
    }

    @Override
    public void adjustVarType(ConcurrentHashMap<String, VarItem> global) {
        for (Map.Entry entry : this.vars.entrySet()) {
            String name = (String)entry.getKey();
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("UnknownType")) {
                if (global.containsKey(name)) {
                    VarItem gvar = global.get(name);
                    type.setTypeName(gvar.getType().getTypeName());
                } else {
                    type.setTypeName(this.seqType);
                }
            }
            if (!global.containsKey(name)) continue;
            item.setGlobal(true);
            item.setCell(global.get(name).isCell());
            item.setC(global.get(name).getC());
            item.setR(global.get(name).getR());
        }
    }

    @Override
    public void adjustVarType(PgmCellSet cellSet) {
        Object obj;
        DataType newType;
        String name;
        Context ctx = cellSet.getContext();
        for (Map.Entry entry : this.vars.entrySet()) {
            Object obj2;
            name = (String)entry.getKey();
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            try {
                obj2 = item.isCell() ? cellSet.getCell(item.getName()).getValue() : ctx.getParam(name).getValue();
            }
            catch (Exception e) {
                continue;
            }
            DataType newType2 = DeriveMethodMaker.getObjectType(obj2);
            if (newType2 == null || newType2.isType("UnknownType")) continue;
            type.setTypeName(newType2.getTypeName());
            type.setArray(newType2.isArray());
        }
        for (VarItem item : this.assignVars) {
            Object obj3;
            name = item.getName();
            DataType type = item.getType();
            try {
                obj3 = item.isCell() ? cellSet.getCell(item.getName()).getValue() : ctx.getParam(name).getValue();
            }
            catch (Exception e) {
                continue;
            }
            DataType newType3 = DeriveMethodMaker.getObjectType(obj3);
            if (newType3 == null || newType3.isType("UnknownType")) continue;
            type.setTypeName(newType3.getTypeName());
            type.setArray(newType3.isArray());
        }
        if (cellSet.getCell(this.currentVarName) != null && (newType = DeriveMethodMaker.getObjectType(obj = cellSet.getCell(this.currentVarName).getValue())) != null && !newType.isType("UnknownType")) {
            this.seqType = newType.getTypeName();
        }
    }

    @Override
    public String getCurrentSeq() {
        return this.currentSeq;
    }

    @Override
    public void setCurrentSeq(String currentSeq) {
        this.currentSeq = currentSeq;
    }

    @Override
    protected DataType getVarType(String var) {
        if (this.currentVarName != null && this.currentVarName.equals(var)) {
            if (this.seqType != null) {
                return new DataType(this.seqType, true);
            }
            return new DataType("SeqDefaultType", true);
        }
        if (this.vars.containsKey(var)) {
            VarItem v = (VarItem)this.vars.get(var);
            return v.getType();
        }
        return new DataType("UnknownType");
    }

    @Override
    public String getCurrentVarName() {
        return this.currentVarName;
    }

    @Override
    public void setCurrentVarName(String currentVarName) {
        this.currentVarName = currentVarName;
    }

    @Override
    public String getCurrentVar() {
        throw new RuntimeException();
    }

    @Override
    public void setCurrentVar(String currentVar) {
        throw new RuntimeException();
    }

    public void addAssignVar(String assignVar) {
        VarItem vi = (VarItem)this.vars.get(assignVar);
        if (vi != null) {
            if (this.assignVars == null) {
                this.assignVars = new ArrayList<VarItem>();
            }
            this.assignVars.add(vi);
        }
    }

    @Override
    public ConcurrentHashMap<String, String> getTypes() {
        return this.types;
    }

    @Override
    public void setTypes(ConcurrentHashMap<String, String> types) {
        this.types = types;
    }

    public boolean isSequenceDerive() {
        return this.isSequenceDerive;
    }

    public void setSequenceDerive(boolean isSequenceDerive) {
        this.isSequenceDerive = isSequenceDerive;
    }

    public void addInitCode(String code) {
        if (this.initCode == null) {
            this.initCode = "";
        }
        this.initCode = String.valueOf(this.initCode) + code + System.lineSeparator();
    }
}

