/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.compile.CodeItem;
import com.scudata.compile.DataType;
import com.scudata.compile.TypeCaster;

public class LineItem
extends CodeItem {
    public static final CodeItem NULL = new LineItem("null", DataType.ObjectType, null);
    public static final CodeItem NOP = new LineItem("", DataType.VoidType, null);
    private String content;
    private DataType lineType;

    public LineItem(String content) {
        this(content, null, null);
    }

    public LineItem(String content, DataType returnType) {
        this(content, returnType, null);
    }

    public LineItem(String content, DataType returnType, DataType lineType) {
        super(returnType);
        this.content = content;
        this.lineType = lineType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public DataType getLineType() {
        return this.lineType;
    }

    @Override
    public CodeItem makeAssign(CodeItem value) {
        if (this.assignStr == null) {
            throw new RuntimeException();
        }
        String line = String.format(this.assignStr, value.toString());
        return new LineItem(line, value.getType());
    }

    @Override
    public String makeAssignString(String value) {
        return String.format(this.assignStr, value);
    }

    public String toString() {
        return this.content;
    }

    @Override
    public boolean isAssigned() {
        throw new RuntimeException();
    }

    @Override
    public CodeItem cast() {
        String newType;
        if (this.lineType == null) {
            return this;
        }
        String type = this.lineType.getTypeName();
        String line = TypeCaster.cast(this.content, type, newType = this.type.getTypeName());
        if (line == this.content) {
            return this;
        }
        return new LineItem(line, new DataType(type));
    }

    @Override
    public CodeItem cast(String newType) {
        String type = this.lineType == null ? this.type.getTypeName() : this.lineType.getTypeName();
        String content = this.content;
        if (content.indexOf(".") != -1 || content.indexOf("?") != -1 || content.indexOf(":") != -1) {
            content = "(" + content + ")";
        }
        String line = TypeCaster.cast(content, type, newType);
        return new LineItem(line, new DataType(newType));
    }
}

