/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.compile.CodeItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.VarItem;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.CSVariable;
import com.scudata.expression.Constant;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.CurrentSeq;
import com.scudata.expression.ElementRef;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldRef;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.ValueList;
import com.scudata.expression.VarParam;
import com.scudata.expression.fn.If;
import com.scudata.expression.fn.math.Cos;
import com.scudata.expression.fn.math.Pow;
import com.scudata.expression.fn.math.Rand;
import com.scudata.expression.fn.math.Sin;
import com.scudata.expression.fn.math.Sqrt;
import com.scudata.expression.mfn.sequence.PMin;
import com.scudata.expression.operator.Add;
import com.scudata.expression.operator.AddAssign;
import com.scudata.expression.operator.And;
import com.scudata.expression.operator.Assign;
import com.scudata.expression.operator.Comma;
import com.scudata.expression.operator.Divide;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.Multiply;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Or;
import com.scudata.expression.operator.Smaller;
import com.scudata.expression.operator.Subtract;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodMaker {
    public static final String SeqDefaultType = "SeqDefaultType";
    protected HashMap<String, VarItem> vars;
    protected String name;
    protected String option;
    protected String retType;
    protected StringBuffer code;
    protected ConcurrentHashMap<String, VarItem> globalVars;
    protected ConcurrentHashMap<String, String> types;

    public MethodMaker(String name) {
        this(name, null, null);
    }

    public MethodMaker(String name, String option, String retType) {
        this.name = name;
        this.option = option;
        this.retType = retType;
        this.vars = new HashMap();
        this.code = new StringBuffer();
    }

    public void addVar(String name, DataType type, String initVal) {
        if (this.vars.containsKey(name)) {
            throw new RuntimeException();
        }
        VarItem var = new VarItem(name, type, initVal);
        this.vars.put(name, var);
    }

    public void addVar(VarItem var) {
        String name = var.getName();
        if (this.vars.containsKey(name)) {
            this.vars.remove(name);
            this.vars.put(name, var);
        } else {
            this.vars.put(name, var);
        }
        this.adjustVarTypeByTip(this.types);
    }

    public void setVar(String name, DataType type, String initVal) {
        if (this.vars.containsKey(name)) {
            VarItem var = this.vars.get(name);
            if (type != null) {
                var.setType(type);
            }
            if (initVal != null) {
                var.setInitValue(initVal);
            }
        } else {
            VarItem var = new VarItem(name, type, initVal);
            this.vars.put(name, var);
        }
    }

    public boolean hasVar(String var) {
        return this.vars.containsKey(var);
    }

    public void addLine(String line) {
        this.code.append(String.valueOf(line) + ";");
        this.code.append(System.lineSeparator());
    }

    public void addLine2(String line) {
        this.code.append(line);
        this.code.append(System.lineSeparator());
    }

    public void addLine3(String line) {
        this.code.append(line);
    }

    public static String col2varName(int col, int row) {
        char ch = (char)(64 + col);
        return "" + ch + row;
    }

    protected static DataType calcMaxType(DataType type1, DataType type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        String t1 = type1.getTypeName();
        String t2 = type2.getTypeName();
        if (t1.equals("double") || t2.equals("double")) {
            return new DataType("double");
        }
        if (t1.equals("long") || t2.equals("long")) {
            return new DataType("long");
        }
        if (t1.equals("int") && t2.equals("int")) {
            return new DataType("int");
        }
        return type1 != null ? type1 : type2;
    }

    public static String makeFieldCode(String type, String field) {
        String code = "private " + type + " " + field + ";" + System.lineSeparator();
        String field_ = String.valueOf(("" + field.charAt(0)).toUpperCase()) + field.substring(1);
        String setter = "public void set" + field_ + "(" + type + " value) { this." + field + "=value;}" + System.lineSeparator();
        String getter = "public " + type + " get" + field_ + "() {return " + field + ";}" + System.lineSeparator();
        return String.valueOf(code) + getter + setter;
    }

    protected static String makeCompareCode(String left, String right, String op, String type) {
        if ("double".equals(type)) {
            if ("==".equals(op)) {
                return "(Double.compare(" + left + ", " + right + ") == 0)";
            }
            if ("!=".equals(op)) {
                return "(Double.compare(" + left + ", " + right + ") != 0)";
            }
            if (">=".equals(op)) {
                return "(Double.compare(" + left + ", " + right + ") >= 0)";
            }
            if ("<=".equals(op)) {
                return "(Double.compare(" + left + ", " + right + ") <= 0)";
            }
            if (">".equals(op)) {
                return "(" + left + " > " + right + ")";
            }
            if ("<".equals(op)) {
                return "(" + left + " < " + right + ")";
            }
            throw new IllegalArgumentException("Unsupported operator for double: " + op);
        }
        if ("int".equals(type) || "long".equals(type)) {
            return "(" + left + " " + op + " " + right + ")";
        }
        if ("boolean".equals(type)) {
            if ("==".equals(op) || "!=".equals(op)) {
                return "(" + left + " " + op + " " + right + ")";
            }
            throw new IllegalArgumentException("Unsupported operator for boolean: " + op);
        }
        if ("Date".equals(type)) {
            return "(((Date)" + left + ").getTime() " + op + " ((Date)" + right + ").getTime())";
        }
        if ("Object".equals(type)) {
            if (">".equals(op)) {
                return "(Variant.compare(" + left + ", " + right + ") > 0)";
            }
            if ("<".equals(op)) {
                return "(Variant.compare(" + left + ", " + right + ") < 0)";
            }
            if (">=".equals(op)) {
                return "(Variant.compare(" + left + ", " + right + ") >= 0)";
            }
            if ("<=".equals(op)) {
                return "(Variant.compare(" + left + ", " + right + ") <= 0)";
            }
            if ("==".equals(op)) {
                return "(Variant.compare(" + left + ", " + right + ") == 0)";
            }
            if ("!=".equals(op)) {
                return "(Variant.compare(" + left + ", " + right + ") != 0)";
            }
            throw new IllegalArgumentException("Unsupported operator for Object: " + op);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static DataType getObjectType(Object obj) {
        if (obj instanceof Boolean) {
            return DataType.BooleanTypeNullable;
        }
        if (obj instanceof Integer) {
            return new DataType("int");
        }
        if (obj instanceof Long) {
            return new DataType("long");
        }
        if (obj instanceof Double) {
            return new DataType("double");
        }
        if (obj instanceof String) {
            return DataType.StringType;
        }
        if (obj instanceof Table) {
            return new DataType("table");
        }
        if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            IArray arr = seq.getMems();
            if (arr instanceof IntArray) {
                return DataType.newSequenceType("int");
            }
            if (arr instanceof LongArray) {
                return DataType.newSequenceType("long");
            }
            if (arr instanceof DoubleArray) {
                return DataType.newSequenceType("double");
            }
            DataType subType = MethodMaker.getObjectType(arr.ifn());
            return DataType.newSequenceType(subType);
        }
        return new DataType();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addExp(int col, int row, Expression exp, String expStr) throws ParseNodeException {
        if (exp == null) {
            return;
        }
        CodeItem item = this.parse(exp.getHome());
        this.addLine(item.toString());
    }

    protected DataType getVarType(String var) {
        if (this.vars.containsKey(var)) {
            VarItem v = this.vars.get(var);
            return v.getType();
        }
        return null;
    }

    protected VarItem getVar(String var) {
        if (this.vars.containsKey(var)) {
            VarItem v = this.vars.get(var);
            return v;
        }
        return null;
    }

    protected static String getVarName(UnknownSymbol us) {
        return us.getName();
    }

    protected static String getVarName(VarParam vp) {
        return vp.getParam().getName();
    }

    protected static String getVarName(CSVariable cs) {
        return MethodMaker.col2varName(cs.getSourceCell().getCol(), cs.getSourceCell().getRow());
    }

    protected static String getVarName(Node node) {
        if (node instanceof UnknownSymbol) {
            return MethodMaker.getVarName((UnknownSymbol)node);
        }
        if (node instanceof CSVariable) {
            return MethodMaker.getVarName((CSVariable)node);
        }
        if (node instanceof VarParam) {
            return MethodMaker.getVarName((VarParam)node);
        }
        return null;
    }

    public HashMap<String, VarItem> getVars() {
        return this.vars;
    }

    public void setVars(HashMap<String, VarItem> vars) {
        this.vars = vars;
    }

    protected CodeItem parse(Node node) throws ParseNodeException {
        Node left = node.getLeft();
        Node right = node.getRight();
        if (node instanceof DotOperator) {
            if (right instanceof PMin) {
                return this.parsePMin((PMin)right, this.parse(left));
            }
            if (right instanceof FieldRef) {
                String leftStr = MethodMaker.getVarName(node.getLeft());
                return this.parseFieldRef((FieldRef)right, leftStr);
            }
            throw new ParseNodeException(right.toString());
        }
        if (node instanceof Assign) {
            throw new ParseNodeException(node.toString());
        }
        if (node instanceof UnknownSymbol) {
            String var = MethodMaker.getVarName((UnknownSymbol)node);
            DataType type = this.getVarType(var);
            VarItem varItem = new VarItem(var, type, null);
            if (!this.hasVar(var)) {
                this.addVar(varItem);
            }
            return varItem;
        }
        if (node instanceof VarParam) {
            String var = MethodMaker.getVarName((VarParam)node);
            DataType type = this.getVarType(var);
            VarItem varItem = new VarItem(var, type, null);
            if (!this.hasVar(var)) {
                this.addVar(varItem);
            }
            return varItem;
        }
        if (node instanceof CSVariable) {
            String var = MethodMaker.getVarName((CSVariable)node);
            DataType type = this.getVarType(var);
            if (!this.hasVar(var)) {
                this.setVar(var, type, null);
            }
            VarItem item = new VarItem(var, type, null);
            item.setCell(true);
            item.setGlobal(true);
            this.addVar(item);
            return item;
        }
        if (node instanceof Greater) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            DataType ty = MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType());
            String line = MethodMaker.makeCompareCode(leftItem.toString(), rightItem.toString(), ">", ty.getTypeName());
            return new LineItem(line, ty);
        }
        if (node instanceof Smaller) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            DataType ty = MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType());
            String line = MethodMaker.makeCompareCode(leftItem.toString(), rightItem.toString(), "<", ty.getTypeName());
            return new LineItem(line, ty);
        }
        if (node instanceof Add) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem("(" + leftItem + ")+(" + rightItem + ")", MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof AddAssign) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "+=" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Subtract) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem("(" + leftItem + ")-(" + rightItem + ")", MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Multiply) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem("(" + leftItem + ")*(" + rightItem + ")", MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Divide) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem("(" + leftItem + ")/(" + rightItem + ")", MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Equals) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            DataType ty = MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType());
            String line = MethodMaker.makeCompareCode(leftItem.toString(), rightItem.toString(), "==", ty.getTypeName());
            return new LineItem(line, ty);
        }
        if (node instanceof Or) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem("(" + leftItem + ")||(" + rightItem + ")", MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof NotSmaller) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            DataType ty = MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType());
            String line = MethodMaker.makeCompareCode(leftItem.toString(), rightItem.toString(), ">=", ty.getTypeName());
            return new LineItem(line, ty);
        }
        if (node instanceof NotGreater) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            DataType ty = MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType());
            String line = MethodMaker.makeCompareCode(leftItem.toString(), rightItem.toString(), "<=", ty.getTypeName());
            return new LineItem(line, ty);
        }
        if (node instanceof CurrentElement) {
            throw new ParseNodeException(right.toString());
        }
        if (node instanceof CurrentSeq) {
            throw new ParseNodeException(right.toString());
        }
        if (node instanceof Constant) {
            Object obj = node.calculate(null);
            return new LineItem(obj.toString(), MethodMaker.getObjectType(obj));
        }
        if (node instanceof If) {
            throw new ParseNodeException(node.toString());
        }
        if (node instanceof Comma) {
            this.addLine(this.parse(node.getLeft()).toString());
            return this.parse(node.getRight());
        }
        if (node instanceof ValueList) {
            return this.parseValueList((ValueList)node);
        }
        if (node instanceof ElementRef) {
            return this.parseElementRef((ElementRef)node);
        }
        if (node instanceof Rand) {
            return this.parseRand((Rand)node);
        }
        if (node instanceof And) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + " && " + rightItem, new DataType("boolean"));
        }
        if (node instanceof Sqrt) {
            return this.parseSqrt((Sqrt)node);
        }
        if (node instanceof Pow) {
            return this.parsePow((Pow)node);
        }
        if (node instanceof Sin) {
            return this.parseSin((Sin)node);
        }
        if (node instanceof Cos) {
            return this.parseCos((Cos)node);
        }
        throw new ParseNodeException(node.toString());
    }

    private CodeItem parseFieldRef(FieldRef node, String left) throws ParseNodeException {
        String name = node.getName();
        VarItem item = new VarItem(String.valueOf(left) + "__" + name);
        item.setFieldRef(left);
        return item;
    }

    private CodeItem parseRand(Rand rand) throws ParseNodeException {
        if (rand.getParam() == null && rand.getOption() == null) {
            return new LineItem("random.nextDouble()", new DataType("double"));
        }
        throw new ParseNodeException(rand.toString());
    }

    private CodeItem parsePMin(PMin node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            String line = "pmin(" + left + ")";
            return new LineItem(line, new DataType("int"));
        }
        throw new ParseNodeException(node.toString());
    }

    private CodeItem parseElementRef(ElementRef node) throws ParseNodeException {
        LineItem ret;
        CodeItem idxNode;
        DataType type;
        CodeItem datas = this.parse(node.getLeft());
        datas.getType().setArray(true);
        String line = datas.toString();
        if (datas.getType() == null) {
            datas.setType(new DataType("UnknownType", true));
        }
        if ((type = (idxNode = this.parse(node.getExp().getHome())).getType()) != null && type.isArray()) {
            line = "getElments(" + line + "," + idxNode + ")";
            return new LineItem(line, datas.getType());
        }
        line = String.valueOf(line) + "[" + idxNode + "]";
        type = datas.getType();
        if (type != null) {
            type = new DataType(type.getTypeName(), false);
            ret = new LineItem(line, type);
        } else {
            ret = new LineItem(line, null);
        }
        ret.setRelatedVar(datas);
        return ret;
    }

    private CodeItem parseValueList(ValueList node) throws ParseNodeException {
        IParam param = node.getParam();
        char type = param.getType();
        if (type == '\u0000') {
            Expression exp = param.getLeafExpression();
            CodeItem item = this.parse(exp.getHome());
            DataType ty = item.getType();
            String line = "new " + ty + "[]{0," + item + "}";
            return new LineItem(line, ty);
        }
        if (type == ',') {
            int size = param.getSubSize();
            DataType ty = null;
            String line = "[]{0,";
            int i = 0;
            while (i < size) {
                IParam sub = param.getSub(i);
                if (sub == null) {
                    throw new ParseNodeException(node.toString());
                }
                if (!sub.isLeaf()) {
                    throw new ParseNodeException(node.toString());
                }
                Expression exp = sub.getLeafExpression();
                CodeItem item = this.parse(exp.getHome());
                ty = MethodMaker.calcMaxType(ty, item.getType());
                line = String.valueOf(line) + item.toString() + ",";
                ++i;
            }
            line = "new " + ty + line + "}";
            ty.setArray(true);
            return new LineItem(line, ty);
        }
        if (type == ':') {
            throw new ParseNodeException(node.toString());
        }
        throw new ParseNodeException(node.toString());
    }

    private CodeItem parseSqrt(Sqrt node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            throw new ParseNodeException(node.toString());
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            CodeItem item = this.parse(exp.getHome());
            return new LineItem("Math.sqrt(" + item + ")", item.getType());
        }
        throw new ParseNodeException(node.toString());
    }

    private CodeItem parsePow(Pow node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            throw new ParseNodeException(node.toString());
        }
        if (param.isLeaf()) {
            throw new ParseNodeException(node.toString());
        }
        if (param.getSubSize() != 2) {
            throw new ParseNodeException(node.toString());
        }
        IParam sub1 = param.getSub(0);
        IParam sub2 = param.getSub(1);
        if (sub1 == null || sub2 == null) {
            throw new ParseNodeException(node.toString());
        }
        CodeItem item1 = this.parse(sub1.getLeafExpression().getHome());
        CodeItem item2 = this.parse(sub2.getLeafExpression().getHome());
        String line = "Math.pow(" + item1 + ", " + item2 + ")";
        return new LineItem(line, item1.getType());
    }

    private CodeItem parseSin(Sin node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            throw new ParseNodeException(node.toString());
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            CodeItem item = this.parse(exp.getHome());
            return new LineItem("Math.sin(" + item + ")", item.getType());
        }
        throw new ParseNodeException(node.toString());
    }

    private CodeItem parseCos(Cos node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            throw new ParseNodeException(node.toString());
        }
        if (param.isLeaf()) {
            Expression exp = param.getLeafExpression();
            CodeItem item = this.parse(exp.getHome());
            return new LineItem("Math.cos(" + item + ")", item.getType());
        }
        throw new ParseNodeException(node.toString());
    }

    public String finish() {
        StringBuffer result = new StringBuffer();
        if (this.option == null) {
            this.option = "public static ";
        }
        if (this.retType == null) {
            this.retType = "void ";
        }
        result.append(this.option);
        result.append(this.retType);
        result.append(this.name);
        result.append("{");
        result.append(System.lineSeparator());
        for (Map.Entry<String, VarItem> entry : this.vars.entrySet()) {
            VarItem item = entry.getValue();
            result.append(item.getType());
            result.append(" ");
            result.append(item.getName());
            result.append(";");
            result.append(System.lineSeparator());
        }
        result.append(this.code);
        result.append("}");
        return result.toString();
    }

    public void adjustVarTypeByTip(ConcurrentHashMap<String, String> types) {
        for (Map.Entry<String, VarItem> entry : this.vars.entrySet()) {
            String ty;
            String name = entry.getKey();
            VarItem item = entry.getValue();
            DataType type = item.getType();
            if (type == null || !type.isType("UnknownType")) continue;
            if (types.containsKey(name)) {
                ty = types.get(name);
                type.setTypeName(ty);
                continue;
            }
            if (!types.containsKey("default")) continue;
            ty = types.get("default");
            type.setTypeName(ty);
        }
    }

    public void adjustVarType(ConcurrentHashMap<String, VarItem> global) {
        for (Map.Entry<String, VarItem> entry : this.vars.entrySet()) {
            String name = entry.getKey();
            VarItem item = entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("UnknownType") && global.containsKey(name)) {
                VarItem gvar = global.get(name);
                type.setTypeName(gvar.getType().getTypeName());
            }
            if (!global.containsKey(name)) continue;
            item.setGlobal(true);
            item.setCell(global.get(name).isCell());
            item.setC(global.get(name).getC());
            item.setR(global.get(name).getR());
        }
    }

    public void adjustVarType(PgmCellSet cellSet) {
        Context ctx = cellSet.getContext();
        for (Map.Entry<String, VarItem> entry : this.vars.entrySet()) {
            Object obj;
            String name = entry.getKey();
            VarItem item = entry.getValue();
            DataType type = item.getType();
            try {
                obj = item.isCell() ? cellSet.getCell(item.getName()).getValue() : ctx.getParam(name).getValue();
            }
            catch (Exception e) {
                continue;
            }
            DataType newType = MethodMaker.getObjectType(obj);
            if (newType == null || newType.isType("UnknownType")) continue;
            type.setTypeName(newType.getTypeName());
            type.setArray(newType.isArray());
        }
    }

    public static void appendLine(StringBuffer buf, String str) {
        buf.append(str);
        buf.append(System.lineSeparator());
    }

    public ConcurrentHashMap<String, VarItem> getGlobalVars() {
        return this.globalVars;
    }

    public void setGlobalVars(ConcurrentHashMap<String, VarItem> globalVars) {
        this.globalVars = globalVars;
    }

    public ConcurrentHashMap<String, String> getTypes() {
        return this.types;
    }

    public void setTypes(ConcurrentHashMap<String, String> types) {
        this.types = types;
    }

    protected static String getArrayType(String t) {
        if (t.equals("int")) {
            return "IntArray";
        }
        if (t.equals("long")) {
            return "LongArray";
        }
        if (t.equals("double")) {
            return "DoubleArray";
        }
        if (t.equals("String")) {
            return "StringArray";
        }
        if (t.equals("Date")) {
            return "DateArray";
        }
        if (t.equals("boolean")) {
            return "BoolArray";
        }
        return "ObjectArray";
    }

    protected static String getInitValue(String t) {
        if (t.equals("int")) {
            return "0";
        }
        if (t.equals("long")) {
            return "0";
        }
        if (t.equals("double")) {
            return "0.0";
        }
        if (t.equals("String")) {
            return "null";
        }
        if (t.equals("Date")) {
            return "null";
        }
        if (t.equals("boolean")) {
            return "false";
        }
        return "null";
    }
}

