/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.array.BoolArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.StringArray;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.compile.CodeItem;
import com.scudata.compile.CurrentSeqItem;
import com.scudata.compile.CurrentVarItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.MethodMaker;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.VarItem;
import com.scudata.dm.Context;
import com.scudata.expression.CSVariable;
import com.scudata.expression.Constant;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.CurrentSeq;
import com.scudata.expression.ElementRef;
import com.scudata.expression.Expression;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.ValueList;
import com.scudata.expression.VarParam;
import com.scudata.expression.fn.If;
import com.scudata.expression.fn.math.Rand;
import com.scudata.expression.mfn.sequence.Insert;
import com.scudata.expression.mfn.sequence.Len;
import com.scudata.expression.mfn.sequence.PMin;
import com.scudata.expression.mfn.sequence.Run;
import com.scudata.expression.operator.Add;
import com.scudata.expression.operator.AddAssign;
import com.scudata.expression.operator.Assign;
import com.scudata.expression.operator.Comma;
import com.scudata.expression.operator.Divide;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.Multiply;
import com.scudata.expression.operator.NotEquals;
import com.scudata.expression.operator.Smaller;
import com.scudata.expression.operator.Subtract;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RunMethodMaker
extends MethodMaker {
    protected String seqType;
    protected String currentVarName;
    protected String currentVar;
    protected String currentSeq;
    protected int stack = 0;
    protected int ifVarId = 0;
    private boolean isNumber;

    public RunMethodMaker(String name, String option, String retType) {
        super(name, option, retType);
    }

    public static String defaultRunMethod() {
        String s = "\tpublic Object calculate(Context ctx) {\r\n\t\tIArray arr = srcSequence.getMems();\r\n\t\tif (arr instanceof IntArray) {\r\n\t\t\treturn calculate_int(ctx);\r\n\t\t} else if (arr instanceof LongArray) {\r\n\t\t\treturn calculate_long(ctx);\r\n\t\t} else if (arr instanceof DoubleArray) {\r\n\t\t\treturn calculate_double(ctx);\r\n\t\t} else {\r\n\t\t\tsrcFun = new Run();\r\n\t\t\tsrcFun.setParam(getParam());\r\n\t\t\tsrcFun.setDotLeftObject(srcSequence);\r\n\t\t\treturn srcFun.calculate(ctx);\r\n\t\t}\r\n\t}";
        return s;
    }

    protected void startCycle(StringBuffer out) {
        String arrType;
        if (this.isNumber) {
            String i = "i" + this.stack;
            String len = "len" + this.stack;
            out.append("for (int " + i + " = 1, " + len + " = " + this.currentVarName + "; " + i + " <= " + len + "; " + i + "++) {");
            out.append(System.lineSeparator());
            return;
        }
        if (this.seqType.equals("int")) {
            arrType = "com.scudata.array.IntArray";
        } else if (this.seqType.equals("long")) {
            arrType = "com.scudata.array.LongArray";
        } else if (this.seqType.equals("double")) {
            arrType = "com.scudata.array.DoubleArray";
        } else if (this.seqType.equals("boolean")) {
            arrType = "com.scudata.array.BooleanArray";
        } else {
            throw new RuntimeException();
        }
        out.append(String.valueOf(arrType) + " arr = (" + arrType + ")srcSequence.getMems();");
        out.append(System.lineSeparator());
        out.append(String.valueOf(this.seqType) + "[] datas = arr.getDatas();");
        out.append(System.lineSeparator());
        out.append("int len = arr.size();");
        out.append(System.lineSeparator());
        out.append("for (int i = 1; i <= len; i++) {");
        out.append(System.lineSeparator());
    }

    protected void endCycle(StringBuffer out) {
        out.append("}");
        out.append(System.lineSeparator());
    }

    private CodeItem parseIf(If node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param.isLeaf()) {
            return this.parse(param.getLeafExpression().getHome());
        }
        IParam sub0 = param.getSub(0);
        IParam sub1 = param.getSub(1);
        IParam sub2 = param.getSubSize() == 3 ? param.getSub(2) : null;
        CodeItem item0 = this.parse(sub0.getLeafExpression().getHome());
        String tempVar = "ifVar" + this.ifVarId;
        String line = "if (" + item0.toString() + "){";
        this.addLine2(line);
        CodeItem item1 = this.parse(sub1.getLeafExpression().getHome());
        if (item1.type == DataType.VoidType) {
            line = item1 + "}";
            this.addLine2(line);
            return new LineItem("", DataType.VoidType);
        }
        line = String.valueOf(tempVar) + "=" + item1 + ";}";
        this.addLine2(line);
        if (sub2 != null) {
            CodeItem item2 = this.parse(sub2.getLeafExpression().getHome());
            line = "else{" + tempVar + "=" + item2 + ";}";
            this.addLine2(line);
        }
        this.addVar(tempVar, item1.getType(), null);
        ++this.ifVarId;
        return new LineItem(tempVar, item1.getType());
    }

    protected static void adjustType(CodeItem item1, CodeItem item2) {
        if (item1.getType().getTypeName() == "UnknownType") {
            item1.setType(item2.getType());
        } else if (item2.getType().getTypeName() == "UnknownType") {
            item2.setType(item1.getType());
        }
    }

    @Override
    protected CodeItem parse(Node node) throws ParseNodeException {
        Node left = node.getLeft();
        Node right = node.getRight();
        if (node instanceof DotOperator) {
            if (right instanceof PMin) {
                return this.parsePMin((PMin)right, this.parse(left));
            }
            if (right instanceof Run) {
                CodeItem leftItem = this.parse(left);
                RunMethodMaker maker = new RunMethodMaker("", "", "");
                if (leftItem.getType().isArray()) {
                    int stack = this.stack + 1;
                    maker.setCurrentVar("datas" + stack + "[i" + stack + "]");
                    maker.setSeqType("SeqDefaultType");
                } else {
                    maker.setCurrentVarName(leftItem.toString());
                    maker.setCurrentVar("i" + (this.stack + 1));
                    maker.setSeqType(leftItem.getType().getTypeName());
                    maker.isNumber = true;
                }
                maker.setCurrentSeq("i" + (this.stack + 1));
                maker.setStack(this.stack + 1);
                maker.setGlobalVars(this.globalVars);
                maker.setTypes(this.types);
                Run run = (Run)right;
                IParam param = run.getParam();
                ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
                Expression[] exps = pi.getExpressions1();
                Expression[] assignExps = pi.getExpressions2();
                int len = exps.length;
                int i = 0;
                while (i < len) {
                    if (assignExps[i] != null) {
                        Assign ass = new Assign();
                        ass.setLeft(assignExps[i].getHome());
                        ass.setRight(exps[i].getHome());
                        maker.addExp(-1, -1, new Expression((Node)ass), null);
                    } else {
                        maker.addExp(-1, -1, exps[i], null);
                    }
                    ++i;
                }
                if (maker.vars != null) {
                    for (Map.Entry entry : maker.vars.entrySet()) {
                        VarItem varItem = (VarItem)entry.getValue();
                        this.addVar(varItem);
                    }
                }
                return new LineItem(maker.toForCode(), DataType.VoidType);
            }
            if (right instanceof Insert) {
                CodeItem leftItem = this.parse(left);
                IParam param = ((Insert)right).getParam();
                ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"run", (boolean)true, (boolean)false);
                Expression[] exps = pi.getExpressions1();
                CodeItem num = this.parse(exps[0].getHome());
                CodeItem obj = this.parse(exps[1].getHome());
                if (num.toString().equals("0")) {
                    return new LineItem(leftItem + ".add(" + obj + ")", leftItem.getType());
                }
                return new LineItem(leftItem + ".insert(" + num + "," + obj + ")", leftItem.getType());
            }
            throw new ParseNodeException(right.toString());
        }
        if (node instanceof Assign) {
            String leftName;
            if (left instanceof UnknownSymbol) {
                leftName = RunMethodMaker.getVarName((UnknownSymbol)left);
            } else if (left instanceof CSVariable) {
                leftName = RunMethodMaker.getVarName((CSVariable)left);
            } else {
                if (left instanceof CurrentElement) {
                    CodeItem rightItem = this.parse(right);
                    String line = String.valueOf(this.currentVar) + "=" + rightItem;
                    this.setSeqType(rightItem.getType().getTypeName());
                    return new LineItem(line, rightItem.getType());
                }
                if (left instanceof ElementRef) {
                    CodeItem rightItem = this.parse(right);
                    CodeItem leftItem = this.parseElementRef((ElementRef)left);
                    if (rightItem.getType() != null) {
                        this.adjustType(leftItem, rightItem.getType());
                    }
                    String leftName2 = leftItem.toString();
                    String line = String.valueOf(leftName2) + "=" + rightItem;
                    return new LineItem(line, rightItem.getType());
                }
                throw new ParseNodeException(node.toString());
            }
            CodeItem rightItem = this.parse(right);
            this.setVar(leftName, rightItem.getType(), null);
            String line = String.valueOf(leftName) + "=" + rightItem;
            return new LineItem(line, rightItem.getType());
        }
        if (node instanceof UnknownSymbol) {
            String var = RunMethodMaker.getVarName((UnknownSymbol)node);
            DataType type = this.getVarType(var);
            VarItem varItem = new VarItem(var, type, null);
            if (!this.hasVar(var)) {
                this.addVar(varItem);
            }
            return varItem;
        }
        if (node instanceof VarParam) {
            String var = RunMethodMaker.getVarName((VarParam)node);
            DataType type = this.getVarType(var);
            VarItem varItem = new VarItem(var, type, null);
            if (!this.hasVar(var)) {
                this.addVar(varItem);
            }
            return varItem;
        }
        if (node instanceof CSVariable) {
            String var = RunMethodMaker.getVarName((CSVariable)node);
            DataType type = this.getVarType(var);
            if (!this.hasVar(var)) {
                this.setVar(var, type, null);
            }
            VarItem item = new VarItem(var, type, null);
            item.setCell(true);
            item.setGlobal(true);
            this.addVar(item);
            return item;
        }
        if (node instanceof Greater) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            RunMethodMaker.adjustType(leftItem, rightItem);
            return new LineItem(leftItem + ">" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Smaller) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            RunMethodMaker.adjustType(leftItem, rightItem);
            return new LineItem(leftItem + "<" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Add) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            RunMethodMaker.adjustType(leftItem, rightItem);
            return new LineItem(leftItem + "+" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof AddAssign) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "+=" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Subtract) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "-" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Multiply) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "*" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Divide) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            return new LineItem(leftItem + "/" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof Equals) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            RunMethodMaker.adjustType(leftItem, rightItem);
            return new LineItem(leftItem + "==" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof NotEquals) {
            CodeItem leftItem = this.parse(left);
            CodeItem rightItem = this.parse(right);
            RunMethodMaker.adjustType(leftItem, rightItem);
            return new LineItem(leftItem + "!=" + rightItem, MethodMaker.calcMaxType(leftItem.getType(), rightItem.getType()));
        }
        if (node instanceof CurrentElement) {
            return new CurrentVarItem(this.getCurrentVarItemType(), this);
        }
        if (node instanceof CurrentSeq) {
            return new CurrentSeqItem(this);
        }
        if (node instanceof Constant) {
            Object obj = node.calculate(null);
            return new LineItem(obj.toString(), MethodMaker.getObjectType(obj));
        }
        if (node instanceof If) {
            return this.parseIf((If)node);
        }
        if (node instanceof Comma) {
            this.addLine(this.parse(node.getLeft()).toString());
            return this.parse(node.getRight());
        }
        if (node instanceof ValueList) {
            return this.parseValueList((ValueList)node);
        }
        if (node instanceof ElementRef) {
            return this.parseElementRef((ElementRef)node);
        }
        if (node instanceof Rand) {
            return this.parseRand((Rand)node);
        }
        throw new ParseNodeException(node.toString());
    }

    private CodeItem parseRand(Rand rand) throws ParseNodeException {
        if (rand.getParam() == null && rand.getOption() == null) {
            return new LineItem("random.nextDouble()", new DataType("double"));
        }
        throw new ParseNodeException(rand.toString());
    }

    private CodeItem parsePMin(PMin node, CodeItem left) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            String line = "pmin(" + left + ")";
            return new LineItem(line, new DataType("int"));
        }
        throw new ParseNodeException(node.toString());
    }

    private CodeItem parseElementRef(ElementRef node) throws ParseNodeException {
        LineItem ret;
        CodeItem datas = this.parse(node.getLeft());
        datas.getType().setArray(true);
        String line = datas.toString();
        if (datas.getType() == null) {
            datas.setType(new DataType("UnknownType", true));
        }
        CodeItem idxNode = this.parse(node.getExp().getHome());
        line = String.valueOf(line) + "[" + idxNode + "]";
        DataType type = datas.getType();
        if (type != null) {
            type = new DataType(type.getTypeName(), false);
            ret = new LineItem(line, type);
        } else {
            ret = new LineItem(line, null);
        }
        ret.setRelatedVar(datas);
        return ret;
    }

    private CodeItem parseValueList(ValueList node) throws ParseNodeException {
        IParam param = node.getParam();
        char type = param.getType();
        if (type == '\u0000') {
            Expression exp = param.getLeafExpression();
            CodeItem item = this.parse(exp.getHome());
            DataType ty = item.getType();
            String line = "new " + ty + "[]{0," + item + "}";
            return new LineItem(line, ty);
        }
        if (type == ',') {
            int size = param.getSubSize();
            DataType ty = null;
            String line = "[]{0,";
            int i = 0;
            while (i < size) {
                IParam sub = param.getSub(i);
                if (sub == null) {
                    throw new ParseNodeException(node.toString());
                }
                if (!sub.isLeaf()) {
                    throw new ParseNodeException(node.toString());
                }
                Expression exp = sub.getLeafExpression();
                CodeItem item = this.parse(exp.getHome());
                ty = MethodMaker.calcMaxType(ty, item.getType());
                line = String.valueOf(line) + item.toString() + ",";
                ++i;
            }
            line = "new " + ty + line + "}";
            ty.setArray(true);
            return new LineItem(line, ty);
        }
        if (type == ':') {
            throw new ParseNodeException(node.toString());
        }
        throw new ParseNodeException(node.toString());
    }

    @Override
    public void addExp(int col, int row, Expression exp, String expStr) throws ParseNodeException {
        if (exp == null) {
            return;
        }
        CodeItem item = this.parse(exp.getHome());
        this.addLine(item.toString());
    }

    @Override
    public String finish() {
        VarItem item;
        StringBuffer result = new StringBuffer();
        if (this.option == null) {
            this.option = "public ";
        }
        if (this.retType == null) {
            this.retType = "void ";
        }
        result.append(this.option);
        result.append(this.retType);
        result.append(this.name);
        result.append("{");
        result.append(System.lineSeparator());
        for (Map.Entry entry : this.vars.entrySet()) {
            item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("SeqDefaultType")) {
                type = new DataType(type);
                type.setTypeName(this.seqType);
            }
            if (type != null && type.isType("UnknownType")) {
                type = new DataType(type);
                type.setTypeName(this.seqType);
            }
            result.append(type);
            result.append(" ");
            result.append(item.getName());
            if (item.isGlobal()) {
                if (item.isCell()) {
                    if (!item.getType().isArray()) {
                        result.append(" = (" + type + ")getObject(\"" + item.getName() + "\")");
                    } else {
                        String str = "getObject(\"" + item.getName() + "\")";
                        result.append(" = (" + type + ")getDatas(" + str + ")");
                    }
                } else if (!item.getType().isArray()) {
                    result.append(" = (" + type + ")ctx.getParam(\"" + item.getName() + "\").getValue()");
                } else {
                    result.append(" = (" + type + ")getDatas(\"" + item.getName() + "\", ctx)");
                }
            }
            result.append(";");
            result.append(System.lineSeparator());
        }
        this.startCycle(result);
        result.append(this.code);
        this.endCycle(result);
        for (Map.Entry entry : this.vars.entrySet()) {
            item = (VarItem)entry.getValue();
            if (!item.isGlobal()) continue;
            if (item.isCell()) {
                if (item.getType().isArray()) continue;
                result.append("setObject(" + item.getR() + "," + item.getC() + "," + item.getName() + ")");
                result.append(";");
                result.append(System.lineSeparator());
                continue;
            }
            if (item.getType().isArray()) continue;
            result.append("ctx.getParam(\"" + item.getName() + "\").setValue(" + item.getName() + ")");
            result.append(";");
            result.append(System.lineSeparator());
        }
        result.append("return srcSequence;");
        result.append(System.lineSeparator());
        result.append("}");
        return result.toString();
    }

    public String toForCode() {
        StringBuffer result = new StringBuffer();
        this.startCycle(result);
        result.append(this.code);
        this.endCycle(result);
        return result.toString();
    }

    public String getCurrentVar() {
        return this.currentVar;
    }

    public void setCurrentVar(String currentVar) {
        this.currentVar = currentVar;
    }

    public String getSeqType() {
        return this.seqType;
    }

    public void setSeqType(String seqType) {
        this.seqType = seqType;
    }

    private static void parseAssinNode(Node node, DataType type, ConcurrentHashMap<String, VarItem> vars) {
        VarItem var;
        String name;
        Node left = node.getLeft();
        Node right = node.getRight();
        if (node instanceof Assign) {
            RunMethodMaker.parseAssinNode(left, type, vars);
            RunMethodMaker.parseAssinNode(right, type, vars);
            return;
        }
        if (node instanceof UnknownSymbol) {
            name = RunMethodMaker.getVarName((UnknownSymbol)node);
        } else if (node instanceof CSVariable) {
            name = RunMethodMaker.getVarName((CSVariable)node);
        } else {
            return;
        }
        if (vars.containsKey(name)) {
            var = vars.get(name);
            var.setType(type);
        } else {
            var = new VarItem(name, type, null);
        }
        vars.put(name, var);
    }

    public static void searchVar(Node node, ConcurrentHashMap<String, VarItem> vars) {
        if (node == null) {
            return;
        }
        if (node instanceof Assign) {
            Node left = node.getLeft();
            Node right = node.getRight();
            DataType rightType = null;
            if (right instanceof DotOperator) {
                if ((right = right.getRight()) instanceof Len) {
                    rightType = new DataType("int");
                }
            } else if (right instanceof Constant) {
                Object obj = right.calculate(null);
                rightType = MethodMaker.getObjectType(obj);
            }
            RunMethodMaker.parseAssinNode(left, rightType, vars);
        } else if (node instanceof Comma) {
            RunMethodMaker.searchVar(node.getLeft(), vars);
            RunMethodMaker.searchVar(node.getRight(), vars);
        }
    }

    private void adjustType(CodeItem item, DataType newType) {
        if (item == null) {
            return;
        }
        item.adjustType(newType);
        if (item instanceof VarItem && !item.getType().getTypeName().equals("UnknownType")) {
            VarItem var = (VarItem)item;
            this.addVar(var);
        }
        if (item.getRelatedVar() != null) {
            this.adjustType(item.getRelatedVar(), newType);
        }
    }

    @Override
    public void adjustVarType(ConcurrentHashMap<String, VarItem> global) {
        for (Map.Entry entry : this.vars.entrySet()) {
            String name = (String)entry.getKey();
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("UnknownType")) {
                if (global.containsKey(name)) {
                    VarItem gvar = global.get(name);
                    type.setTypeName(gvar.getType().getTypeName());
                } else {
                    type.setTypeName(this.seqType);
                }
            }
            if (!global.containsKey(name)) continue;
            item.setGlobal(true);
            item.setCell(global.get(name).isCell());
            item.setC(global.get(name).getC());
            item.setR(global.get(name).getR());
        }
    }

    @Override
    public void adjustVarType(PgmCellSet cellSet) {
        Context ctx = cellSet.getContext();
        for (Map.Entry entry : this.vars.entrySet()) {
            Object obj;
            String name = (String)entry.getKey();
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            try {
                obj = item.isCell() ? cellSet.getCell(item.getName()).getValue() : ctx.getParam(name).getValue();
            }
            catch (Exception e) {
                continue;
            }
            DataType newType = RunMethodMaker.getObjectType(obj);
            if (newType == null || newType.isType("UnknownType")) continue;
            type.setTypeName(newType.getTypeName());
            type.setArray(newType.isArray());
        }
        Object obj = cellSet.getCell(this.currentVarName).getValue();
        DataType newType = RunMethodMaker.getObjectType(obj);
        if (newType != null && !newType.isType("UnknownType")) {
            this.seqType = newType.getTypeName();
        }
    }

    public String getCurrentSeq() {
        return this.currentSeq;
    }

    public void setCurrentSeq(String currentSeq) {
        this.currentSeq = currentSeq;
    }

    @Override
    protected DataType getVarType(String var) {
        if (this.currentVarName != null && this.currentVarName.equals(var)) {
            if (this.seqType != null) {
                return new DataType(this.seqType, true);
            }
            return new DataType("SeqDefaultType", true);
        }
        if (this.vars.containsKey(var)) {
            VarItem v = (VarItem)this.vars.get(var);
            return v.getType();
        }
        return new DataType("UnknownType");
    }

    public String getCurrentVarName() {
        return this.currentVarName;
    }

    public void setCurrentVarName(String currentVarName) {
        this.currentVarName = currentVarName;
    }

    public int getStack() {
        return this.stack;
    }

    public void setStack(int stack) {
        this.stack = stack;
    }

    protected static String getType(Object o) {
        if (o instanceof IntArray) {
            return "int";
        }
        if (o instanceof LongArray) {
            return "long";
        }
        if (o instanceof DoubleArray) {
            return "double";
        }
        if (o instanceof StringArray) {
            return "String";
        }
        if (o instanceof DateArray) {
            return "Date";
        }
        if (o instanceof BoolArray) {
            return "boolean";
        }
        if (o instanceof Integer) {
            return "int";
        }
        if (o instanceof Long) {
            return "long";
        }
        if (o instanceof Double) {
            return "double";
        }
        if (o instanceof String) {
            return "String";
        }
        if (o instanceof Date) {
            return "Date";
        }
        if (o instanceof Boolean) {
            return "boolean";
        }
        return "Object";
    }

    public DataType getCurrentVarItemType() {
        if (this.isNumber) {
            return new DataType(this.seqType);
        }
        return new DataType("SeqDefaultType");
    }
}

