/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.array.BoolArray;
import com.scudata.array.DateArray;
import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.array.LongArray;
import com.scudata.array.StringArray;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.compile.CompilerUtil;
import com.scudata.compile.DataType;
import com.scudata.compile.MethodMaker;
import com.scudata.compile.VarItem;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Table;
import com.scudata.pdm.PureTable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SelectMethodMaker
extends MethodMaker {
    protected Table table;
    protected DataStruct ds;
    protected boolean hasUnknownExp;
    private String initCode;

    public SelectMethodMaker(String name) {
        super(name);
    }

    public SelectMethodMaker(Table table, String name, String option, String retType) {
        super(name, option, retType);
        this.table = table;
        if (table != null) {
            this.ds = table.dataStruct();
        }
    }

    protected void startCycle(StringBuffer out) {
        out.append("int len = seq.length();");
        out.append(System.lineSeparator());
        out.append("for (int i = 1; i <= len; i++) {");
        out.append(System.lineSeparator());
    }

    protected void endCycle(StringBuffer out) {
        out.append("}");
        out.append(System.lineSeparator());
    }

    @Override
    public String finish() {
        if (this.table == null) {
            return null;
        }
        if (this.table instanceof PureTable) {
            throw new RuntimeException();
        }
        return this.finishTable();
    }

    private int getFieldIndex(String name) {
        return this.ds.getFieldIndex(name);
    }

    private static String getType(Object o) {
        if (o instanceof IntArray) {
            return "int";
        }
        if (o instanceof LongArray) {
            return "long";
        }
        if (o instanceof DoubleArray) {
            return "double";
        }
        if (o instanceof StringArray) {
            return "String";
        }
        if (o instanceof DateArray) {
            return "Date";
        }
        if (o instanceof BoolArray) {
            return "boolean";
        }
        if (o instanceof Integer) {
            return "int";
        }
        if (o instanceof Long) {
            return "long";
        }
        if (o instanceof Double) {
            return "double";
        }
        if (o instanceof String) {
            return "String";
        }
        if (o instanceof Date) {
            return "Date";
        }
        if (o instanceof Boolean) {
            return "boolean";
        }
        return "Object";
    }

    private String[] getFieldType(String name) {
        String[] types;
        String type;
        Class<?> cls;
        if (this.types != null && this.types.containsKey(name) && (cls = CompilerUtil.toJavaType(type = ((String)this.types.get(name)).toLowerCase())) != null) {
            types = new String[2];
            types[0] = cls.getName();
            try {
                types[1] = SelectMethodMaker.getType(cls.newInstance());
            }
            catch (Exception e) {
                types = null;
            }
            if (types != null) {
                return types;
            }
        }
        if (this.table instanceof PureTable) {
            int idx = this.ds.getFieldIndex(name);
            if (idx < 0) {
                return null;
            }
            IArray arr = ((PureTable)this.table).getFieldValueArray(idx);
            String[] types2 = new String[]{arr.getClass().getName(), SelectMethodMaker.getType(arr)};
            return types2;
        }
        BaseRecord rec = this.table.getRecord(1);
        Object obj = rec.getFieldValue(name);
        types = new String[]{obj.getClass().getName(), SelectMethodMaker.getType(obj)};
        return types;
    }

    private String finishTable() {
        List<String> strs;
        String name;
        StringBuffer result = new StringBuffer();
        if (this.option == null) {
            this.option = "public ";
        }
        if (this.retType == null) {
            this.retType = "void ";
        }
        result.append(this.option);
        result.append(this.retType);
        result.append(this.name);
        result.append(System.lineSeparator());
        result.append("Sequence seq = srcSequence;");
        result.append(System.lineSeparator());
        result.append("if (seq == null) return seq;");
        result.append(System.lineSeparator());
        result.append("IArray mems = seq.getMems();");
        result.append(System.lineSeparator());
        result.append("int len = mems.size();");
        result.append(System.lineSeparator());
        if (this.initCode != null) {
            result.append(this.initCode);
            result.append(System.lineSeparator());
        }
        for (Map.Entry entry : this.vars.entrySet()) {
            int idx;
            String t;
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("SeqDefaultType")) {
                t = CompilerUtil.getType(item.getName(), null, this.types);
                type.setTypeName(t);
            }
            if (type != null && type.isType("UnknownType")) {
                t = CompilerUtil.getType(item.getName(), null, this.types);
                type.setTypeName(t);
            }
            if ((idx = this.getFieldIndex(name = item.getName())) >= 0) {
                String[] types = this.getFieldType(name);
                String define = String.valueOf(types[1]) + " " + name;
                result.append(define);
            } else if (item.isGlobal()) {
                result.append(type);
                result.append(" ");
                result.append(item.getName());
                if (item.isCell()) {
                    result.append(" = (" + type + ")getObject(\"" + item.getName() + "\")");
                } else {
                    result.append(" = (" + type + ")ctx.getParam(\"" + item.getName() + "\").getValue()");
                }
            }
            result.append(";");
            result.append(System.lineSeparator());
        }
        result.append("IArray resultArray = mems.newInstance(15);");
        result.append(System.lineSeparator());
        if (this.hasUnknownExp) {
            SelectMethodMaker.appendLine(result, "ComputeStack stack = ctx.getComputeStack();");
            SelectMethodMaker.appendLine(result, "Current current = new Current(seq);");
            SelectMethodMaker.appendLine(result, "stack.push(current);");
        }
        result.append("for (int i = 1; i <= len; ++i) {");
        result.append(System.lineSeparator());
        result.append("BaseRecord r = (BaseRecord)seq.get(i);");
        result.append(System.lineSeparator());
        if (this.hasUnknownExp) {
            result.append("current.setCurrent(i);");
            result.append(System.lineSeparator());
        }
        if ((strs = CompilerUtil.splitByAnd(this.code.toString())).size() > 1) {
            result.append("boolean flag;");
            result.append(System.lineSeparator());
            ArrayList<String> outs = new ArrayList<String>();
            int i = 0;
            int len = strs.size();
            while (i < len) {
                String str = strs.get(i);
                Set<String> strSets = CompilerUtil.extractVariables(str);
                for (Map.Entry entry : this.vars.entrySet()) {
                    VarItem item = (VarItem)entry.getValue();
                    String name2 = item.getName();
                    String key = (String)entry.getKey();
                    DataType type = item.getType();
                    if (!strSets.contains(key) || outs.contains(key)) continue;
                    outs.add(key);
                    int idx = this.getFieldIndex(name2);
                    if (idx < 0) continue;
                    result.append(String.valueOf(name2) + " = (" + type + ")r.getNormalFieldValue(" + idx + ");");
                    result.append(System.lineSeparator());
                }
                result.append("flag = " + str + ";");
                result.append(System.lineSeparator());
                if (i != len - 1) {
                    result.append("if (!flag) {\r\n\t\t\tcontinue; \r\n\t\t}");
                    result.append(System.lineSeparator());
                }
                ++i;
            }
            SelectMethodMaker.appendLine(result, "if (flag) {");
            SelectMethodMaker.appendLine(result, "resultArray.add(mems, i);");
            SelectMethodMaker.appendLine(result, "}");
        } else {
            for (Map.Entry entry : this.vars.entrySet()) {
                VarItem item = (VarItem)entry.getValue();
                name = item.getName();
                DataType type = item.getType();
                int idx = this.getFieldIndex(name);
                if (idx < 0) continue;
                result.append(String.valueOf(name) + " = (" + type + ")r.getNormalFieldValue(" + idx + ");");
                result.append(System.lineSeparator());
            }
            SelectMethodMaker.appendLine(result, "boolean flag = " + this.code.toString());
            SelectMethodMaker.appendLine(result, "if (flag) {");
            SelectMethodMaker.appendLine(result, "resultArray.add(mems, i);");
            SelectMethodMaker.appendLine(result, "}");
        }
        this.endCycle(result);
        SelectMethodMaker.appendLine(result, "return new Sequence(resultArray);");
        result.append("}");
        return result.toString();
    }

    @Override
    public ConcurrentHashMap<String, String> getTypes() {
        return this.types;
    }

    @Override
    public void setTypes(ConcurrentHashMap<String, String> types) {
        this.types = types;
    }

    @Override
    public void adjustVarTypeByTip(ConcurrentHashMap<String, String> types) {
        for (Map.Entry entry : this.vars.entrySet()) {
            String name = (String)entry.getKey();
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type == null || !type.isType("UnknownType") || !types.containsKey(name)) continue;
            String ty = types.get(name);
            type.setTypeName(ty);
        }
    }

    @Override
    public void adjustVarType(ConcurrentHashMap<String, VarItem> global) {
        for (Map.Entry entry : this.vars.entrySet()) {
            String name = (String)entry.getKey();
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("UnknownType") && global.containsKey(name)) {
                VarItem gvar = global.get(name);
                type.setTypeName(gvar.getType().getTypeName());
            }
            if (!global.containsKey(name)) continue;
            item.setGlobal(true);
            item.setCell(global.get(name).isCell());
            item.setC(global.get(name).getC());
            item.setR(global.get(name).getR());
        }
    }

    @Override
    public void adjustVarType(PgmCellSet cellSet) {
        Context ctx = cellSet.getContext();
        for (Map.Entry entry : this.vars.entrySet()) {
            Object obj;
            String name = (String)entry.getKey();
            VarItem item = (VarItem)entry.getValue();
            DataType type = item.getType();
            try {
                obj = item.isCell() ? cellSet.getCell(item.getName()).getValue() : ctx.getParam(name).getValue();
            }
            catch (Exception e) {
                continue;
            }
            DataType newType = SelectMethodMaker.getObjectType(obj);
            if (newType == null || newType.isType("UnknownType")) continue;
            type.setTypeName(newType.getTypeName());
            type.setArray(newType.isArray());
        }
    }
}

