/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.compile.CellSetUtil2;
import com.scudata.compile.MethodMaker;
import com.scudata.compile.PgmCellSet2;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.expression.Node;
import com.scudata.expression.fn.Func;
import com.scudata.expression.fn.Output;
import com.scudata.expression.mfn.sequence.Insert;
import com.scudata.expression.mfn.sequence.Run;
import com.scudata.expression.operator.AddAssign;
import com.scudata.expression.operator.Assign;
import com.scudata.expression.operator.DivideAssign;
import com.scudata.expression.operator.DotOperator;
import com.scudata.expression.operator.ISectAssign;
import com.scudata.expression.operator.IntDivideAssign;
import com.scudata.expression.operator.ModAssign;
import com.scudata.expression.operator.MultiplyAssign;
import com.scudata.expression.operator.SubtractAssign;
import com.scudata.expression.operator.UnionAssign;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class SplxChecker {
    private static boolean filterNode(Node node) {
        if (node instanceof Assign) {
            return true;
        }
        if (node instanceof AddAssign) {
            return true;
        }
        if (node instanceof SubtractAssign) {
            return true;
        }
        if (node instanceof DivideAssign) {
            return true;
        }
        if (node instanceof IntDivideAssign) {
            return true;
        }
        if (node instanceof MultiplyAssign) {
            return true;
        }
        if (node instanceof ModAssign) {
            return true;
        }
        if (node instanceof ISectAssign) {
            return true;
        }
        if (node instanceof UnionAssign) {
            return true;
        }
        if (node instanceof Func) {
            return true;
        }
        if (node instanceof Output) {
            return true;
        }
        if (node instanceof DotOperator) {
            Node right = node.getRight();
            if (right == null) {
                return false;
            }
            if (right instanceof Run) {
                return true;
            }
            if (right instanceof Insert) {
                return true;
            }
        }
        return false;
    }

    private static void searchVar(PgmCellSet2 cellSet, List<String> vars) {
        if (cellSet == null || vars == null) {
            return;
        }
        int col = cellSet.getColCount();
        int row = cellSet.getRowCount();
        int r = 1;
        while (r <= row) {
            int c = 1;
            while (c <= col) {
                String name = MethodMaker.col2varName(c, r);
                PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                if ((cell.getType() & 4) == 0 && (cell.getType() & 8) == 0) {
                    Node node;
                    Expression exp = cell.getExpression();
                    String expStr = cell.getExpString();
                    if (exp != null && expStr != null && !SplxChecker.filterNode(node = exp.getHome()) && !vars.contains(name)) {
                        vars.add(name);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    private static String cell2Name(INormalCell cel) {
        int c = cel.getCol();
        int r = cel.getRow();
        return MethodMaker.col2varName(c, r);
    }

    private static void searchVar2_(PgmCellSet2 cellSet, List<String> vars, String s) {
        Expression sexp = new Expression(s);
        ArrayList vlist = new ArrayList();
        sexp.getUsedFields(new Context(), vlist);
        for (String str : vlist) {
            String v;
            INormalCell cel = cellSet.getCell(str);
            if (cel == null || vars.contains(v = SplxChecker.cell2Name(cel))) continue;
            vars.add(v);
        }
    }

    private static void searchVar2(PgmCellSet2 cellSet, List<String> vars) {
        if (cellSet == null || vars == null) {
            return;
        }
        int col = cellSet.getColCount();
        int row = cellSet.getRowCount();
        int r = 1;
        while (r <= row) {
            int c = 1;
            while (c <= col) {
                String s;
                PgmNormalCell cell = cellSet.getPgmNormalCell(r, c);
                Expression exp = cell.getExpression();
                String expStr = cell.getExpString();
                if (exp == null && expStr != null && expStr.startsWith("return ")) {
                    s = expStr.substring(7);
                    SplxChecker.searchVar2_(cellSet, vars, s);
                } else if (exp == null && expStr != null && expStr.startsWith("if ")) {
                    s = expStr.substring(3);
                    SplxChecker.searchVar2_(cellSet, vars, s);
                } else if (exp != null && expStr != null) {
                    ArrayList list = new ArrayList();
                    exp.getUsedCells(list);
                    for (INormalCell cel : list) {
                        String var = SplxChecker.cell2Name(cel);
                        if (vars.contains(var)) continue;
                        vars.add(var);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    private static void checkUnused(PgmCellSet2 cellSet) {
        ArrayList<String> vars = new ArrayList<String>();
        ArrayList<String> vars2 = new ArrayList<String>();
        SplxChecker.searchVar(cellSet, vars);
        SplxChecker.searchVar2(cellSet, vars2);
        for (String var : vars) {
            if (vars2.contains(var)) continue;
            System.out.println("Warning: The cell [" + var + "] maybe never used.");
        }
    }

    private static String getPercentFormat(double d, int IntegerDigits, int FractionDigits) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMaximumIntegerDigits(IntegerDigits);
        nf.setMinimumFractionDigits(FractionDigits);
        String str = nf.format(d);
        return str;
    }

    private static void statistic(PgmCellSet2 cellSet) {
        long value;
        int row;
        cellSet.initTimes();
        cellSet.execute();
        long[][] times = cellSet.getTimes();
        int colSize = cellSet.getColCount();
        int rowSize = cellSet.getRowCount();
        long total = 0L;
        String[] fields = new String[]{"name", "value", "ratio"};
        DataStruct ds = new DataStruct(fields);
        Table table = new Table(ds);
        int col = 1;
        while (col <= colSize) {
            row = 1;
            while (row <= rowSize) {
                value = times[row][col];
                total += value;
                ++row;
            }
            ++col;
        }
        col = 1;
        while (col <= colSize) {
            row = 1;
            while (row <= rowSize) {
                value = times[row][col];
                BaseRecord rec = table.newLast();
                rec.setNormalFieldValue(0, (Object)MethodMaker.col2varName(col, row));
                rec.setNormalFieldValue(1, (Object)value);
                rec.setNormalFieldValue(2, (Object)((double)value / (double)total));
                ++row;
            }
            ++col;
        }
        Expression exp = new Expression("value");
        table.sort(exp, null, "zo", new Context());
        int len = table.length() > 8 ? 8 : table.length();
        int i = 1;
        while (i <= len) {
            BaseRecord rec = table.getRecord(i);
            double r = (Double)rec.getNormalFieldValue(2);
            if (r > 0.1) {
                String name = (String)rec.getNormalFieldValue(0);
                long t = (Long)rec.getNormalFieldValue(1);
                System.out.println("[" + name + "] " + t + " ms " + SplxChecker.getPercentFormat(r, 2, 2));
            }
            ++i;
        }
        System.out.println("Total time is " + total + " ms");
    }

    public static void check(String file) {
        try {
            PgmCellSet2 cellSet = CellSetUtil2.readCellSet(file);
            SplxChecker.checkUnused(cellSet);
            SplxChecker.statistic(cellSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

