/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.RQException;
import com.scudata.compile.CellSetUtil2;
import com.scudata.compile.ClassInfo;
import com.scudata.compile.ClassMaker;
import com.scudata.compile.CompilerUtil;
import com.scudata.compile.DynamicClassLoader;
import com.scudata.compile.SplxChecker;
import com.scudata.compile.function.FakeFetch;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.FunctionLib;
import com.scudata.util.CellSetUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;

public class SplxCompiler {
    static boolean fast = false;
    static boolean debug = false;
    static boolean encrypt = false;
    static boolean check = false;
    private static boolean loaded = false;

    public static void loadFunctions() {
        if (loaded) {
            return;
        }
        try {
            FunctionLib.loadCustomFunctions((String)"splfunctions.properties");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        loaded = true;
        FunctionLib.addMemberFunction((String)FakeFetch.class.getSimpleName(), FakeFetch.class);
    }

    public static boolean compile(String file, String[] args) {
        fast = false;
        debug = false;
        encrypt = false;
        check = false;
        SplxCompiler.loadFunctions();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg != null) {
                    if (arg.toLowerCase().startsWith("-fast")) {
                        fast = true;
                    } else if (arg.toLowerCase().startsWith("-debug")) {
                        debug = true;
                    } else if (arg.toLowerCase().startsWith("-encrypt")) {
                        encrypt = true;
                    } else if (arg.toLowerCase().startsWith("-check")) {
                        check = true;
                    }
                }
                ++i;
            }
        }
        if (check) {
            SplxChecker.check(file);
        }
        try {
            FileObject fo = new FileObject(file);
            String fname = fo.getFileName();
            PgmCellSet cellSet = AppUtil.readCellSet((String)file);
            cellSet.getFunctionMap();
            ClassMaker maker = new ClassMaker(fname, cellSet);
            maker.setFast(fast);
            maker.setDebug(debug);
            maker.setEncrypt(encrypt);
            List<Object> files = maker.compileFunctions(fname, cellSet);
            if (files.size() > 0 && debug) {
                FileObject out = new FileObject(String.valueOf(fname) + "_debug.splx");
                OutputStream os = out.getOutputStream(false);
                ObjectWriter writer = new ObjectWriter(os);
                writer.write((byte[])files.get(0));
                writer.close();
            }
            if (files.size() > 1) {
                int idx = fname.lastIndexOf(".splx");
                String newFn = String.valueOf(fname.substring(0, idx)) + ".splb";
                FileObject out = new FileObject(newFn);
                out.delete();
                OutputStream os = out.getOutputStream(false);
                ObjectWriter writer = new ObjectWriter(os);
                int size = files.size();
                writer.writeInt32(size);
                byte[] bytes = (byte[])files.get(0);
                writer.writeInt32(bytes.length);
                writer.write(bytes);
                int i = 1;
                while (i < size) {
                    String name = (String)files.get(i);
                    bytes = (byte[])files.get(i + 1);
                    writer.writeObject((Object)name);
                    writer.writeInt32(bytes.length);
                    writer.write(bytes);
                    i += 2;
                }
                writer.close();
            }
            return files.size() > 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static PgmCellSet open(String file) {
        try {
            FileObject fo = new FileObject(file);
            ObjectReader reader = new ObjectReader(fo.getInputStream());
            int cnt = reader.readInt32();
            int size = reader.readInt32();
            byte[] buf = new byte[size];
            reader.read(buf);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            PgmCellSet cellSet = CellSetUtil.readPgmCellSet((InputStream)bis);
            cellSet.setName(file);
            DynamicClassLoader loader = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
            int i = 1;
            while (i < cnt) {
                String fullName = (String)reader.readObject();
                size = reader.readInt32();
                if (size == 0) {
                    Class<?> cls = Class.forName(fullName);
                    if (!FunctionLib.isFnName((String)cls.getSimpleName())) {
                        FunctionLib.addFunction((String)cls.getSimpleName(), cls);
                    }
                } else {
                    Class<?> cls;
                    boolean isMemberFunction;
                    buf = new byte[size];
                    reader.read(buf);
                    boolean bl = isMemberFunction = !fullName.endsWith("_F");
                    if (isMemberFunction) {
                        cls = loader.loadClass(fullName, buf);
                        FunctionLib.addMemberFunction((String)cls.getSimpleName(), cls);
                    } else {
                        cls = loader.loadClass(fullName, buf);
                        FunctionLib.addFunction((String)cls.getSimpleName(), cls);
                    }
                }
                i += 2;
            }
            reader.close();
            return cellSet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object runFile(String file) {
        PgmCellSet cellSet = SplxCompiler.open(file);
        return CellSetUtil2.execute(cellSet);
    }

    public static Object compileSplxFile(String file, String args) {
        fast = false;
        debug = false;
        encrypt = false;
        check = false;
        boolean run = false;
        if (args != null) {
            debug = args.indexOf("d") != -1;
            boolean bl = run = args.indexOf("r") != -1;
        }
        if (check) {
            SplxChecker.check(file);
        }
        try {
            PgmCellSet cellSet = AppUtil.readCellSet((String)file);
            cellSet.getFunctionMap();
            ClassInfo info = CompilerUtil.compileSplx(cellSet);
            if (info != null && run) {
                return SplxCompiler.run(info);
            }
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object run(ClassInfo info) {
        DynamicClassLoader loader = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
        Class<?> cls = loader.loadClass(info.getFullClassName(), info.getBytecode());
        try {
            Method method = cls.getMethod("run", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RQException((Throwable)e);
        }
    }

    private static void printDs(BaseRecord rec) {
        DataStruct ds = rec.dataStruct();
        Object[] objs = rec.getFieldValues();
        System.out.print("{");
        int i = 0;
        int len = objs.length;
        while (i < len) {
            if (i != 0) {
                System.out.print(",");
            }
            System.out.print(ds.getFieldName(i));
            System.out.print(":");
            SplxCompiler.printType(objs[i]);
            ++i;
        }
        System.out.print("}");
    }

    private static void printType(Object obj) {
        if (obj == null) {
            System.out.print("Object");
        } else if (obj instanceof Integer) {
            System.out.print("Integer");
        } else if (obj instanceof Long) {
            System.out.print("Long");
        } else if (obj instanceof Double) {
            System.out.print("Double");
        } else if (obj instanceof String) {
            System.out.print("String");
        } else if (obj instanceof Date) {
            System.out.print("Date");
        } else if (obj instanceof Table) {
            Table table = (Table)obj;
            System.out.print("Table");
            SplxCompiler.printDs(table.getRecord(1));
        } else if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            obj = seq.ifn();
            System.out.print("Sequence");
            if (obj instanceof BaseRecord) {
                SplxCompiler.printDs((BaseRecord)obj);
            }
        } else if (obj instanceof BaseRecord) {
            System.out.print("BaseRecord");
            SplxCompiler.printDs((BaseRecord)obj);
        } else {
            System.out.print(obj.getClass().getName());
        }
    }

    public static void printDataType(Object obj) {
        SplxCompiler.printType(obj);
        System.out.println();
    }
}

