/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.compile.DataType;
import com.scudata.compile.VarItem;
import com.scudata.compile.parser.NodeParser;
import com.scudata.dm.DataStruct;

public class StructType {
    private String[] fieldNames;
    private String[] fieldIndexStr;
    private DataType[] fieldTypes;
    private DataStruct ds;
    private VarItem[] fieldVars;

    public StructType(String[] fieldNames, DataType[] fieldTypes, NodeParser parser) {
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes;
        this.ds = new DataStruct(fieldNames);
        this.init(parser);
    }

    public int getFieldCount() {
        return this.fieldNames.length;
    }

    public String getFieldName(int index) {
        return this.ds.getFieldName(index);
    }

    public DataType getFieldType(int index) {
        if (index < 0 || index >= this.fieldTypes.length) {
            throw new IndexOutOfBoundsException("\u5b57\u6bb5\u7d22\u5f15\u8d85\u51fa\u8303\u56f4");
        }
        return this.fieldTypes[index];
    }

    public DataType getFieldType(String fieldName) {
        int index = this.ds.getFieldIndex(fieldName);
        return this.fieldTypes[index];
    }

    public void setFieldType(int index, DataType type) {
        if (index < 0 || index >= this.fieldTypes.length) {
            throw new IndexOutOfBoundsException("\u5b57\u6bb5\u7d22\u5f15\u8d85\u51fa\u8303\u56f4");
        }
        if (type.isType("UnknownType")) {
            return;
        }
        if (this.fieldTypes[index] == DataType.ObjectTypeFixed) {
            return;
        }
        this.fieldTypes[index] = type = DataType.toNullable(type);
        this.fieldVars[index].setType(type);
    }

    public void setFieldType(String fieldName, DataType type) {
        int index = this.ds.getFieldIndex(fieldName);
        this.setFieldType(index, type);
    }

    public boolean hasField(String fieldName) {
        return this.ds.getFieldIndex(fieldName) != -1;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public DataType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public DataStruct dataStruct() {
        return this.ds;
    }

    private void init(NodeParser parser) {
        int len = this.fieldTypes.length;
        VarItem[] vars = new VarItem[len];
        int i = 0;
        while (i < len) {
            vars[i] = new VarItem(this.fieldNames[i], this.fieldTypes[i]);
            vars[i].setField(true);
            ++i;
        }
        this.fieldVars = vars;
        this.fieldIndexStr = new String[len];
        if (parser == null) {
            return;
        }
        i = 0;
        while (i < len) {
            String idxStr;
            String fieldName = this.fieldNames[i];
            int idx = this.ds.getFieldIndex(fieldName);
            this.fieldIndexStr[i] = idxStr = parser.generateConstVar("int", String.valueOf(fieldName) + "_index", "" + idx);
            ++i;
        }
    }

    public VarItem[] getFieldVars() {
        return this.fieldVars;
    }

    public VarItem getFieldVar(String fieldName) {
        int idx = this.ds.getFieldIndex(fieldName);
        if (idx == -1) {
            return null;
        }
        ++this.fieldVars[idx].refCount;
        return this.fieldVars[idx];
    }

    public String getFieldIndexStr(String fieldName) {
        int idx = this.ds.getFieldIndex(fieldName);
        if (idx == -1) {
            return null;
        }
        return this.fieldIndexStr[idx];
    }
}

