/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeCaster {
    private static final Set<String> PRIMITIVE_NUMERIC_TYPES = new HashSet<String>(Arrays.asList("int", "long", "double", "byte", "short", "float", "char"));
    private static final Set<String> WRAPPER_NUMERIC_TYPES = new HashSet<String>(Arrays.asList("Integer", "Long", "Double", "Byte", "Short", "Float", "Character"));
    private static final Set<String> BOOLEAN_TYPES = new HashSet<String>(Arrays.asList("boolean", "Boolean"));
    private static final Set<String> OTHER_TYPES = new HashSet<String>(Arrays.asList("String", "Date", "Number", "Object", "byte[]", "Sequence", "Table", "ICursor"));
    private static final Set<String> ALL_SUPPORTED_TYPES = new HashSet<String>();
    private static final Map<String, String> PRIMITIVE_TO_WRAPPER;
    private static final Map<String, String> WRAPPER_TO_PRIMITIVE;
    private static final Map<String, String> WRAPPER_UNBOX_METHODS;

    static {
        ALL_SUPPORTED_TYPES.addAll(PRIMITIVE_NUMERIC_TYPES);
        ALL_SUPPORTED_TYPES.addAll(WRAPPER_NUMERIC_TYPES);
        ALL_SUPPORTED_TYPES.addAll(BOOLEAN_TYPES);
        ALL_SUPPORTED_TYPES.addAll(OTHER_TYPES);
        PRIMITIVE_TO_WRAPPER = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("int", "Integer");
                this.put("long", "Long");
                this.put("double", "Double");
                this.put("byte", "Byte");
                this.put("short", "Short");
                this.put("float", "Float");
                this.put("char", "Character");
                this.put("boolean", "Boolean");
            }
        };
        WRAPPER_TO_PRIMITIVE = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("Integer", "int");
                this.put("Long", "long");
                this.put("Double", "double");
                this.put("Byte", "byte");
                this.put("Short", "short");
                this.put("Float", "float");
                this.put("Character", "char");
                this.put("Boolean", "boolean");
            }
        };
        WRAPPER_UNBOX_METHODS = new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("Integer", "intValue");
                this.put("Long", "longValue");
                this.put("Double", "doubleValue");
                this.put("Byte", "byteValue");
                this.put("Short", "shortValue");
                this.put("Float", "floatValue");
                this.put("Character", "charValue");
                this.put("Boolean", "booleanValue");
            }
        };
    }

    public static String cast(String line, String type, String newType) {
        if (newType.equals(type) || newType.equals("Object")) {
            return line;
        }
        TypeCaster.validateType(type);
        if ("Object".equals(type)) {
            return TypeCaster.handleObjectToTarget(line, newType);
        }
        TypeCaster.validateType(newType);
        if (TypeCaster.isBoxingOrUnboxing(type, newType)) {
            return line;
        }
        if (TypeCaster.isNumericType(type) && TypeCaster.isNumericType(newType)) {
            return TypeCaster.handleNumericConversion(line, type, newType);
        }
        if (newType.equals("String")) {
            return TypeCaster.handleToStringConversion(line, type);
        }
        if (type.equals("String")) {
            return TypeCaster.handleFromStringConversion(line, newType);
        }
        if (type.equals("Date") && newType.equals("String")) {
            return "new SimpleDateFormat().format(" + line + ")";
        }
        if (newType.equals("Date") && type.equals("String")) {
            return "new SimpleDateFormat().parse(" + line + ")";
        }
        if (type.equals("byte[]") && newType.equals("String")) {
            return "new String(" + line + ")";
        }
        if (newType.equals("byte[]") && type.equals("String")) {
            return String.valueOf(line) + ".getBytes()";
        }
        if (newType.equals("Table") && type.equals("Sequence")) {
            return String.format("(%s)%s", newType, line);
        }
        if (newType.equals("Sequence") && type.equals("Table")) {
            return line;
        }
        throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362: %s -> %s", type, newType));
    }

    private static String handleObjectToTarget(String line, String newType) {
        if (PRIMITIVE_NUMERIC_TYPES.contains(newType)) {
            String wrapperType = PRIMITIVE_TO_WRAPPER.get(newType);
            String unboxMethod = WRAPPER_UNBOX_METHODS.get(wrapperType);
            return String.format("((Number)%s).%s()", line, unboxMethod);
        }
        if (WRAPPER_NUMERIC_TYPES.contains(newType) || BOOLEAN_TYPES.contains(newType)) {
            if (newType.equals("Integer")) {
                return String.format("MathLib.toInteger((Number)%s)", line);
            }
            if (newType.equals("Long")) {
                return String.format("MathLib.toLong((Number)%s)", line);
            }
            return String.format("(%s)%s", newType, line);
        }
        if ("String".equals(newType)) {
            return String.valueOf(line) + ".toString()";
        }
        if ("Date".equals(newType)) {
            return String.format("(Date)%s", line);
        }
        if ("byte[]".equals(newType)) {
            return String.format("(byte[])%s", line);
        }
        return String.format("(%s)%s", newType, line);
    }

    private static String handleNumericConversion(String line, String type, String newType) {
        if (PRIMITIVE_NUMERIC_TYPES.contains(type) && PRIMITIVE_NUMERIC_TYPES.contains(newType)) {
            return String.format("(%s)%s", newType, line);
        }
        if (PRIMITIVE_NUMERIC_TYPES.contains(type) && WRAPPER_NUMERIC_TYPES.contains(newType)) {
            return String.format("(%s)%s", TypeCaster.getPrimitiveType(newType), line);
        }
        if (WRAPPER_NUMERIC_TYPES.contains(type) && PRIMITIVE_NUMERIC_TYPES.contains(newType)) {
            return String.format("(%s)((%s)%s).%s()", newType, type, line, WRAPPER_UNBOX_METHODS.get(type));
        }
        if (WRAPPER_NUMERIC_TYPES.contains(type) && WRAPPER_NUMERIC_TYPES.contains(newType)) {
            String targetPrimitive = TypeCaster.getPrimitiveType(newType);
            String unboxMethod = WRAPPER_UNBOX_METHODS.get(type);
            return String.format("(%s)((%s)%s).%s()", targetPrimitive, type, line, unboxMethod);
        }
        if (type.equals("Number")) {
            if (PRIMITIVE_NUMERIC_TYPES.contains(newType)) {
                return String.format("(%s)((Number)%s).doubleValue()", newType, line);
            }
            if (WRAPPER_NUMERIC_TYPES.contains(newType)) {
                String primitiveType = TypeCaster.getPrimitiveType(newType);
                return String.format("%s.valueOf((%s)((Number)%s).doubleValue())", newType, primitiveType, line);
            }
        }
        throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7684\u6570\u503c\u7c7b\u578b\u8f6c\u6362: %s -> %s", type, newType));
    }

    private static boolean isBoxingOrUnboxing(String type, String newType) {
        if (WRAPPER_NUMERIC_TYPES.contains(type) && WRAPPER_TO_PRIMITIVE.get(type).equals(newType)) {
            return true;
        }
        if (PRIMITIVE_NUMERIC_TYPES.contains(type) && PRIMITIVE_TO_WRAPPER.get(type).equals(newType)) {
            return true;
        }
        return BOOLEAN_TYPES.contains(type) && BOOLEAN_TYPES.contains(newType) && !type.equals(newType);
    }

    private static String handleToStringConversion(String line, String type) {
        if (PRIMITIVE_NUMERIC_TYPES.contains(type) || WRAPPER_NUMERIC_TYPES.contains(type)) {
            return "String.valueOf(" + line + ")";
        }
        if (BOOLEAN_TYPES.contains(type)) {
            return "String.valueOf(" + line + ")";
        }
        if (type.equals("Date")) {
            return String.valueOf(line) + ".toString()";
        }
        if (type.equals("byte[]")) {
            return "new String(" + line + ")";
        }
        return String.valueOf(line) + ".toString()";
    }

    private static String handleFromStringConversion(String line, String newType) {
        switch (newType) {
            case "int": {
                return "Integer.parseInt(" + line + ")";
            }
            case "Integer": {
                return "Integer.valueOf(" + line + ")";
            }
            case "long": {
                return "Long.parseLong(" + line + ")";
            }
            case "Long": {
                return "Long.valueOf(" + line + ")";
            }
            case "double": {
                return "Double.parseDouble(" + line + ")";
            }
            case "Double": {
                return "Double.valueOf(" + line + ")";
            }
            case "boolean": {
                return "Boolean.parseBoolean(" + line + ")";
            }
            case "Boolean": {
                return "Boolean.valueOf(" + line + ")";
            }
            case "byte": {
                return "Byte.parseByte(" + line + ")";
            }
            case "Byte": {
                return "Byte.valueOf(" + line + ")";
            }
            case "short": {
                return "Short.parseShort(" + line + ")";
            }
            case "Short": {
                return "Short.valueOf(" + line + ")";
            }
            case "float": {
                return "Float.parseFloat(" + line + ")";
            }
            case "Float": {
                return "Float.valueOf(" + line + ")";
            }
            case "char": {
                return "(" + line + ").charAt(0)";
            }
            case "Character": {
                return "Character.valueOf((" + line + ").charAt(0))";
            }
        }
        throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u4eceString\u8f6c\u6362\u4e3a: %s", newType));
    }

    private static void validateType(String type) {
        if (!ALL_SUPPORTED_TYPES.contains(type)) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b: " + type);
        }
    }

    private static boolean isNumericType(String type) {
        return PRIMITIVE_NUMERIC_TYPES.contains(type) || WRAPPER_NUMERIC_TYPES.contains(type) || "Number".equals(type);
    }

    private static String getPrimitiveType(String wrapperType) {
        return WRAPPER_TO_PRIMITIVE.get(wrapperType);
    }
}

