/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile;

import com.scudata.compile.AssignItem;
import com.scudata.compile.CodeItem;
import com.scudata.compile.CurContext;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;

public class VarItem
extends CodeItem {
    private String name;
    private String initValue;
    private boolean isStatic;
    private boolean isCell;
    private int r;
    private int c;
    private boolean isField;
    private String fieldRef;
    private CurContext curContext;
    private boolean isCompilerVar;
    private boolean isParamVar;
    private boolean isAssigned;
    public int refCount = 0;

    public VarItem(String name) {
        this(name, null, null);
    }

    public VarItem(String name, DataType type) {
        super(type);
        this.name = name;
    }

    public VarItem(String name, DataType type, String initValue) {
        super(type);
        this.name = name;
        this.initValue = initValue;
    }

    public VarItem(String name, DataType type, String initValue, boolean isCell) {
        super(type);
        this.name = name;
        this.initValue = initValue;
        this.isCell = isCell;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInitValue() {
        return this.initValue;
    }

    public void setInitValue(String initValue) {
        this.initValue = initValue;
    }

    public String toString() {
        if (this.isField && this.curContext != null) {
            String line = this.curContext.formatFieldRef(this.name);
            return line;
        }
        return this.name;
    }

    @Override
    public DataType getType() {
        if (this.type == null && this.relatedVar != null) {
            return this.relatedVar.getType();
        }
        return this.type;
    }

    @Override
    public void setType(DataType type) {
        super.setType(type);
        if (this.initValue != null) {
            this.setInitValue(type.getInitStr());
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        DataType type = new DataType(this.type.getTypeName(), this.type.isArray());
        return new VarItem(this.name, type, this.initValue);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isCell() {
        return this.isCell;
    }

    public void setCell(boolean isCell) {
        this.isCell = isCell;
    }

    public int getR() {
        return this.r;
    }

    public void setR(int r) {
        this.r = r;
    }

    public int getC() {
        return this.c;
    }

    public void setC(int c) {
        this.c = c;
    }

    public boolean isField() {
        return this.isField;
    }

    public void setField(boolean isField) {
        this.isField = isField;
    }

    public boolean isCompilerVar() {
        return this.isCompilerVar;
    }

    public void setCompilerVar(boolean isCompilerVar) {
        this.isCompilerVar = isCompilerVar;
    }

    public boolean isParamVar() {
        return this.isParamVar;
    }

    public void setParamVar(boolean isParamVar) {
        this.isParamVar = isParamVar;
    }

    @Override
    public boolean isAssigned() {
        return this.isAssigned;
    }

    public void setAssigned(boolean isAssigned) {
        this.isAssigned = isAssigned;
    }

    public void refCountIncrease() {
        ++this.refCount;
    }

    @Override
    public CodeItem makeAssign(CodeItem value) throws ParseNodeException {
        this.isAssigned = true;
        if (this.isField) {
            return new LineItem(this.curContext.formatCurAssign(value));
        }
        return new AssignItem(this, value);
    }

    @Override
    public String makeAssignString(String value) {
        if (this.isField) {
            return this.curContext.formatCurAssignString(value);
        }
        return String.valueOf(this.name) + " = " + value;
    }

    public void setCurContext(CurContext curContext) {
        this.curContext = curContext;
    }

    @Override
    public CodeItem cast() {
        return this;
    }

    @Override
    public CodeItem cast(String type) {
        if (!this.type.isType(type)) {
            return new LineItem("(" + type + ")" + this.name, new DataType(type));
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarItem varItem = (VarItem)o;
        return varItem.getName().equals(this.name);
    }

    public boolean isGlobal() {
        return false;
    }

    public void setGlobal(boolean isGlobal) {
    }

    public String getFieldRef() {
        return this.fieldRef;
    }

    public void setFieldRef(String fieldRef) {
        this.fieldRef = fieldRef;
    }
}

