/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.function;

import com.scudata.array.DoubleArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.resources.EngineMessage;

public class SequenceDistance
extends Function {
    /*
     * Enabled aggressive block sorting
     */
    public Object calculate(Context ctx) {
        Sequence s1 = null;
        Sequence s2 = null;
        if (this.param.isLeaf()) {
            Object o = this.param.getLeafExpression().calculate(ctx);
            if (!(o instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("dis" + mm.getMessage("function.paramTypeError"));
            }
            s1 = (Sequence)o;
        } else {
            if (this.param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("dis" + mm.getMessage("function.invalidParam"));
            }
            IParam sub1 = this.param.getSub(0);
            IParam sub2 = this.param.getSub(1);
            if (sub1 == null || sub2 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("dis" + mm.getMessage("function.invalidParam"));
            }
            Object o1 = sub1.getLeafExpression().calculate(ctx);
            Object o2 = sub2.getLeafExpression().calculate(ctx);
            if (o1 instanceof Sequence && o2 instanceof Sequence) {
                s1 = (Sequence)o1;
                s2 = (Sequence)o2;
            }
        }
        if (s1.isPurePmt() && s2.isPurePmt()) {
            IArray a1 = s1.getMems();
            IArray a2 = s2.getMems();
            if (a1 instanceof DoubleArray && a2 instanceof DoubleArray && !((DoubleArray)a1).hasSigns() && !((DoubleArray)a2).hasSigns()) {
                return this.dis(((DoubleArray)a1).getDatas(), ((DoubleArray)a2).getDatas(), s1.length());
            }
        }
        int len = s1.length();
        double d = 0.0;
        int i = 1;
        while (i <= len) {
            Object obj1 = s1.get(i);
            Object obj2 = s2.get(i);
            double d1 = ((Number)obj1).doubleValue();
            double d2 = ((Number)obj2).doubleValue();
            d += (d1 -= d2) * d1;
            ++i;
        }
        return Math.sqrt(d);
    }

    private double dis(double[] arr1, double[] arr2, int len) {
        double d = 0.0;
        int i = 1;
        while (i <= len) {
            double d1 = arr1[i];
            double d2 = arr2[i];
            d += (d1 -= d2) * d1;
            ++i;
        }
        return Math.sqrt(d);
    }
}

