/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.compile.VarItem;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;

public class CompilationContextStack {
    private Deque<MethodCompilationInfo> stack = new ArrayDeque<MethodCompilationInfo>();

    public void push(HashMap<String, VarItem> vars, HashMap<String, VarItem> parentVars, List<VarItem> assignVars, boolean isDFX) {
        MethodCompilationInfo info = new MethodCompilationInfo(vars, parentVars, assignVars, isDFX);
        info.setParentInfo(this.peek());
        this.push(info);
    }

    private void push(MethodCompilationInfo info) {
        this.stack.push(info);
    }

    public MethodCompilationInfo pop() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("\u6808\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f39\u51fa\u65b9\u6cd5\u4e0a\u4e0b\u6587");
        }
        return this.stack.pop();
    }

    public MethodCompilationInfo peekFirst() {
        return this.stack.peekFirst();
    }

    public MethodCompilationInfo peek() {
        return this.stack.peek();
    }

    public int size() {
        return this.stack.size();
    }

    public VarItem searchVar(String varName) {
        for (MethodCompilationInfo info : this.stack) {
            if (!info.getVars().containsKey(varName)) continue;
            return info.getVars().get(varName);
        }
        return null;
    }

    public static class MethodCompilationInfo {
        private MethodCompilationInfo parentInfo;
        private HashMap<String, VarItem> vars;
        private HashMap<String, VarItem> parentVars;
        private List<VarItem> assignVars;
        private boolean isDFX;

        public MethodCompilationInfo(HashMap<String, VarItem> vars, HashMap<String, VarItem> parentVars, List<VarItem> assignVars, boolean isDFX) {
            this.vars = vars;
            this.parentVars = parentVars;
            this.assignVars = assignVars;
            this.isDFX = isDFX;
        }

        public HashMap<String, VarItem> getVars() {
            return this.vars;
        }

        public void setVars(HashMap<String, VarItem> vars) {
            this.vars = vars;
        }

        public boolean hasVar(String varName) {
            return this.vars.containsKey(varName);
        }

        public HashMap<String, VarItem> getParentVars() {
            return this.parentVars;
        }

        public void setParentVars(HashMap<String, VarItem> parentVars) {
            this.parentVars = parentVars;
        }

        public MethodCompilationInfo getParentInfo() {
            return this.parentInfo;
        }

        public void setParentInfo(MethodCompilationInfo parentInfo) {
            this.parentInfo = parentInfo;
        }

        public List<VarItem> getAssignVars() {
            return this.assignVars;
        }

        public boolean isDFX() {
            return this.isDFX;
        }

        public void setDFX(boolean isDFX) {
            this.isDFX = isDFX;
        }
    }
}

