/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.compile.CodeItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.StructType;
import com.scudata.compile.parser.FunctionNodeParser;
import com.scudata.compile.parser.NodeParser;
import com.scudata.expression.FileFunction;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.mfn.file.ISelect;
import com.scudata.expression.mfn.file.Import;
import com.scudata.expression.mfn.file.Open;
import com.scudata.expression.mfn.file.Read;

public class FileFunctionParser {
    private static CodeItem parseCommon(NodeParser parser, FileFunction node, CodeItem left) throws ParseNodeException {
        DataType returnType;
        String option = node.getOption();
        if (node instanceof Read) {
            returnType = option != null && option.indexOf("n") != -1 ? DataType.newSequenceType(DataType.StringType) : (option != null && option.indexOf("n") != -1 ? DataType.newSequenceType(DataType.ObjectType) : (option != null && option.indexOf("b") != -1 ? DataType.ByteArray : DataType.StringType));
        } else if (node instanceof Import) {
            if (option != null && option.indexOf("i") != -1) {
                returnType = DataType.newSequenceType();
            } else {
                IParam param = node.getParam();
                int fcount = param.isLeaf() ? 1 : param.getSubSize();
                String[] fieldNames = new String[fcount];
                DataType[] fieldTypes = new DataType[fcount];
                int i = 0;
                while (i < fcount) {
                    fieldNames[i] = param.getSub(i).getLeafExpression().getFieldName();
                    fieldTypes[i] = DataType.ObjectType;
                    ++i;
                }
                StructType structType = new StructType(fieldNames, fieldTypes, parser);
                returnType = DataType.newTableType(structType);
            }
        } else if (node instanceof Open) {
            returnType = new DataType("PhyTable");
        } else {
            throw new ParseNodeException(node.toString());
        }
        return parser.parseFunctionToGeneric((Function)node, left, node.getFunctionName(), returnType, parser);
    }

    private static CodeItem parseISelect(NodeParser parser, ISelect node, CodeItem left) throws ParseNodeException {
        String funName = "iselect_";
        return FunctionNodeParser.parseCommonMFN(parser, (Function)node, left, funName, DataType.ICURSOR);
    }

    public static CodeItem parseNode(NodeParser parser, FileFunction node, CodeItem left) throws ParseNodeException {
        String leftStr = left.toString();
        if (leftStr.startsWith("(")) {
            left = new LineItem("(" + leftStr + ")", left.getType());
        }
        if (node instanceof ISelect) {
            return FileFunctionParser.parseISelect(parser, (ISelect)node, left);
        }
        if (node instanceof FileFunction) {
            return FileFunctionParser.parseCommon(parser, node, left);
        }
        throw new ParseNodeException(node.toString());
    }
}

