/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.cellset.INormalCell;
import com.scudata.cellset.datamodel.NormalCell;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.compile.AssignItem;
import com.scudata.compile.CodeItem;
import com.scudata.compile.CompilerUtil;
import com.scudata.compile.ConstItem;
import com.scudata.compile.CurContext;
import com.scudata.compile.DataType;
import com.scudata.compile.FunCodeItem;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.StructType;
import com.scudata.compile.VarItem;
import com.scudata.compile.parser.MathNodeParser;
import com.scudata.compile.parser.NodeParser;
import com.scudata.dm.Context;
import com.scudata.dm.DfxManager;
import com.scudata.dm.FileObject;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.expression.CSVariable;
import com.scudata.expression.Constant;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.Expression;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Move;
import com.scudata.expression.Node;
import com.scudata.expression.ParamInfo2;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.fn.Call;
import com.scudata.expression.fn.Create;
import com.scudata.expression.fn.CreateFile;
import com.scudata.expression.fn.EnvSet;
import com.scudata.expression.fn.Eval;
import com.scudata.expression.fn.Func;
import com.scudata.expression.fn.If;
import com.scudata.expression.fn.New;
import com.scudata.expression.fn.Output;
import com.scudata.expression.fn.Register;
import com.scudata.expression.fn.To;
import com.scudata.expression.fn.algebra.Var;
import com.scudata.expression.fn.convert.IfSequence;
import com.scudata.expression.fn.convert.IfVariable;
import com.scudata.expression.fn.convert.IsAlpha;
import com.scudata.expression.fn.convert.ToAsc;
import com.scudata.expression.fn.convert.ToChar;
import com.scudata.expression.fn.convert.ToString;
import com.scudata.expression.fn.convert.Typeof;
import com.scudata.expression.fn.datetime.Day;
import com.scudata.expression.fn.datetime.Days;
import com.scudata.expression.fn.datetime.Interval;
import com.scudata.expression.fn.datetime.Month;
import com.scudata.expression.fn.datetime.Now;
import com.scudata.expression.fn.datetime.ToDate;
import com.scudata.expression.fn.datetime.WorkDay;
import com.scudata.expression.fn.datetime.Year;
import com.scudata.expression.fn.gather.Average;
import com.scudata.expression.fn.gather.Max;
import com.scudata.expression.fn.gather.Min;
import com.scudata.expression.fn.math.Rand;
import com.scudata.expression.fn.string.Fill;
import com.scudata.expression.fn.string.Left;
import com.scudata.expression.fn.string.Len;
import com.scudata.expression.fn.string.Lower;
import com.scudata.expression.fn.string.Mid;
import com.scudata.expression.fn.string.Pos;
import com.scudata.expression.fn.string.Right;
import com.scudata.expression.fn.string.Upper;
import com.scudata.resources.EngineMessage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FunctionNodeParser {
    private static CodeItem toBoolItem(CodeItem item) {
        if (item.getType().isType("boolean")) {
            return item;
        }
        return new LineItem("Variant.isTrue(" + item + ")", DataType.BooleanType);
    }

    private static String handleParentheses(CodeItem item) {
        if (item instanceof AssignItem) {
            return "(" + item + ")";
        }
        return item.toString();
    }

    private static DataType getLineType(CodeItem item) {
        if (item instanceof LineItem) {
            return ((LineItem)item).getLineType();
        }
        return null;
    }

    private static CodeItem parseAverage(NodeParser parser, Average node) throws ParseNodeException {
        String line;
        DataType ty;
        IParam param = node.getParam();
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("avg" + mm.getMessage("function.missingParam"));
        }
        if (param.isLeaf()) {
            CodeItem item = parser.parse(param.getLeafExpression().getHome());
            ty = item.getType().getMemberType() != null ? item.getType().getMemberType() : item.getType();
            line = String.format("FunLib.avg(%s)", item);
        } else {
            int size = param.getSubSize();
            String paramStr = "";
            int i = 0;
            while (i < size) {
                CodeItem item = parser.parse(param.getSub(i).getLeafExpression().getHome());
                if (i != 0) {
                    paramStr = String.valueOf(paramStr) + ",";
                }
                paramStr = String.valueOf(paramStr) + item;
                ++i;
            }
            ty = DataType.NumberType;
            line = String.format("FunLib.avg(%s)", paramStr);
        }
        return new LineItem(line, ty, DataType.ObjectType);
    }

    private static DataType calcLineType(DataType t1, DataType t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        if (t1.isType("Object") || t2.isType("Object")) {
            return DataType.ObjectType;
        }
        return NodeParser.calcCommonType(t1, t2);
    }

    private static CodeItem parseIf(NodeParser parser, If node) throws ParseNodeException {
        IParam param = node.getParam();
        DataType type = null;
        DataType lineType = null;
        String line = "";
        if (param.isLeaf()) {
            CodeItem val = parser.parse(param.getLeafExpression().getHome());
            return FunctionNodeParser.toBoolItem(val);
        }
        if (param.getType() == ';') {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("if" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = param.getSub(0);
            if (sub0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("if" + mm.getMessage("function.invalidParam"));
            }
            if (sub0.getType() == ',') {
                CodeItem item;
                int i = 0;
                int size = sub0.getSubSize();
                while (i < size) {
                    IParam sub = sub0.getSub(i);
                    if (sub == null || sub.getSubSize() != 2) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("if" + mm.getMessage("function.invalidParam"));
                    }
                    IParam c = sub.getSub(0);
                    if (c == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("if" + mm.getMessage("function.invalidParam"));
                    }
                    CodeItem obj = parser.parse(c.getLeafExpression().getHome());
                    line = String.valueOf(line) + "(" + FunctionNodeParser.toBoolItem(obj) + ") ? ";
                    c = sub.getSub(1);
                    if (c != null) {
                        item = parser.parse(c.getLeafExpression().getHome());
                        type = NodeParser.calcCommonType(type, item.getType());
                        lineType = FunctionNodeParser.calcLineType(lineType, FunctionNodeParser.getLineType(item));
                        line = String.valueOf(line) + FunctionNodeParser.handleParentheses(item);
                    } else {
                        type = DataType.ObjectType;
                        line = String.valueOf(line) + "null";
                    }
                    line = String.valueOf(line) + ":";
                    ++i;
                }
                IParam sub1 = param.getSub(1);
                if (sub1 != null) {
                    item = parser.parse(sub1.getLeafExpression().getHome());
                    type = NodeParser.calcCommonType(type, item.getType());
                    lineType = FunctionNodeParser.calcLineType(lineType, FunctionNodeParser.getLineType(item));
                    line = String.valueOf(line) + FunctionNodeParser.handleParentheses(item);
                } else {
                    type = DataType.ObjectType;
                    line = String.valueOf(line) + "null";
                }
            } else {
                CodeItem item;
                if (sub0.getSubSize() != 2) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("if" + mm.getMessage("function.invalidParam"));
                }
                IParam sub = sub0.getSub(0);
                if (sub == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("if" + mm.getMessage("function.invalidParam"));
                }
                CodeItem obj = parser.parse(sub.getLeafExpression().getHome());
                obj = FunctionNodeParser.toBoolItem(obj);
                line = obj + "?";
                sub = sub0.getSub(1);
                if (sub == null) {
                    type = DataType.ObjectType;
                    line = String.valueOf(line) + "null";
                } else {
                    item = parser.parse(sub.getLeafExpression().getHome());
                    type = NodeParser.calcCommonType(type, item.getType());
                    line = String.valueOf(line) + FunctionNodeParser.handleParentheses(item);
                }
                line = String.valueOf(line) + ":";
                sub = param.getSub(1);
                if (sub == null) {
                    type = DataType.ObjectType;
                    line = String.valueOf(line) + "null";
                } else {
                    item = parser.parse(sub.getLeafExpression().getHome());
                    type = NodeParser.calcCommonType(type, item.getType());
                    lineType = FunctionNodeParser.calcLineType(lineType, FunctionNodeParser.getLineType(item));
                    line = String.valueOf(line) + FunctionNodeParser.handleParentheses(item);
                }
            }
        } else if (param.getType() == ',') {
            int size = param.getSubSize();
            IParam sub = param.getSub(0);
            if (sub == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("if" + mm.getMessage("function.invalidParam"));
            }
            if (sub.isLeaf()) {
                if (size > 3) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("if" + mm.getMessage("function.invalidParam"));
                }
                if (size == 2) {
                    CodeItem obj = parser.parse(sub.getLeafExpression().getHome());
                    CodeItem obj2 = parser.parse(param.getSub(1).getLeafExpression().getHome());
                    type = obj2.getType();
                    lineType = FunctionNodeParser.calcLineType(lineType, FunctionNodeParser.getLineType(obj2));
                    line = type.isType("void") ? String.format("if(%s) { \n%s;\n}", FunctionNodeParser.toBoolItem(obj), obj2) : String.format("(%s)?%s:null", FunctionNodeParser.toBoolItem(obj), obj2.cast());
                } else {
                    CodeItem item;
                    CodeItem obj = parser.parse(sub.getLeafExpression().getHome());
                    line = FunctionNodeParser.toBoolItem(obj) + "?";
                    sub = param.getSub(1);
                    if (sub == null) {
                        type = DataType.ObjectType;
                        line = String.valueOf(line) + "null";
                    } else {
                        item = parser.parse(sub.getLeafExpression().getHome());
                        type = NodeParser.calcCommonType(type, item.getType());
                        lineType = FunctionNodeParser.calcLineType(lineType, FunctionNodeParser.getLineType(item));
                        line = String.valueOf(line) + FunctionNodeParser.handleParentheses(item);
                    }
                    line = String.valueOf(line) + ":";
                    if (size > 2) {
                        sub = param.getSub(2);
                        if (sub == null) {
                            type = DataType.ObjectType;
                            line = String.valueOf(line) + "null";
                        } else {
                            item = parser.parse(sub.getLeafExpression().getHome());
                            type = NodeParser.calcCommonType(type, item.getType());
                            lineType = FunctionNodeParser.calcLineType(lineType, FunctionNodeParser.getLineType(item));
                            line = String.valueOf(line) + FunctionNodeParser.handleParentheses(item);
                        }
                    } else {
                        type = DataType.ObjectType;
                        line = String.valueOf(line) + "null";
                    }
                }
            } else {
                int i = 0;
                while (i < size) {
                    sub = param.getSub(i);
                    if (sub == null || sub.getSubSize() != 2) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("if" + mm.getMessage("function.invalidParam"));
                    }
                    IParam c = sub.getSub(0);
                    if (c == null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException("if" + mm.getMessage("function.invalidParam"));
                    }
                    CodeItem obj = parser.parse(c.getLeafExpression().getHome());
                    line = String.valueOf(line) + FunctionNodeParser.toBoolItem(obj) + "?";
                    c = sub.getSub(1);
                    if (c != null) {
                        CodeItem item = parser.parse(c.getLeafExpression().getHome());
                        type = NodeParser.calcCommonType(type, item.getType());
                        lineType = FunctionNodeParser.calcLineType(lineType, FunctionNodeParser.getLineType(item));
                        line = String.valueOf(line) + item;
                    } else {
                        type = DataType.ObjectType;
                        line = String.valueOf(line) + "null";
                    }
                    line = String.valueOf(line) + ":";
                    ++i;
                }
                type = DataType.ObjectType;
                line = String.valueOf(line) + "null";
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException("if" + mm.getMessage("function.invalidParam"));
        }
        return new LineItem(line, type, lineType);
    }

    private static CodeItem parseRand(NodeParser parser, Rand node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            return new LineItem("ctx.getRandom().nextDouble()", DataType.DoubleType);
        }
        if (param.isLeaf()) {
            CodeItem obj = parser.parse(param.getLeafExpression().getHome());
            String option = NodeParser.toMacroString(node.getOption());
            return new LineItem(String.format("FunLib.rand(%s, %s, ctx)", obj, option), DataType.IntTypeNullable);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("rand" + mm.getMessage("function.invalidParam"));
    }

    private static CodeItem parseOutput(NodeParser parser, Output node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("output" + mm.getMessage("function.missingParam"));
        }
        Expression[] exps = node.getParamExpressions("output", false);
        String paramStr = "";
        int i = 0;
        int len = exps.length;
        while (i < len) {
            Expression exp = exps[i];
            CodeItem item = parser.parse(exp.getHome());
            paramStr = String.valueOf(paramStr) + "," + item;
            ++i;
        }
        String option = NodeParser.toMacroString(node.getOption());
        return new LineItem(String.format("FunLib.output(%s%s)", option, paramStr), DataType.ObjectType);
    }

    private static CodeItem parseTypeof(NodeParser parser, Typeof node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("output" + mm.getMessage("function.missingParam"));
        }
        CodeItem item = parser.parse(param.getLeafExpression().getHome());
        String option = NodeParser.toMacroString(node.getOption());
        return new LineItem(String.format("FunLib.typeof(%s, %s)", item, option), DataType.StringType);
    }

    private static CodeItem parseInterval(NodeParser parser, Interval node) throws ParseNodeException {
        IParam param = node.getParam();
        String opt = NodeParser.toMacroString(node.getOption());
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.missingParam"));
        }
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = param.getSub(0);
        IParam sub2 = param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.invalidParam"));
        }
        Expression exp1 = sub1.getLeafExpression();
        Expression exp2 = sub2.getLeafExpression();
        CodeItem item1 = parser.parse(exp1.getHome());
        CodeItem item2 = parser.parse(exp2.getHome());
        return new LineItem(String.format("FunLib.interval(%s, %s, %s)", item1, item2, opt), DataType.NumberType);
    }

    private static CodeItem parseCreate(NodeParser parser, Create node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("create" + mm.getMessage("function.missingParam"));
        }
        Expression[] exps = node.getParamExpressions("create", true);
        int size = exps.length;
        String[] names = new String[size];
        ArrayList<String> pkList = null;
        int i = 0;
        while (i < size) {
            if (exps[i] != null) {
                String name = exps[i].getIdentifierName();
                if (name != null && name.length() > 0 && name.charAt(0) == '#') {
                    name = name.substring(1);
                    if (pkList == null) {
                        pkList = new ArrayList<String>();
                    }
                    pkList.add(name);
                }
                names[i] = name;
            }
            ++i;
        }
        String[] pkNames = null;
        if (pkList != null) {
            int count = pkList.size();
            pkNames = new String[count];
            pkList.toArray(pkNames);
        }
        DataType[] newTypes = new DataType[size];
        int i2 = 0;
        while (i2 < size) {
            newTypes[i2] = DataType.ObjectTypeFixed;
            ++i2;
        }
        String s1 = parser.generateStrArrConstVar(names);
        String s2 = parser.generateStrArrConstVar(pkNames);
        StructType structType = new StructType(names, newTypes, parser);
        DataType returnType = DataType.newTableType(structType);
        return new LineItem(String.format("FunLib.create(%s, %s)", s1, s2), returnType);
    }

    private static CodeItem parseRight(NodeParser parser, Right node) throws ParseNodeException {
        CodeItem item2;
        CodeItem item1;
        IParam param = node.getParam();
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.missingParam"));
        }
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = param.getSub(0);
        IParam sub2 = param.getSub(1);
        if (sub1 == null) {
            item1 = LineItem.NULL;
        } else {
            Expression exp1 = sub1.getLeafExpression();
            item1 = parser.parse(exp1.getHome());
        }
        if (sub2 == null) {
            item2 = LineItem.NULL;
        } else {
            Expression exp2 = sub2.getLeafExpression();
            item2 = parser.parse(exp2.getHome());
        }
        return new LineItem(String.format("FunLib.right(%s, %s)", item1, item2), DataType.StringType);
    }

    private static CodeItem parseWorkDay(NodeParser parser, WorkDay node) throws ParseNodeException {
        IParam param = node.getParam();
        String opt = NodeParser.toMacroString(node.getOption());
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new ParseNodeException("workday" + mm.getMessage("function.missingParam"));
        }
        int size = param.getSubSize();
        if (size != 2 && size != 3) {
            MessageManager mm = EngineMessage.get();
            throw new ParseNodeException("workday" + mm.getMessage("function.invalidParam"));
        }
        CodeItem item1 = parser.parse(param.getSub(0).getLeafExpression().getHome());
        CodeItem item2 = parser.parse(param.getSub(1).getLeafExpression().getHome());
        CodeItem item3 = parser.parse(param.getSub(2).getLeafExpression().getHome());
        return new LineItem(String.format("FunLib.workDay(%s, %s, %s, %s)", item1, item2, item3, opt), DataType.DateType);
    }

    private static CodeItem parseMaxF(NodeParser parser, Max node) throws ParseNodeException {
        String line;
        IParam param = node.getParam();
        if (param.isLeaf()) {
            return parser.parse(param.getLeafExpression().getHome());
        }
        int size = param.getSubSize();
        CodeItem item = parser.parseParams(param, null);
        DataType ty = item.getType();
        if (size == 2) {
            if (ty.isType("int") || ty.isType("long") || ty.isType("double")) {
                String line2 = String.format("Math.max(%s)", item);
                return new LineItem(line2, ty);
            }
            CodeItem item0 = parser.parse(param.getSub(0).getLeafExpression().getHome());
            CodeItem item1 = parser.parse(param.getSub(1).getLeafExpression().getHome());
            if (item0 instanceof ConstItem) {
                item0 = item0.cast(ty.getTypeName());
            }
            if (item1 instanceof ConstItem) {
                item1 = item1.cast(ty.getTypeName());
            }
            line = String.format("FunLib.max(%s, %s)", item0, item1);
        } else {
            line = String.format("FunLib.max(%s)", item);
        }
        return new LineItem(line, ty, DataType.ObjectType);
    }

    private static CodeItem parseMinF(NodeParser parser, Min node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param.isLeaf()) {
            return parser.parse(param.getLeafExpression().getHome());
        }
        int size = param.getSubSize();
        CodeItem item = parser.parseParams(param, null);
        DataType ty = item.getType();
        String line = size == 2 ? (ty.isType("int") || ty.isType("long") || ty.isType("double") ? String.format("Math.min(%s)", item) : String.format("FunLib.min(%s)", item)) : String.format("FunLib.min(%s)", item);
        return new LineItem(line, ty, DataType.ObjectType);
    }

    private static CodeItem parseNewF(NodeParser parser, New node) throws ParseNodeException {
        LineItem item;
        String line;
        DataType type;
        IParam param = node.getParam();
        String option = node.getOption();
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("new" + mm.getMessage("function.missingParam"));
        }
        ParamInfo2 pi = ParamInfo2.parse((IParam)param, (String)"new", (boolean)false, (boolean)false);
        Expression[] exps = pi.getExpressions1();
        String[] names = pi.getExpressionStrs2();
        int colCount = names.length;
        CodeItem[] items = new CodeItem[colCount];
        int i = 0;
        while (i < colCount) {
            if ((names[i] == null || names[i].length() == 0) && exps[i] != null) {
                names[i] = exps[i].getFieldName();
            }
            items[i] = parser.parse(exps[i].getHome());
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < items.length) {
            CodeItem item2 = items[i2];
            if (item2 != null) {
                sb.append(item2.toString());
            } else {
                sb.append("null");
            }
            if (i2 < items.length - 1) {
                sb.append(",");
            }
            ++i2;
        }
        boolean isRec = option == null || option.indexOf(116) == -1;
        String result1 = sb.toString();
        String result2 = parser.generateStrArrConstVar(names);
        DataType[] fieldTypes = new DataType[colCount];
        String preLine = "";
        int i3 = 0;
        while (i3 < colCount) {
            fieldTypes[i3] = items[i3].getType();
            CodeItem item3 = items[i3];
            if (item3.getPreItems() != null && item3.getPreItems().size() > 0) {
                for (CodeItem citem : item3.getPreItems()) {
                    preLine = String.valueOf(preLine) + citem.toString() + ";";
                }
            }
            ++i3;
        }
        if (isRec) {
            type = DataType.newRecordType(new StructType(names, fieldTypes, parser));
            line = String.format("FunLib.NewRecord(%s, %s)", result2, result1);
            item = new LineItem(line, type);
        } else {
            type = DataType.newTableType(new StructType(names, fieldTypes, parser));
            line = String.format("FunLib.NewTable(%s, %s)", result2, result1);
            item = new LineItem(line, type);
        }
        if (preLine.length() > 0) {
            item.setPreItem(new LineItem(preLine));
        }
        return item;
    }

    private static CodeItem parseTo(NodeParser parser, To node) throws ParseNodeException {
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        if (param.isLeaf()) {
            CodeItem o = parser.parse(param.getLeafExpression().getHome());
            String line = String.format("FunLib.To(%s)", o);
            return new LineItem(line, DataType.newSequenceType("int"));
        }
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("to" + mm.getMessage("function.invalidParam"));
        }
        IParam sub1 = param.getSub(0);
        IParam sub2 = param.getSub(1);
        if (sub1 == null || sub2 == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("to" + mm.getMessage("function.invalidParam"));
        }
        CodeItem o1 = parser.parse(sub1.getLeafExpression().getHome());
        CodeItem o2 = parser.parse(sub2.getLeafExpression().getHome());
        String line = String.format("FunLib.To(%s, %s, %s)", o1, o2, option);
        return new LineItem(line, DataType.newSequenceType("int"));
    }

    private static CodeItem parseToChar(NodeParser parser, ToChar node) throws ParseNodeException {
        IParam param = node.getParam();
        CodeItem obj = parser.parse(param.getLeafExpression().getHome());
        String line = String.format("FunLib.ToChar(%s)", obj);
        return new LineItem(line, DataType.StringType);
    }

    private static CodeItem parseToString(NodeParser parser, ToString node) throws ParseNodeException {
        CodeItem val;
        CodeItem fmt = LineItem.NULL;
        CodeItem locale = LineItem.NULL;
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        if (param.isLeaf()) {
            val = parser.parse(param.getLeafExpression().getHome());
        } else {
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("string" + mm.getMessage("function.invalidParam"));
            }
            IParam sub0 = param.getSub(0);
            IParam sub1 = param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("string" + mm.getMessage("function.invalidParam"));
            }
            val = parser.parse(sub0.getLeafExpression().getHome());
            if (sub1.isLeaf()) {
                fmt = parser.parse(sub1.getLeafExpression().getHome());
            } else {
                IParam fmtParam = sub1.getSub(0);
                IParam locParam = sub1.getSub(1);
                if (fmtParam == null || locParam == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("string" + mm.getMessage("function.invalidParam"));
                }
                fmt = parser.parse(fmtParam.getLeafExpression().getHome());
                locale = parser.parse(locParam.getLeafExpression().getHome());
            }
        }
        String line = String.format("FunLib.ToString(%s, %s, %s, %s)", val, fmt.toString(), locale.toString(), option);
        return new LineItem(line, DataType.StringType);
    }

    private static CodeItem parseFunc(NodeParser parser, Func node) throws ParseNodeException {
        String s;
        Expression exp;
        CodeItem[] args;
        IParam param = node.getParam();
        ConcurrentHashMap<String, DataType> types = new ConcurrentHashMap<String, DataType>();
        if (param.isLeaf()) {
            args = null;
            exp = param.getLeafExpression();
        } else {
            IParam sub0 = param.getSub(0);
            if (sub0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("func" + mm.getMessage("function.invalidParam"));
            }
            int size = param.getSubSize();
            args = new CodeItem[size - 1];
            exp = sub0.getLeafExpression();
            int i = 1;
            while (i < size) {
                IParam sub = param.getSub(i);
                if (sub != null) {
                    args[i - 1] = parser.parse(sub.getLeafExpression().getHome()).cast();
                }
                ++i;
            }
        }
        if (!(exp.getHome() instanceof CSVariable)) {
            throw new ParseNodeException();
        }
        INormalCell cell = exp.calculateCell(null);
        PgmCellSet cellSet = (PgmCellSet)cell.getCellSet();
        int c = cell.getCol();
        int r = cell.getRow();
        int endRow = cellSet.getFuncEndRow(r, c);
        String funcName = "func_" + NodeParser.col2varName(c, r);
        if (parser.funCodeMap.containsKey(funcName)) {
            String arg = args == null ? "" : args[0].toString();
            String line = String.format("%s(%s)", funcName, arg);
            return new LineItem(line, parser.funCodeMap.get(funcName).getType());
        }
        String replaceTypeStr = "_" + funcName + "_return_type";
        DataType replaceType = new DataType(replaceTypeStr);
        parser.funCodeMap.put(funcName, new LineItem("", replaceType));
        if (args != null && args[0] != null) {
            types.put(NodeParser.col2varName(c, r), args[0].getType());
        }
        parser.pushStack();
        parser.setTypes(types);
        FunCodeItem fci = CompilerUtil.compilePgmCellSet(cellSet, r, c + 1, endRow, parser);
        String paramVarsDefine = parser.getParentVarsDefinition();
        String paramVars = parser.getParentVars();
        parser.popStack();
        List<String> lines = fci.getLines();
        DataType returnType = fci.getType();
        boolean recursive = false;
        for (String line : lines) {
            if (line.indexOf(funcName) == -1) continue;
            recursive = true;
            break;
        }
        if (recursive) {
            parser.pushStack();
            parser.setTypes(types);
            parser.funCodeMap.put(funcName, new LineItem("", returnType));
            fci = CompilerUtil.compilePgmCellSet(cellSet, r, c + 1, endRow, parser);
            parser.popStack();
            lines = fci.getLines();
            returnType = fci.getType();
        }
        StringBuilder result = new StringBuilder();
        int size = lines.size();
        int i = 0;
        while (i < size - 1) {
            String line = lines.get(i);
            result.append(line);
            if (!line.startsWith("}") && !line.endsWith("{")) {
                result.append(";");
            }
            ++i;
        }
        String lastLine = lines.get(size - 1).trim();
        if (!lastLine.equals("}")) {
            if (lastLine.startsWith("return")) {
                result.append(lastLine);
            } else {
                result.append("return ").append(lastLine);
            }
            result.append(";");
        } else {
            result.append(lastLine);
            result.append("return ").append(returnType.getDefaultValueStr());
            result.append(";");
        }
        if (args != null) {
            String[] argNames = new String[args.length];
            int i2 = 0;
            while (i2 < args.length) {
                if (args[i2] != null && args[i2].getType().isType("UnknownType")) {
                    String err = String.format("ERROR: %s %s func() parameter %s missing type definition", cellSet.getName(), NodeParser.col2varName(c, r), args[i2].toString());
                    System.out.println(err);
                    return null;
                }
                argNames[i2] = args[i2].getType() + " " + args[i2].toString();
                ++i2;
            }
            String argStr = String.format("%s %s%s", args[0].getType().toString(), NodeParser.col2varName(c, r), paramVarsDefine);
            s = String.format("private static %s %s(%s) {%s}", returnType.getTypeName(), funcName, argStr, result);
        } else {
            String argStr = paramVarsDefine;
            s = String.format("private static %s %s(%s) {%s}", returnType.getTypeName(), funcName, argStr, result);
        }
        LineItem item = new LineItem(s, returnType);
        parser.funCodeMap.put(funcName, item);
        String line = String.format("%s(%s%s)", funcName, args == null ? "" : args[0], paramVars);
        return new LineItem(line, parser.funCodeMap.get(funcName).getType());
    }

    private static CodeItem parsePCSFunc(NodeParser parser, Function node, PgmCellSet funcCellSet, PgmCellSet.FuncInfo funcInfo, CodeItem[] paramItems) throws ParseNodeException {
        PgmNormalCell cell = funcInfo.getCell();
        ConcurrentHashMap<String, DataType> types = new ConcurrentHashMap<String, DataType>();
        ConcurrentHashMap<String, DataType> tipTypes = new ConcurrentHashMap<String, DataType>();
        String funcName = String.valueOf(funcInfo.getFnName()) + "_" + parser.constPool.generateNextId();
        CompilerUtil.parseTip(tipTypes, cell.getTip(), parser);
        String[] argNames = funcInfo.getArgNames();
        int i = 0;
        int size = argNames.length;
        while (i < size) {
            DataType type = tipTypes.get(argNames[i]);
            if (type != null) {
                if (paramItems[i] instanceof LineItem) {
                    paramItems[i] = paramItems[i].cast(type.getTypeName());
                } else {
                    paramItems[i].setType(type);
                }
            }
            types.put(argNames[i], paramItems[i].getType());
            ++i;
        }
        int row = cell.getRow();
        int col = cell.getCol() + 1;
        int endRow = funcInfo.getEndRow();
        parser.pushStack();
        parser.setTypes(types);
        for (Map.Entry<String, DataType> entry : tipTypes.entrySet()) {
            String name = entry.getKey();
            DataType type = entry.getValue();
            if (types.containsKey(name)) continue;
            parser.addVar(new VarItem(name, type));
        }
        FunCodeItem fci = CompilerUtil.compilePgmCellSet(funcCellSet, row, col, endRow, parser);
        HashMap<String, VarItem> vars = parser.getVars();
        parser.popStack();
        if (fci == null) {
            return null;
        }
        boolean changed = false;
        int i2 = 0;
        int size2 = argNames.length;
        while (i2 < size2) {
            CodeItem item = paramItems[i2];
            String name = argNames[i2];
            VarItem var = vars.get(name);
            if (var != null && !item.getType().equalTo(var.getType())) {
                DataType newType = NodeParser.calcMinType(item.getType(), var.getType());
                paramItems[i2] = item.cast(newType.toString());
                types.put(argNames[i2], newType);
                changed = true;
            }
            ++i2;
        }
        if (changed) {
            parser.pushStack();
            parser.setTypes(types);
            fci = CompilerUtil.compilePgmCellSet(funcCellSet, row, col, endRow, parser);
            parser.popStack();
            if (fci == null) {
                return null;
            }
        }
        List<String> lines = fci.getLines();
        DataType returnType = fci.getType();
        StringBuilder result = new StringBuilder();
        int size3 = lines.size();
        int i3 = 0;
        while (i3 < size3 - 1) {
            String line = lines.get(i3);
            result.append(line);
            if (!line.startsWith("}") && !line.endsWith("{")) {
                result.append(";");
            }
            ++i3;
        }
        String lastLine = lines.get(size3 - 1).trim();
        if (!lastLine.equals("}")) {
            if (lastLine.startsWith("return")) {
                result.append(lastLine);
            } else {
                result.append("return ").append(lastLine);
            }
            result.append(";");
        } else {
            result.append(lastLine);
        }
        String p = "";
        size3 = argNames.length;
        int i4 = 0;
        while (i4 < size3) {
            if (!funcInfo.isMacroArg(i4)) {
                String type = paramItems[i4].getType().getTypeName();
                if (p.length() != 0) {
                    p = String.valueOf(p) + ",";
                }
                p = String.valueOf(p) + type + " " + argNames[i4];
            }
            ++i4;
        }
        String s = String.format("private static %s %s(%s) {%s}", returnType.getTypeName(), funcName, p, result);
        LineItem item = new LineItem(s, returnType);
        parser.funCodeMap.put(funcName, item);
        p = "";
        int i5 = 0;
        while (i5 < size3) {
            if (!funcInfo.isMacroArg(i5)) {
                if (p.length() != 0) {
                    p = String.valueOf(p) + ",";
                }
                p = String.valueOf(p) + paramItems[i5].cast();
            }
            ++i5;
        }
        String line = String.format("%s(%s)", funcName, p);
        return new LineItem(line, returnType);
    }

    private static PgmCellSet getPgmCellSet(PgmCellSet.FuncInfo funcInfo) {
        PgmCellSet funcCellSet = null;
        try {
            Field field = funcInfo.getClass().getDeclaredField("this$0");
            field.setAccessible(true);
            funcCellSet = (PgmCellSet)field.get(funcInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return funcCellSet;
    }

    public static CodeItem parsePCSFunction(NodeParser parser, Function node, PgmCellSet.FuncInfo funcInfo) throws ParseNodeException {
        IParam param = node.getParam();
        String option = node.getOption();
        String macroExp = funcInfo.getMacroExpression();
        String fopt = funcInfo.getOption();
        if (fopt != null && fopt.indexOf("m") != -1) {
            Expression exp = new Expression(macroExp);
            return parser.parse(exp.getHome());
        }
        Object[] args = funcInfo.getDefaultValues();
        int len = args == null ? 0 : args.length;
        boolean[] needParse = new boolean[len];
        CodeItem[] argItems = new CodeItem[len];
        int i = 0;
        while (i < len) {
            needParse[i] = true;
            ++i;
        }
        boolean hasOptParam = funcInfo.hasOptParam();
        if (param != null) {
            IParam sub;
            int i2;
            int size;
            if (hasOptParam) {
                if (param.isLeaf()) {
                    if (args == null || args.length < 2) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(String.valueOf(funcInfo.getFnName()) + mm.getMessage("function.invalidParam"));
                    }
                    args[0] = option;
                    if (funcInfo.isMacroArg(1)) {
                        args[1] = param.getLeafExpression().toString();
                    } else {
                        argItems[1] = parser.parse(param.getLeafExpression().getHome());
                        needParse[1] = false;
                    }
                } else {
                    size = param.getSubSize();
                    if (args == null || args.length < size + 1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(String.valueOf(funcInfo.getFnName()) + mm.getMessage("function.invalidParam"));
                    }
                    args[0] = option;
                    i2 = 0;
                    while (i2 < size) {
                        sub = param.getSub(i2);
                        if (sub != null) {
                            if (funcInfo.isMacroArg(i2 + 1)) {
                                args[i2 + 1] = sub.getLeafExpression().toString();
                            } else {
                                argItems[i2 + 1] = parser.parse(sub.getLeafExpression().getHome());
                                needParse[i2 + 1] = false;
                            }
                        }
                        ++i2;
                    }
                }
            } else if (param.isLeaf()) {
                if (funcInfo.isMacroArg(0)) {
                    args[0] = param.getLeafExpression().toString();
                } else {
                    argItems[0] = parser.parse(param.getLeafExpression().getHome());
                    needParse[0] = false;
                }
            } else {
                size = param.getSubSize();
                if (args == null || args.length < size) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(funcInfo.getFnName()) + mm.getMessage("function.invalidParam"));
                }
                i2 = 0;
                while (i2 < size) {
                    sub = param.getSub(i2);
                    if (sub != null) {
                        if (funcInfo.isMacroArg(i2)) {
                            args[i2] = sub.getLeafExpression().toString();
                        } else {
                            argItems[i2] = parser.parse(sub.getLeafExpression().getHome());
                            needParse[i2] = false;
                        }
                    }
                    ++i2;
                }
            }
        } else if (hasOptParam) {
            args[0] = option;
            needParse[0] = true;
        }
        int i3 = 0;
        while (i3 < len) {
            if (needParse[i3]) {
                argItems[i3] = parser.parse((Node)new Constant(args[i3]));
            }
            ++i3;
        }
        PgmCellSet funcCellSet = FunctionNodeParser.getPgmCellSet(funcInfo);
        String tip = funcInfo.getCell().getTip();
        boolean skip = false;
        if (tip != null && tip.indexOf("skip") != -1) {
            skip = true;
        }
        if (!skip && funcCellSet != null) {
            Context ctx = funcCellSet.getContext();
            String[] names = funcInfo.getArgNames();
            int i4 = 0;
            while (i4 < len) {
                if (needParse[i4]) {
                    ctx.setParamValue(names[i4], args[i4]);
                }
                ++i4;
            }
            CodeItem item = FunctionNodeParser.parsePCSFunc(parser, node, funcCellSet, funcInfo, argItems);
            if (item != null) {
                return item;
            }
        }
        String paramVars = "";
        int i5 = 0;
        while (i5 < len) {
            paramVars = String.valueOf(paramVars) + ",";
            paramVars = String.valueOf(paramVars) + argItems[i5];
            ++i5;
        }
        String cellSetVar = parser.generatePgmCellSetVar(funcCellSet);
        String line = String.format("FunLib.runPCSFunction(\"%s\" , ctx,%s %s)", funcInfo.getFnName(), cellSetVar, paramVars);
        return new LineItem(line, DataType.ObjectType);
    }

    private static CodeItem parseCall(NodeParser parser, Call node) throws ParseNodeException {
        CodeItem obj;
        IParam param = node.getParam();
        String opt = node.getOption();
        if (opt != null && opt.indexOf("f") != -1) {
            return LineItem.NOP;
        }
        String funcName = "call_" + parser.constPool.generateNextId();
        if (param.isLeaf()) {
            obj = parser.parse(param.getLeafExpression().getHome());
        } else {
            IParam sub0 = param.getSub(0);
            if (sub0 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("call" + mm.getMessage("function.invalidParam"));
            }
            obj = parser.parse(sub0.getLeafExpression().getHome());
        }
        if (obj instanceof ConstItem) {
            CodeItem code;
            PgmCellSet pcs;
            Object file = ((ConstItem)obj).getValue();
            if (file instanceof FileObject) {
                pcs = DfxManager.readDfx((FileObject)((FileObject)file), (Context)new Context());
            } else if (file instanceof String) {
                pcs = DfxManager.readDfx((String)((String)file), (Context)new Context());
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("call" + mm.getMessage("function.paramTypeError"));
            }
            boolean skip = false;
            if (pcs == null) {
                skip = true;
            } else {
                String tip = ((NormalCell)pcs.getCell("A1")).getTip();
                if (tip != null && tip.indexOf("skip") != -1) {
                    skip = true;
                }
            }
            if (skip) {
                return parser.parseFunctionToGeneric((Function)node, null, "call", DataType.ObjectType, parser);
            }
            String paramStr = "";
            String paramStr2 = "";
            ArrayList<VarItem> paramVars = new ArrayList<VarItem>();
            ParamList list = pcs.getParamList();
            if (list != null) {
                CodeItem item;
                Param p;
                int size = param.getSubSize();
                if (size - 1 > list.count()) {
                    size = list.count() + 1;
                }
                CodeItem[] paramItems = new CodeItem[size];
                int i = 1;
                while (i < size) {
                    IParam sub = param.getSub(i);
                    p = list.get(i - 1);
                    paramItems[i] = sub != null ? parser.parse(sub.getLeafExpression().getHome()) : parser.parse((Node)new Constant(p.getValue()));
                    ++i;
                }
                i = 1;
                while (i < size) {
                    item = paramItems[i];
                    paramStr = i == 1 ? String.valueOf(paramStr) + item : String.valueOf(paramStr) + "," + item;
                    ++i;
                }
                i = 1;
                while (i < size) {
                    item = paramItems[i];
                    p = list.get(i - 1);
                    paramStr2 = i == 1 ? String.valueOf(paramStr2) + item.getType() + " " + p.getName() : String.valueOf(paramStr2) + "," + item.getType() + " " + p.getName();
                    paramVars.add(new VarItem(p.getName(), item.getType()));
                    ++i;
                }
            }
            parser.pushStack();
            try {
                parser.isDFX = true;
                CompilerUtil.printError = false;
                code = CompilerUtil.processPgmCellSet(pcs, parser, paramVars);
                CompilerUtil.printError = true;
            }
            catch (Exception e) {
                parser.popStack();
                CompilerUtil.printError = true;
                return parser.parseFunctionToGeneric((Function)node, null, node.getFunctionName(), DataType.ObjectType, parser);
            }
            parser.popStack();
            String method = String.format("private static %s %s(%s) {%s}", code.getType(), funcName, paramStr2, code);
            parser.funCodeMap.put(funcName, new LineItem(method));
            String line = String.format("%s(%s)", funcName, paramStr);
            return new LineItem(line, code.getType());
        }
        return parser.parseFunctionToGeneric((Function)node, null, node.getFunctionName(), DataType.ObjectType, parser);
    }

    private static CodeItem parseEnvSet(NodeParser parser, EnvSet node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param.isLeaf()) {
            throw new RQException("todo");
        }
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("env" + mm.getMessage("function.invalidParam"));
        }
        IParam sub0 = param.getSub(0);
        if (sub0 == null || !sub0.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("env" + mm.getMessage("function.invalidParam"));
        }
        String name = sub0.getLeafExpression().getIdentifierName();
        IParam sub1 = param.getSub(1);
        if (sub1 == null || !sub1.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("env" + mm.getMessage("function.invalidParam"));
        }
        CodeItem item = parser.parse(sub1.getLeafExpression().getHome());
        VarItem var = new VarItem(name, item.getType());
        var.setStatic(true);
        parser.addVar(var);
        String funcName = "envSet_" + parser.constPool.generateNextId();
        String code = String.format("com.scudata.dm.Env.setParamValue(\"%s\", obj);return obj;", name, item);
        String method = String.format("private static %s %s(%s obj) {%s}", item.getType(), funcName, item.getType(), code);
        parser.funCodeMap.put(funcName, new LineItem(method));
        String line = String.valueOf(name) + "=" + funcName + "(" + item + ")";
        return new LineItem(line, item.getType());
    }

    private static CodeItem parseIfVariable(NodeParser parser, IfVariable node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("ifv" + mm.getMessage("function.missingParam"));
        }
        if (!param.isLeaf()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("ifv" + mm.getMessage("function.invalidParam"));
        }
        String name = param.getLeafExpression().getIdentifierName();
        VarItem var = parser.findVar(name);
        if (var != null && var.isStatic()) {
            return ConstItem.TRUE;
        }
        return ConstItem.FALSE;
    }

    private static CodeItem parseMove(NodeParser parser, Move node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param.isLeaf()) {
            CodeItem posObj = parser.parse(param.getLeafExpression().getHome());
            String posStr = !posObj.getType().isType("int") ? "((Number)" + posObj + ").intValue()" : posObj.toString();
            Node left = node.getLeft();
            if (left instanceof CurrentElement) {
                CurContext cur = parser.getCurContext();
                String line = cur.formatCurMove(posStr);
                return new LineItem(line, DataType.toNullable(cur.getMemberType()), DataType.ObjectType);
            }
            if (left instanceof UnknownSymbol) {
                CurContext cur = parser.getCurContext();
                String field = ((UnknownSymbol)left).getName();
                String line = cur.formatFieldMove(field, posStr);
                DataType type = cur.getStructType().getFieldType(field);
                return new LineItem(line, DataType.toNullable(type), DataType.ObjectType);
            }
        } else {
            Node left;
            CodeItem obj;
            CodeItem start = LineItem.NULL;
            CodeItem end = LineItem.NULL;
            if (param.getSubSize() != 2) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("[]" + mm.getMessage("function.invalidParam"));
            }
            IParam startParam = param.getSub(0);
            IParam endParam = param.getSub(1);
            if (startParam != null) {
                start = obj = parser.parse(startParam.getLeafExpression().getHome());
            }
            if (endParam != null) {
                end = obj = parser.parse(endParam.getLeafExpression().getHome());
            }
            if ((left = node.getLeft()) instanceof CurrentElement) {
                CurContext cur = parser.getCurContext();
                String line = cur.formatCurMoves(start.toString(), end.toString());
                DataType type = DataType.newSequenceType(DataType.toNullable(cur.getMemberType()));
                return new LineItem(line, type);
            }
            if (left instanceof UnknownSymbol) {
                CurContext cur = parser.getCurContext();
                String field = ((UnknownSymbol)left).getName();
                String line = cur.formatFieldMoves(field, start.toString(), end.toString());
                DataType type = cur.getStructType().getFieldType(field);
                type = DataType.newSequenceType(type);
                return new LineItem(line, type);
            }
        }
        throw new ParseNodeException();
    }

    public static CodeItem parseCommonMFN(NodeParser parser, Function node, CodeItem left, String funName, DataType returnType) throws ParseNodeException {
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        String paramStr = NodeParser.toMacroString(node.getParamString());
        ArrayList<VarItem> vars = new ArrayList<VarItem>();
        parser.searchVarsInParam(param, vars);
        String params = "";
        String paramsDef = "";
        String preLine = "";
        for (VarItem var : vars) {
            preLine = String.valueOf(preLine) + String.format("ctx.setParamValue(\"%s\", %s);", var, var);
            params = String.valueOf(params) + "," + var;
            paramsDef = String.valueOf(paramsDef) + "," + var.getType() + " " + var;
            var.refCountIncrease();
        }
        String line = String.format("FunctionExecutor.calculateMFN(%s, \"%s\", %s, %s)", "left", funName, option, paramStr);
        String tempFunName = String.valueOf(funName) + "__" + parser.constPool.generateNextId();
        String funStr = String.format("private static %s %s(Object left %s){%s return (%s) %s;}", returnType, tempFunName, paramsDef, preLine, returnType, line);
        parser.funCodeMap.put(tempFunName, new LineItem(funStr));
        if (left == null) {
            if (paramsDef.length() > 0) {
                params = paramsDef.substring(1);
            }
            line = String.valueOf(tempFunName) + "(" + params + ")";
        } else {
            line = String.valueOf(tempFunName) + "(" + left + params + ")";
        }
        return new LineItem(line, returnType);
    }

    private static CodeItem parseCommon(NodeParser parser, Function node) throws ParseNodeException {
        DataType returnType;
        String option = node.getOption();
        if (node instanceof Mid) {
            returnType = DataType.StringType;
        } else if (node instanceof Day) {
            returnType = DataType.IntTypeNullable;
        } else if (node instanceof Days) {
            returnType = DataType.IntTypeNullable;
        } else if (node instanceof Month) {
            returnType = DataType.IntTypeNullable;
        } else if (node instanceof ToDate) {
            returnType = DataType.DateType;
        } else if (node instanceof Fill) {
            returnType = DataType.StringType;
        } else if (node instanceof Now) {
            returnType = DataType.DateType;
        } else if (node instanceof CreateFile) {
            returnType = DataType.FileObjectType;
        } else if (node instanceof IsAlpha) {
            returnType = DataType.BooleanType;
        } else if (node instanceof Lower) {
            returnType = DataType.StringType;
        } else if (node instanceof Eval) {
            returnType = option == null || option.indexOf(115) == -1 ? DataType.ObjectType : DataType.StringType;
        } else if (node instanceof Var) {
            returnType = DataType.DoubleTypeNullable;
        } else if (node instanceof Output) {
            returnType = DataType.ObjectType;
        } else if (node instanceof Pos) {
            returnType = DataType.IntTypeNullable;
        } else if (node instanceof Year) {
            returnType = DataType.IntTypeNullable;
        } else if (node instanceof IfSequence) {
            returnType = DataType.BooleanType;
        } else {
            if (node instanceof Register) {
                return LineItem.NOP;
            }
            if (node instanceof Len) {
                returnType = DataType.IntTypeNullable;
            } else if (node instanceof ToAsc) {
                returnType = DataType.IntTypeNullable;
            } else if (node instanceof Left) {
                returnType = DataType.StringType;
            } else if (node instanceof Upper) {
                returnType = DataType.StringType;
            } else {
                throw new ParseNodeException(node.toString());
            }
        }
        return parser.parseFunctionToGeneric(node, null, node.getFunctionName(), returnType, parser);
    }

    public static CodeItem parseNode(NodeParser parser, Function node) throws ParseNodeException {
        if (node instanceof Average) {
            return FunctionNodeParser.parseAverage(parser, (Average)node);
        }
        if (node instanceof Rand) {
            return FunctionNodeParser.parseRand(parser, (Rand)node);
        }
        if (node instanceof WorkDay) {
            return FunctionNodeParser.parseWorkDay(parser, (WorkDay)node);
        }
        if (node instanceof If) {
            return FunctionNodeParser.parseIf(parser, (If)node);
        }
        if (node instanceof Max) {
            return FunctionNodeParser.parseMaxF(parser, (Max)node);
        }
        if (node instanceof Min) {
            return FunctionNodeParser.parseMinF(parser, (Min)node);
        }
        if (node instanceof New) {
            return FunctionNodeParser.parseNewF(parser, (New)node);
        }
        if (node instanceof To) {
            return FunctionNodeParser.parseTo(parser, (To)node);
        }
        if (node instanceof ToString) {
            return FunctionNodeParser.parseToString(parser, (ToString)node);
        }
        if (node instanceof ToChar) {
            return FunctionNodeParser.parseToChar(parser, (ToChar)node);
        }
        if (node instanceof Func) {
            return FunctionNodeParser.parseFunc(parser, (Func)node);
        }
        if (node instanceof Move) {
            return FunctionNodeParser.parseMove(parser, (Move)node);
        }
        if (node instanceof Interval) {
            return FunctionNodeParser.parseInterval(parser, (Interval)node);
        }
        if (node instanceof Output) {
            return FunctionNodeParser.parseOutput(parser, (Output)node);
        }
        if (node instanceof Typeof) {
            return FunctionNodeParser.parseTypeof(parser, (Typeof)node);
        }
        if (node instanceof Create) {
            return FunctionNodeParser.parseCreate(parser, (Create)node);
        }
        if (node instanceof Right) {
            return FunctionNodeParser.parseRight(parser, (Right)node);
        }
        if (node instanceof Call) {
            return FunctionNodeParser.parseCall(parser, (Call)node);
        }
        if (node instanceof EnvSet) {
            return FunctionNodeParser.parseEnvSet(parser, (EnvSet)node);
        }
        if (node instanceof IfVariable) {
            return FunctionNodeParser.parseIfVariable(parser, (IfVariable)node);
        }
        CodeItem item = MathNodeParser.parseNode(parser, node);
        if (item != null) {
            return item;
        }
        if (node instanceof Function) {
            return FunctionNodeParser.parseCommon(parser, node);
        }
        throw new ParseNodeException(node.toString());
    }
}

