/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.compile.CodeItem;
import com.scudata.compile.ConstItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.parser.NodeParser;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.fn.math.Abs;
import com.scudata.expression.fn.math.And;
import com.scudata.expression.fn.math.Arccos;
import com.scudata.expression.fn.math.Arccosh;
import com.scudata.expression.fn.math.Arcsin;
import com.scudata.expression.fn.math.Arcsinh;
import com.scudata.expression.fn.math.Arctan;
import com.scudata.expression.fn.math.Arctanh;
import com.scudata.expression.fn.math.Bin;
import com.scudata.expression.fn.math.Bit1;
import com.scudata.expression.fn.math.Ceiling;
import com.scudata.expression.fn.math.Cos;
import com.scudata.expression.fn.math.Cosh;
import com.scudata.expression.fn.math.Digit;
import com.scudata.expression.fn.math.Digits;
import com.scudata.expression.fn.math.Exp;
import com.scudata.expression.fn.math.Fact;
import com.scudata.expression.fn.math.Floor;
import com.scudata.expression.fn.math.Gcd;
import com.scudata.expression.fn.math.Hash;
import com.scudata.expression.fn.math.Hex;
import com.scudata.expression.fn.math.Inf;
import com.scudata.expression.fn.math.Lcm;
import com.scudata.expression.fn.math.Log;
import com.scudata.expression.fn.math.Loga;
import com.scudata.expression.fn.math.Not;
import com.scudata.expression.fn.math.Or;
import com.scudata.expression.fn.math.Permut;
import com.scudata.expression.fn.math.Pi;
import com.scudata.expression.fn.math.Pow;
import com.scudata.expression.fn.math.Product;
import com.scudata.expression.fn.math.Remainder;
import com.scudata.expression.fn.math.Round;
import com.scudata.expression.fn.math.Shift;
import com.scudata.expression.fn.math.Sign;
import com.scudata.expression.fn.math.Sin;
import com.scudata.expression.fn.math.Sinh;
import com.scudata.expression.fn.math.Sqrt;
import com.scudata.expression.fn.math.Tan;
import com.scudata.expression.fn.math.Tanh;
import com.scudata.expression.fn.math.Xor;
import com.scudata.resources.EngineMessage;

public class MathNodeParser {
    private static CodeItem parseAbs(NodeParser parser, Abs node) throws ParseNodeException {
        IParam param = node.getParam();
        CodeItem obj = parser.parse(param.getLeafExpression().getHome());
        if (obj.getType().isType("int") || obj.getType().isType("long") || obj.getType().isType("double")) {
            String line = "Math.abs(" + obj + ")";
            return new LineItem(line, obj.getType());
        }
        String line = "Variant.abs(" + obj + ")";
        line = obj.getType().prefixWithTypeName(line);
        return new LineItem(line, obj.getType(), DataType.ObjectType);
    }

    private static CodeItem parsePow(NodeParser parser, Pow node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("power" + mm.getMessage("function.invalidParam"));
        }
        if (param.isLeaf()) {
            CodeItem obj = parser.parse(param.getLeafExpression().getHome());
            if (obj.getType().isType("int")) {
                String line = String.format("%s * %s", obj, obj);
                return new LineItem(line, DataType.IntType);
            }
            if (obj.getType().isType("long")) {
                String line = String.format("%s * %s", obj, obj);
                return new LineItem(line, DataType.LongType);
            }
            if (obj.getType().isType("double")) {
                String line = String.format("%s * %s", obj, obj);
                return new LineItem(line, DataType.DoubleType);
            }
            String line = "Variant.square(" + obj + ")";
            return new LineItem(line, DataType.NumberType, DataType.ObjectType);
        }
        if (param.getSubSize() != 2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("power" + mm.getMessage("function.invalidParam"));
        }
        return parser.parseFunctionToGeneric((Function)node, null, "power", DataType.DoubleTypeNullable, parser);
    }

    private static CodeItem parseSqrt(NodeParser parser, Sqrt node) throws ParseNodeException {
        IParam param = node.getParam();
        if (param.isLeaf()) {
            CodeItem result = parser.parse(param.getLeafExpression().getHome());
            String line = "MathLib.sqrt(" + result + ")";
            return new LineItem(line, DataType.DoubleTypeNullable);
        }
        if (param.getSubSize() == 2) {
            IParam sub0 = param.getSub(0);
            IParam sub1 = param.getSub(1);
            if (sub0 == null || sub1 == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("sqrt" + mm.getMessage("function.invalidParam"));
            }
            CodeItem a = parser.parse(sub0.getLeafExpression().getHome());
            CodeItem b = parser.parse(sub1.getLeafExpression().getHome());
            String line = "MathLib.sqrt(" + a + ", " + b + ")";
            return new LineItem(line, DataType.DoubleTypeNullable);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("sqrt" + mm.getMessage("function.invalidParam"));
    }

    public static CodeItem parseNode(NodeParser parser, Function node) throws ParseNodeException {
        if (node instanceof Abs) {
            return MathNodeParser.parseAbs(parser, (Abs)node);
        }
        if (node instanceof And) {
            return parser.parseFunctionToGeneric(node, null, "power", DataType.NumberType, parser);
        }
        if (node instanceof Arccos || node instanceof Arccosh || node instanceof Arcsin || node instanceof Arcsinh || node instanceof Arctan || node instanceof Arctanh || node instanceof Cos || node instanceof Cosh || node instanceof Sin || node instanceof Sinh || node instanceof Tan || node instanceof Tanh) {
            return parser.parseFunctionToGeneric(node, null, node.getFunctionName(), DataType.DoubleTypeNullable, parser);
        }
        if (node instanceof Bin) {
            return parser.parseFunctionToGeneric(node, null, "bin", DataType.newSequenceType("Integer"), parser);
        }
        if (node instanceof Bit1) {
            return parser.parseFunctionToGeneric(node, null, "bit1", DataType.IntTypeNullable, parser);
        }
        if (node instanceof Ceiling) {
            return parser.parseFunctionToGeneric(node, null, "ceil", DataType.NumberType, parser);
        }
        if (node instanceof Digit) {
            return parser.parseFunctionToGeneric(node, null, "digit", DataType.LongTypeNullable, parser);
        }
        if (node instanceof Digits) {
            return parser.parseFunctionToGeneric(node, null, "digits", DataType.StringType, parser);
        }
        if (node instanceof Exp) {
            return parser.parseFunctionToGeneric(node, null, "exp", DataType.DoubleTypeNullable, parser);
        }
        if (node instanceof Fact) {
            return parser.parseFunctionToGeneric(node, null, "fact", DataType.LongTypeNullable, parser);
        }
        if (node instanceof Floor) {
            return parser.parseFunctionToGeneric(node, null, "floor", DataType.NumberType, parser);
        }
        if (node instanceof Gcd) {
            return parser.parseFunctionToGeneric(node, null, "gcd", DataType.LongTypeNullable, parser);
        }
        if (node instanceof Hash) {
            return parser.parseFunctionToGeneric(node, null, "hash", DataType.IntTypeNullable, parser);
        }
        if (node instanceof Hex) {
            return parser.parseFunctionToGeneric(node, null, "hex", DataType.newSequenceType("String"), parser);
        }
        if (node instanceof Inf) {
            return ConstItem.POSITIVE_INFINITY;
        }
        if (node instanceof Lcm) {
            return parser.parseFunctionToGeneric(node, null, "lcm", DataType.LongTypeNullable, parser);
        }
        if (node instanceof Log) {
            return parser.parseFunctionToGeneric(node, null, "log", DataType.DoubleTypeNullable, parser);
        }
        if (node instanceof Loga) {
            return parser.parseFunctionToGeneric(node, null, "loga", DataType.DoubleTypeNullable, parser);
        }
        if (node instanceof Not) {
            return parser.parseFunctionToGeneric(node, null, "not", DataType.NumberType, parser);
        }
        if (node instanceof Or) {
            return parser.parseFunctionToGeneric(node, null, "or", DataType.NumberType, parser);
        }
        if (node instanceof Permut) {
            return parser.parseFunctionToGeneric(node, null, "permut", DataType.LongTypeNullable, parser);
        }
        if (node instanceof Pi) {
            return parser.parseFunctionToGeneric(node, null, "pi", DataType.DoubleTypeNullable, parser);
        }
        if (node instanceof Pow) {
            return MathNodeParser.parsePow(parser, (Pow)node);
        }
        if (node instanceof Product) {
            return parser.parseFunctionToGeneric(node, null, "product", DataType.DoubleTypeNullable, parser);
        }
        if (node instanceof Remainder) {
            return parser.parseFunctionToGeneric(node, null, "remainder", DataType.NumberType, parser);
        }
        if (node instanceof Round) {
            return parser.parseFunctionToGeneric(node, null, "round", DataType.ObjectType, parser);
        }
        if (node instanceof Shift) {
            return parser.parseFunctionToGeneric(node, null, "shift", DataType.NumberType, parser);
        }
        if (node instanceof Sign) {
            return parser.parseFunctionToGeneric(node, null, "sign", DataType.NumberType, parser);
        }
        if (node instanceof Sqrt) {
            return MathNodeParser.parseSqrt(parser, (Sqrt)node);
        }
        if (node instanceof Xor) {
            return parser.parseFunctionToGeneric(node, null, "xor", DataType.NumberType, parser);
        }
        return null;
    }
}

