/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.compile.CodeItem;
import com.scudata.compile.ConstItem;
import com.scudata.compile.ConstPool;
import com.scudata.compile.CurContext;
import com.scudata.compile.DataType;
import com.scudata.compile.FunCodeItem;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.StructType;
import com.scudata.compile.VarItem;
import com.scudata.compile.parser.CodeMaker;
import com.scudata.compile.parser.CompilationContextStack;
import com.scudata.compile.parser.CursorFunctionNodeParser;
import com.scudata.compile.parser.FileFunctionParser;
import com.scudata.compile.parser.FunctionNodeParser;
import com.scudata.compile.parser.OperatorParser;
import com.scudata.compile.parser.RecordFunctionParser;
import com.scudata.compile.parser.SequenceNodeParser;
import com.scudata.compile.parser.StringFunctionParser;
import com.scudata.compile.parser.TableFunctionParser;
import com.scudata.dm.Context;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.CSVariable;
import com.scudata.expression.Calc;
import com.scudata.expression.Constant;
import com.scudata.expression.CurrentCell;
import com.scudata.expression.CurrentElement;
import com.scudata.expression.CurrentSeq;
import com.scudata.expression.ElementRef;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldRef;
import com.scudata.expression.FileFunction;
import com.scudata.expression.ForCellCurSeq;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.Operator;
import com.scudata.expression.RecordFunction;
import com.scudata.expression.SequenceFunction;
import com.scudata.expression.StringFunction;
import com.scudata.expression.TableFunction;
import com.scudata.expression.UnknownSymbol;
import com.scudata.expression.ValueList;
import com.scudata.expression.VarParam;
import com.scudata.expression.fn.Ifn;
import com.scudata.expression.fn.PCSFunction;
import com.scudata.expression.fn.convert.ToInteger;
import com.scudata.expression.mfn.cursor.Fetch;
import com.scudata.expression.mfn.db.CreateCursor;
import com.scudata.expression.operator.Assign;
import com.scudata.expression.operator.DotOperator;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CellSetUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NodeParser {
    protected ConcurrentHashMap<String, DataType> types;
    protected HashMap<String, CodeItem> funCodeMap;
    protected ConstPool constPool;
    protected CompilationContextStack stack;
    protected HashMap<String, VarItem> vars;
    protected CurContext curContext;
    protected HashMap<String, VarItem> parentVars = new HashMap();
    protected List<VarItem> assignVars = new ArrayList<VarItem>();
    private PgmNormalCell cell;
    private boolean retry;
    public boolean isDFX;
    protected HashMap<String, String> cellSetMap = new HashMap();

    public NodeParser() {
        this(null);
    }

    public NodeParser(ConcurrentHashMap<String, DataType> types) {
        this.types = types;
        this.vars = new LinkedHashMap<String, VarItem>();
        this.funCodeMap = new HashMap();
        this.constPool = new ConstPool();
        this.stack = new CompilationContextStack();
    }

    public void pushStack() {
        this.stack.push(this.vars, this.parentVars, this.assignVars, this.isDFX);
        this.vars = new LinkedHashMap<String, VarItem>();
        this.parentVars = new HashMap();
        this.assignVars = new ArrayList<VarItem>();
        this.isDFX = false;
    }

    public void popStack() {
        CompilationContextStack.MethodCompilationInfo info = this.stack.pop();
        this.vars = info.getVars();
        this.parentVars = info.getParentVars();
        this.assignVars = info.getAssignVars();
        this.isDFX = info.isDFX();
    }

    public int getStackLevel() {
        return this.stack.size();
    }

    public void pushCurContext(CurContext curContext) {
        curContext.setParentCur(this.curContext);
        curContext.setStackLevel(this.stack.size());
        this.curContext = curContext;
    }

    public void pushCurContext(String cellName, String tableName, String recName, StructType structType, boolean isTable, String iStr) throws ParseNodeException {
        CurContext cur = CurContext.newTableCurItem(cellName, tableName, recName, iStr, structType);
        this.pushCurContext(cur);
    }

    public CurContext popCurContext() {
        CurContext curContext = this.curContext;
        this.curContext = this.curContext.getParentCur();
        return curContext;
    }

    protected String makeParamVarsDefinition(HashMap<String, VarItem> paramVars, List<VarItem> assignVars) {
        if (paramVars.size() != 0) {
            String lines = "";
            for (Map.Entry<String, VarItem> entry : paramVars.entrySet()) {
                String name = entry.getKey();
                VarItem item = entry.getValue();
                if (assignVars.contains(item)) {
                    LineItem lineitem = new LineItem(String.format("private static %s %s;", item.getType(), name));
                    this.funCodeMap.put(name, lineitem);
                    continue;
                }
                lines = String.valueOf(lines) + item.getType() + " " + item.getName() + ",";
            }
            if (lines.length() > 0) {
                lines = lines.substring(0, lines.length() - 1);
            }
            return lines;
        }
        return "";
    }

    protected String makeParamVars(HashMap<String, VarItem> paramVars, List<VarItem> assignVars) {
        if (paramVars.size() != 0) {
            String lines = "";
            for (Map.Entry<String, VarItem> entry : paramVars.entrySet()) {
                String name = entry.getKey();
                VarItem item = entry.getValue();
                if (assignVars.contains(item)) continue;
                lines = String.valueOf(lines) + name + ",";
            }
            if (lines.length() == 0) {
                return lines;
            }
            lines = lines.substring(0, lines.length() - 1);
            return lines;
        }
        return "";
    }

    protected String getVarsDefinition() {
        String lines = "";
        if (this.vars.size() != 0) {
            for (Map.Entry<String, VarItem> entry : this.vars.entrySet()) {
                String name = entry.getKey();
                VarItem item = entry.getValue();
                if (item.isGlobal() || item.isCell() || item.isParamVar()) continue;
                lines = String.valueOf(lines) + item.getType() + " " + name + ";";
            }
        }
        return lines;
    }

    protected String getParentVarsDefinition() {
        return this.makeParamVarsDefinition(this.parentVars, this.assignVars);
    }

    protected String getParentVars() {
        return this.makeParamVars(this.parentVars, this.assignVars);
    }

    public VarItem getVar(String var) {
        if (this.vars.containsKey(var)) {
            VarItem v = this.vars.get(var);
            return v;
        }
        return null;
    }

    public VarItem findVar(String var) {
        if (this.vars.containsKey(var)) {
            VarItem v = this.vars.get(var);
            return v;
        }
        if (this.parentVars != null && this.parentVars.containsKey(var)) {
            VarItem v = this.parentVars.get(var);
            return v;
        }
        return null;
    }

    private VarItem searchVarInCurContext(String varName) {
        VarItem var;
        if (this.curContext == null) {
            return null;
        }
        if (this.curContext.getStructType() != null && (var = this.curContext.getStructType().getFieldVar(varName)) != null) {
            return var;
        }
        if (this.curContext.getParentCur() != null && this.curContext.getParentCur().getStructType() != null && (var = this.curContext.getParentCur().getStructType().getFieldVar(varName)) != null) {
            this.parentVars.put(varName, var);
            return var;
        }
        return null;
    }

    private CodeItem searchCur(String name) {
        if (this.curContext == null) {
            return null;
        }
        if (name.equals(this.curContext.getCellName())) {
            return new LineItem(this.curContext.formatCur(), this.curContext.getMemberType(), DataType.ObjectType);
        }
        if (this.curContext.getParentCur() != null && name.equals(this.curContext.getParentCur().getCellName())) {
            String varName = String.valueOf(name) + "__cur";
            DataType type = this.curContext.getParentCur().getMemberType();
            LineItem lt = new LineItem(this.curContext.getParentCur().formatCur(), type, DataType.ObjectType);
            this.parentVars.put(lt.cast().toString(), new VarItem(varName, type));
            return new LineItem(varName, type, DataType.ObjectType);
        }
        return null;
    }

    private CodeItem searchCurSeq(String name) {
        if (this.curContext == null) {
            return null;
        }
        if (name.equals(this.curContext.getCellName())) {
            return new LineItem(this.curContext.getSeq(), DataType.IntType);
        }
        if (this.curContext.getParentCur() != null && name.equals(this.curContext.getParentCur().getCellName())) {
            String varName = String.valueOf(name) + "__curSeq";
            LineItem lt = new LineItem(this.curContext.getParentCur().getSeq(), DataType.IntType);
            this.parentVars.put(lt.cast().toString(), new VarItem(varName, DataType.IntType));
            return new LineItem(varName, DataType.IntType);
        }
        return null;
    }

    private VarItem searchVarInStack(String varName) {
        if (this.stack.size() == 0) {
            return null;
        }
        VarItem var = this.stack.searchVar(varName);
        if (var == null) {
            return null;
        }
        this.parentVars.put(varName, var);
        CompilationContextStack.MethodCompilationInfo info = this.stack.peek();
        while (info != null) {
            if (info.hasVar(varName)) break;
            info.getParentVars().put(varName, var);
            info = info.getParentInfo();
        }
        return var;
    }

    public void addVars(VarItem[] vars) throws ParseNodeException {
        VarItem[] varItemArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            VarItem var = varItemArray[n2];
            this.addVar(var);
            ++n2;
        }
    }

    public VarItem addVar(VarItem var) throws ParseNodeException {
        String name = var.getName();
        if (this.vars.containsKey(name)) {
            VarItem oldVar = this.vars.get(name);
            if (oldVar.getType().isType("UnknownType")) {
                this.vars.put(name, var);
                return var;
            }
            if (oldVar.getType().getMemberType() == null) {
                oldVar.getType().setMemberType(var.getType().getMemberType());
            }
            if (oldVar.getInitValue() == null) {
                oldVar.setInitValue(var.getInitValue());
            }
            return oldVar;
        }
        if (var.getType().isType("UnknownType")) {
            VarItem vi = this.searchVarInCurContext(name);
            if (vi != null) {
                return vi;
            }
            vi = this.searchVarInStack(name);
            if (vi == null) {
                if (var.isCell()) {
                    var.setType(DataType.newSequenceType(DataType.ObjectType));
                    var.setInitValue(var.getType().getInitStr());
                    this.vars.put(name, var);
                    return var;
                }
                throw new ParseNodeException("unknown type :" + var.getName());
            }
            return vi;
        }
        if (!(var.isCell() || this.cell == null || var.isParamVar() || var.isField() || this.cell.getExpression() == null || this.cell.getExpression().getHome() instanceof Assign)) {
            var.setInitValue(var.getType().getInitStr());
        }
        if (var.isCell()) {
            int r = var.getR();
            int c = var.getC();
            if (this.cell.getRow() > r || this.cell.getRow() == r && this.cell.getCol() > c) {
                var.setInitValue(var.getType().getInitStr());
            }
        }
        this.vars.put(name, var);
        return var;
    }

    public void setVarType(String name, DataType type) throws ParseNodeException {
        if (type == null || type.isType("UnknownType")) {
            return;
        }
        VarItem var = this.searchVarInCurContext(name);
        if (var != null && var.isField()) {
            this.curContext.getStructType().setFieldType(name, type);
            var.setType(type);
            return;
        }
        if (!this.vars.containsKey(name)) {
            throw new ParseNodeException("unknown var : " + name);
        }
        var = this.vars.get(name);
        var.setType(type);
    }

    protected boolean hasVar(String var) {
        return this.vars.containsKey(var);
    }

    protected DataType getVarType(String var) {
        if (this.vars.containsKey(var)) {
            VarItem v = this.vars.get(var);
            return v.getType();
        }
        return null;
    }

    protected static String getVarName(UnknownSymbol us) {
        return us.getName();
    }

    protected static String getVarName(VarParam vp) {
        return vp.getParam().getName();
    }

    public static String toMacroString(String str) {
        if (str == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append("\"");
        return sb.toString();
    }

    public static String col2varName(int col, int row) {
        char ch = (char)(64 + col);
        return "" + ch + row;
    }

    protected static String getVarName(CSVariable cs) {
        return NodeParser.col2varName(cs.getSourceCell().getCol(), cs.getSourceCell().getRow());
    }

    protected static String getVarName(Node node) {
        if (node instanceof UnknownSymbol) {
            return NodeParser.getVarName((UnknownSymbol)node);
        }
        if (node instanceof CSVariable) {
            return NodeParser.getVarName((CSVariable)node);
        }
        if (node instanceof VarParam) {
            return NodeParser.getVarName((VarParam)node);
        }
        return null;
    }

    protected CurContext getCurContext() {
        return this.curContext;
    }

    public HashMap<String, CodeItem> getFunCodeMap() {
        return this.funCodeMap;
    }

    public ConcurrentHashMap<String, DataType> getTypes() {
        return this.types;
    }

    public void setTypes(ConcurrentHashMap<String, DataType> types) {
        this.types = types;
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public HashMap<String, VarItem> getVars() {
        return this.vars;
    }

    public void setVars(HashMap<String, VarItem> vars) {
        this.vars = vars;
    }

    public List<VarItem> getAllVars() {
        ArrayList<VarItem> list = new ArrayList<VarItem>();
        for (VarItem var : this.vars.values()) {
            list.add(var);
        }
        if (this.stack.size() > 0) {
            CompilationContextStack.MethodCompilationInfo info = this.stack.peek();
            while (info != null) {
                for (VarItem var : info.getVars().values()) {
                    list.add(var);
                }
                info = info.getParentInfo();
            }
        }
        return list;
    }

    public static DataType getObjectType(Object obj) {
        if (obj instanceof Integer) {
            return DataType.IntType;
        }
        if (obj instanceof Long) {
            return DataType.LongType;
        }
        if (obj instanceof Double) {
            return DataType.DoubleType;
        }
        if (obj instanceof String) {
            return DataType.StringType;
        }
        if (obj instanceof Table) {
            return DataType.newTableType();
        }
        if (obj instanceof Sequence) {
            return DataType.newSequenceType();
        }
        return DataType.ObjectType;
    }

    protected static DataType calcCommonType(DataType type1, DataType type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1 == type2) {
            return type1;
        }
        if (type1.isNumber() && type2.isNumber()) {
            if (type1.equals(type2)) {
                return type1;
            }
            String t1 = type1.getBaseTypeName();
            String t2 = type2.getBaseTypeName();
            if (t1.equals("int") && t2.equals("int")) {
                if (type1.isNullable() || type2.isNullable()) {
                    return DataType.IntTypeNullable;
                }
                return DataType.IntType;
            }
            if (t1.equals("long") && t2.equals("long")) {
                if (type1.isNullable() || type2.isNullable()) {
                    return DataType.LongTypeNullable;
                }
                return DataType.LongType;
            }
            if (t1.equals("int") && t2.equals("long")) {
                if (type1.isNullable() || type2.isNullable()) {
                    return DataType.LongTypeNullable;
                }
                return DataType.LongType;
            }
            if (t1.equals("long") && t2.equals("int")) {
                if (type1.isNullable() || type2.isNullable()) {
                    return DataType.LongTypeNullable;
                }
                return DataType.LongType;
            }
            if (t1.equals("double") || t2.equals("double")) {
                if (type1.isNullable() || type2.isNullable()) {
                    return DataType.DoubleTypeNullable;
                }
                return DataType.DoubleType;
            }
            return DataType.ObjectType;
        }
        if (type1.isType("Sequence") && type2.isType("Sequence")) {
            if (type1.getMemberType() != null && type2.getMemberType() != null && type1.getMemberType().equalTo(type2.getMemberType())) {
                return type1;
            }
            return DataType.newSequenceType(DataType.ObjectType);
        }
        return DataType.ObjectType;
    }

    protected static DataType calcMinType(DataType type1, DataType type2) throws ParseNodeException {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1 == type2) {
            return type1;
        }
        if (type1.isType("Object")) {
            return type2;
        }
        if (type2.isType("Object")) {
            return type1;
        }
        if (type1.isNumber() && type2.isNumber()) {
            if (type1.equals(type2)) {
                return type1;
            }
            String t1 = type1.getBaseTypeName();
            String t2 = type2.getBaseTypeName();
            if (t1.equals("int") && t2.equals("int")) {
                if (type1.isNullable() || type2.isNullable()) {
                    return DataType.IntTypeNullable;
                }
                return DataType.IntType;
            }
            if (t1.equals("long") && t2.equals("long")) {
                if (type1.isNullable() || type2.isNullable()) {
                    return DataType.LongTypeNullable;
                }
                return DataType.LongType;
            }
            if (t1.equals("double") || t2.equals("double")) {
                if (type1.isNullable() || type2.isNullable()) {
                    return DataType.DoubleTypeNullable;
                }
                return DataType.DoubleType;
            }
            return DataType.NumberType;
        }
        throw new ParseNodeException("error type : " + type1 + "," + type2);
    }

    protected static String checkIfNeedParentheses(CodeItem item) {
        if (item instanceof LineItem) {
            return "(" + item + ")";
        }
        return item.toString();
    }

    protected void adjustType(CodeItem item, DataType newType) throws ParseNodeException {
        if (item == null) {
            return;
        }
        item.adjustType(newType);
        if (item instanceof VarItem && !item.getType().getTypeName().equals("UnknownType")) {
            VarItem var = (VarItem)item;
            this.addVar(var);
        }
        if (item.getRelatedVar() != null) {
            this.adjustType(item.getRelatedVar(), newType);
        }
    }

    protected void adjustVarTypeByTip(ConcurrentHashMap<String, String> types) {
        for (Map.Entry<String, VarItem> entry : this.vars.entrySet()) {
            String ty;
            String name = entry.getKey();
            VarItem item = entry.getValue();
            DataType type = item.getType();
            if (type == null || !type.isType("UnknownType")) continue;
            if (types.containsKey(name)) {
                ty = types.get(name);
                type.setTypeName(ty);
                continue;
            }
            if (!types.containsKey("default")) continue;
            ty = types.get("default");
            type.setTypeName(ty);
        }
    }

    protected void adjustVarType(ConcurrentHashMap<String, VarItem> global) {
        for (Map.Entry<String, VarItem> entry : this.vars.entrySet()) {
            String name = entry.getKey();
            VarItem item = entry.getValue();
            DataType type = item.getType();
            if (type != null && type.isType("UnknownType") && global.containsKey(name)) {
                VarItem gvar = global.get(name);
                type.setTypeName(gvar.getType().getTypeName());
            }
            if (!global.containsKey(name)) continue;
            item.setGlobal(true);
            item.setCell(global.get(name).isCell());
            item.setC(global.get(name).getC());
            item.setR(global.get(name).getR());
        }
    }

    protected void adjustVarType(PgmCellSet cellSet) {
        Context ctx = cellSet.getContext();
        for (Map.Entry<String, VarItem> entry : this.vars.entrySet()) {
            Object obj;
            String name = entry.getKey();
            VarItem item = entry.getValue();
            DataType type = item.getType();
            try {
                obj = item.isCell() ? cellSet.getCell(item.getName()).getValue() : ctx.getParam(name).getValue();
            }
            catch (Exception e) {
                continue;
            }
            DataType newType = NodeParser.getObjectType(obj);
            if (newType == null || newType.isType("UnknownType")) continue;
            type.setTypeName(newType.getTypeName());
            type.setArray(newType.isArray());
        }
    }

    protected String generateExpressionConstVar(String expStr) {
        int id = this.constPool.generateNextId();
        String varName = "expression_" + id;
        String line = String.format("private static final Expression %s = new Expression(%s)", varName, NodeParser.toMacroString(expStr));
        this.constPool.addItem(new LineItem(line));
        return varName;
    }

    protected String generateExpArrConstVar(String[] expStrs) {
        String code = "";
        if (expStrs == null) {
            code = "null";
        } else {
            String[] stringArray = expStrs;
            int n = expStrs.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                code = str == null ? String.valueOf(code) + "null," : String.valueOf(code) + String.format("new Expression(%s),", NodeParser.toMacroString(str));
                ++n2;
            }
            code = "{" + code + "}";
        }
        int id = this.constPool.generateNextId();
        String varName = "expressions_" + id;
        String line = String.format("private static final Expression[] %s = %s", varName, code);
        this.constPool.addItem(new LineItem(line));
        return varName;
    }

    protected String generateStrConstVar(String str) {
        String code = str == null ? "null" : NodeParser.toMacroString(str);
        int id = this.constPool.generateNextId();
        String varName = "string_" + id;
        String line = String.format("private static final String %s = %s", varName, code);
        this.constPool.addItem(new LineItem(line));
        return varName;
    }

    protected String generateStrArrConstVar(String[] strs) {
        String code = "";
        if (strs == null) {
            code = "null";
        } else {
            String[] stringArray = strs;
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                code = String.valueOf(code) + String.format("%s,", NodeParser.toMacroString(str));
                ++n2;
            }
            code = "{" + code + "}";
        }
        int id = this.constPool.generateNextId();
        String varName = "strings_" + id;
        String line = String.format("private static final String[] %s = %s", varName, code);
        this.constPool.addItem(new LineItem(line));
        return varName;
    }

    protected String generateCharArrConstVar(char[] chars) {
        String code = "";
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            code = String.valueOf(code) + String.format("'%c',", Character.valueOf(ch));
            ++n2;
        }
        int id = this.constPool.generateNextId();
        String varName = "chars_" + id;
        String line = String.format("private static final char[] %s = {%s}", varName, code);
        this.constPool.addItem(new LineItem(line));
        return varName;
    }

    protected String generateDataStructConstVar(String[] strs) {
        String code = "";
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            code = String.valueOf(code) + String.format("%s,", NodeParser.toMacroString(str));
            ++n2;
        }
        int id = this.constPool.generateNextId();
        String varName = "ds_" + id;
        String line = String.format("private static final DataStruct %s = new DataStruct(new String[]{%s})", varName, code);
        this.constPool.addItem(new LineItem(line));
        return varName;
    }

    public String generateConstVar(String varTypeName, String varInitStr) {
        int id = this.constPool.generateNextId();
        String varName = String.valueOf(varTypeName) + "_" + id;
        String line = String.format("private static final %s %s = %s", varTypeName, varName, varInitStr);
        this.constPool.addItem(new LineItem(line));
        return varName;
    }

    public String generateConstVar(String varTypeName, String prefix, String varInitStr) {
        int id = this.constPool.generateNextId();
        String varName = String.valueOf(prefix) + "_" + id;
        String line = String.format("private static final %s %s = %s", varTypeName, varName, varInitStr);
        this.constPool.addItem(new LineItem(line));
        return varName;
    }

    public String generatePgmCellSetVar0(PgmCellSet cellSet) {
        String setName = cellSet.getName();
        if (this.cellSetMap.containsKey(setName = new FileObject(setName).getFileName().replace(".", "_"))) {
            return this.cellSetMap.get(setName);
        }
        int id = this.constPool.generateNextId();
        String varName = String.valueOf(setName) + "_" + id;
        String bytesName = String.valueOf(setName) + "_bytes_" + id;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(10240);
            CellSetUtil.writePgmCellSet((OutputStream)os, (PgmCellSet)cellSet);
            os.close();
            byte[] bytes = os.toByteArray();
            String bytesStr = "";
            int i = 0;
            int len = bytes.length;
            while (i < len) {
                byte by = bytes[i];
                bytesStr = String.valueOf(bytesStr) + by + ", ";
                if (i % 32 == 0) {
                    bytesStr = String.valueOf(bytesStr) + System.lineSeparator();
                }
                ++i;
            }
            String line = String.format("private static final byte[] %s = {%s}", bytesName, bytesStr);
            this.constPool.addItem(new LineItem(line));
            line = String.format("private static final PgmCellSet %s = FunLib.loadCellSet(%s)", varName, bytesName);
            this.constPool.addItem(new LineItem(line));
        }
        catch (Exception e) {
            throw new RQException((Throwable)e);
        }
        this.cellSetMap.put(setName, varName);
        return varName;
    }

    public String generatePgmCellSetVar(PgmCellSet cellSet) {
        String setName = cellSet.getName();
        if (this.cellSetMap.containsKey(setName = new FileObject(setName).getFileName().replace(".", "_"))) {
            return this.cellSetMap.get(setName);
        }
        int id = this.constPool.generateNextId();
        String varName = String.valueOf(setName) + "_" + id;
        String line = String.format("private static final PgmCellSet %s = FunLib.loadCellSet(\"%s\")", varName, cellSet.getName());
        this.constPool.addItem(new LineItem(line));
        this.cellSetMap.put(setName, varName);
        return varName;
    }

    private CodeItem parseIfn(IParam params) throws ParseNodeException {
        CodeItem[] items = this.parseParams0(params);
        String result = "null";
        int i = items.length - 1;
        while (i >= 0) {
            String itemRef = items[i].toString();
            if (!itemRef.equals("null")) {
                result = i == items.length - 1 ? itemRef : String.format("FunLib.ifn(%s, %s)", itemRef, result);
                if (items[i] instanceof VarItem) {
                    this.setVarType(((VarItem)items[i]).getName(), DataType.toNullable(items[i].getType()));
                }
            }
            --i;
        }
        DataType ty = null;
        int i2 = 0;
        int size = items.length;
        while (i2 < size) {
            ty = NodeParser.calcMinType(ty, items[i2].getType());
            ++i2;
        }
        return new LineItem(result, ty, DataType.ObjectType);
    }

    public CodeItem[] parseParams0(IParam param) throws ParseNodeException {
        if (param.isLeaf()) {
            CodeItem item = this.parse(param.getLeafExpression().getHome());
            return new CodeItem[]{item};
        }
        int size = param.getSubSize();
        CodeItem[] items = new CodeItem[size];
        int i = 0;
        while (i < size) {
            IParam sub = param.getSub(i);
            if (sub == null) {
                throw new ParseNodeException(param.toString());
            }
            items[i] = this.parse(sub.getLeafExpression().getHome());
            ++i;
        }
        return items;
    }

    protected CodeItem parseParams(IParam param, PgmCellSet.FuncInfo funcInfo) throws ParseNodeException {
        int i;
        if (param == null) {
            return new LineItem("");
        }
        int size = param.getSubSize();
        CodeItem[] items = new CodeItem[size];
        DataType ty = null;
        boolean[] isMacroArg = new boolean[size];
        if (funcInfo != null) {
            i = 0;
            while (i < size) {
                isMacroArg[i] = funcInfo.isMacroArg(i);
                ++i;
            }
        }
        if (param.isLeaf()) {
            return this.parse(param.getLeafExpression().getHome());
        }
        i = 0;
        while (i < size) {
            IParam sub = param.getSub(i);
            if (sub == null) {
                throw new ParseNodeException(param.toString());
            }
            items[i] = isMacroArg[i] ? this.parse((Node)new Constant((Object)sub.getLeafExpression().toString())) : this.parse(sub.getLeafExpression().getHome());
            ty = NodeParser.calcCommonType(ty, items[i].getType());
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < items.length) {
            sb.append(items[i2].toString());
            if (i2 < items.length - 1) {
                sb.append(",");
            }
            ++i2;
        }
        String line = sb.toString();
        return new LineItem(line, ty);
    }

    public CodeItem parse(Node node) throws ParseNodeException {
        Node left = node.getLeft();
        Node right = node.getRight();
        if (node instanceof DotOperator) {
            if (right instanceof FieldRef) {
                CodeItem s2r = this.parse(left);
                String fieldName = ((FieldRef)right).getName();
                if (s2r.getType().getStructType() == null) {
                    String line = String.format("OperatorLib.fieldRef(%s, \"%s\", ctx)", s2r, fieldName);
                    return new LineItem(line, DataType.ObjectType);
                }
                DataType type = s2r.getType().getStructType().getFieldType(fieldName);
                type = DataType.toNullable(type);
                if (s2r.getType().isType("BaseRecord")) {
                    String idxStr = s2r.getType().getStructType().getFieldIndexStr(fieldName);
                    String line = String.format("FunLib.getField(%s, %s)", s2r.cast("BaseRecord"), idxStr);
                    return new LineItem(line, type, DataType.ObjectType);
                }
                String line = String.format("OperatorLib.fieldRef(%s, \"%s\", ctx)", s2r, fieldName);
                return new LineItem(line, type, DataType.ObjectType);
            }
            if (right instanceof SequenceFunction) {
                CodeItem leftItem = this.parse(left);
                if (leftItem.getType().isType("int") || leftItem.getType().isType("Integer")) {
                    leftItem = new LineItem("FunLib.To(" + leftItem + ")", DataType.newSequenceType(leftItem.getType()));
                }
                return SequenceNodeParser.parseNode(this, (SequenceFunction)right, leftItem);
            }
            if (right instanceof StringFunction) {
                CodeItem leftItem = this.parse(left);
                return StringFunctionParser.parseNode(this, (StringFunction)right, leftItem);
            }
            if (right instanceof RecordFunction) {
                CodeItem leftItem = this.parse(left);
                return RecordFunctionParser.parseNode(this, (RecordFunction)right, leftItem);
            }
            if (right instanceof FileFunction) {
                CodeItem leftItem = this.parse(left);
                return FileFunctionParser.parseNode(this, (FileFunction)right, leftItem);
            }
            if (right instanceof TableFunction) {
                CodeItem leftItem = this.parse(left);
                return TableFunctionParser.parseNode(this, (TableFunction)right, leftItem);
            }
            if (right instanceof Calc) {
                if (((Calc)right).getOption() != null) {
                    throw new ParseNodeException("todo");
                }
                Expression exp = ((Calc)right).getParam().getLeafExpression();
                return CodeMaker.generateCalc(this, this.parse(left), exp);
            }
            if (right instanceof CreateCursor) {
                String funName = "cursor";
                CodeItem leftItem = this.parse(node.getLeft());
                return FunctionNodeParser.parseCommonMFN(this, (Function)right, leftItem, funName, DataType.ICURSOR);
            }
            if (right instanceof Fetch) {
                CodeItem leftItem = this.parse(node.getLeft());
                return CursorFunctionNodeParser.parseNode(this, (Function)right, leftItem);
            }
            if (right instanceof CurrentElement) {
                String leftName;
                if (left instanceof UnknownSymbol) {
                    leftName = NodeParser.getVarName((UnknownSymbol)left);
                } else if (left instanceof CSVariable) {
                    leftName = NodeParser.getVarName((CSVariable)left);
                } else if (left instanceof VarParam) {
                    leftName = ((VarParam)left).getParam().getName();
                } else {
                    throw new ParseNodeException(left.toString());
                }
                return this.searchCur(leftName);
            }
            if (right instanceof CurrentSeq) {
                String leftName;
                if (left instanceof UnknownSymbol) {
                    leftName = NodeParser.getVarName((UnknownSymbol)left);
                } else if (left instanceof CSVariable) {
                    leftName = NodeParser.getVarName((CSVariable)left);
                } else if (left instanceof VarParam) {
                    leftName = ((VarParam)left).getParam().getName();
                } else {
                    throw new ParseNodeException(left.toString());
                }
                return this.searchCurSeq(leftName);
            }
            throw new ParseNodeException(right.toString());
        }
        if (node instanceof Assign) {
            String leftName;
            if (left instanceof UnknownSymbol) {
                leftName = NodeParser.getVarName((UnknownSymbol)left);
            } else if (left instanceof CSVariable) {
                leftName = NodeParser.getVarName((CSVariable)left);
            } else if (left instanceof VarParam) {
                leftName = ((VarParam)left).getParam().getName();
            } else {
                if (left instanceof CurrentElement) {
                    CodeItem rightItem = this.parse(right);
                    if (this.curContext == null) {
                        throw new ParseNodeException(node.toString());
                    }
                    String line = this.curContext.formatCurAssign(rightItem);
                    return new LineItem(line, DataType.VoidType);
                }
                if (left instanceof ElementRef) {
                    CodeItem rightItem = this.parse(right);
                    CodeItem leftItem = this.parseElementRef((ElementRef)left);
                    if (rightItem.getType() != null) {
                        this.adjustType(leftItem, rightItem.getType());
                    }
                    return leftItem.makeAssign(rightItem);
                }
                if (left instanceof Assign) {
                    Assign n = new Assign();
                    n.setLeft(left.getRight());
                    n.setRight(right);
                    CodeItem valueItem1 = this.parse((Node)n);
                    n = new Assign();
                    n.setLeft(left.getLeft());
                    n.setRight(right);
                    this.parse((Node)n);
                    CodeItem leftItem0 = this.parse(left.getLeft());
                    return leftItem0.makeAssign(valueItem1);
                }
                throw new ParseNodeException(left.toString());
            }
            CodeItem rightItem = this.parse(right);
            VarItem leftItem = this.searchVarInCurContext(leftName);
            if (leftItem == null) {
                leftItem = this.findVar(leftName);
            }
            if (leftItem == null) {
                VarItem vi = new VarItem(leftName, rightItem.getType());
                if (left instanceof CSVariable) {
                    CSVariable csv = (CSVariable)left;
                    vi.setCell(true);
                    vi.setR(csv.getSourceCell().getRow());
                    vi.setC(csv.getSourceCell().getCol());
                }
                leftItem = this.addVar(vi);
            }
            this.assignVars.add(leftItem);
            if (leftItem.isField()) {
                String line = this.curContext.formatFieldRefAssign(leftName, rightItem);
                LineItem item = new LineItem(line, rightItem.getType(), DataType.ObjectType);
                item.setPreItem(rightItem.getPreItem());
                return item;
            }
            return leftItem.makeAssign(rightItem);
        }
        if (node instanceof UnknownSymbol) {
            String varName = NodeParser.getVarName((UnknownSymbol)node);
            DataType type = this.getVarType(varName);
            VarItem varItem = this.getVar(varName);
            if (varItem == null) {
                varItem = new VarItem(varName, type, null);
            }
            if (this.curContext != null && this.curContext.getStructType() != null && this.curContext.getStructType().hasField(varName)) {
                varItem = this.curContext.getStructType().getFieldVar(varName);
                varItem.setCurContext(this.curContext);
                return varItem;
            }
            if (!this.funCodeMap.containsKey(varName) && !this.hasVar(varName)) {
                varItem = this.addVar(varItem);
            }
            return varItem;
        }
        if (node instanceof VarParam) {
            String var = NodeParser.getVarName((VarParam)node);
            DataType type = this.getVarType(var);
            VarItem varItem = new VarItem(var, type, null);
            if (!this.hasVar(var)) {
                varItem = this.addVar(varItem);
            }
            return varItem;
        }
        if (node instanceof CurrentCell) {
            String cellName = this.cell.getCellId();
            VarItem var = this.getVar(cellName);
            if (var == null) {
                var = new VarItem(cellName);
                var.setCell(true);
                var.refCountIncrease();
                return this.addVar(var);
            }
            var.refCountIncrease();
            return var;
        }
        if (node instanceof CSVariable) {
            String var = NodeParser.getVarName((CSVariable)node);
            VarItem item = this.vars.get(var);
            if (item == null && (item = this.searchVarInStack(var)) != null) {
                item.setGlobal(true);
            }
            if (item == null) {
                item = new VarItem(var, null);
                item.setCell(true);
                item = this.addVar(item);
                return item;
            }
            item.refCountIncrease();
            return item;
        }
        if (node instanceof Operator) {
            return OperatorParser.parseNode(node, this);
        }
        if (node instanceof ForCellCurSeq) {
            if (this.curContext == null) {
                throw new ParseNodeException(node.toString());
            }
            return new LineItem(this.curContext.getSeq(), DataType.IntType);
        }
        if (node instanceof CurrentElement) {
            if (this.curContext == null) {
                throw new ParseNodeException(node.toString());
            }
            return new LineItem(this.curContext.formatCur(), this.curContext.getMemberType(), DataType.ObjectType);
        }
        if (node instanceof CurrentSeq) {
            if (this.curContext == null) {
                throw new ParseNodeException(node.toString());
            }
            return new LineItem(this.curContext.getSeq(), DataType.IntType);
        }
        if (node instanceof Constant) {
            Object obj = node.calculate(null);
            if (obj == null) {
                return LineItem.NULL;
            }
            if (obj instanceof Double || obj instanceof Float) {
                double value = ((Number)obj).doubleValue();
                if (value == Double.NEGATIVE_INFINITY) {
                    return ConstItem.NEGATIVE_INFINITY;
                }
                if (value == Double.POSITIVE_INFINITY) {
                    return ConstItem.POSITIVE_INFINITY;
                }
                if (value == Double.NaN) {
                    return ConstItem.NaN;
                }
            }
            if (obj instanceof String) {
                return new ConstItem(this.generateStrConstVar((String)obj), DataType.StringType, obj);
            }
            return new ConstItem(obj.toString(), NodeParser.getObjectType(obj), obj);
        }
        if (node instanceof ValueList) {
            return this.parseValueList((ValueList)node);
        }
        if (node instanceof ElementRef) {
            return this.parseElementRef((ElementRef)node);
        }
        if (node instanceof PCSFunction) {
            String fname = ((PCSFunction)node).getFuncInfo().getFnName();
            CodeItem func = this.funCodeMap.get(fname);
            if (func instanceof FunCodeItem) {
                if (((FunCodeItem)func).isCompiling()) {
                    CodeItem item = this.parseParams(((PCSFunction)node).getParam(), ((PCSFunction)node).getFuncInfo());
                    return new LineItem(String.valueOf(fname) + "(" + item + ")", DataType.ObjectType);
                }
                PgmCellSet.FuncInfo info = ((FunCodeItem)func).getFunc();
                ((FunCodeItem)func).setCompiling(true);
                return FunctionNodeParser.parsePCSFunction(this, (Function)((PCSFunction)node), info);
            }
            DataType dt = func == null ? null : func.getType();
            CodeItem item = this.parseParams(((PCSFunction)node).getParam(), ((PCSFunction)node).getFuncInfo());
            return new LineItem(String.valueOf(fname) + "(" + item + ")", dt);
        }
        if (node instanceof Ifn) {
            IParam param = ((Ifn)node).getParam();
            return this.parseIfn(param);
        }
        if (node instanceof ToInteger) {
            IParam param = ((ToInteger)node).getParam();
            if (param == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("int" + mm.getMessage("function.missingParam"));
            }
            if (!param.isLeaf()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("int" + mm.getMessage("function.invalidParam"));
            }
            CodeItem item = this.parse(param.getLeafExpression().getHome());
            if (item.getType().isType("int")) {
                return item;
            }
            return new LineItem(String.format("FunLib.ToInteger(%s)", item), DataType.IntTypeNullable);
        }
        if (node instanceof Function) {
            return FunctionNodeParser.parseNode(this, (Function)node);
        }
        throw new ParseNodeException(node.toString());
    }

    protected static boolean isValidVariableName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        char firstChar = name.charAt(0);
        if (!Character.isLetter(firstChar) && firstChar != '_') {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private CodeItem parseElementRef(ElementRef node) throws ParseNodeException {
        CodeItem left = this.parse(node.getLeft());
        if (left == null) {
            return null;
        }
        String line = left.toString();
        if (this.funCodeMap.containsKey(left.toString())) {
            CodeItem func = this.funCodeMap.get(left.toString());
            PgmCellSet.FuncInfo info = null;
            if (func instanceof FunCodeItem) {
                info = ((FunCodeItem)func).getFunc();
                return FunctionNodeParser.parsePCSFunction(this, (Function)node, info);
            }
            CodeItem item = this.parseParams(node.getParam(), info);
            return new LineItem(String.valueOf(left.toString()) + "(" + item + ")", func.getType());
        }
        if (left.getType() == null || left.getType().getMemberType() == null) {
            throw new ParseNodeException(node.toString());
        }
        CodeItem idxNode = this.parse(node.getExp().getHome());
        if (!NodeParser.isValidVariableName(line)) {
            line = "(" + line + ")";
        }
        if (idxNode.getType().isType("Sequence")) {
            line = String.valueOf(line) + ".get(" + idxNode + ")";
            LineItem item = new LineItem(line, left.getType(), DataType.ObjectType);
            String assignStr = String.format("SequenceLib.elementAssign(%s,%s,%%s)", left, idxNode);
            item.setAssignStr(assignStr);
            return item;
        }
        line = String.valueOf(line) + ".get(" + idxNode.cast() + ")";
        if (!left.getType().getMemberType().isType("Object")) {
            line = "(" + left.getType().getMemberType() + ")" + line;
        }
        LineItem item = new LineItem(line, left.getType().getMemberType(), DataType.ObjectType);
        String assignStr = String.format("(%s).set(%s, %%s)", left, idxNode.cast());
        item.setAssignStr(assignStr);
        return item;
    }

    static boolean isConstValue(IParam param) {
        if (param == null) {
            return true;
        }
        if (param.isLeaf()) {
            Node home = param.getLeafExpression().getHome();
            if (home instanceof ValueList) {
                return NodeParser.isConstValue(((Function)home).getParam());
            }
            return home instanceof Constant;
        }
        char type = param.getType();
        if (type == ',' || type == ':') {
            int i = 0;
            while (i < param.getSubSize()) {
                if (!NodeParser.isConstValue(param.getSub(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean containVars(IParam param) {
        if (param == null) {
            return false;
        }
        if (!param.isLeaf()) {
            int size = param.getSubSize();
            int i = 0;
            while (i < size) {
                if (this.containVars(param.getSub(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        Expression exp = param.getLeafExpression();
        String expStr = exp.toString();
        if (expStr == null) {
            return false;
        }
        List<VarItem> list = this.getAllVars();
        for (VarItem var : list) {
            if (expStr.indexOf(var.getName()) == -1) continue;
            return true;
        }
        return (expStr.indexOf("~") != -1 || expStr.indexOf("#") != -1) && this.curContext != null;
    }

    public void searchVarsInParam(IParam param, List<VarItem> vars) {
        if (param == null) {
            return;
        }
        if (!param.isLeaf()) {
            int size = param.getSubSize();
            int i = 0;
            while (i < size) {
                this.searchVarsInParam(param.getSub(i), vars);
                ++i;
            }
            return;
        }
        Expression exp = param.getLeafExpression();
        String expStr = exp.toString();
        if (expStr == null) {
            return;
        }
        List<VarItem> list = this.getAllVars();
        for (VarItem var : list) {
            if (expStr.indexOf(var.getName()) == -1 || vars.contains(var)) continue;
            vars.add(var);
        }
    }

    protected static CodeItem sequenceToCode(Sequence seq) {
        DataType ty = null;
        StringBuilder sb = new StringBuilder();
        sb.append("new Sequence(new Object[] { ");
        int i = 1;
        int len = seq.length();
        while (i <= len) {
            Object obj = seq.get(i);
            if (i != 1) {
                sb.append(", ");
            }
            if (obj instanceof Sequence) {
                CodeItem item = NodeParser.sequenceToCode((Sequence)obj);
                ty = NodeParser.calcCommonType(ty, item.getType());
                sb.append(item);
            } else {
                ty = NodeParser.calcCommonType(ty, NodeParser.getObjectType(obj));
                if (obj instanceof String) {
                    sb.append(NodeParser.toMacroString((String)obj));
                } else {
                    sb.append(obj);
                }
            }
            ++i;
        }
        if (ty == null) {
            ty = DataType.ObjectType;
        }
        sb.append(" })");
        String line = sb.toString();
        return new LineItem(line, DataType.newSequenceType(ty));
    }

    static String[] getRange(String start, String end) {
        int sCol = start.charAt(0) - 65;
        int eCol = end.charAt(0) - 65;
        int sRow = Integer.parseInt(start.substring(1));
        int eRow = Integer.parseInt(end.substring(1));
        int total = (eCol - sCol + 1) * (eRow - sRow + 1);
        String[] result = new String[total];
        int idx = 0;
        int c = sCol;
        while (c <= eCol) {
            char col = (char)(65 + c);
            int r = sRow;
            while (r <= eRow) {
                result[idx++] = String.valueOf(col) + String.valueOf(r);
                ++r;
            }
            ++c;
        }
        return result;
    }

    private CodeItem parseValueList(ValueList node) throws ParseNodeException {
        IParam param = node.getParam();
        if (NodeParser.isConstValue(param)) {
            CodeItem item = NodeParser.sequenceToCode((Sequence)node.calculate(null));
            String line = item.toString();
            return new LineItem(line, item.getType());
        }
        char type = param.getType();
        if (type == '\u0000') {
            Expression exp = param.getLeafExpression();
            CodeItem item = this.parse(exp.getHome());
            DataType ty = item.getType();
            String line = String.format("new Sequence(new Object[]{%s})", item);
            return new LineItem(line, DataType.newSequenceType(ty));
        }
        if (type == ',') {
            int size = param.getSubSize();
            DataType ty = null;
            String line = "new Sequence(new Object[]{";
            int i = 0;
            while (i < size) {
                IParam sub = param.getSub(i);
                if (sub == null) {
                    line = String.valueOf(line) + "null, ";
                    ty = DataType.ObjectType;
                } else if (sub.isLeaf()) {
                    Expression exp = sub.getLeafExpression();
                    CodeItem item = this.parse(exp.getHome());
                    line = String.valueOf(line) + item.toString() + ",";
                    ty = NodeParser.calcCommonType(ty, item.getType());
                } else {
                    throw new ParseNodeException(node.toString());
                }
                ++i;
            }
            line = String.valueOf(line) + "})";
            return new LineItem(line, DataType.newSequenceType(ty));
        }
        if (type == ':') {
            String start = param.getSub(0).getLeafExpression().toString();
            String end = param.getSub(1).getLeafExpression().toString();
            String[] cells = NodeParser.getRange(start, end);
            DataType ty = null;
            String line = "new Sequence(new Object[]{";
            int i = 0;
            int size = cells.length;
            while (i < size) {
                VarItem item = this.getVar(cells[i]);
                line = String.valueOf(line) + ((Object)item).toString() + ",";
                ty = NodeParser.calcCommonType(ty, ((CodeItem)item).getType());
                ++i;
            }
            line = String.valueOf(line) + "})";
            return new LineItem(line, DataType.newSequenceType(ty));
        }
        throw new ParseNodeException(node.toString());
    }

    private void splitParam(IParam param, List<Character> seps, List<String> items) throws ParseNodeException {
        if (param == null) {
            return;
        }
        if (param.isLeaf()) {
            Node node = param.getLeafExpression().getHome();
            if (node instanceof UnknownSymbol) {
                items.add(NodeParser.getVarName((UnknownSymbol)node));
            } else {
                items.add(this.parse(node).toString());
            }
        } else {
            int size = param.getSubSize();
            char sep = param.getType();
            int i = 0;
            while (i < size) {
                IParam sub = param.getSub(i);
                if (sub == null) {
                    items.add("null");
                    seps.add(Character.valueOf(sep));
                } else {
                    this.splitParam(sub, seps, items);
                    seps.add(Character.valueOf(sep));
                }
                ++i;
            }
        }
    }

    protected CodeItem parseFunctionToGeneric(Function node, CodeItem left, String funName, DataType returnType, NodeParser parser) throws ParseNodeException {
        String funStr;
        int i;
        IParam param = node.getParam();
        String option = NodeParser.toMacroString(node.getOption());
        String sepStr = "null";
        ArrayList<Character> seps = new ArrayList<Character>();
        ArrayList<String> items = new ArrayList<String>();
        boolean optionNull = option.equals("null");
        if (param != null && !this.containVars(param)) {
            String paramStr = NodeParser.toMacroString(node.getParamString());
            String line = left == null ? String.format("FunctionExecutor.calculateFN(\"%s\", %s, %s)", funName, option, paramStr) : String.format("FunctionExecutor.calculateMFN(%s, \"%s\", %s, %s)", "left", funName, option, paramStr);
            int seq = parser.constPool.generateNextId();
            String tempFunName = String.valueOf(funName) + "__" + seq;
            String funStr2 = left == null ? String.format("private static %s %s(){return (%s) %s;}", returnType, tempFunName, returnType, line) : String.format("private static %s %s(Object left){return (%s) %s;}", returnType, tempFunName, returnType, line);
            parser.funCodeMap.put(tempFunName, new LineItem(funStr2));
            line = left == null ? String.valueOf(tempFunName) + "()" : String.valueOf(tempFunName) + "(" + left + ")";
            return new LineItem(line, returnType);
        }
        this.splitParam(param, seps, items);
        if (seps.size() > 0) {
            int size = seps.size();
            char[] sepArr = new char[size];
            i = 0;
            while (i < size) {
                sepArr[i] = ((Character)seps.get(i)).charValue();
                ++i;
            }
            sepStr = this.generateCharArrConstVar(sepArr);
        }
        String objStr = "";
        String objStr2 = "null";
        if (items.size() > 0) {
            objStr = String.join((CharSequence)",", items);
            objStr2 = "";
            i = 0;
            while (i < items.size()) {
                objStr2 = i == 0 ? String.valueOf(objStr2) + "obj" + i : String.valueOf(objStr2) + ",obj" + i;
                ++i;
            }
        }
        String line = left == null ? (param == null ? String.format("FunctionExecutor.calculateFN(\"%s\", %s)", funName, option) : String.format("FunctionExecutor.calculateFN(\"%s\", %s, %s, %s)", funName, option, sepStr, objStr2)) : (param == null ? (!optionNull ? String.format("FunctionExecutor.calculateMFN(%s, \"%s\", %s)", "left", funName, option) : String.format("FunctionExecutor.calculateMFN(%s, \"%s\")", "left", funName)) : String.format("FunctionExecutor.calculateMFN(%s, \"%s\", %s, %s, %s)", "left", funName, option, sepStr, objStr2));
        int seq = parser.constPool.generateNextId();
        String tempFunName = String.valueOf(funName) + "__" + seq;
        String tempParam = "";
        int i2 = 0;
        while (i2 < items.size()) {
            if (i2 != 0) {
                tempParam = String.valueOf(tempParam) + ",";
            }
            tempParam = String.valueOf(tempParam) + "Object obj" + i2;
            ++i2;
        }
        if (left == null) {
            funStr = String.format("private static %s %s(%s){return (%s) %s;}", returnType, tempFunName, tempParam, returnType, line);
        } else {
            if (tempParam.length() > 0) {
                tempParam = "," + tempParam;
            }
            funStr = String.format("private static %s %s(Object left %s){return (%s) %s;}", returnType, tempFunName, tempParam, returnType, line);
        }
        parser.funCodeMap.put(tempFunName, new LineItem(funStr));
        if (left == null) {
            line = String.valueOf(tempFunName) + "(" + objStr + ")";
        } else {
            if (objStr.length() > 0) {
                objStr = "," + objStr;
            }
            line = String.valueOf(tempFunName) + "(" + left + objStr + ")";
        }
        return new LineItem(line, returnType);
    }

    public CodeItem compileNode(Node node, PgmNormalCell cell) throws ParseNodeException {
        this.cell = cell;
        CodeItem item = this.parse(node);
        if (this.retry) {
            item = this.parse(node);
            this.retry = false;
        }
        return item;
    }

    public void setRetry(boolean b) {
        this.retry = b;
    }
}

