/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.parser;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.compile.AssignItem;
import com.scudata.compile.CodeItem;
import com.scudata.compile.CompilerUtil;
import com.scudata.compile.ConstItem;
import com.scudata.compile.DataType;
import com.scudata.compile.LineItem;
import com.scudata.compile.ParseNodeException;
import com.scudata.compile.VarItem;
import com.scudata.compile.parser.NodeParser;
import com.scudata.expression.Node;
import com.scudata.expression.operator.Add;
import com.scudata.expression.operator.AddAssign;
import com.scudata.expression.operator.And;
import com.scudata.expression.operator.Comma;
import com.scudata.expression.operator.Conj;
import com.scudata.expression.operator.ConjAssign;
import com.scudata.expression.operator.Diff;
import com.scudata.expression.operator.Divide;
import com.scudata.expression.operator.DivideAssign;
import com.scudata.expression.operator.Equals;
import com.scudata.expression.operator.Greater;
import com.scudata.expression.operator.ISect;
import com.scudata.expression.operator.ISectAssign;
import com.scudata.expression.operator.IntDivideAssign;
import com.scudata.expression.operator.MemAdd;
import com.scudata.expression.operator.MemDivide;
import com.scudata.expression.operator.MemIntDivide;
import com.scudata.expression.operator.MemMod;
import com.scudata.expression.operator.MemMultiply;
import com.scudata.expression.operator.MemSubtract;
import com.scudata.expression.operator.Mod;
import com.scudata.expression.operator.ModAssign;
import com.scudata.expression.operator.Multiply;
import com.scudata.expression.operator.MultiplyAssign;
import com.scudata.expression.operator.Negative;
import com.scudata.expression.operator.Not;
import com.scudata.expression.operator.NotEquals;
import com.scudata.expression.operator.NotGreater;
import com.scudata.expression.operator.NotSmaller;
import com.scudata.expression.operator.Or;
import com.scudata.expression.operator.Plus;
import com.scudata.expression.operator.Smaller;
import com.scudata.expression.operator.Subtract;
import com.scudata.expression.operator.SubtractAssign;
import com.scudata.expression.operator.Union;
import com.scudata.expression.operator.UnionAssign;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;

public class OperatorParser {
    public static DataType ifHasSequenceType(DataType type1, DataType type2) {
        if (type1.isType("Sequence")) {
            return type1;
        }
        if (type2.isType("Sequence")) {
            return type2;
        }
        return null;
    }

    private static String toBoolString(CodeItem item) {
        if (item.getType().isType("boolean")) {
            return item.toString();
        }
        return "Variant.isTrue(" + item + ")";
    }

    private static String formatTypeStr(DataType type) {
        if (type.isType("Object")) {
            return "";
        }
        return "(" + type + ")";
    }

    private static String getRelationSymbol(Node relation) throws ParseNodeException {
        if (relation instanceof Greater) {
            return ">";
        }
        if (relation instanceof NotGreater) {
            return "<=";
        }
        if (relation instanceof Smaller) {
            return "<";
        }
        if (relation instanceof NotSmaller) {
            return ">=";
        }
        if (relation instanceof Equals) {
            return "==";
        }
        if (relation instanceof NotEquals) {
            return "!=";
        }
        throw new ParseNodeException(relation.toString());
    }

    private static String makeDefaultCompareCode(CodeItem left, CodeItem right, String op) throws ParseNodeException {
        String line;
        if (">".equals(op)) {
            line = "(Variant.compare(" + left + ", " + right + ") > 0)";
        } else if ("<".equals(op)) {
            line = "(Variant.compare(" + left + ", " + right + ") < 0)";
        } else if (">=".equals(op)) {
            line = "(Variant.compare(" + left + ", " + right + ") >= 0)";
        } else if ("<=".equals(op)) {
            line = "(Variant.compare(" + left + ", " + right + ") <= 0)";
        } else if ("==".equals(op)) {
            line = "(Variant.compare(" + left + ", " + right + ") == 0)";
        } else if ("!=".equals(op)) {
            line = "(Variant.compare(" + left + ", " + right + ") != 0)";
        } else {
            throw new ParseNodeException("Unsupported operator for Object: " + op);
        }
        return line;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static CodeItem makeCompareCode2(CodeItem left, CodeItem right, String op) throws ParseNodeException {
        String line;
        DataType ty1 = left.getType();
        DataType ty2 = right.getType();
        if (op.equals("==") && (left.toString().equals("null") || right.toString().equals("null"))) {
            String line2 = left + "==" + right;
            return new LineItem(line2, DataType.BooleanType);
        }
        if ((ty1.isNullable() || ty2.isNullable()) && !ty1.equalTo(ty2)) {
            line = OperatorParser.makeDefaultCompareCode(left, right, op);
            return new LineItem(line, DataType.BooleanType);
        } else {
            String typeName1 = ty1.getTypeName();
            String typeName2 = ty2.getTypeName();
            if (ty1.isNumber() && ty2.isNumber() && typeName1.equals(typeName2)) {
                if ("double".equals(typeName1)) {
                    if ("==".equals(op)) {
                        line = "(Double.compare(" + left + ", " + right + ") == 0)";
                        return new LineItem(line, DataType.BooleanType);
                    } else if ("!=".equals(op)) {
                        line = "(Double.compare(" + left + ", " + right + ") != 0)";
                        return new LineItem(line, DataType.BooleanType);
                    } else if (">=".equals(op)) {
                        line = "(Double.compare(" + left + ", " + right + ") >= 0)";
                        return new LineItem(line, DataType.BooleanType);
                    } else if ("<=".equals(op)) {
                        line = "(Double.compare(" + left + ", " + right + ") <= 0)";
                        return new LineItem(line, DataType.BooleanType);
                    } else if (">".equals(op)) {
                        line = "(" + left + " > " + right + ")";
                        return new LineItem(line, DataType.BooleanType);
                    } else {
                        if (!"<".equals(op)) throw new ParseNodeException("Unsupported operator for double: " + op);
                        line = "(" + left + " < " + right + ")";
                    }
                    return new LineItem(line, DataType.BooleanType);
                } else if ("Double".equals(typeName1)) {
                    if ("==".equals(op)) {
                        line = "(MathLib.compare(" + left.cast("Double") + ", " + right.cast("Double") + ") == 0)";
                        return new LineItem(line, DataType.BooleanType);
                    } else if ("!=".equals(op)) {
                        line = "(MathLib.compare(" + left.cast("Double") + ", " + right.cast("Double") + ") != 0)";
                        return new LineItem(line, DataType.BooleanType);
                    } else if (">=".equals(op)) {
                        line = "(MathLib.compare(" + left.cast("Double") + ", " + right.cast("Double") + ") >= 0)";
                        return new LineItem(line, DataType.BooleanType);
                    } else if ("<=".equals(op)) {
                        line = "(MathLib.compare(" + left.cast("Double") + ", " + right.cast("Double") + ") <= 0)";
                        return new LineItem(line, DataType.BooleanType);
                    } else if (">".equals(op)) {
                        line = "(MathLib.compare(" + left.cast("Double") + ", " + right.cast("Double") + ") > 0)";
                        return new LineItem(line, DataType.BooleanType);
                    } else {
                        if (!"<".equals(op)) throw new ParseNodeException("Unsupported operator for double: " + op);
                        line = "(MathLib.compare(" + left.cast("Double") + ", " + right.cast("Double") + ") < 0)";
                    }
                    return new LineItem(line, DataType.BooleanType);
                } else if ("int".equals(typeName1) || "long".equals(typeName1)) {
                    line = "(" + left.cast() + " " + op + " " + right.cast() + ")";
                    return new LineItem(line, DataType.BooleanType);
                } else {
                    if ("boolean".equals(typeName1)) {
                        if (!"==".equals(op) && !"!=".equals(op)) throw new ParseNodeException("Unsupported operator for boolean: " + op);
                        String line3 = "(" + left + " " + op + " " + right + ")";
                        throw new ParseNodeException("Unsupported operator for boolean: " + op);
                    }
                    line = OperatorParser.makeDefaultCompareCode(left, right, op);
                }
                return new LineItem(line, DataType.BooleanType);
            } else {
                line = OperatorParser.makeDefaultCompareCode(left, right, op);
            }
        }
        return new LineItem(line, DataType.BooleanType);
    }

    private static CodeItem parseRelation(Node op, CodeItem leftItem, CodeItem rightItem, boolean isNumber) throws ParseNodeException {
        String symbol = OperatorParser.getRelationSymbol(op);
        if (isNumber) {
            String line = OperatorParser.makeCompareCode(leftItem, rightItem, symbol);
            return new LineItem(line, DataType.BooleanType);
        }
        if (leftItem.getType().isType("Date") && rightItem.getType().isType("Date")) {
            String line = "MathLib.compare(" + leftItem.cast() + ", " + rightItem.cast() + ")" + symbol + "0";
            return new LineItem(line, DataType.BooleanType);
        }
        String line = OperatorParser.makeDefaultCompareCode(leftItem, rightItem, symbol);
        return new LineItem(line, DataType.BooleanType, DataType.ObjectType);
    }

    public static CodeItem parseNode(Node op, NodeParser parser) throws ParseNodeException {
        CodeItem leftItem = op.getLeft() == null ? null : parser.parse(op.getLeft());
        CodeItem rightItem = parser.parse(op.getRight());
        boolean isNullable = false;
        boolean isSameType = false;
        boolean isNumber = false;
        boolean isOptimizable = false;
        if (rightItem.getType().isNullable() || leftItem != null && leftItem.getType().isNullable()) {
            isNullable = true;
        }
        if (leftItem != null && leftItem.getType().equalTo(rightItem.getType())) {
            isSameType = true;
        }
        if (leftItem != null && leftItem.getType().isNumber() && rightItem.getType().isNumber()) {
            isNumber = !leftItem.getType().isType("Number") && !rightItem.getType().isType("Number");
        }
        if (!isNullable && isNumber) {
            isOptimizable = true;
        }
        if (op instanceof Greater || op instanceof NotGreater || op instanceof NotSmaller || op instanceof Smaller || op instanceof Equals || op instanceof NotEquals) {
            return OperatorParser.parseRelation(op, leftItem, rightItem, isNumber);
        }
        if (op instanceof Not) {
            if (isNullable) {
                return new LineItem("Variant.isFalse(" + rightItem + ")", DataType.BooleanType);
            }
            return new LineItem("!(" + rightItem + ")", DataType.BooleanType);
        }
        if (op instanceof Negative) {
            if (rightItem.getType().isNumber() && rightItem instanceof ConstItem) {
                String line = Variant.negate((Object)((ConstItem)rightItem).getValue()).toString();
                line = "(" + line + ")";
                return new LineItem(line, rightItem.getType());
            }
            if (rightItem.getType().isNumber() && rightItem instanceof VarItem) {
                String line = "(-" + rightItem + ")";
                return new LineItem(line, rightItem.getType());
            }
            DataType lineType = rightItem.getType().isNumber() ? DataType.NumberType : (rightItem.getType().isType("String") ? DataType.StringType : (rightItem.getType().isType("Date") ? DataType.DateType : DataType.ObjectType));
            return new LineItem("Variant.negate(" + rightItem.cast() + ")", rightItem.getType(), lineType);
        }
        if (op instanceof Plus) {
            if (rightItem.getType().isNumber()) {
                return rightItem;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"+\"" + mm.getMessage("operator.numberRightOperation"));
        }
        DataType commonType = NodeParser.calcCommonType(leftItem.getType(), rightItem.getType());
        DataType sequenceType = OperatorParser.ifHasSequenceType(leftItem.getType(), rightItem.getType());
        String leftItemStr = NodeParser.checkIfNeedParentheses(leftItem.cast());
        String rightItemStr = NodeParser.checkIfNeedParentheses(rightItem.cast());
        if (op instanceof Add || op instanceof AddAssign) {
            if (isOptimizable) {
                if (op instanceof Add) {
                    return new LineItem(leftItem.cast() + "+" + rightItem.cast(), commonType);
                }
                return new LineItem(String.valueOf(leftItemStr) + "+=" + rightItem.cast(), commonType);
            }
            DataType leftType = leftItem.getType();
            DataType rightType = rightItem.getType();
            DataType returnType = leftType.isNumber() && rightType.isNumber() ? (leftType.isType("double") || leftType.isType("Double") || rightType.isType("double") || rightType.isType("Double") ? DataType.DoubleTypeNullable : DataType.LongTypeNullable) : (leftItem.getType().isType("String") && isSameType ? leftItem.getType() : (leftItem.getType().isType("String") && rightItem.getType().isNumber() ? DataType.LongTypeNullable : (rightItem.getType().isType("String") && leftItem.getType().isNumber() ? DataType.LongTypeNullable : (leftItem.getType().isType("Date") && rightItem.getType().isNumber() ? DataType.DateType : (rightItem.getType().isType("Date") && leftItem.getType().isNumber() ? DataType.DateType : DataType.ObjectType)))));
            if (op instanceof Add) {
                if (isNumber) {
                    return new LineItem("MathLib.add(" + leftItem.cast() + "," + rightItem.cast() + ")", returnType, returnType);
                }
                return new LineItem("Variant.add(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
            }
            leftItem.setType(returnType);
            LineItem value = isNumber ? new LineItem("MathLib.add(" + leftItem.cast() + "," + rightItem.cast() + ")", returnType, returnType) : new LineItem("Variant.add(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
            return new AssignItem(leftItem, value);
        }
        if (op instanceof And) {
            if (leftItem.getType().isType("boolean") && rightItem.getType().isType("boolean") && !isNullable) {
                String line = String.format("%s && %s", CompilerUtil.handleParentheses(leftItem.toString()), CompilerUtil.handleParentheses(rightItem.toString()));
                return new LineItem(line, DataType.BooleanType);
            }
            String line = String.format("(%s) && (%s)", OperatorParser.toBoolString(leftItem), OperatorParser.toBoolString(rightItem));
            return new LineItem(line, DataType.BooleanType);
        }
        if (op instanceof Comma) {
            rightItem.setPreItem(leftItem);
            return rightItem;
        }
        if (op instanceof Conj) {
            DataType returnType = leftItem.getType().isType("Table") ? leftItem.getType().getMemberType() : (rightItem.getType().isType("Table") ? rightItem.getType().getMemberType() : (leftItem.getType().isType("Sequence") && leftItem.getType().getMemberType() != null ? leftItem.getType().getMemberType() : (rightItem.getType().isType("Sequence") && rightItem.getType().getMemberType() != null ? rightItem.getType().getMemberType() : NodeParser.calcMinType(leftItem.getType(), rightItem.getType()))));
            returnType = DataType.newSequenceType(returnType);
            return new LineItem(String.format("OperatorLib.conj(%s, %s)", leftItem, rightItem), returnType);
        }
        if (op instanceof ConjAssign) {
            DataType returnType = leftItem.getType().isType("Sequence") && leftItem.getType().getMemberType() != null ? leftItem.getType().getMemberType() : (rightItem.getType().isType("Sequence") && rightItem.getType().getMemberType() != null ? rightItem.getType().getMemberType() : NodeParser.calcMinType(leftItem.getType(), rightItem.getType()));
            returnType = DataType.newSequenceType(returnType);
            LineItem value = new LineItem(String.format("OperatorLib.conj(%s, %s)", leftItem, rightItem), returnType);
            if (leftItem instanceof VarItem && ((VarItem)leftItem).isField()) {
                String line = parser.getCurContext().formatFieldRefAssign(((VarItem)leftItem).getName(), value);
                return new LineItem(line, returnType, DataType.ObjectType);
            }
            return new AssignItem(leftItem, value);
        }
        if (op instanceof Diff || op instanceof IntDivideAssign) {
            if (leftItem.getType().isType("int") && rightItem.getType().isType("int")) {
                if (op instanceof Diff) {
                    return new LineItem(String.valueOf(leftItemStr) + "/" + rightItemStr, DataType.IntType);
                }
                return new LineItem(String.valueOf(leftItemStr) + "/=" + rightItemStr, DataType.IntType);
            }
            DataType returnType = sequenceType != null ? sequenceType : commonType;
            if (op instanceof Diff) {
                return new LineItem("SequenceLib.diff(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
            }
            return new LineItem(leftItem + "=SequenceLib.diff(" + leftItem + "," + rightItem + ")", returnType);
        }
        if (op instanceof Divide || op instanceof DivideAssign) {
            if (!isNullable && isNumber) {
                if (op instanceof Divide) {
                    String line = String.format("%s / %s", leftItem.cast("double"), rightItem.cast("double"));
                    return new LineItem(line, DataType.DoubleType);
                }
                String line = String.format("%s = %s / %s", leftItem, leftItem.cast("double"), rightItem.cast("double"));
                return new LineItem(line, DataType.DoubleType);
            }
            DataType returnType = rightItem.getType().isType("String") ? rightItem.getType() : (leftItem.getType().isType("String") ? leftItem.getType() : commonType);
            if (op instanceof Divide) {
                if (isNumber) {
                    return new LineItem("MathLib.div(" + leftItem.cast() + "," + rightItem.cast() + ")", returnType, returnType);
                }
                return new LineItem("Variant.divide(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
            }
            LineItem value = isNumber ? new LineItem("MathLib.div(" + leftItem.cast() + "," + rightItem.cast() + ")", returnType, returnType) : new LineItem("Variant.divide(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
            return new AssignItem(leftItem, value);
        }
        if (op instanceof ISect) {
            return new LineItem("SequenceLib.isect(" + leftItem + "," + rightItem + ")", sequenceType);
        }
        if (op instanceof ISectAssign) {
            return new LineItem(leftItem + "=SequenceLib.isect(" + leftItem + "," + rightItem + ")", sequenceType);
        }
        if (op instanceof MemAdd) {
            return new LineItem("SequenceLib.memAdd(" + leftItem + "," + rightItem + ")", sequenceType);
        }
        if (op instanceof MemDivide) {
            return new LineItem("SequenceLib.memDivide(" + leftItem + "," + rightItem + ")", sequenceType);
        }
        if (op instanceof MemIntDivide) {
            return new LineItem("SequenceLib.memIntDivide(" + leftItem + "," + rightItem + ")", sequenceType);
        }
        if (op instanceof MemMod) {
            return new LineItem("SequenceLib.memMod(" + leftItem + "," + rightItem + ")", sequenceType);
        }
        if (op instanceof MemMultiply) {
            return new LineItem("SequenceLib.memMultiply(" + leftItem + "," + rightItem + ")", sequenceType);
        }
        if (op instanceof MemSubtract) {
            return new LineItem("SequenceLib.memSubtract(" + leftItem + "," + rightItem + ")", sequenceType);
        }
        if (op instanceof Mod || op instanceof ModAssign) {
            if (isOptimizable) {
                if (op instanceof Mod) {
                    return new LineItem(String.valueOf(leftItemStr) + "%" + rightItemStr, commonType);
                }
                return new LineItem(String.valueOf(leftItemStr) + "=" + leftItemStr + "%" + rightItemStr, commonType);
            }
            DataType returnType = sequenceType != null ? sequenceType : commonType;
            if (op instanceof Mod) {
                String typeStr = OperatorParser.formatTypeStr(returnType);
                return new LineItem(String.valueOf(typeStr) + "SequenceLib.mod(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
            }
            return new LineItem(leftItem + "=SequenceLib.mod(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
        }
        if (op instanceof Multiply || op instanceof MultiplyAssign) {
            if (isOptimizable) {
                if (op instanceof Multiply) {
                    return new LineItem(String.valueOf(leftItemStr) + " * " + rightItemStr, commonType);
                }
                return new LineItem(String.valueOf(leftItemStr) + "*=" + rightItem.cast(), commonType);
            }
            DataType returnType = sequenceType != null ? sequenceType : DataType.ifIntToLong(commonType);
            if (op instanceof Multiply) {
                if (isNumber) {
                    return new LineItem("MathLib.mul(" + leftItem.cast() + "," + rightItem.cast() + ")", returnType, returnType);
                }
                return new LineItem("Variant.multiply(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
            }
            LineItem value = isNumber ? new LineItem("MathLib.mul(" + leftItem.cast() + "," + rightItem.cast() + ")", returnType, returnType) : new LineItem("Variant.multiply(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
            return new AssignItem(leftItem, value);
        }
        if (op instanceof Or) {
            if (leftItem.getType().isType("boolean") && rightItem.getType().isType("boolean") && !isNullable) {
                String line = String.format("%s || %s", CompilerUtil.handleParentheses(leftItem.toString()), CompilerUtil.handleParentheses(rightItem.toString()));
                return new LineItem(line, DataType.BooleanType);
            }
            String line = String.format("(%s) || (%s)", OperatorParser.toBoolString(leftItem), OperatorParser.toBoolString(rightItem));
            return new LineItem(line, DataType.BooleanType);
        }
        if (op instanceof Subtract || op instanceof SubtractAssign) {
            DataType returnType;
            if (isOptimizable) {
                if (op instanceof Subtract) {
                    return new LineItem("(" + leftItem.cast() + ")-(" + rightItem.cast() + ")", commonType);
                }
                return new LineItem("(" + leftItem + ")-=(" + rightItem.cast() + ")", commonType);
            }
            if (leftItem.getType().isNumber() && rightItem.getType().isNumber()) {
                returnType = commonType;
                returnType = DataType.ifIntToLong(returnType);
            } else {
                returnType = leftItem.getType().isType("Date") && isSameType ? DataType.LongTypeNullable : (leftItem.getType().isType("Date") && rightItem.getType().isNumber() ? DataType.DateType : DataType.ObjectType);
            }
            if (op instanceof Subtract) {
                if (isNumber) {
                    return new LineItem("MathLib.sub(" + leftItem.cast() + "," + rightItem.cast() + ")", returnType, returnType);
                }
                return new LineItem("Variant.subtract(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
            }
            leftItem.setType(returnType);
            LineItem value = isNumber ? new LineItem("MathLib.sub(" + leftItem.cast() + "," + rightItem.cast() + ")", returnType, returnType) : new LineItem("Variant.subtract(" + leftItem + "," + rightItem + ")", returnType, DataType.ObjectType);
            return new AssignItem(leftItem, value);
        }
        if (op instanceof Union) {
            return new LineItem(String.format("OperatorLib.union(%s, %s)", leftItem, rightItem), sequenceType);
        }
        if (op instanceof UnionAssign) {
            return new LineItem(String.format("%s=OperatorLib.union(%s, %s)", leftItem, leftItem, rightItem), sequenceType);
        }
        throw new ParseNodeException(op.toString());
    }

    private static boolean isWrapperType(String type) {
        return "Integer".equals(type) || "Long".equals(type) || "Double".equals(type);
    }

    public static String makeCompareCode(CodeItem leftItem, CodeItem rightItem, String op) {
        boolean hasDoublePrimitive;
        String right;
        String left;
        block19: {
            left = leftItem.cast().toString();
            right = rightItem.cast().toString();
            String leftType = leftItem.getType().getTypeName();
            String rightType = rightItem.getType().getTypeName();
            boolean hasWrapper = OperatorParser.isWrapperType(leftType) || OperatorParser.isWrapperType(rightType);
            boolean bl = hasDoublePrimitive = "double".equals(leftType) || "double".equals(rightType);
            if (!hasWrapper) break block19;
            if ("==".equals(op) || "!=".equals(op)) {
                String equalsCall = "MathLib.equals(" + left + ", " + right + ")";
                return "==".equals(op) ? equalsCall : "!" + equalsCall;
            }
            String compareCall = "MathLib.compare(" + left + ", " + right + ")";
            switch (op) {
                case ">": {
                    return String.valueOf(compareCall) + " > 0";
                }
                case "<": {
                    return String.valueOf(compareCall) + " < 0";
                }
                case ">=": {
                    return String.valueOf(compareCall) + " >= 0";
                }
                case "<=": {
                    return String.valueOf(compareCall) + " <= 0";
                }
            }
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7b26: " + op);
        }
        if (hasDoublePrimitive) {
            if (">".equals(op) || "<".equals(op)) {
                return String.valueOf(left) + " " + op + " " + right;
            }
            return "Double.compare(" + leftItem.cast("double") + ", " + rightItem.cast("double") + ")" + op + "0";
        }
        return String.valueOf(left) + " " + op + " " + right;
    }
}

