/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.runtime;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.Escape;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.common.UUID;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DfxManager;
import com.scudata.dm.FileObject;
import com.scudata.dm.JobSpace;
import com.scudata.dm.JobSpaceManager;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.expression.FunctionLib;
import com.scudata.ide.spl.Esprocx;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.CallJob;
import com.scudata.util.CellSetUtil;
import com.scudata.util.Variant;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;

public class FunLib {
    public static void loadFunctions() {
        try {
            Esprocx.initEnv();
            FunctionLib.loadCustomFunctions((String)"splfunctions.properties");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static Object avg(Object ... values) {
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            Object obj = values[0];
            if (obj == null) {
                return null;
            }
            if (obj instanceof Sequence) {
                return ((Sequence)obj).average();
            }
            if (obj instanceof Number) {
                return obj;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("avg" + mm.getMessage("function.paramTypeError"));
        }
        Object result = null;
        int count = 0;
        int i = 0;
        int size = values.length;
        while (i < size) {
            Object obj = values[i];
            if (obj != null) {
                if (!(obj instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("avg" + mm.getMessage("function.paramTypeError"));
                }
                ++count;
                result = Variant.add(result, (Object)obj);
            }
            ++i;
        }
        return Variant.avg(result, (int)count);
    }

    private static boolean isWorkDay(Calendar calendar, Sequence offDays, String option) {
        boolean isWorkDay;
        int week = calendar.get(7);
        boolean bl = isWorkDay = week != 1 && week != 7;
        if (offDays == null || offDays.length() == 0) {
            return isWorkDay;
        }
        long time = calendar.getTimeInMillis();
        if (option == null || option.indexOf(98) == -1) {
            int i = 1;
            int count = offDays.length();
            while (i <= count) {
                Object obj = offDays.getMem(i);
                if (!(obj instanceof java.util.Date)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("workday" + mm.getMessage("function.paramTypeError"));
                }
                if (((java.util.Date)obj).getTime() == time) {
                    return !isWorkDay;
                }
                ++i;
            }
        } else {
            int low = 1;
            int high = offDays.length();
            while (low <= high) {
                int mid = low + high >> 1;
                Object obj = offDays.getMem(mid);
                if (!(obj instanceof java.util.Date)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("workday" + mm.getMessage("function.paramTypeError"));
                }
                long curTime = ((java.util.Date)obj).getTime();
                if (curTime < time) {
                    low = mid + 1;
                    continue;
                }
                if (curTime > time) {
                    high = mid - 1;
                    continue;
                }
                return !isWorkDay;
            }
        }
        return isWorkDay;
    }

    /*
     * Unable to fully structure code
     */
    public static java.util.Date workDay(Object obj1, Object obj2, Object obj3, String option) {
        block3: {
            if (!(obj1 instanceof java.util.Date) || !(obj2 instanceof Number)) {
                mm = EngineMessage.get();
                throw new RQException("workday" + mm.getMessage("function.paramTypeError"));
            }
            offDays = null;
            if (obj3 != null && obj3 instanceof Sequence) {
                offDays = (Sequence)obj3;
            }
            date1 = (java.util.Date)obj1;
            calendar = Calendar.getInstance();
            calendar.setTime(date1);
            diff = ((Number)obj2).intValue();
            d = 1;
            if (diff >= 0) break block3;
            d = -1;
            ** GOTO lbl21
        }
        if (diff != 0) ** GOTO lbl21
        return date1;
lbl-1000:
        // 1 sources

        {
            calendar.add(5, d);
            if (!FunLib.isWorkDay(calendar, offDays, option)) continue;
            diff -= d;
lbl21:
            // 4 sources

            ** while (diff != 0)
        }
lbl22:
        // 1 sources

        date = (java.util.Date)date1.clone();
        date.setTime(calendar.getTimeInMillis());
        return date;
    }

    private static long longInterval(Object result1, Object result2, String option) {
        if (result1 instanceof String) {
            if (!((result1 = Variant.parseDate((String)((String)result1))) instanceof java.util.Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            if (result1 instanceof Integer) {
                if (!(result2 instanceof Integer)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
                }
                return Variant.interval((int)((Integer)result1), (int)((Integer)result2), (String)option);
            }
            if (!(result1 instanceof java.util.Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        }
        if (result2 instanceof String) {
            if (!((result2 = Variant.parseDate((String)((String)result2))) instanceof java.util.Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        } else if (!(result2 instanceof java.util.Date)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
        }
        return Variant.interval((java.util.Date)((java.util.Date)result1), (java.util.Date)((java.util.Date)result2), (String)option);
    }

    private static double realInterval(Object result1, Object result2, String option) {
        if (result1 instanceof String) {
            if (!((result1 = Variant.parseDate((String)((String)result1))) instanceof java.util.Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        } else {
            if (result1 instanceof Integer) {
                if (!(result2 instanceof Integer)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
                }
                return Variant.realInterval((int)((Integer)result1), (int)((Integer)result2), (String)option);
            }
            if (!(result1 instanceof java.util.Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        }
        if (result2 instanceof String) {
            if (!((result2 = Variant.parseDate((String)((String)result2))) instanceof java.util.Date)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
            }
        } else if (!(result2 instanceof java.util.Date)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("interval" + mm.getMessage("function.paramTypeError"));
        }
        return Variant.realInterval((java.util.Date)((java.util.Date)result1), (java.util.Date)((java.util.Date)result2), (String)option);
    }

    public static Number interval(Object obj1, Object obj2, String option) {
        if (obj1 == null || obj2 == null) {
            return null;
        }
        if (option == null || option.indexOf(114) == -1) {
            return new Long(FunLib.longInterval(obj1, obj2, option));
        }
        return new Double(FunLib.realInterval(obj1, obj2, option));
    }

    public static Object If(String[] fltExps, String[] valExps, Object val, Context ctx) {
        int size = fltExps.length;
        int i = 0;
        while (i < size) {
            Expression exp = new Expression(fltExps[i]);
            Object obj = exp.calculate(ctx);
            if (Variant.isTrue((Object)obj)) {
                if (valExps[i] != null) {
                    return new Expression(valExps[i]).calculate(ctx);
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public static Object ifn(Object o1, Object o2) {
        if (o1 == null) {
            return o2;
        }
        return o1;
    }

    public static Integer ToInteger(Object result) {
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof Number) {
            return ObjectCache.getInteger((int)((Number)result).intValue());
        }
        if (result instanceof String) {
            try {
                double d = Double.parseDouble((String)result);
                return ObjectCache.getInteger((int)((int)d));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (result == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("int" + mm.getMessage("function.paramTypeError"));
    }

    public static BaseRecord NewRecord(String[] names, Object ... vals) {
        Table table = new Table(names, 1);
        BaseRecord r = table.newLast();
        r.setStart(0, vals);
        return r;
    }

    public static Table NewTable(String[] names, Object ... vals) {
        Table table = new Table(names, 1);
        BaseRecord r = table.newLast();
        r.setStart(0, vals);
        return table;
    }

    public static Sequence To(Object o) {
        if (o instanceof Number) {
            int end = ((Number)o).intValue();
            return end > 0 ? new Sequence(1, end) : new Sequence(0);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("to" + mm.getMessage("function.paramTypeError"));
    }

    public static Sequence To(Object o1, Object o2, String option) {
        if (o1 instanceof Long && o2 instanceof Long) {
            long begin = ((Number)o1).longValue();
            long end = ((Number)o2).longValue();
            if (option != null && option.indexOf(115) != -1) {
                end = end >= 0L ? (end += begin - 1L) : (end += begin + 1L);
            }
            return new Sequence(begin, end);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            int begin = ((Number)o1).intValue();
            int end = ((Number)o2).intValue();
            if (option != null && option.indexOf(115) != -1) {
                end = end >= 0 ? (end += begin - 1) : (end += begin + 1);
            }
            return new Sequence(begin, end);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("to" + mm.getMessage("function.paramTypeError"));
    }

    public static String ToChar(Object result) {
        if (result instanceof Number) {
            char[] c = new char[]{(char)((Number)result).intValue()};
            return new String(c);
        }
        if (result == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("char" + mm.getMessage("function.paramTypeError"));
    }

    public static String ToString(Object val, String fmt, String local, String option) {
        if (val instanceof String) {
            String str = (String)val;
            String opt = option;
            if (opt != null) {
                if (opt.indexOf(117) != -1) {
                    StringBuffer sb = new StringBuffer(str.length() + 16);
                    StringUtils.deunicode((String)str, (StringBuffer)sb, (String)"\"'");
                    str = sb.toString();
                } else if (opt.indexOf(101) != -1) {
                    str = Escape.add((String)str);
                }
                if (opt.indexOf(113) != -1) {
                    str = String.valueOf('\"') + str + '\"';
                }
            }
            return str;
        }
        if (fmt == null) {
            return Variant.toString((Object)val);
        }
        if (local == null) {
            return Variant.format((Object)val, (String)fmt);
        }
        return Variant.format((Object)val, (String)fmt, (String)local);
    }

    public static Object max(Object ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        Object maxVal = values[0];
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (Variant.compare((Object)maxVal, (Object)obj, (boolean)true) < 0) {
                maxVal = obj;
            }
            ++n2;
        }
        return maxVal;
    }

    public static Object min(Object ... values) {
        if (values == null || values.length == 0) {
            return null;
        }
        Object minVal = values[0];
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (Variant.compare((Object)minVal, (Object)obj, (boolean)true) > 0) {
                minVal = obj;
            }
            ++n2;
        }
        return minVal;
    }

    public static Integer rand(Object obj, String option, Context ctx) {
        if (option == null || option.indexOf(115) == -1) {
            int n = ((Number)obj).intValue();
            return new Integer(ctx.getRandom().nextInt(n));
        }
        long seed = ((Number)obj).longValue();
        ctx.getRandom(seed);
        return null;
    }

    public static Object output(String option, Object ... objs) {
        String msg = null;
        int i = 0;
        int size = objs.length;
        while (i < size) {
            Object obj = objs[i];
            msg = i == 0 ? Variant.toString((Object)obj) : String.valueOf(msg) + '\t' + Variant.toString((Object)obj);
            ++i;
        }
        boolean isTime = false;
        boolean isLF = true;
        if (option != null) {
            if (option.indexOf(101) != -1) {
                Logger.error((Object)msg);
                return null;
            }
            if (option.indexOf(103) != -1) {
                if (option.indexOf(49) != -1) {
                    Logger.debug((Object)msg);
                } else if (option.indexOf(51) != -1) {
                    Logger.warning((Object)msg);
                } else if (option.indexOf(52) != -1) {
                    Logger.severe((Object)msg);
                } else {
                    Logger.info((Object)msg);
                }
                return null;
            }
            if (option.indexOf(116) != -1) {
                isTime = true;
            }
            if (option.indexOf(115) != -1) {
                isLF = false;
            }
        }
        if (isTime) {
            Timestamp time = new Timestamp(System.currentTimeMillis());
            msg = String.valueOf(Variant.toString((Object)time)) + '\t' + msg;
        }
        if (isLF) {
            System.out.println(msg);
        } else {
            System.out.print(msg);
        }
        return null;
    }

    public static PgmCellSet loadCellSet(byte[] bytes) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            PgmCellSet cellSet = CellSetUtil.readPgmCellSet((InputStream)is);
            is.close();
            cellSet.getFunctionMap();
            return cellSet;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PgmCellSet loadCellSet(String fp) {
        FileObject fo = new FileObject(fp);
        try {
            return AppUtil.readCellSet((String)fo.getFileName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object runPCSFunction(String funName, Context ctx, PgmCellSet cellSet, Object ... args) {
        PgmCellSet.FuncInfo funcInfo = cellSet.getFuncInfo(funName);
        return funcInfo.execute(args, ctx);
    }

    public static Object runPCSFunction(String funName, Context ctx, HashMap<String, PgmCellSet.FuncInfo> funMap, Object ... args) {
        PgmCellSet.FuncInfo funcInfo = funMap.get(funName);
        return funcInfo.execute(args, ctx);
    }

    public static Object runDFX(PgmCellSet pcs, String option, Object ... args) {
        boolean nopt = false;
        boolean useCache = true;
        boolean fopt = false;
        if (option != null) {
            if (option.indexOf(110) != -1) {
                nopt = true;
            }
            if (option.indexOf(114) != -1) {
                useCache = false;
            }
            if (option.indexOf(102) != -1) {
                fopt = true;
            }
        }
        pcs.setParamToContext();
        ParamList list = pcs.getParamList();
        if (list != null) {
            Context curCtx = pcs.getContext();
            int size = args.length - 1;
            if (size > list.count()) {
                size = list.count();
            }
            int i = 0;
            while (i < size) {
                Param p = list.get(i);
                curCtx.setParamValue(p.getName(), args[i + 1]);
                ++i;
            }
        }
        if (nopt) {
            String uuid = UUID.randomUUID().toString();
            JobSpace jobSpace = JobSpaceManager.getSpace((String)uuid);
            pcs.getContext().setJobSpace(jobSpace);
            CallJob job = new CallJob(pcs, option);
            Thread thread = new Thread((Runnable)job);
            thread.start();
            return null;
        }
        Object val = pcs.execute();
        if (useCache) {
            pcs.reset();
            DfxManager.getInstance().putDfx(pcs);
        }
        return val;
    }

    public static Object getField(BaseRecord rec, String field) {
        if (rec == null) {
            return null;
        }
        int index = rec.dataStruct().getFieldIndex(field);
        return rec.getNormalFieldValue(index);
    }

    public static Object setField(BaseRecord rec, String field, Object value) {
        int index = rec.dataStruct().getFieldIndex(field);
        rec.setNormalFieldValue(index, value);
        return value;
    }

    public static Object getField(BaseRecord rec, int findex) {
        if (rec == null) {
            return null;
        }
        return rec.getNormalFieldValue(findex);
    }

    public static Object setField(BaseRecord rec, int findex, Object value) {
        rec.setNormalFieldValue(findex, value);
        return value;
    }

    public static Table create(String[] names, String[] pkNames) {
        Table table = new Table(names);
        table.setPrimary(pkNames);
        return table;
    }

    public static String typeof(Object obj, String option) {
        if (obj == null) {
            return "null";
        }
        if (option == null || option.indexOf(120) == -1) {
            if (obj instanceof String) {
                return "string";
            }
            if (obj instanceof Number) {
                return "number";
            }
            if (obj instanceof java.util.Date) {
                return "datetime";
            }
            if (obj instanceof Boolean) {
                return "bool";
            }
            if (obj instanceof BaseRecord) {
                return "record";
            }
            if (obj instanceof Table) {
                return "table";
            }
            if (obj instanceof Sequence) {
                return "sequence";
            }
            if (obj instanceof byte[]) {
                return "blob";
            }
            if (obj instanceof SerialBytes) {
                return "bytes";
            }
            return obj.getClass().getName();
        }
        if (obj instanceof String) {
            return "string";
        }
        if (obj instanceof Integer) {
            return "int";
        }
        if (obj instanceof Long) {
            return "long";
        }
        if (obj instanceof Double) {
            return "float";
        }
        if (obj instanceof BigDecimal) {
            return "decimal";
        }
        if (obj instanceof Date) {
            return "date";
        }
        if (obj instanceof Time) {
            return "time";
        }
        if (obj instanceof java.util.Date) {
            return "datetime";
        }
        if (obj instanceof Boolean) {
            return "bool";
        }
        if (obj instanceof BaseRecord) {
            return "record";
        }
        if (obj instanceof Table) {
            return "table";
        }
        if (obj instanceof Sequence) {
            return "sequence";
        }
        if (obj instanceof byte[]) {
            return "blob";
        }
        if (obj instanceof SerialBytes) {
            return "bytes";
        }
        if (obj instanceof Number) {
            return "number";
        }
        return obj.getClass().getName();
    }

    private static String right(String str, int n) {
        int len = str.length();
        if (n >= len) {
            return str;
        }
        if (n > 0) {
            return str.substring(len - n);
        }
        if (n == 0) {
            return "";
        }
        if ((n = -n - 1) >= len) {
            return "";
        }
        return str.substring(n);
    }

    public static String right(Object result1, Object result2) {
        if (result1 == null) {
            return null;
        }
        if (!(result1 instanceof String)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("right" + mm.getMessage("function.paramTypeError"));
        }
        if (!(result2 instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("right" + mm.getMessage("function.paramTypeError"));
        }
        return FunLib.right((String)result1, ((Number)result2).intValue());
    }
}

