/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.runtime;

import com.scudata.compile.parser.NodeParser;
import com.scudata.dm.Context;
import com.scudata.expression.Constant;
import com.scudata.expression.Expression;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FunctionExecutor {
    private static final ConcurrentMap<String, Expression> expCcache = new ConcurrentHashMap<String, Expression>();
    public static Context ctx = new Context();

    public static Expression getExpression(String expStr) {
        Expression existing;
        Expression expression = (Expression)expCcache.get(expStr);
        if (expression == null && (existing = expCcache.putIfAbsent(expStr, expression = new Expression(expStr))) != null) {
            expression = existing;
        }
        return expression;
    }

    public static Object calculateFN(String fun, String option) {
        if (option == null) {
            option = "";
        }
        String expStr = String.format("%s@%s()", fun, option);
        Expression exp = new Expression(expStr);
        return exp.calculate(ctx);
    }

    public static Object calculateFN(String fun, String option, String param) {
        if (option == null) {
            option = "";
        }
        String expStr = String.format("%s@%s(%s)", fun, option, param);
        Expression exp = new Expression(expStr);
        return exp.calculate(ctx);
    }

    public static Object calculateFN(String fun, String option, char[] separators, Object ... objs) {
        String param;
        int s = 0;
        if (objs == null || objs.length == 0) {
            param = "";
        } else {
            int size = objs.length;
            int i = 0;
            while (i < size) {
                if (objs[i] instanceof String) {
                    objs[i] = NodeParser.toMacroString((String)objs[i]);
                } else if (objs[i] instanceof Timestamp) {
                    objs[i] = "datetime(\"" + objs[i] + "\")";
                } else if (objs[i] instanceof Date) {
                    objs[i] = "date(\"" + objs[i] + "\")";
                }
                ++i;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(objs[0] != null ? objs[0].toString() : "null");
            int i2 = 1;
            while (i2 < size) {
                sb.append(separators[s++]);
                sb.append(objs[i2] != null ? objs[i2].toString() : "null");
                ++i2;
            }
            param = sb.toString();
        }
        if (option == null) {
            option = "";
        }
        String expStr = String.format("%s@%s(%s)", fun, option, param);
        Expression exp = new Expression(ctx, expStr);
        return exp.calculate(ctx);
    }

    public static Object calculateMFN(Object left, String fun, String option, String param) {
        if (option == null) {
            option = "";
        }
        String expStr = String.format("null.%s@%s(%s)", fun, option, param);
        Expression exp = new Expression(expStr);
        ((Constant)exp.getHome().getLeft()).setValue(left);
        return exp.calculate(ctx);
    }

    public static Object calculateMFN(Object left, String fun, String option) {
        if (option == null) {
            option = "";
        }
        String expStr = String.format("null.%s@%s()", fun, option);
        Expression exp = new Expression(expStr);
        ((Constant)exp.getHome().getLeft()).setValue(left);
        return exp.calculate(ctx);
    }

    public static Object calculateMFN(Object left, String fun) {
        String expStr = String.format("null.%s()", fun);
        Expression exp = new Expression(expStr);
        ((Constant)exp.getHome().getLeft()).setValue(left);
        return exp.calculate(ctx);
    }

    public static Object calculateMFN(Object left, String fun, String option, char[] separators, Object ... objs) {
        String param;
        int s = 0;
        if (objs == null || objs.length == 0) {
            param = "";
        } else {
            int size = objs.length;
            int i = 0;
            while (i < size) {
                if (objs[i] instanceof String) {
                    objs[i] = NodeParser.toMacroString((String)objs[i]);
                } else if (objs[i] instanceof Timestamp) {
                    objs[i] = "datetime(\"" + objs[i] + "\")";
                } else if (objs[i] instanceof Date) {
                    objs[i] = "date(\"" + objs[i] + "\")";
                }
                ++i;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(objs[0] != null ? objs[0].toString() : "");
            int i2 = 1;
            while (i2 < size) {
                sb.append(separators[s++]);
                sb.append(objs[i2] != null ? objs[i2].toString() : "");
                ++i2;
            }
            param = sb.toString();
        }
        if (option == null) {
            option = "";
        }
        String expStr = String.format("null.%s@%s(%s)", fun, option, param);
        Expression exp = new Expression(expStr);
        ((Constant)exp.getHome().getLeft()).setValue(left);
        return exp.calculate(ctx);
    }
}

