/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.compile.runtime;

import com.scudata.array.ConstArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.expression.mfn.sequence.MGet;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CursorUtil;
import com.scudata.util.Variant;

public class SequenceLib {
    public static Object elementAssign(Sequence srcSeries, Sequence posSeries, Object value) {
        int len = srcSeries.length();
        int count = posSeries.length();
        if (value instanceof Sequence) {
            Sequence tseq = (Sequence)value;
            if (count != tseq.length()) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.memCountNotMatch"));
            }
            int i = 1;
            while (i <= count) {
                Object posObj = posSeries.get(i);
                if (!(posObj instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needIntSeries"));
                }
                int index = ((Number)posObj).intValue();
                if (index > len) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(index) + mm.getMessage("engine.indexOutofBound"));
                }
                srcSeries.set(index, tseq.get(i));
                ++i;
            }
        } else {
            int i = 1;
            while (i <= count) {
                Object posObj = posSeries.get(i);
                if (!(posObj instanceof Number)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needIntSeries"));
                }
                int index = ((Number)posObj).intValue();
                if (index > len) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(String.valueOf(index) + mm.getMessage("engine.indexOutofBound"));
                }
                srcSeries.set(index, value);
                ++i;
            }
        }
        return value;
    }

    private static Sequence select_option_i(Sequence result, String option) {
        if (option != null && option.indexOf(105) != -1) {
            if (result instanceof Table) {
                Table table = (Table)result;
                if (table.getIndexTable() == null) {
                    table.createIndexTable(null);
                }
            } else if (result instanceof Sequence) {
                Sequence seq = result;
                if (seq.length() == 0) {
                    return seq;
                }
                Table table = seq.derive("o");
                table.createIndexTable(null);
                return table;
            }
        }
        return result;
    }

    public static Sequence select(Sequence srcSequence, String option, Context ctx) {
        if (srcSequence == null) {
            return null;
        }
        Sequence result = (Sequence)srcSequence.select(null, option, ctx);
        return SequenceLib.select_option_i(result, option);
    }

    public static Sequence select(Sequence srcSequence, Expression exp, String option, Context ctx) {
        if (srcSequence == null) {
            return null;
        }
        Sequence result = (Sequence)srcSequence.select(exp, option, ctx);
        return SequenceLib.select_option_i(result, option);
    }

    public static Sequence conj(Object left, Object right) {
        Sequence s2;
        Sequence s1;
        Object o1 = left;
        Object o2 = right;
        if (o1 instanceof Sequence) {
            s1 = (Sequence)o1;
        } else if (o1 == null) {
            s1 = new Sequence(0);
        } else {
            s1 = new Sequence(1);
            s1.add(o1);
        }
        if (o2 instanceof Sequence) {
            s2 = (Sequence)o2;
        } else if (o2 == null) {
            s2 = new Sequence(0);
        } else {
            s2 = new Sequence(1);
            s2.add(o2);
        }
        return s1.conj(s2, false);
    }

    public static Sequence conj(Sequence left, String opt) {
        if (left == null) {
            return null;
        }
        return left.conj(opt);
    }

    public static Object diff(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null || o2 instanceof Sequence || o2 instanceof Number) {
                return null;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException("\"\\\"" + mm.getMessage("function.paramTypeError"));
        }
        if (o1 instanceof Sequence) {
            if (o2 == null) {
                return o1;
            }
            if (!(o2 instanceof Sequence)) {
                Sequence s2 = new Sequence(1);
                s2.add(o2);
                o2 = s2;
            }
            return ((Sequence)o1).diff((Sequence)o2, false);
        }
        return Variant.intDivide((Object)o1, (Object)o2);
    }

    public static Sequence insert(Sequence seq, Integer posVal, Object val, String option) {
        if (posVal != null) {
            if (!(posVal instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("insert" + mm.getMessage("function.paramTypeError"));
            }
            seq.insert(((Number)posVal).intValue(), val);
        } else {
            seq.sortedInsert(val);
        }
        return seq;
    }

    public static Sequence isect(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 != null && !(o2 instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("\"^\"" + mm.getMessage("function.paramTypeError"));
            }
            return null;
        }
        if (o1 instanceof Sequence) {
            if (o2 == null) {
                return null;
            }
            if (!(o2 instanceof Sequence)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("\"^\"" + mm.getMessage("function.paramTypeError"));
            }
            return ((Sequence)o1).isect((Sequence)o2, false);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("\"^\"" + mm.getMessage("function.paramTypeError"));
    }

    public static Sequence memAdd(Object left, Object right) {
        Object obj = left;
        if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            obj = right;
            if (obj instanceof Sequence) {
                return seq.memberAdd((Sequence)obj);
            }
            ConstArray array = new ConstArray(obj, seq.length());
            return seq.memberAdd(new Sequence((IArray)array));
        }
        if (obj == null) {
            Object obj2 = right;
            if (obj2 instanceof Sequence) {
                return (Sequence)obj2;
            }
            return null;
        }
        Object obj2 = right;
        if (obj2 instanceof Sequence) {
            Sequence seq = (Sequence)obj2;
            ConstArray array = new ConstArray(obj, seq.length());
            return seq.memberAdd(new Sequence((IArray)array));
        }
        if (obj2 == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("\"++\"" + mm.getMessage("function.paramTypeError"));
    }

    public static Sequence memDivide(Object left, Object right) {
        Object obj = left;
        if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            obj = right;
            if (obj instanceof Sequence) {
                return seq.memberDivide((Sequence)obj);
            }
            ConstArray array = new ConstArray(obj, seq.length());
            return seq.memberDivide(new Sequence((IArray)array));
        }
        if (obj == null) {
            Object obj2 = right;
            if (obj2 instanceof Sequence) {
                Sequence seq2 = (Sequence)obj2;
                ConstArray array = new ConstArray(null, seq2.length());
                Sequence seq = new Sequence((IArray)array);
                return seq.memberDivide(seq2);
            }
            return null;
        }
        Object obj2 = right;
        if (obj2 instanceof Sequence) {
            Sequence seq2 = (Sequence)obj2;
            ConstArray array = new ConstArray(obj, seq2.length());
            Sequence seq = new Sequence((IArray)array);
            return seq.memberDivide(seq2);
        }
        if (obj2 == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("\"//\"" + mm.getMessage("function.paramTypeError"));
    }

    public static Sequence memIntDivide(Object left, Object right) {
        Object obj = left;
        if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            obj = right;
            if (obj instanceof Sequence) {
                return seq.memberIntDivide((Sequence)obj);
            }
            ConstArray array = new ConstArray(obj, seq.length());
            return seq.memberIntDivide(new Sequence((IArray)array));
        }
        if (obj == null) {
            Object obj2 = right;
            if (obj2 instanceof Sequence) {
                Sequence seq2 = (Sequence)obj2;
                ConstArray array = new ConstArray(null, seq2.length());
                Sequence seq = new Sequence((IArray)array);
                return seq.memberIntDivide(seq2);
            }
            return null;
        }
        Object obj2 = right;
        if (obj2 instanceof Sequence) {
            Sequence seq2 = (Sequence)obj2;
            ConstArray array = new ConstArray(obj, seq2.length());
            Sequence seq = new Sequence((IArray)array);
            return seq.memberIntDivide(seq2);
        }
        if (obj2 == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("\"\\\\\"" + mm.getMessage("function.paramTypeError"));
    }

    public static Sequence memMod(Object left, Object right) {
        Object obj = left;
        if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            obj = right;
            if (obj instanceof Sequence) {
                return seq.memberMod((Sequence)obj);
            }
            ConstArray array = new ConstArray(obj, seq.length());
            return seq.memberMod(new Sequence((IArray)array));
        }
        if (obj == null) {
            Object obj2 = right;
            if (obj2 instanceof Sequence) {
                Sequence seq2 = (Sequence)obj2;
                ConstArray array = new ConstArray(null, seq2.length());
                Sequence seq = new Sequence((IArray)array);
                return seq.memberMod(seq2);
            }
            return null;
        }
        Object obj2 = right;
        if (obj2 instanceof Sequence) {
            Sequence seq2 = (Sequence)obj2;
            ConstArray array = new ConstArray(obj, seq2.length());
            Sequence seq = new Sequence((IArray)array);
            return seq.memberMod(seq2);
        }
        if (obj2 == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("\"%%\"" + mm.getMessage("function.paramTypeError"));
    }

    public static Sequence memMultiply(Object left, Object right) {
        Object obj = left;
        if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            obj = right;
            if (obj instanceof Sequence) {
                return seq.memberMultiply((Sequence)obj);
            }
            ConstArray array = new ConstArray(obj, seq.length());
            return seq.memberMultiply(new Sequence((IArray)array));
        }
        if (obj == null) {
            Object obj2 = right;
            if (obj2 instanceof Sequence) {
                Sequence seq2 = (Sequence)obj2;
                ConstArray array = new ConstArray(obj, seq2.length());
                return new Sequence((IArray)array);
            }
            return null;
        }
        Object obj2 = right;
        if (obj2 instanceof Sequence) {
            Sequence seq = (Sequence)obj2;
            ConstArray array = new ConstArray(obj, seq.length());
            return seq.memberMultiply(new Sequence((IArray)array));
        }
        if (obj2 == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("\"**\"" + mm.getMessage("function.paramTypeError"));
    }

    public static Sequence memSubtract(Object left, Object right) {
        Object obj = left;
        if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            obj = right;
            if (obj instanceof Sequence) {
                return seq.memberSubtract((Sequence)obj);
            }
            ConstArray array = new ConstArray(obj, seq.length());
            return seq.memberSubtract(new Sequence((IArray)array));
        }
        if (obj == null) {
            Object obj2 = right;
            if (obj2 instanceof Sequence) {
                Sequence seq2 = (Sequence)obj2;
                ConstArray array = new ConstArray(null, seq2.length());
                Sequence seq = new Sequence((IArray)array);
                return seq.memberSubtract(seq2);
            }
            return null;
        }
        Object obj2 = right;
        if (obj2 instanceof Sequence) {
            Sequence seq2 = (Sequence)obj2;
            ConstArray array = new ConstArray(obj, seq2.length());
            Sequence seq = new Sequence((IArray)array);
            return seq.memberSubtract(seq2);
        }
        if (obj2 == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("\"--\"" + mm.getMessage("function.paramTypeError"));
    }

    public static Object mod(Object left, Object right) {
        Object o1 = left;
        Object o2 = right;
        if (o1 instanceof Sequence) {
            if (o2 instanceof Sequence) {
                return CursorUtil.xor((Sequence)((Sequence)o1), (Sequence)((Sequence)o2));
            }
            if (o2 == null) {
                return o1;
            }
            Sequence seq2 = new Sequence(1);
            seq2.add(o2);
            return CursorUtil.xor((Sequence)((Sequence)o1), (Sequence)seq2);
        }
        if (o2 instanceof Sequence) {
            if (o1 == null) {
                return o2;
            }
            Sequence seq1 = new Sequence(1);
            seq1.add(o1);
            return CursorUtil.xor((Sequence)seq1, (Sequence)((Sequence)o2));
        }
        return Variant.mod((Object)o1, (Object)o2);
    }

    public static Object sum(Sequence srcSequence, Expression exp, Context ctx) {
        if (srcSequence == null) {
            return null;
        }
        return srcSequence.calc(exp, "o", ctx).sum();
    }

    public static Integer len(Sequence srcSequence) {
        return srcSequence == null ? null : Integer.valueOf(srcSequence.length());
    }

    private static Sequence record(Table srcTable, Object src, Object posObj, String option) {
        int pos;
        if (src == null && posObj == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("record" + mm.getMessage("function.missingParam"));
        }
        int n = pos = posObj == null ? 0 : ((Number)posObj).intValue();
        if (src instanceof Sequence) {
            return srcTable.record(pos, (Sequence)src, option);
        }
        if (src == null) {
            return srcTable;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("record" + mm.getMessage("function.paramTypeError"));
    }

    private static Table record(Sequence seq, int fcount) {
        int len = seq.length();
        if (len == 0) {
            return null;
        }
        if (fcount < 1 || fcount > len) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("record" + mm.getMessage("function.invalidParam"));
        }
        String[] fnames = new String[fcount];
        int i = 1;
        while (i <= fcount) {
            Object obj = seq.getMem(i);
            if (obj instanceof String) {
                fnames[i - 1] = (String)obj;
            } else if (obj != null) {
                fnames[i - 1] = obj.toString();
            }
            ++i;
        }
        Table table = new Table(fnames, len / fcount);
        Sequence tmp = seq.get(fcount + 1, len + 1);
        table.record(1, tmp, null);
        return table;
    }

    public static Sequence recordValue(Sequence srcSequence, Object src, Object posObj, String option) {
        if (srcSequence instanceof Table) {
            return SequenceLib.record((Table)srcSequence, src, posObj, option);
        }
        if (src == null) {
            return srcSequence.toTable();
        }
        if (posObj == null) {
            Object obj = src;
            if (!(obj instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("record" + mm.getMessage("function.paramTypeError"));
            }
            int fcount = ((Number)obj).intValue();
            return SequenceLib.record(srcSequence, fcount);
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("record" + mm.getMessage("function.invalidParam"));
    }

    public static Object MGet(Sequence srcSequence, Object pval, String option) {
        IArray mems = srcSequence.getMems();
        int srcLen = mems.size();
        boolean isRepeat = false;
        boolean reserveZero = true;
        boolean isBackward = true;
        if (option != null) {
            if (option.indexOf(114) != -1) {
                isRepeat = true;
            }
            if (option.indexOf(48) != -1) {
                reserveZero = false;
            }
            if (option.indexOf(112) != -1) {
                isBackward = false;
            }
        }
        if (pval == null) {
            return null;
        }
        if (pval instanceof Number) {
            int pos = MGet.convert((int)srcLen, (int)((Number)pval).intValue(), (boolean)isRepeat, (boolean)isBackward);
            if (pos > 0) {
                return mems.get(pos);
            }
            return null;
        }
        if (pval instanceof Sequence) {
            Sequence posSequence = (Sequence)pval;
            int posCount = posSequence.length();
            Sequence result = new Sequence(posCount);
            int i = 1;
            while (i <= posCount) {
                Object posObj = posSequence.get(i);
                if (posObj instanceof Number) {
                    int pos = MGet.convert((int)srcLen, (int)((Number)posObj).intValue(), (boolean)isRepeat, (boolean)false);
                    if (pos > 0) {
                        result.add(mems.get(pos));
                    } else if (reserveZero) {
                        result.add(null);
                    }
                } else if (posObj == null) {
                    if (reserveZero) {
                        result.add(null);
                    }
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("m" + mm.getMessage("function.paramTypeError"));
                }
                ++i;
            }
            return result;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("m" + mm.getMessage("function.paramTypeError"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object MGet(Sequence srcSequence, Object obj0, Object obj1, String option, Context ctx) {
        int pos1;
        int pos0;
        IArray mems = srcSequence.getMems();
        int srcLen = mems.size();
        boolean isRepeat = false;
        if (option != null && option.indexOf(114) != -1) {
            isRepeat = true;
        }
        if (obj0 != null) {
            if (!(obj0 instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("m" + mm.getMessage("function.paramTypeError"));
            }
            int n = ((Number)obj0).intValue();
            pos0 = MGet.convert((int)srcLen, (int)n, (boolean)isRepeat, (boolean)false);
            if (pos0 == 0) {
                if (n >= 0) return new Sequence();
                pos0 = 1;
            }
        } else {
            if (srcLen <= 0) return new Sequence();
            pos0 = 1;
        }
        if (obj1 != null) {
            if (!(obj1 instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("m" + mm.getMessage("function.paramTypeError"));
            }
            int n = ((Number)obj1).intValue();
            pos1 = MGet.convert((int)srcLen, (int)n, (boolean)isRepeat, (boolean)false);
            if (pos1 == 0) {
                if (n <= srcLen) return new Sequence();
                pos1 = srcLen;
            }
        } else {
            if (srcLen <= 0) return new Sequence();
            pos1 = srcLen;
        }
        if (pos0 <= pos1) {
            Sequence result = new Sequence(pos1 - pos0 + 1);
            int i = pos0;
            while (i <= pos1) {
                result.add(mems.get(i));
                ++i;
            }
            return result;
        }
        Sequence result = new Sequence(pos0 - pos1 + 1);
        int i = pos0;
        while (i >= pos1) {
            result.add(mems.get(i));
            --i;
        }
        return result;
    }

    public static Object getNullable(Sequence srcSequence, int seq) {
        if (seq < 1 || seq > srcSequence.length()) {
            return null;
        }
        return srcSequence.getMem(seq);
    }

    public static Object setNullable(Sequence srcSequence, int seq, Object value) {
        if (seq < 1 || seq > srcSequence.length()) {
            return value;
        }
        srcSequence.set(seq, value);
        return value;
    }

    public static Object getNullable(Table table, int seq, int index) {
        if (seq < 1 || seq > table.length()) {
            return null;
        }
        return table.getRecord(seq).getNormalFieldValue(index);
    }

    public static Object setNullable(Table table, int seq, int index, Object value) {
        if (seq < 1 || seq > table.length()) {
            return value;
        }
        table.getRecord(seq).setNormalFieldValue(index, value);
        return value;
    }

    public static int[] calculateIndexRange(int curIndex, int len, Number start, Number end) {
        int endSeq;
        int startSeq;
        if (curIndex < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.seriesNotInStack"));
        }
        if (start == null) {
            startSeq = 1;
        } else {
            startSeq = curIndex + start.intValue();
            if (startSeq < 1) {
                startSeq = 1;
            }
        }
        if (end == null) {
            endSeq = len;
        } else {
            endSeq = curIndex + end.intValue();
            if (endSeq > len) {
                endSeq = len;
            }
        }
        if (startSeq <= endSeq) {
            return new int[]{startSeq, endSeq};
        }
        return null;
    }

    public static Sequence getNullable(Sequence srcSequence, int curIndex, Number start, Number end) {
        if (srcSequence == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("engine.seriesNotInStack"));
        }
        int[] range = SequenceLib.calculateIndexRange(curIndex, srcSequence.length(), start, end);
        if (range == null) {
            return new Sequence(0);
        }
        int startSeq = range[0];
        int endSeq = range[1];
        Sequence result = new Sequence(endSeq - startSeq + 1);
        while (startSeq <= endSeq) {
            result.add(srcSequence.get(startSeq));
            ++startSeq;
        }
        return result;
    }

    public static Sequence getNullable(Table table, int curIndex, int findex, Number start, Number end) {
        if (table == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("[]" + mm.getMessage("engine.seriesNotInStack"));
        }
        int[] range = SequenceLib.calculateIndexRange(curIndex, table.length(), start, end);
        if (range == null) {
            return new Sequence(0);
        }
        int startSeq = range[0];
        int endSeq = range[1];
        Sequence result = new Sequence(endSeq - startSeq + 1);
        while (startSeq <= endSeq) {
            Object obj = table.getRecord(startSeq).getNormalFieldValue(findex);
            result.add(obj);
            ++startSeq;
        }
        return result;
    }
}

