/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.dql;

import com.scudata.dm.query.dql.ExpNode;
import com.scudata.dm.query.dql.FieldNode;
import com.scudata.dm.query.dql.GatherNode;
import com.scudata.dm.query.dql.INode;
import java.util.List;

class Case
extends INode {
    private ExpNode field;
    private List<ExpNode> whenList;
    private List<ExpNode> thenList;
    private ExpNode defaultExp;

    public void setCase(ExpNode field, List<ExpNode> whenList, List<ExpNode> thenList, ExpNode defaultExp) {
        this.field = field;
        this.whenList = whenList;
        this.thenList = thenList;
        this.defaultExp = defaultExp;
    }

    @Override
    public void listFieldNode(List<FieldNode> out) {
        if (this.field != null) {
            this.field.listFieldNode(out);
        }
        for (ExpNode exp : this.whenList) {
            exp.listFieldNode(out);
        }
        for (ExpNode exp : this.thenList) {
            exp.listFieldNode(out);
        }
        if (this.defaultExp != null) {
            this.defaultExp.listFieldNode(out);
        }
    }

    @Override
    public void listGatherNode(List<GatherNode> out) {
        if (this.field != null) {
            this.field.listGatherNode(out);
        }
        for (ExpNode exp : this.whenList) {
            exp.listGatherNode(out);
        }
        for (ExpNode exp : this.thenList) {
            exp.listGatherNode(out);
        }
        if (this.defaultExp != null) {
            this.defaultExp.listGatherNode(out);
        }
    }

    @Override
    public boolean isEquals(INode node) {
        if (!(node instanceof Case)) {
            return false;
        }
        Case other = (Case)node;
        if (!Case.isEquals((ExpNode)this.field, (ExpNode)other.field) || !Case.isEquals((ExpNode)this.defaultExp, (ExpNode)other.defaultExp)) {
            return false;
        }
        int count = this.whenList.size();
        if (count != other.whenList.size()) {
            return false;
        }
        int i = 0;
        while (i < count) {
            if (!Case.isEquals((ExpNode)this.whenList.get(i), (ExpNode)other.whenList.get(i)) || !Case.isEquals((ExpNode)this.thenList.get(i), (ExpNode)other.thenList.get(i))) {
                return false;
            }
            ++i;
        }
        return Case.isEquals((ExpNode)this.defaultExp, (ExpNode)other.defaultExp);
    }

    @Override
    public void replaceTableNode(INode leftNode) {
        if (this.field != null) {
            this.field.replaceTableNode(leftNode);
        }
        for (ExpNode exp : this.whenList) {
            exp.replaceTableNode(leftNode);
        }
        for (ExpNode exp : this.thenList) {
            exp.replaceTableNode(leftNode);
        }
        if (this.defaultExp != null) {
            this.defaultExp.replaceTableNode(leftNode);
        }
    }

    @Override
    public void toExpression(StringBuffer out) {
        if (this.field == null) {
            out.append("if(");
            int size = this.whenList.size();
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    out.append(",");
                }
                this.whenList.get(i).toExpression(out);
                out.append(":");
                this.thenList.get(i).toExpression(out);
                ++i;
            }
        } else {
            out.append("case(");
            this.field.toExpression(out);
            int size = this.whenList.size();
            int i = 0;
            while (i < size) {
                out.append(",");
                this.whenList.get(i).toExpression(out);
                out.append(":");
                this.thenList.get(i).toExpression(out);
                ++i;
            }
        }
        if (this.defaultExp != null) {
            out.append(";");
            this.defaultExp.toExpression(out);
        }
        out.append(")");
    }

    @Override
    public void toFinalExpression(StringBuffer out) {
        if (this.field == null) {
            out.append("if(");
            int size = this.whenList.size();
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    out.append(",");
                }
                this.whenList.get(i).toFinalExpression(out);
                out.append(":");
                this.thenList.get(i).toFinalExpression(out);
                ++i;
            }
        } else {
            out.append("case(");
            this.field.toFinalExpression(out);
            int size = this.whenList.size();
            int i = 0;
            while (i < size) {
                out.append(",");
                this.whenList.get(i).toFinalExpression(out);
                out.append(":");
                this.thenList.get(i).toFinalExpression(out);
                ++i;
            }
        }
        if (this.defaultExp != null) {
            out.append(";");
            this.defaultExp.toFinalExpression(out);
        }
        out.append(")");
    }
}

