/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.dql;

import com.scudata.common.Escape;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.query.dql.CommonNode;
import com.scudata.dm.query.dql.ExpNode;
import com.scudata.dm.query.dql.FieldNode;
import com.scudata.dm.query.dql.FunctionNode;
import com.scudata.dm.query.dql.IIIIIIIIIllIllll;
import com.scudata.dm.query.dql.IIIIllIlIIIIlIII;
import com.scudata.dm.query.dql.IIIllIlIIlIlIlIl;
import com.scudata.dm.query.dql.IIllIllIIIlllIll;
import com.scudata.dm.query.dql.INode;
import com.scudata.dm.query.dql.ITableNode;
import com.scudata.dm.query.dql.IlIlllIlIllIllll;
import com.scudata.dm.query.dql.NormalNode;
import com.scudata.dm.query.dql.ParenNode;
import com.scudata.dm.query.dql.TableNode;
import com.scudata.dm.query.dql.Token;
import com.scudata.dm.query.dql.Tokenizer;
import com.scudata.dm.query.metadata.AliasField;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.IField;
import com.scudata.dm.query.metadata.ITable;
import com.scudata.dm.query.metadata.LevelFunction;
import com.scudata.dm.query.metadata.LevelFunctionList;
import com.scudata.dm.query.metadata.Table;
import com.scudata.dm.query.metadata.TableList;
import com.scudata.dm.query.resources.ParseMessage;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DQLUtils {
    public static String toJSONString(String str) {
        if (str == null) {
            return "\"\"";
        }
        return Escape.addEscAndQuote((String)str);
    }

    public static IField getRightField(IField leftField, LevelFunction level, FieldNode rightFieldNode) {
        IField result;
        Table table;
        if (level != null) {
            leftField = level.getDestDim();
        }
        if ((table = leftField.getRefTable()) == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(leftField.getName() + mm.getMessage("field.illegalFK"));
        }
        String fieldName = rightFieldNode.getFieldName();
        String tableName = rightFieldNode.getTableName();
        if (tableName != null) {
            if (!table.isEquals(tableName) && (table = table.getAnnexTableByName(tableName)) == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(tableName + mm.getMessage("syntax.unknownTable"));
            }
            result = table.getField(fieldName);
        } else {
            result = table.getField(fieldName);
            if (result == null) {
                result = table.getAnnexTableField(fieldName);
            }
        }
        return result;
    }

    public static IField getField(ITable table, FieldNode fieldNode) {
        String fieldName = fieldNode.getFieldName();
        String tableName = fieldNode.getTableName();
        if (tableName != null) {
            TableList tableList;
            if (!(table.isEquals(tableName) || (tableList = table.getAnnexTableList()) != null && (table = tableList.getTableByName(tableName)) != null)) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(tableName + mm.getMessage("syntax.unknownTable"));
            }
            return table.getField(fieldName);
        }
        IField field = table.getField(fieldName);
        if (field != null) {
            return field;
        }
        TableList tableList = table.getAnnexTableList();
        if (tableList == null) {
            return null;
        }
        for (Table annexTable : tableList) {
            if (annexTable == table || (field = annexTable.getField(fieldName)) == null) continue;
            return field;
        }
        return null;
    }

    public static boolean canConvertTo(IField field, Field dim2) {
        if (field == null) {
            return false;
        }
        if (field == dim2 || field.getDim() == dim2) {
            return true;
        }
        return DQLUtils.getLevel(field, dim2) != null;
    }

    public static LevelFunction getLevel(IField field, Field dim2) {
        if (field == null) {
            return null;
        }
        Field dim1 = field.getDim();
        if (dim1 == null || dim2 == null || dim1 == dim2) {
            return null;
        }
        LevelFunctionList levelList = dim1.getLevelFunctionList();
        if (levelList == null) {
            return null;
        }
        for (LevelFunction level : levelList) {
            if (level.getDestDim() != dim2) continue;
            return level;
        }
        return null;
    }

    public static int getFieldNext(Token[] tokens, int start, int next) {
        ++start;
        while (start < next) {
            char type = tokens[start].getType();
            if (type == '.') {
                if (++start == next || tokens[start].getType() != '\u0001') {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
                }
            } else if (type != '#' && type != '@') {
                return start;
            }
            ++start;
        }
        return next;
    }

    public static boolean isAnnexTables(Table t1, Table t2) {
        return t1 == t2 || t1.getAnnexTableList() == t2.getAnnexTableList();
    }

    public static FieldNode scanTableField(ITableNode tableNode, Token[] tokens, int start, int next) {
        String name = tokens[start].getString();
        if (tableNode._$1(name) && start + 2 < next && tokens[start + 1].getType() == '.') {
            if (tokens[start += 2].getType() != '\u0001') {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
            }
            return DQLUtils.scanField(tableNode, tokens, start, next);
        }
        return DQLUtils.scanField(tableNode, tokens, start, next);
    }

    public static FieldNode scanField(INode leftNode, Token[] tokens, int start, int next) {
        String fieldName = tokens[start++].getString();
        String tableName = null;
        if (start < next && tokens[start].getType() == '@') {
            tableName = tokens[start++].getTableName();
        }
        String levelName = null;
        if (start < next && tokens[start].getType() == '#') {
            levelName = tokens[start++].getLevelName();
        }
        FieldNode fieldNode = new FieldNode(leftNode, fieldName, tableName, levelName);
        if (start == next) {
            return fieldNode;
        }
        if (tokens[start].getType() == '.') {
            if (++start == next || tokens[start].getType() != '\u0001') {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
            return DQLUtils.scanField(fieldNode, tokens, start, next);
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExpNode scanExp(ITableNode table, Token[] tokens, int start, int next) {
        if (start == next) {
            return null;
        }
        ArrayList<INode> nodeList = new ArrayList<INode>();
        for (int i = start; i < next; ++i) {
            void var8_9;
            block54: {
                char type;
                Token token;
                block60: {
                    block59: {
                        block58: {
                            block57: {
                                block55: {
                                    int pos;
                                    block56: {
                                        token = tokens[i];
                                        type = token.getType();
                                        if (type != '\u0001') break block55;
                                        pos = i + 1;
                                        if (pos != next) break block56;
                                        FieldNode fieldNode = new FieldNode(table, token.getString());
                                        INode iNode = DQLUtils.replaceAliasField(fieldNode);
                                        break block54;
                                    }
                                    if (tokens[pos].getType() == '(') {
                                        int end = Tokenizer.scanParen(tokens, pos, next);
                                        FunctionNode functionNode = DQLUtils.scanFunction(table, tokens, i, end);
                                        i = end;
                                        break block54;
                                    } else if (tokens[pos].getType() == '@' && pos + 1 < next && tokens[pos + 1].getType() == '(') {
                                        int end = Tokenizer.scanParen(tokens, pos + 1, next);
                                        FunctionNode functionNode = DQLUtils.scanFunction(table, tokens, i, end);
                                        i = end;
                                        break block54;
                                    } else {
                                        int fieldNext = DQLUtils.getFieldNext(tokens, i, next);
                                        FieldNode fieldNode = DQLUtils.scanTableField(table, tokens, i, fieldNext);
                                        INode iNode = DQLUtils.replaceAliasField(fieldNode);
                                        i = fieldNext - 1;
                                    }
                                    break block54;
                                }
                                if (type != '(') break block57;
                                int end = Tokenizer.scanParen(tokens, i, next);
                                ExpNode expNode = DQLUtils.scanExp(table, tokens, i + 1, end);
                                ParenNode parenNode = new ParenNode(expNode);
                                i = end;
                                break block54;
                            }
                            if (!token.equals("!")) break block58;
                            if (i + 1 < next && tokens[i + 1].equals("=")) {
                                ++i;
                                CommonNode commonNode = new CommonNode("!=");
                                break block54;
                            } else {
                                NormalNode normalNode = new NormalNode(token);
                            }
                            break block54;
                        }
                        if (!token.equals("=")) break block59;
                        if (i + 1 < next && tokens[i + 1].equals("=")) {
                            ++i;
                        }
                        CommonNode commonNode = new CommonNode("==");
                        break block54;
                    }
                    if (!token.equals("<")) break block60;
                    if (i + 1 < next && tokens[i + 1].equals(">")) {
                        CommonNode commonNode = new CommonNode("!=");
                        ++i;
                        break block54;
                    } else if (i + 1 < next && tokens[i + 1].equals("=")) {
                        CommonNode commonNode = new CommonNode("<=");
                        ++i;
                        break block54;
                    } else {
                        CommonNode commonNode = new CommonNode("<");
                    }
                    break block54;
                }
                if (token.equals(">")) {
                    if (i + 1 < next && tokens[i + 1].equals("=")) {
                        CommonNode commonNode = new CommonNode(">=");
                        ++i;
                    } else {
                        CommonNode commonNode = new CommonNode(">");
                    }
                } else if (token.isKeyWord("IN")) {
                    if (++i == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                    }
                    if (tokens[i].getType() != '(') {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                    }
                    int end = Tokenizer.scanParen(tokens, i, next);
                    ExpNode param = DQLUtils.scanExp(table, tokens, i + 1, end);
                    boolean isNot = false;
                    INode last = DQLUtils.removeLastNot(nodeList);
                    if (last != null) {
                        isNot = true;
                    }
                    last = DQLUtils.removeLastLogic(nodeList, "IN");
                    IlIlllIlIllIllll ilIlllIlIllIllll = new IlIlllIlIllIllll(last, param, isNot);
                    i = end;
                } else if (type == '\u0000' && i + 1 < next && tokens[i + 1].getType() == '(') {
                    try {
                        int end = Tokenizer.scanParen(tokens, i + 1, next);
                        FunctionNode functionNode = DQLUtils.scanFunction(table, tokens, i, end);
                        i = end;
                    }
                    catch (Exception e) {
                        NormalNode normalNode = new NormalNode(token);
                    }
                } else if (type == '\u0000' && i + 2 < next && tokens[i + 1].getType() == '@' && tokens[i + 2].getType() == '(') {
                    try {
                        int end = Tokenizer.scanParen(tokens, i + 2, next);
                        FunctionNode functionNode = DQLUtils.scanFunction(table, tokens, i, end);
                        i = end;
                    }
                    catch (Exception e) {
                        NormalNode normalNode = new NormalNode(token);
                    }
                } else if (token.isKeyWord("IS")) {
                    if (++i == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                    }
                    if (tokens[i].isKeyWord("NULL")) {
                        CommonNode commonNode = new CommonNode("==null");
                    } else {
                        if (!tokens[i].isKeyWord("NOT")) {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                        }
                        if (++i == next || !tokens[i].isKeyWord("NULL")) {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                        }
                        CommonNode commonNode = new CommonNode("!=null");
                    }
                } else if (token.isKeyWord("CASE")) {
                    IIIIllIlIIIIlIII caseNode = new IIIIllIlIIIIlIII();
                    i = DQLUtils._$1(table, tokens, i, next, caseNode);
                    IIIIllIlIIIIlIII iIIIllIlIIIIlIII = caseNode;
                } else if (token.isKeyWord("LIKE")) {
                    if (++i == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                    }
                    int end = Tokenizer.scanLogicalOperator(tokens, i, next);
                    if (end == -1) {
                        end = next;
                    }
                    ExpNode exp = DQLUtils.scanExp(table, tokens, i, end);
                    boolean isNot = false;
                    INode last = DQLUtils.removeLastNot(nodeList);
                    if (last != null) {
                        isNot = true;
                    }
                    last = DQLUtils.removeLastLogic(nodeList, "LIKE");
                    IIllIllIIIlllIll iIllIllIIIlllIll = new IIllIllIIIlllIll(last, exp, isNot);
                    i = end - 1;
                } else if (token.isKeyWord("BETWEEN")) {
                    if (++i == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                    }
                    int end = Tokenizer.scanKeyWord("AND", tokens, i, next);
                    if (end == -1) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                    }
                    ExpNode from = DQLUtils.scanExp(table, tokens, i, end);
                    i = end + 1;
                    if (i == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                    }
                    end = Tokenizer.scanLogicalOperator(tokens, i, next);
                    if (end == -1) {
                        end = next;
                    }
                    ExpNode to = DQLUtils.scanExp(table, tokens, i, end);
                    boolean isNot = false;
                    INode last = DQLUtils.removeLastNot(nodeList);
                    if (last != null) {
                        isNot = true;
                    }
                    last = DQLUtils.removeLastLogic(nodeList, "BETWEEN");
                    IIIllIlIIlIlIlIl iIIllIlIIlIlIlIl = new IIIllIlIIlIlIlIl(last, from, to, isNot);
                    i = end - 1;
                } else if (token.isKeyWord("AND") || token.isKeyWord("OR") || token.isKeyWord("NOT")) {
                    NormalNode normalNode = new NormalNode(token);
                } else {
                    NormalNode normalNode = new NormalNode(token);
                }
            }
            nodeList.add((INode)var8_9);
        }
        int size = nodeList.size();
        if (size == 0) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[next - 1].getPos());
        }
        INode[] nodes = new INode[size];
        nodeList.toArray(nodes);
        return new ExpNode(nodes);
    }

    private static int _$1(ITableNode table, Token[] tokens, int start, int next, IIIIllIlIIIIlIII caseNode) {
        int pos;
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        ExpNode field = null;
        ArrayList<ExpNode> whenList = new ArrayList<ExpNode>();
        ArrayList<ExpNode> thenList = new ArrayList<ExpNode>();
        ExpNode defaultExp = null;
        if (!tokens[start].isKeyWord("WHEN")) {
            pos = Tokenizer.scanKeyWord("WHEN", tokens, start + 1, next);
            if (pos == -1) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
            }
            field = DQLUtils.scanExp(table, tokens, start, pos);
            start = pos;
        }
        while (true) {
            MessageManager mm;
            if (start == next) {
                MessageManager mm2 = ParseMessage.get();
                throw new RQException(mm2.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
            if (tokens[start].isKeyWord("WHEN")) {
                if ((pos = Tokenizer.scanKeyWord("THEN", tokens, ++start, next)) == -1) {
                    mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
                }
                ExpNode when = DQLUtils.scanExp(table, tokens, start, pos);
                start = pos + 1;
                if ((pos = Tokenizer.scanNextCaseKeyWord(tokens, start, next)) == -1) {
                    MessageManager mm3 = ParseMessage.get();
                    throw new RQException(mm3.getMessage("syntax.error") + tokens[start].getPos());
                }
                ExpNode then = DQLUtils.scanExp(table, tokens, start, pos);
                whenList.add(when);
                thenList.add(then);
                start = pos;
                continue;
            }
            if (!tokens[start].isKeyWord("ELSE")) break;
            pos = Tokenizer.scanKeyWord("END", tokens, start, next);
            if (pos == -1) {
                mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
            }
            defaultExp = DQLUtils.scanExp(table, tokens, ++start, pos);
            start = pos;
        }
        if (tokens[start].isKeyWord("END")) {
            caseNode.setCase(field, whenList, thenList, defaultExp);
            return start;
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
    }

    private static int _$1(IIIIIIIIIllIllll onNode, TableNode destTable, Token[] tokens, int start, int next, IIIIllIlIIIIlIII caseNode) {
        int pos;
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        ExpNode field = null;
        ArrayList<ExpNode> whenList = new ArrayList<ExpNode>();
        ArrayList<ExpNode> thenList = new ArrayList<ExpNode>();
        ExpNode defaultExp = null;
        if (!tokens[start].isKeyWord("WHEN")) {
            pos = Tokenizer.scanKeyWord("WHEN", tokens, start + 1, next);
            if (pos == -1) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
            }
            field = DQLUtils.scanDimExp(onNode, tokens, start, pos, destTable);
            start = pos;
        }
        while (true) {
            MessageManager mm;
            if (start == next) {
                MessageManager mm2 = ParseMessage.get();
                throw new RQException(mm2.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
            if (tokens[start].isKeyWord("WHEN")) {
                if ((pos = Tokenizer.scanKeyWord("THEN", tokens, ++start, next)) == -1) {
                    mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
                }
                ExpNode when = DQLUtils.scanDimExp(onNode, tokens, start, pos, destTable);
                start = pos + 1;
                if ((pos = Tokenizer.scanNextCaseKeyWord(tokens, start, next)) == -1) {
                    MessageManager mm3 = ParseMessage.get();
                    throw new RQException(mm3.getMessage("syntax.error") + tokens[start].getPos());
                }
                ExpNode then = DQLUtils.scanDimExp(onNode, tokens, start, pos, destTable);
                whenList.add(when);
                thenList.add(then);
                start = pos;
                continue;
            }
            if (!tokens[start].isKeyWord("ELSE")) break;
            pos = Tokenizer.scanKeyWord("END", tokens, start, next);
            if (pos == -1) {
                mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
            }
            defaultExp = DQLUtils.scanDimExp(onNode, tokens, ++start, pos, destTable);
            start = pos;
        }
        if (tokens[start].isKeyWord("END")) {
            caseNode.setCase(field, whenList, thenList, defaultExp);
            return start;
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
    }

    public static FunctionNode scanFunction(ITableNode table, Token[] tokens, int start, int end) {
        int paramPos;
        String name = tokens[start].getOriginString();
        String opt = null;
        if (tokens[start + 1].getType() == '@') {
            opt = tokens[start + 1].getOriginString();
            paramPos = start + 3;
        } else {
            paramPos = start + 2;
        }
        ExpNode param = DQLUtils.scanExp(table, tokens, paramPos, end);
        return new FunctionNode(name, opt, param);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExpNode scanDimExp(IIIIIIIIIllIllll onNode, Token[] tokens, int start, int next, TableNode destTable) {
        if (start == next) {
            return null;
        }
        ArrayList<INode> nodeList = new ArrayList<INode>();
        for (int i = start; i < next; ++i) {
            void var9_10;
            block54: {
                char type;
                Token token;
                block60: {
                    block59: {
                        block58: {
                            block57: {
                                block55: {
                                    int pos;
                                    block56: {
                                        token = tokens[i];
                                        type = token.getType();
                                        if (type != '\u0001') break block55;
                                        pos = i + 1;
                                        if (pos != next) break block56;
                                        FieldNode fieldNode = DQLUtils._$2(onNode, tokens, i, pos, destTable);
                                        break block54;
                                    }
                                    if (tokens[pos].getType() == '(') {
                                        int end = Tokenizer.scanParen(tokens, pos, next);
                                        FunctionNode functionNode = DQLUtils._$1(onNode, tokens, i, end, destTable);
                                        i = end;
                                        break block54;
                                    } else if (tokens[pos].getType() == '@' && pos + 1 < next && tokens[pos + 1].getType() == '(') {
                                        int end = Tokenizer.scanParen(tokens, pos + 1, next);
                                        FunctionNode functionNode = DQLUtils._$1(onNode, tokens, i, end, destTable);
                                        i = end;
                                        break block54;
                                    } else {
                                        int fieldNext = DQLUtils.getFieldNext(tokens, i, next);
                                        FieldNode fieldNode = DQLUtils._$2(onNode, tokens, i, fieldNext, destTable);
                                        i = fieldNext - 1;
                                    }
                                    break block54;
                                }
                                if (type != '(') break block57;
                                int end = Tokenizer.scanParen(tokens, i, next);
                                ExpNode expNode = DQLUtils.scanDimExp(onNode, tokens, i + 1, end, destTable);
                                ParenNode parenNode = new ParenNode(expNode);
                                i = end;
                                break block54;
                            }
                            if (!token.equals("!")) break block58;
                            if (i + 1 < next && tokens[i + 1].equals("=")) {
                                ++i;
                                CommonNode commonNode = new CommonNode("!=");
                                break block54;
                            } else {
                                NormalNode normalNode = new NormalNode(token);
                            }
                            break block54;
                        }
                        if (!token.equals("=")) break block59;
                        if (i + 1 < next && tokens[i + 1].equals("=")) {
                            ++i;
                        }
                        CommonNode commonNode = new CommonNode("==");
                        break block54;
                    }
                    if (!token.equals("<")) break block60;
                    if (i + 1 < next && tokens[i + 1].equals(">")) {
                        CommonNode commonNode = new CommonNode("!=");
                        ++i;
                        break block54;
                    } else if (i + 1 < next && tokens[i + 1].equals("=")) {
                        CommonNode commonNode = new CommonNode("<=");
                        ++i;
                        break block54;
                    } else {
                        CommonNode commonNode = new CommonNode("<");
                    }
                    break block54;
                }
                if (token.equals(">")) {
                    if (i + 1 < next && tokens[i + 1].equals("=")) {
                        CommonNode commonNode = new CommonNode(">=");
                        ++i;
                    } else {
                        CommonNode commonNode = new CommonNode(">");
                    }
                } else if (token.isKeyWord("IS")) {
                    if (++i == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                    }
                    if (tokens[i].isKeyWord("NULL")) {
                        CommonNode commonNode = new CommonNode("==null");
                    } else {
                        if (!tokens[i].isKeyWord("NOT")) {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                        }
                        if (++i == next || !tokens[i].isKeyWord("NULL")) {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                        }
                        CommonNode commonNode = new CommonNode("!=null");
                    }
                } else if (token.isKeyWord("CASE")) {
                    IIIIllIlIIIIlIII caseNode = new IIIIllIlIIIIlIII();
                    i = DQLUtils._$1(onNode, destTable, tokens, i, next, caseNode);
                    IIIIllIlIIIIlIII iIIIllIlIIIIlIII = caseNode;
                } else if (token.isKeyWord("LIKE")) {
                    if (++i == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                    }
                    int end = Tokenizer.scanLogicalOperator(tokens, i, next);
                    if (end == -1) {
                        end = next;
                    }
                    ExpNode exp = DQLUtils.scanDimExp(onNode, tokens, i, end, destTable);
                    boolean isNot = false;
                    INode last = DQLUtils.removeLastNot(nodeList);
                    if (last != null) {
                        isNot = true;
                    }
                    last = DQLUtils.removeLastLogic(nodeList, "LIKE");
                    IIllIllIIIlllIll iIllIllIIIlllIll = new IIllIllIIIlllIll(last, exp, isNot);
                    i = end - 1;
                } else if (token.isKeyWord("IN")) {
                    if (++i == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                    }
                    if (tokens[i].getType() != '(') {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                    }
                    int end = Tokenizer.scanParen(tokens, i, next);
                    ExpNode param = DQLUtils.scanDimExp(onNode, tokens, i + 1, end, destTable);
                    boolean isNot = false;
                    INode last = DQLUtils.removeLastNot(nodeList);
                    if (last != null) {
                        isNot = true;
                    }
                    last = DQLUtils.removeLastLogic(nodeList, "IN");
                    IlIlllIlIllIllll ilIlllIlIllIllll = new IlIlllIlIllIllll(last, param, isNot);
                    i = end;
                } else if (token.isKeyWord("BETWEEN")) {
                    if (++i == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                    }
                    int end = Tokenizer.scanKeyWord("AND", tokens, i, next);
                    if (end == -1) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                    }
                    ExpNode from = DQLUtils.scanDimExp(onNode, tokens, i, end, destTable);
                    i = end + 1;
                    if (i == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                    }
                    end = Tokenizer.scanLogicalOperator(tokens, i, next);
                    if (end == -1) {
                        end = next;
                    }
                    ExpNode to = DQLUtils.scanDimExp(onNode, tokens, i, end, destTable);
                    boolean isNot = false;
                    INode last = DQLUtils.removeLastNot(nodeList);
                    if (last != null) {
                        isNot = true;
                    }
                    last = DQLUtils.removeLastLogic(nodeList, "BETWEEN");
                    IIIllIlIIlIlIlIl iIIllIlIIlIlIlIl = new IIIllIlIIlIlIlIl(last, from, to, isNot);
                    i = end - 1;
                } else if (token.isKeyWord("AND") || token.isKeyWord("OR") || token.isKeyWord("NOT")) {
                    NormalNode normalNode = new NormalNode(token);
                } else if (type == '\u0000' && i + 1 < next && tokens[i + 1].getType() == '(') {
                    try {
                        int end = Tokenizer.scanParen(tokens, i + 1, next);
                        FunctionNode functionNode = DQLUtils._$1(onNode, tokens, i, end, destTable);
                        i = end;
                    }
                    catch (Exception e) {
                        NormalNode normalNode = new NormalNode(token);
                    }
                } else if (type == '\u0000' && i + 2 < next && tokens[i + 1].getType() == '@' && tokens[i + 2].getType() == '(') {
                    try {
                        int end = Tokenizer.scanParen(tokens, i + 2, next);
                        FunctionNode functionNode = DQLUtils._$1(onNode, tokens, i, end, destTable);
                        i = end;
                    }
                    catch (Exception e) {
                        NormalNode normalNode = new NormalNode(token);
                    }
                } else {
                    NormalNode normalNode = new NormalNode(token);
                }
            }
            nodeList.add((INode)var9_10);
        }
        int size = nodeList.size();
        if (size == 0) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[next - 1].getPos());
        }
        INode[] nodes = new INode[size];
        nodeList.toArray(nodes);
        return new ExpNode(nodes);
    }

    private static FieldNode _$2(IIIIIIIIIllIllll onNode, Token[] tokens, int start, int next, TableNode destTable) {
        String dimName = tokens[start].getString();
        int index = onNode.getDimIndex(dimName);
        if (index == -1) {
            if (onNode.getDimCount() == 1) {
                FieldNode fieldNode = destTable.getByField(0);
                return DQLUtils.scanField(fieldNode, tokens, start, next);
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        FieldNode fieldNode = destTable.getByField(index);
        if (++start == next) {
            return fieldNode;
        }
        if (tokens[start].getType() == '.') {
            if (++start == next || tokens[start].getType() != '\u0001') {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
            return DQLUtils.scanField(fieldNode, tokens, start, next);
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
    }

    private static FunctionNode _$1(IIIIIIIIIllIllll onNode, Token[] tokens, int start, int end, TableNode destTable) {
        int paramPos;
        String name = tokens[start].getOriginString();
        String opt = null;
        if (tokens[start + 1].getType() == '@') {
            opt = tokens[start + 1].getOriginString();
            paramPos = start + 3;
        } else {
            paramPos = start + 2;
        }
        ExpNode param = DQLUtils.scanDimExp(onNode, tokens, paramPos, end, destTable);
        return new FunctionNode(name, opt, param);
    }

    public static String convert(String fieldExp, LevelFunction level) {
        String formula = level.getFormula();
        return StringUtils.replace((String)formula, (String)"?", (String)fieldExp);
    }

    public static INode replaceAliasField(INode node) {
        if (!(node instanceof FieldNode)) {
            return node;
        }
        FieldNode fieldNode = (FieldNode)node;
        IField field = fieldNode.getField();
        if (field instanceof AliasField) {
            ExpNode expNode = ((AliasField)field).getExpNode();
            expNode.replaceTableNode(fieldNode.getLeft());
            ParenNode paren = new ParenNode(expNode);
            paren.setAliasName(field.getName());
            return paren;
        }
        return node;
    }

    public static INode removeLastNot(List<INode> nodeList) {
        int last = nodeList.size() - 1;
        if (last >= 0 && nodeList.get(last).isNotOperator()) {
            return nodeList.remove(last);
        }
        return null;
    }

    public static INode removeLastLogic(List<INode> nodeList, String errorInfo) {
        int count;
        int start;
        int size = nodeList.size();
        for (start = size - 1; start >= 0 && !nodeList.get(start).isLogicalOperator(); --start) {
        }
        if ((count = size - ++start) == 1) {
            return nodeList.remove(start);
        }
        if (count > 1) {
            INode[] nodes = new INode[count];
            for (int i = 0; i < count; ++i) {
                nodes[i] = nodeList.remove(start);
            }
            return new ExpNode(nodes);
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException(mm.getMessage("syntax.error") + errorInfo);
    }
}

