/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.dql;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.IMultipath;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.query.dql.DQLUtils;
import com.scudata.dm.query.dql.FieldConvertor;
import com.scudata.dm.query.dql.FieldNode;
import com.scudata.dm.query.dql.JoinOperation;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.FieldList;
import com.scudata.dm.query.metadata.ForeignKey;
import com.scudata.dm.query.metadata.ForeignKeyList;
import com.scudata.dm.query.metadata.IField;
import com.scudata.dm.query.metadata.ITable;
import com.scudata.dm.query.metadata.LevelFunction;
import com.scudata.dm.query.metadata.Table;
import com.scudata.dm.query.metadata.TableVisibility;
import com.scudata.dm.query.resources.ParseMessage;
import com.scudata.expression.Expression;
import com.scudata.pseudo.Pseudo;
import com.scudata.resources.EngineMessage;
import java.util.ArrayList;
import java.util.List;

class TableConvertor {
    private ITable table;
    private List<String> invisibleFieldList;
    private Object sourceObject;
    private Context ctx;
    private ArrayList<FieldConvertor> fieldList = new ArrayList();
    private String joinFieldName;
    private ArrayList<Expression> filterList = new ArrayList();
    private ArrayList<JoinOperation> joinList = new ArrayList();
    private ArrayList<String> selectFieldList = new ArrayList();

    public TableConvertor(ITable table, Context ctx) {
        this.table = table;
        this.ctx = ctx;
        this.sourceObject = table.getSourceObject();
        if (!(this.sourceObject instanceof Sequence) && !(this.sourceObject instanceof Pseudo)) {
            MessageManager mm = ParseMessage.get();
            String msg = mm.getMessage("config.tableSourceError", (Object)table.getName());
            throw new RQException(msg);
        }
    }

    public ITable getTable() {
        return this.table;
    }

    public void setTableVisibility(TableVisibility visibility) {
        this.invisibleFieldList = visibility.getInvisibleFieldList();
    }

    public Pseudo getPseudoTable() {
        if (this.sourceObject instanceof Pseudo) {
            return (Pseudo)((Object)this.sourceObject);
        }
        return null;
    }

    private Sequence getSourceData() {
        return this.cursor(true).fetch();
    }

    public FieldConvertor getFieldConvertor(FieldNode fieldNode) {
        FieldConvertor fieldConvertor2;
        for (FieldConvertor fieldConvertor2 : this.fieldList) {
            if (!fieldConvertor2.isCompatible(fieldNode)) continue;
            return fieldConvertor2;
        }
        fieldConvertor2 = this.createFieldConvertor(fieldNode);
        this.fieldList.add(fieldConvertor2);
        return fieldConvertor2;
    }

    public FieldConvertor getFieldConvertor(FieldNode fieldNode, FieldNode rightFieldNode) {
        FieldConvertor fieldConvertor2;
        for (FieldConvertor fieldConvertor2 : this.fieldList) {
            if (!fieldConvertor2.isCompatible(fieldNode, rightFieldNode)) continue;
            return fieldConvertor2;
        }
        fieldConvertor2 = this.createFieldConvertor(fieldNode, rightFieldNode);
        this.fieldList.add(fieldConvertor2);
        return fieldConvertor2;
    }

    private FieldConvertor getAnnexTableFK(Table annexTable) {
        Table table = (Table)this.table;
        ForeignKeyList fkList = table.getForeignKeyList();
        ForeignKey foreignKey = null;
        if (fkList != null) {
            for (ForeignKey fk : fkList) {
                if (fk.getRefTable() != annexTable || !fk.isPrimary()) continue;
                foreignKey = fk;
                break;
            }
        }
        if (foreignKey == null) {
            foreignKey = new ForeignKey(annexTable.getLogicMetaData());
            foreignKey.setName("FK_" + annexTable.getName());
            foreignKey.setFieldNameList(table.getPK());
            foreignKey.setRefTableName(annexTable.getName());
            foreignKey.setRefFieldNameList(annexTable.getPK());
            foreignKey.setTable(table);
            foreignKey.setFieldList(table.getPKFieldList());
            foreignKey.setRefTable(annexTable);
            foreignKey.setRefFieldList(annexTable.getPKFieldList());
        }
        for (FieldConvertor fieldConvertor : this.fieldList) {
            if (!fieldConvertor.isCompatible(foreignKey)) continue;
            return fieldConvertor;
        }
        TableConvertor refTable = new TableConvertor(annexTable, this.ctx);
        FieldConvertor fieldConvertor = new FieldConvertor(this, foreignKey, null, refTable);
        this.fieldList.add(fieldConvertor);
        return fieldConvertor;
    }

    public FieldConvertor createFieldConvertor(FieldNode fieldNode) {
        IField field = DQLUtils.getField(this.table, fieldNode);
        if (field == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(fieldNode.getFieldName()) + mm.getMessage("field.notExist"));
        }
        if (field.getTable() != null && field.getTable() != this.table) {
            FieldConvertor fieldConvertor = this.getAnnexTableFK(field.getTable());
            return fieldConvertor.getFieldConvertor(fieldNode);
        }
        LevelFunction level = null;
        String levelName = fieldNode.getLevelName();
        if (levelName != null) {
            if (!(field instanceof Field)) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(levelName) + mm.getMessage("syntax.unknownLevel"));
            }
            level = ((Field)field).getLevelFunctionByName(levelName);
            if (level == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(levelName) + mm.getMessage("syntax.unknownLevel"));
            }
        }
        return new FieldConvertor(this, field, level);
    }

    public FieldConvertor createFieldConvertor(FieldNode fieldNode, FieldNode rightFieldNode) {
        IField rightField;
        IField field = DQLUtils.getField(this.table, fieldNode);
        if (field == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(fieldNode.getFieldName()) + mm.getMessage("field.notExist"));
        }
        if (field.getTable() != null && field.getTable() != this.table) {
            FieldConvertor fieldConvertor = this.getAnnexTableFK(field.getTable());
            return fieldConvertor.getFieldConvertor(fieldNode, rightFieldNode);
        }
        LevelFunction level = null;
        String levelName = fieldNode.getLevelName();
        if (levelName != null) {
            if (!(field instanceof Field)) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(levelName) + mm.getMessage("syntax.unknownLevel"));
            }
            level = ((Field)field).getLevelFunctionByName(levelName);
            if (level == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(String.valueOf(levelName) + mm.getMessage("syntax.unknownLevel"));
            }
        }
        if ((rightField = DQLUtils.getRightField(field, level, rightFieldNode)) == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(String.valueOf(rightFieldNode.getFieldName()) + mm.getMessage("field.notExist"));
        }
        TableConvertor refTable = new TableConvertor(rightField.getTable(), this.ctx);
        return new FieldConvertor(this, field, level, refTable);
    }

    public void analyse() {
        List<String> invisibleFieldList = this.invisibleFieldList;
        if (invisibleFieldList == null) {
            for (FieldConvertor field : this.fieldList) {
                field.analyse();
            }
        } else {
            for (FieldConvertor field : this.fieldList) {
                String fieldName = field.getFieldName();
                for (String invisibleField : invisibleFieldList) {
                    if (!fieldName.equalsIgnoreCase(invisibleField)) continue;
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(String.valueOf(fieldName) + mm.getMessage("field.invisible"));
                }
                field.analyse();
            }
        }
    }

    public String addForeignKey(IField field, LevelFunction level, TableConvertor tableConvertor) {
        if (field instanceof Field) {
            this.addSelectField(((Field)field).getSource());
        } else {
            FieldList fieldList = ((ForeignKey)field).getFieldList();
            for (Field srcField : fieldList) {
                this.addSelectField(srcField.getSource());
            }
        }
        JoinOperation join = new JoinOperation(field, level, tableConvertor);
        this.joinList.add(join);
        ITable refTable = tableConvertor.getTable();
        return String.valueOf(field.getName()) + "@" + refTable.getName();
    }

    public void addFilter(Expression exp, Context ctx) {
        this.filterList.add(exp);
    }

    public String getJoinFieldName() {
        return this.joinFieldName;
    }

    public void setJoinFieldName(String joinFieldName) {
        this.joinFieldName = joinFieldName;
    }

    public String[] getPrimaryKey() {
        FieldList pkList = this.table.getPKFieldList();
        if (pkList == null || pkList.size() == 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        int count = pkList.size();
        String[] pks = new String[count];
        int i = 0;
        while (i < count) {
            pks[i] = ((Field)pkList.get(i)).getSource();
            ++i;
        }
        return pks;
    }

    public String[] getPrimaryKey(int count) {
        FieldList pkList = this.table.getPKFieldList();
        if (pkList == null || pkList.size() < count) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("dw.segFieldNotMatch"));
        }
        String[] pks = new String[count];
        int i = 0;
        while (i < count) {
            pks[i] = ((Field)pkList.get(i)).getSource();
            ++i;
        }
        return pks;
    }

    public ICursor cursor(boolean containKey) {
        return this.cursor(containKey, null);
    }

    public ICursor cursor(boolean containKey, ICursor syncCursor) {
        FieldList pkList;
        Pseudo operable;
        ArrayList<String> fieldNameList = new ArrayList<String>();
        if (containKey) {
            FieldList fieldList = this.table.getPKFieldList();
            for (Object field : fieldList) {
                fieldNameList.add(((Field)field).getSource());
            }
        }
        for (String field : this.selectFieldList) {
            if (fieldNameList.contains(field)) continue;
            fieldNameList.add(field);
        }
        Object fields = new String[fieldNameList.size()];
        fieldNameList.toArray((T[])fields);
        if (this.sourceObject instanceof Pseudo) {
            operable = (Pseudo)((Object)this.sourceObject);
        } else {
            Sequence seq = (Sequence)this.sourceObject;
            if (syncCursor instanceof MultipathCursors) {
                pkList = this.table.getPKFieldList();
                int keyCount = pkList.size();
                String[] keys = new String[keyCount];
                int k = 0;
                while (k < keyCount) {
                    keys[k] = ((Field)pkList.get(k)).getSource();
                    ++k;
                }
                operable = TableConvertor.createSyncCursor(seq, keys, (IMultipath)((MultipathCursors)syncCursor), this.ctx);
            } else {
                operable = seq.cursor();
            }
        }
        int joinCount = this.joinList.size();
        if (joinCount > 0) {
            ArrayList<String> fkNameList = new ArrayList<String>(joinCount);
            ArrayList<Expression[]> fkExpsList = new ArrayList<Expression[]>();
            ArrayList<Sequence> refTableList = new ArrayList<Sequence>();
            ArrayList<Expression[]> keyExpsList = new ArrayList<Expression[]>();
            for (JoinOperation join : this.joinList) {
                FieldList pkList2;
                Expression[] exps;
                IField field = join.getField();
                LevelFunction level = join.getLevel();
                TableConvertor tableConvertor = join.getTableConvertor();
                ITable refTable = tableConvertor.getTable();
                boolean isMerge = false;
                if (field instanceof Field) {
                    String source = "~." + FieldConvertor.getFieldValueRefExp((Field)field);
                    if (level != null) {
                        source = DQLUtils.convert(source, level);
                    }
                    exps = new Expression[]{new Expression(this.ctx, source)};
                    if (tableConvertor.getTable().isSorted() && this.table.isSorted()) {
                        pkList2 = this.table.getPKFieldList();
                        isMerge = pkList2 != null && pkList2.get(0) == field;
                    }
                } else {
                    ForeignKey fk = (ForeignKey)field;
                    if (refTable.isSorted() && this.table.isSorted()) {
                        isMerge = fk.isMergeJoin();
                    }
                    FieldList fieldList = fk.getFieldList();
                    int size = fieldList.size();
                    exps = new Expression[size];
                    int i = 0;
                    while (i < size) {
                        Field srcField = (Field)fieldList.get(i);
                        String source = "~." + FieldConvertor.getFieldValueRefExp(srcField);
                        exps[i] = new Expression(this.ctx, source);
                        ++i;
                    }
                }
                String fkName = String.valueOf(field.getName()) + "@" + refTable.getName();
                pkList2 = refTable.getPKFieldList();
                int pkCount = pkList2.size();
                Expression[] keyExps = new Expression[pkCount];
                int i = 0;
                while (i < pkCount) {
                    Field key = (Field)pkList2.get(i);
                    String source = "~." + FieldConvertor.getFieldValueRefExp(key);
                    keyExps[i] = new Expression(this.ctx, source);
                    ++i;
                }
                if (isMerge) {
                    ICursor[] cursors = new ICursor[]{tableConvertor.cursor(true, syncCursor)};
                    Expression[][] refKeyExps = new Expression[][]{keyExps};
                    Expression[] curExps = new Expression[]{new Expression("~")};
                    Expression[][] refExps = new Expression[][]{curExps};
                    String[][] dimNames = new String[][]{{fkName}};
                    String opt = null;
                    if (refTable instanceof Table && ((Table)refTable).isHasTimeKey()) {
                        opt = "t";
                    }
                    operable = operable.pjoin(null, exps, null, null, cursors, new String[1], refKeyExps, refExps, dimNames, opt, this.ctx);
                    continue;
                }
                Sequence refData = tableConvertor.getSourceData();
                fkNameList.add(fkName);
                fkExpsList.add(exps);
                refTableList.add(refData);
                keyExpsList.add(keyExps);
            }
            int fkCount = fkNameList.size();
            if (fkCount > 0) {
                Expression[][] fkExps = new Expression[fkCount][];
                Sequence[] dimTables = new Sequence[fkCount];
                Expression[][] keyExps = new Expression[fkCount][];
                fkExpsList.toArray((T[])fkExps);
                keyExpsList.toArray((T[])keyExps);
                Expression[][] dimExps = new Expression[fkCount][];
                String[][] dimNames = new String[fkCount][];
                int i = 0;
                while (i < fkCount) {
                    dimTables[i] = (Sequence)refTableList.get(i);
                    dimExps[i] = new Expression[]{new Expression("~")};
                    dimNames[i] = new String[]{(String)fkNameList.get(i)};
                    ++i;
                }
                operable = operable.join(null, null, fkExps, dimTables, keyExps, dimExps, dimNames, null, this.ctx);
            }
        }
        for (Expression exp : this.filterList) {
            operable = operable.select(null, exp, null, this.ctx);
        }
        if (operable instanceof ICursor) {
            return (ICursor)operable;
        }
        if (((String[])fields).length == 0) {
            pkList = this.table.getPKFieldList();
            fields = pkList == null || pkList.size() == 0 ? null : new String[]{((Field)pkList.get(0)).getSource()};
        }
        return operable.cursor(null, (String[])fields);
    }

    private static ICursor createSyncCursor(Sequence seq, String[] keys1, IMultipath mcs, Context ctx) {
        ICursor[] cursors = mcs.getParallelCursors();
        int pathCount = cursors.length;
        if (pathCount == 1) {
            ICursor[] resultCursors = new ICursor[]{seq.cursor()};
            return new MultipathCursors(resultCursors, ctx);
        }
        int len = seq.length();
        int fcount = keys1.length;
        Object[][] minValues = new Object[pathCount][];
        int i = 0;
        while (i < pathCount) {
            Sequence data = cursors[i].peek(1);
            if (data == null) {
                throw new RQException("Less data.");
            }
            BaseRecord r = (BaseRecord)data.get(1);
            Object[] vals = new Object[fcount];
            minValues[i] = vals;
            int f = 0;
            while (f < fcount) {
                vals[f] = r.getNormalFieldValue(f);
                ++f;
            }
            ++i;
        }
        ICursor[] resultCursors = new ICursor[pathCount];
        Expression[] exps = new Expression[fcount];
        int f = 0;
        while (f < fcount) {
            exps[f] = new Expression(ctx, keys1[f]);
            ++f;
        }
        int start = 1;
        int i2 = 1;
        while (i2 < pathCount) {
            int index = (Integer)seq.pselect(exps, minValues[i2], start, "s", ctx);
            if (index < 0) {
                index = -index;
            }
            resultCursors[i2 - 1] = seq.cursor(start, index);
            start = index;
            ++i2;
        }
        resultCursors[pathCount - 1] = seq.cursor(start, len + 1);
        return new MultipathCursors(resultCursors, ctx);
    }

    void addSelectField(String fieldName) {
        if (!this.selectFieldList.contains(fieldName)) {
            this.selectFieldList.add(fieldName);
        }
    }
}

