/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.dql;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.query.dql.DQLUtils;
import com.scudata.dm.query.dql.Token;
import com.scudata.resources.ParseMessage;
import java.util.ArrayList;

public final class Tokenizer {
    public static final char KEYWORD = '\u0000';
    public static final char IDENT = '\u0001';
    public static final char NUMBER = '\u0002';
    public static final char STRING = '\u0003';
    public static final char OPERATOR = '\u0004';
    public static final char LPAREN = '(';
    public static final char RPAREN = ')';
    public static final char COMMA = ',';
    public static final char DOT = '.';
    public static final char PARAMMARK = '?';
    public static final char LEVELMARK = '#';
    public static final char TABLEMARK = '@';
    public static final char OUTERFUNCTION = '$';
    private static final String _$6 = "+-*/=<>&|^%!~";
    private static final String[] _$5 = new String[]{"AVG", "COUNT", "ICOUNT", "MAX", "MIN", "SUM"};
    public static final String COL_AS = " ";
    public static final String TABLE_AS = " ";
    private static final String[] _$4 = new String[]{"AND", "OR", "LIKE", "NOT"};
    private static final String[] _$3 = new String[]{"ALL", "AND", "AS", "ASC", "BETWEEN", "BOTTOM", "BY", "CASE", "CREATE", "DESC", "DISTINCT", "DROP", "ELSE", "END", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FIRST", "FROM", "FULL", "GROUP", "HAVING", "IN", "INNER", "INTERSECT", "INTO", "IS", "JOIN", "LEFT", "LIKE", "LIMIT", "MINUS", "NOT", "NULL", "OFFSET", "ON", "ONLY", "OR", "ORDER", "OUTER", "ROWS", "SELECT", "TABLE", "TEMP", "TEMPORARY", "THEN", "TO", "TOP", "TRUE", "UNION", "WHEN", "WHERE", "WITH", "INT", "DECIMAL", "FLOAT", "DOUBLE", "VARCHAR", "DATE", "DATETIME", "BOOLEAN"};
    private static final String[] _$2 = new String[]{"ALL", "AND", "AS", "ASC", "BETWEEN", "BOTTOM", "BY", "CASE", "CREATE", "DESC", "DISTINCT", "DROP", "ELSE", "END", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FIRST", "FROM", "FULL", "GROUP", "HAVING", "IN", "INNER", "INTERSECT", "INTO", "IS", "JOIN", "LEFT", "LIKE", "LIMIT", "MINUS", "NOT", "NULL", "OFFSET", "ON", "ONLY", "OR", "ORDER", "OUTER", "ROWS", "SELECT", "TABLE", "TEMP", "TEMPORARY", "THEN", "TO", "TOP", "TRUE", "UNION", "WHEN", "WHERE", "WITH", "INT", "DECIMAL", "FLOAT", "DOUBLE", "VARCHAR", "DATE", "DATETIME", "BOOLEAN"};
    private static final String[] _$1 = new String[]{"DEPTH", "DIM", "FIELD", "FOREIGN", "KEY", "LAYER", "LIST", "METADATA", "OF", "PRIMARY", "SUB", "TABLE", "TYPE"};

    public static int scanMergeKeyWord(Token[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            if (tokens[i].isMergeKeyWord()) {
                return i;
            }
            if (tokens[i].getType() != '(') continue;
            i = Tokenizer.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static int scanByDataKeyWord(Token[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            Token token = tokens[i];
            if (token.getType() == '\u0000') {
                if (token.equals("BY")) {
                    return i;
                }
                if (!token.equals("FROM") && !token.equals("HAVING") && !token.equals("ORDER")) continue;
                return -1;
            }
            if (tokens[i].getType() != '(') continue;
            i = Tokenizer.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static int scanKeyWord(String key, Token[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            if (tokens[i].isKeyWord(key)) {
                return i;
            }
            if (tokens[i].getType() != '(') continue;
            i = Tokenizer.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static int scanLogicalOperator(Token[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            if (tokens[i].isKeyWord("AND") || tokens[i].isKeyWord("OR")) {
                return i;
            }
            if (tokens[i].getType() != '(') continue;
            i = Tokenizer.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static int lastScanKeyWord(String key, Token[] tokens, int start, int next) {
        for (int i = next - 1; i >= start; --i) {
            if (tokens[i].isKeyWord(key)) {
                return i;
            }
            if (tokens[i].getType() != ')') continue;
            i = Tokenizer.lastScanParen(tokens, start, i);
        }
        return -1;
    }

    public static int scanKeyWords(String[] keys, Token[] tokens, int start, int next) {
        int keyCount = keys.length;
        for (int i = start; i < next; ++i) {
            Token token = tokens[i];
            if (token.getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next);
                continue;
            }
            if (token.getType() != '\u0000') continue;
            for (int k = 0; k < keyCount; ++k) {
                if (!token.equals(keys[k])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int scanComma(Token[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            char type = tokens[i].getType();
            if (type == ',') {
                return i;
            }
            if (type != '(') continue;
            i = Tokenizer.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static int scanParen(Token[] tokens, int start, int next) {
        int deep = 0;
        for (int i = start + 1; i < next; ++i) {
            if (tokens[i].getType() == '(') {
                ++deep;
                continue;
            }
            if (tokens[i].getType() != ')') continue;
            if (deep == 0) {
                return i;
            }
            --deep;
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException("(,)" + mm.getMessage("mark.notMatch"));
    }

    public static int lastScanParen(Token[] tokens, int start, int end) {
        int deep = 0;
        for (int i = end - 1; i >= start; --i) {
            if (tokens[i].getType() == '(') {
                if (deep == 0) {
                    return i;
                }
                --deep;
                continue;
            }
            if (tokens[i].getType() != ')') continue;
            ++deep;
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException("(,)" + mm.getMessage("mark.notMatch"));
    }

    public static int scanNextCaseKeyWord(Token[] tokens, int start, int next) {
        int pos = Tokenizer.scanKeyWord("WHEN", tokens, start, next);
        if (pos != -1) {
            return pos;
        }
        pos = Tokenizer.scanKeyWord("ELSE", tokens, start, next);
        if (pos != -1) {
            return pos;
        }
        return Tokenizer.scanKeyWord("END", tokens, start, next);
    }

    public static String[] getStrings(Token[] tokens, int start, int next) {
        String[] ts = new String[next - start];
        for (int i = start; i < next; ++i) {
            ts[i - start] = tokens[i].getString();
        }
        return ts;
    }

    public static boolean isGatherFunction(String name) {
        name = name.toUpperCase();
        return Tokenizer._$1(name, _$5);
    }

    public static boolean isOperatorKeyWord(String name) {
        return Tokenizer._$1(name, _$4);
    }

    public static boolean isKeyWord(String id) {
        return Tokenizer._$1(id, _$3);
    }

    public static boolean isSQLKeyWord(String id) {
        return Tokenizer._$1(id, _$2);
    }

    public static boolean isListKeyWord(String id) {
        return Tokenizer._$1(id, _$1);
    }

    private static boolean _$1(String id, String[] keyWords) {
        int len = keyWords.length;
        for (int i = 0; i < len; ++i) {
            if (!keyWords[i].equals(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    public static boolean isIdentifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch);
    }

    public static Token[] parse(String command) {
        int curIndex = 0;
        command = command.trim();
        int cmdLen = command.length();
        ArrayList<Token> tokenList = new ArrayList<Token>();
        int paramSeq = 0;
        while (curIndex < cmdLen) {
            String id;
            Token token;
            Token token2;
            char ch = command.charAt(curIndex);
            if (Character.isWhitespace(ch)) {
                ++curIndex;
                continue;
            }
            if (ch == '[' || ch == ']' || ch == '{' || ch == '}' || ch == ':' || ch == '\\' || ch == '~') {
                Token token3 = new Token(ch, "" + ch, curIndex, "" + ch);
                tokenList.add(token3);
                ++curIndex;
                continue;
            }
            if (ch == '#' || ch == '@') {
                int next = Tokenizer._$1(command, curIndex + 1);
                String id2 = command.substring(curIndex, next);
                token2 = new Token(ch, id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '$') {
                int next = Tokenizer._$1(command, curIndex + 1);
                String id3 = command.substring(curIndex, next);
                token2 = new Token('\u0001', id3, curIndex, id3);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (Tokenizer.isIdentifierStart(ch)) {
                int next = Tokenizer._$1(command, curIndex + 1);
                String id4 = command.substring(curIndex, next);
                String upId = id4.toUpperCase();
                if (Tokenizer.isKeyWord(upId)) {
                    token = new Token('\u0000', upId, curIndex, id4);
                    tokenList.add(token);
                } else {
                    token = new Token('\u0001', id4, curIndex, id4);
                    tokenList.add(token);
                }
                curIndex = next;
                continue;
            }
            if (Character.isDigit(ch)) {
                int next = Tokenizer.scanNumber(command, curIndex + 1);
                String id5 = command.substring(curIndex, next);
                token2 = new Token('\u0002', id5, curIndex, id5);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '.') {
                int next = Tokenizer.scanNumber(command, curIndex);
                String id6 = command.substring(curIndex, next);
                if (next > curIndex + 1) {
                    token2 = new Token('\u0002', id6, curIndex, id6);
                    tokenList.add(token2);
                } else {
                    token2 = new Token(ch, id6, curIndex, id6);
                    tokenList.add(token2);
                }
                curIndex = next;
                continue;
            }
            if (ch == '\'') {
                int next = Tokenizer.scanString(command, curIndex + 1);
                if (next < 0) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                String id7 = '\"' + command.substring(curIndex + 1, next - 1) + '\"';
                String origin = command.substring(curIndex, next);
                token = new Token('\u0003', id7, curIndex, origin);
                tokenList.add(token);
                curIndex = next;
                continue;
            }
            if (ch == '\"') {
                int next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException("\",\"" + mm.getMessage("mark.notMatch"));
                }
                String id8 = command.substring(curIndex + 1, next);
                token2 = new Token('\u0001', id8, curIndex, id8);
                tokenList.add(token2);
                curIndex = next + 1;
                continue;
            }
            if (ch == '?') {
                int next;
                block23: {
                    int numIndex = curIndex + 1;
                    next = Tokenizer.scanNumber(command, numIndex);
                    if (next > numIndex) {
                        MessageManager mm;
                        try {
                            String strNum = command.substring(numIndex, next);
                            paramSeq = Integer.parseInt(strNum);
                            if (paramSeq < 1) {
                                mm = ParseMessage.get();
                                throw new RQException(mm.getMessage("syntax.error") + numIndex);
                            }
                            break block23;
                        }
                        catch (NumberFormatException e) {
                            mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + numIndex);
                        }
                    }
                    ++paramSeq;
                }
                String id9 = command.substring(curIndex, next);
                token = new Token(ch, Integer.toString(paramSeq), curIndex, id9);
                tokenList.add(token);
                curIndex = next;
                continue;
            }
            if (_$6.indexOf(ch) != -1) {
                id = command.substring(curIndex, curIndex + 1);
                Token token4 = new Token('\u0004', id, curIndex, id);
                tokenList.add(token4);
                ++curIndex;
                continue;
            }
            if (ch == '(' || ch == ')' || ch == ',') {
                id = command.substring(curIndex, curIndex + 1);
                Token token5 = new Token(ch, id, curIndex, id);
                tokenList.add(token5);
                ++curIndex;
                continue;
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + curIndex);
        }
        int size = tokenList.size();
        Token[] tokens = new Token[size];
        tokenList.toArray(tokens);
        return tokens;
    }

    public static Token[] parseSQL(String command) {
        int curIndex = 0;
        command = command.trim();
        int cmdLen = command.length();
        ArrayList<Token> tokenList = new ArrayList<Token>();
        int paramSeq = 0;
        while (curIndex < cmdLen) {
            String id;
            Token token;
            Token token2;
            char ch = command.charAt(curIndex);
            if (Character.isWhitespace(ch)) {
                ++curIndex;
                continue;
            }
            if (ch == '[' || ch == ']' || ch == '{' || ch == '}' || ch == ':' || ch == '\\' || ch == '~') {
                Token token3 = new Token(ch, "" + ch, curIndex, "" + ch);
                tokenList.add(token3);
                ++curIndex;
                continue;
            }
            if (ch == '#' || ch == '@') {
                int next = Tokenizer._$1(command, curIndex + 1);
                String id2 = command.substring(curIndex, next);
                token2 = new Token(ch, id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '$') {
                int next = Tokenizer._$1(command, curIndex + 1);
                String id3 = command.substring(curIndex, next);
                token2 = new Token('\u0001', id3, curIndex, id3);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (Tokenizer.isIdentifierStart(ch)) {
                int next = Tokenizer._$1(command, curIndex + 1);
                String id4 = command.substring(curIndex, next);
                String upId = id4.toUpperCase();
                if (Tokenizer.isSQLKeyWord(upId)) {
                    token = new Token('\u0000', upId, curIndex, id4);
                    tokenList.add(token);
                } else {
                    token = new Token('\u0001', id4, curIndex, id4);
                    tokenList.add(token);
                }
                curIndex = next;
                continue;
            }
            if (Character.isDigit(ch)) {
                int next = Tokenizer.scanNumber(command, curIndex + 1);
                String id5 = command.substring(curIndex, next);
                token2 = new Token('\u0002', id5, curIndex, id5);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '.') {
                int next = Tokenizer.scanNumber(command, curIndex);
                String id6 = command.substring(curIndex, next);
                if (next > curIndex + 1) {
                    token2 = new Token('\u0002', id6, curIndex, id6);
                    tokenList.add(token2);
                } else {
                    token2 = new Token(ch, id6, curIndex, id6);
                    tokenList.add(token2);
                }
                curIndex = next;
                continue;
            }
            if (ch == '\'') {
                int next = Tokenizer.scanString(command, curIndex + 1);
                if (next < 0) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                String id7 = '\"' + command.substring(curIndex + 1, next - 1) + '\"';
                String origin = command.substring(curIndex, next);
                token = new Token('\u0003', id7, curIndex, origin);
                tokenList.add(token);
                curIndex = next;
                continue;
            }
            if (ch == '\"') {
                int next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException("\",\"" + mm.getMessage("mark.notMatch"));
                }
                String id8 = command.substring(curIndex + 1, next);
                token2 = new Token('\u0001', id8, curIndex, id8);
                tokenList.add(token2);
                curIndex = next + 1;
                continue;
            }
            if (ch == '?') {
                int next;
                block23: {
                    int numIndex = curIndex + 1;
                    next = Tokenizer.scanNumber(command, numIndex);
                    if (next > numIndex) {
                        MessageManager mm;
                        try {
                            String strNum = command.substring(numIndex, next);
                            paramSeq = Integer.parseInt(strNum);
                            if (paramSeq < 1) {
                                mm = ParseMessage.get();
                                throw new RQException(mm.getMessage("syntax.error") + numIndex);
                            }
                            break block23;
                        }
                        catch (NumberFormatException e) {
                            mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + numIndex);
                        }
                    }
                    ++paramSeq;
                }
                String id9 = command.substring(curIndex, next);
                token = new Token(ch, Integer.toString(paramSeq), curIndex, id9);
                tokenList.add(token);
                curIndex = next;
                continue;
            }
            if (_$6.indexOf(ch) != -1) {
                id = command.substring(curIndex, curIndex + 1);
                Token token4 = new Token('\u0004', id, curIndex, id);
                tokenList.add(token4);
                ++curIndex;
                continue;
            }
            if (ch == '(' || ch == ')' || ch == ',') {
                id = command.substring(curIndex, curIndex + 1);
                Token token5 = new Token(ch, id, curIndex, id);
                tokenList.add(token5);
                ++curIndex;
                continue;
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + curIndex);
        }
        int size = tokenList.size();
        Token[] tokens = new Token[size];
        tokenList.toArray(tokens);
        return tokens;
    }

    public static Token[] parseList(String command) {
        int curIndex = 0;
        command = command.trim();
        int cmdLen = command.length();
        ArrayList<Token> tokenList = new ArrayList<Token>();
        int paramSeq = 0;
        while (curIndex < cmdLen) {
            String id;
            Token token;
            Token token2;
            char ch = command.charAt(curIndex);
            if (Character.isWhitespace(ch)) {
                ++curIndex;
                continue;
            }
            if (ch == '[' || ch == ']' || ch == '{' || ch == '}' || ch == ':' || ch == '\\' || ch == '~') {
                Token token3 = new Token(ch, "" + ch, curIndex, "" + ch);
                tokenList.add(token3);
                ++curIndex;
                continue;
            }
            if (ch == '#' || ch == '@') {
                int next = Tokenizer._$1(command, curIndex + 1);
                String id2 = command.substring(curIndex, next);
                token2 = new Token(ch, id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '$') {
                int next = Tokenizer._$1(command, curIndex + 1);
                String id3 = command.substring(curIndex, next);
                token2 = new Token('\u0001', id3, curIndex, id3);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (Tokenizer.isIdentifierStart(ch)) {
                int next = Tokenizer._$1(command, curIndex + 1);
                String id4 = command.substring(curIndex, next);
                String upId = id4.toUpperCase();
                if (Tokenizer.isListKeyWord(upId)) {
                    token = new Token('\u0000', upId, curIndex, id4);
                    tokenList.add(token);
                } else {
                    token = new Token('\u0001', id4, curIndex, id4);
                    tokenList.add(token);
                }
                curIndex = next;
                continue;
            }
            if (Character.isDigit(ch)) {
                int next = Tokenizer.scanNumber(command, curIndex + 1);
                String id5 = command.substring(curIndex, next);
                token2 = new Token('\u0002', id5, curIndex, id5);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '.') {
                int next = Tokenizer.scanNumber(command, curIndex);
                String id6 = command.substring(curIndex, next);
                if (next > curIndex + 1) {
                    token2 = new Token('\u0002', id6, curIndex, id6);
                    tokenList.add(token2);
                } else {
                    token2 = new Token(ch, id6, curIndex, id6);
                    tokenList.add(token2);
                }
                curIndex = next;
                continue;
            }
            if (ch == '\'') {
                int next = Tokenizer.scanString(command, curIndex + 1);
                if (next < 0) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                String id7 = '\"' + command.substring(curIndex + 1, next - 1) + '\"';
                String origin = command.substring(curIndex, next);
                token = new Token('\u0003', id7, curIndex, origin);
                tokenList.add(token);
                curIndex = next;
                continue;
            }
            if (ch == '\"') {
                int next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException("\",\"" + mm.getMessage("mark.notMatch"));
                }
                String id8 = command.substring(curIndex + 1, next);
                token2 = new Token('\u0001', id8, curIndex, id8);
                tokenList.add(token2);
                curIndex = next + 1;
                continue;
            }
            if (ch == '?') {
                int next;
                block23: {
                    int numIndex = curIndex + 1;
                    next = Tokenizer.scanNumber(command, numIndex);
                    if (next > numIndex) {
                        MessageManager mm;
                        try {
                            String strNum = command.substring(numIndex, next);
                            paramSeq = Integer.parseInt(strNum);
                            if (paramSeq < 1) {
                                mm = ParseMessage.get();
                                throw new RQException(mm.getMessage("syntax.error") + numIndex);
                            }
                            break block23;
                        }
                        catch (NumberFormatException e) {
                            mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + numIndex);
                        }
                    }
                    ++paramSeq;
                }
                String id9 = command.substring(curIndex, next);
                token = new Token(ch, Integer.toString(paramSeq), curIndex, id9);
                tokenList.add(token);
                curIndex = next;
                continue;
            }
            if (_$6.indexOf(ch) != -1) {
                id = command.substring(curIndex, curIndex + 1);
                Token token4 = new Token('\u0004', id, curIndex, id);
                tokenList.add(token4);
                ++curIndex;
                continue;
            }
            if (ch == '(' || ch == ')' || ch == ',') {
                id = command.substring(curIndex, curIndex + 1);
                Token token5 = new Token(ch, id, curIndex, id);
                tokenList.add(token5);
                ++curIndex;
                continue;
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + curIndex);
        }
        int size = tokenList.size();
        Token[] tokens = new Token[size];
        tokenList.toArray(tokens);
        return tokens;
    }

    public static int getLogicSqlStart(String command) {
        int curIndex = 0;
        int cmdLen = command.length();
        while (curIndex < cmdLen) {
            MessageManager mm;
            int next;
            char ch = command.charAt(curIndex);
            if (Character.isWhitespace(ch)) {
                ++curIndex;
                continue;
            }
            if (Character.isJavaIdentifierStart(ch)) {
                next = Tokenizer._$1(command, curIndex + 1);
                String id = command.substring(curIndex, next).toUpperCase();
                if (id.equals("SELECT") || id.equals("WITH") || id.equals("CREATE") || id.equals("DROP")) {
                    return curIndex;
                }
                curIndex = next;
                continue;
            }
            if (Character.isDigit(ch)) {
                curIndex = Tokenizer.scanNumber(command, curIndex + 1);
                continue;
            }
            if (ch == '\"') {
                next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                curIndex = next + 1;
                continue;
            }
            if (ch == '\'') {
                next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                curIndex = next + 1;
                continue;
            }
            ++curIndex;
        }
        return -1;
    }

    private static int _$1(String command, int start) {
        char ch;
        int len = command.length();
        if (start == len) {
            return start;
        }
        if (command.charAt(start) == '\'') {
            if ((start = Sentence.scanQuotation((String)command, (int)start)) < 0) {
                MessageManager mm = ParseMessage.get();
                throw new RQException("','" + mm.getMessage("mark.notMatch"));
            }
            if (++start == len) {
                return start;
            }
            char ch2 = command.charAt(start);
            if (Tokenizer.isIdentifierPart(ch2)) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + start);
            }
            return start;
        }
        while (start < len && Tokenizer.isIdentifierPart(ch = command.charAt(start))) {
            ++start;
        }
        return start;
    }

    public static int scanNumber(String command, int start) {
        int len = command.length();
        while (start < len && Character.isDigit(command.charAt(start))) {
            ++start;
        }
        if (start < len && command.charAt(start) == '.') {
            ++start;
            while (start < len && Character.isDigit(command.charAt(start))) {
                ++start;
            }
        }
        return start;
    }

    public static int scanString(String command, int start) {
        int len = command.length();
        while (start < len) {
            if (command.charAt(start) == '\'' && (++start == len || command.charAt(start) != '\'')) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static String replace(String str, char s, String r, boolean ignoreQuote) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(128 + len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (!(ignoreQuote || ch != '\'' && ch != '\"')) {
                int pos = Sentence.scanQuotation((String)str, (int)i);
                if (pos == -1) {
                    sb.append(str.substring(i));
                    break;
                }
                sb.append(str.substring(i, pos + 1));
                i = pos;
                continue;
            }
            if (ch == s) {
                sb.append(r);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String replaceTable(String str, String tableName, String exp) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(128 + len);
        int subLen = tableName.length();
        if (tableName == null || exp == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.error"));
        }
        int i = 0;
        while (i < len) {
            int next;
            if (i + subLen >= len) {
                sb.append(str.substring(i));
                break;
            }
            char ch = str.charAt(i);
            if (Tokenizer.isIdentifierStart(ch) || ch == '\"') {
                next = Tokenizer._$1(str, i);
                if (next - i == subLen && str.charAt(next) == '.' && str.regionMatches(true, i, tableName, 0, subLen)) {
                    sb.append(exp);
                } else {
                    sb.append(str.substring(i, next));
                }
                i = next;
                continue;
            }
            if (ch == '\'') {
                int pos = Sentence.scanQuotation((String)str, (int)i);
                if (pos == -1) {
                    sb.append(str.substring(i));
                    break;
                }
                sb.append(str.substring(i, pos + 1));
                i = pos + 1;
                continue;
            }
            if (ch == '.') {
                sb.append(ch);
                if (!Tokenizer.isIdentifierStart(ch = str.charAt(++i)) && ch != '\"') continue;
                next = Tokenizer._$1(str, i);
                sb.append(str.substring(i, next));
                i = next;
                continue;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static String replace(String str, String sub, String exp, boolean ignoreQuote) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(128 + len);
        int subLen = sub.length();
        int i = 0;
        while (i < len) {
            if (i + subLen - 1 > len) {
                sb.append(str.substring(i));
                break;
            }
            char ch = str.charAt(i);
            if (!(ignoreQuote || ch != '\'' && ch != '\"')) {
                int pos = Sentence.scanQuotation((String)str, (int)i);
                if (pos == -1) {
                    sb.append(str.substring(i));
                    break;
                }
                sb.append(str.substring(i, pos + 1));
                i = pos + 1;
                continue;
            }
            if (str.regionMatches(true, i, sub, 0, subLen)) {
                sb.append(exp);
                i += subLen;
                continue;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static boolean isOperator(String ch) {
        return ch.length() == 1 && _$6.indexOf(ch) != -1;
    }

    public static String parseTableName(String exp) {
        Token[] tokens = Tokenizer.parse(exp);
        String tableName = null;
        int i = 0;
        int len = tokens.length;
        while (i < len) {
            Token token = tokens[i];
            if (token.getType() == '\u0001' && i + 1 < len && tokens[i + 1].getType() == '.') {
                String name = tokens[i].getString();
                if (tableName == null) {
                    tableName = name;
                } else if (!tableName.equalsIgnoreCase(name)) {
                    return null;
                }
                i = DQLUtils.getFieldNext(tokens, i, len);
                continue;
            }
            ++i;
        }
        return tableName;
    }
}

