/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.dql.sql;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.query.dql.Token;
import com.scudata.dm.query.dql.Tokenizer;
import com.scudata.dm.query.dql.sql.SQL;
import com.scudata.dm.query.dql.sql.TableField;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.LevelFunction;
import com.scudata.dm.query.metadata.LevelFunctionList;
import com.scudata.dm.query.resources.ParseMessage;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupBy {
    private Token[] _$4;
    private int _$3;
    private int _$2;
    private String _$1;

    public GroupBy(Token[] tokens, int start, int next) {
        this._$4 = tokens;
        this._$3 = start;
        this._$2 = next;
    }

    public boolean isEquals(Token[] tokens, int b, int e) {
        int count = e - b;
        if (this._$2 - this._$3 != count) {
            return false;
        }
        Token[] src = this._$4;
        int i = this._$3;
        while (b < e) {
            if (!SQL.equalSymbol(src[i].getString(), tokens[b].getString())) {
                return false;
            }
            ++i;
            ++b;
        }
        return true;
    }

    public String toDql() {
        return this._$1;
    }

    public void analyse(SQL sql) {
        Token[] tokens = this._$4;
        int count = this._$2 - this._$3;
        if (count == 1) {
            String fieldName = tokens[this._$3].getString();
            TableField tableField = sql._$1(null, fieldName);
            if (tableField == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(fieldName + mm.getMessage("field.notExist"));
            }
            this._$1 = tableField.toDql();
        } else if (count == 3 && tokens[this._$3 + 1].getType() == '.') {
            String fieldName;
            String tableName = tokens[this._$3].getString();
            TableField tableField = sql._$1(tableName, fieldName = tokens[this._$3 + 2].getString());
            if (tableField == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(tableName + '.' + fieldName + mm.getMessage("field.notExist"));
            }
            this._$1 = tableField.toDql();
        } else {
            StringBuffer sb = new StringBuffer();
            SQL._$3(tokens, this._$3, this._$2, sb);
            String exp = sb.toString();
            tokens = Tokenizer.parseSQL(exp);
            int start = 0;
            int next = tokens.length;
            ArrayList<Token> tokenList = new ArrayList<Token>(count);
            TableField tableField = null;
            Token fieldToken = new Token('?', "1", -1, "?");
            for (int i = start; i < next; ++i) {
                Token token = tokens[i];
                if (token.getType() == '\u0001') {
                    MessageManager mm;
                    int pos = i + 1;
                    if (pos < next && tokens[pos].getType() == '.') {
                        String tableName = token.getString();
                        if (++pos == next) {
                            mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + tokens[pos - 1].getPos());
                        }
                        String fieldName = tokens[pos].getString();
                        if (tableField == null) {
                            tableField = sql._$1(tableName, fieldName);
                            if (tableField == null) {
                                MessageManager mm2 = ParseMessage.get();
                                throw new RQException(fieldName + mm2.getMessage("field.notExist"));
                            }
                        } else if (!tableField.isSameField(tableName, fieldName)) {
                            MessageManager mm3 = ParseMessage.get();
                            throw new RQException(mm3.getMessage("sql.illGroupBy"));
                        }
                        i = pos;
                        tokenList.add(fieldToken);
                        continue;
                    }
                    if (pos < next && tokens[pos].getType() == '(') {
                        tokenList.add(token);
                        tokenList.add(tokens[pos]);
                        i = pos;
                        continue;
                    }
                    String fieldName = token.getString();
                    if (tableField == null) {
                        tableField = sql._$1(null, fieldName);
                        if (tableField == null) {
                            mm = ParseMessage.get();
                            throw new RQException(fieldName + mm.getMessage("field.notExist"));
                        }
                    } else if (!tableField.isSameField(fieldName)) {
                        mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("sql.illGroupBy"));
                    }
                    tokenList.add(fieldToken);
                    continue;
                }
                tokenList.add(token);
            }
            if (tableField == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("sql.illGroupBy"));
            }
            Field dim = tableField.getField().getDim();
            if (dim == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("sql.illGroupBy"));
            }
            LevelFunctionList levelList = dim.getLevelFunctionList();
            if (levelList == null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("sql.illGroupBy"));
            }
            for (LevelFunction level : levelList) {
                String formula = level.getFormula();
                if (!GroupBy._$1(tokenList, formula)) continue;
                this._$1 = tableField.toDql() + '#' + level.getName();
                return;
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("sql.illGroupBy"));
        }
    }

    private static boolean _$1(ArrayList<Token> tokenList, String formula) {
        int count = tokenList.size();
        Token[] tokens = Tokenizer.parseSQL(formula);
        if (tokens.length != count) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (SQL.equalSymbol(tokens[i].getString(), tokenList.get(i).getString())) continue;
            return false;
        }
        return true;
    }
}

