/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.dql.sql;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.query.dql.Token;
import com.scudata.dm.query.dql.Tokenizer;
import com.scudata.dm.query.dql.sql.GroupBy;
import com.scudata.dm.query.dql.sql.JoinRelation;
import com.scudata.dm.query.dql.sql.TableField;
import com.scudata.dm.query.dql.sql.TableNode;
import com.scudata.dm.query.dql.sql.TokenArray;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.ForeignKey;
import com.scudata.dm.query.metadata.ForeignKeyList;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Table;
import com.scudata.dm.query.resources.ParseMessage;
import com.scudata.dm.query.utils.IOUtil;
import com.scudata.dm.sql.FunInfoManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQL {
    private LogicMetaData _$8 = null;
    private String _$7;
    private HashSet<String> _$6 = new HashSet();
    private ArrayList<TableNode> _$5 = new ArrayList();
    private TableNode _$4;
    private TokenArray _$3;
    private ArrayList<GroupBy> _$2 = new ArrayList();
    private String _$1;

    public SQL(LogicMetaData lmd, String sql) {
        this._$8 = lmd;
        this._$7 = sql;
    }

    public static boolean equalSymbol(String src, String dest) {
        return src.equalsIgnoreCase(dest);
    }

    public String toDQL() {
        if (this._$1 == null) {
            this._$1();
        }
        return this._$1;
    }

    private void _$1() {
        Token[] tokens = Tokenizer.parseSQL(this._$7);
        int paramSeq = 0;
        for (Token token : tokens) {
            if (token.getType() != '?') continue;
            token.setString("?" + ++paramSeq);
        }
        StringBuffer dqlBuffer = new StringBuffer();
        this._$8(tokens, 0, tokens.length, dqlBuffer);
        this._$1 = dqlBuffer.toString();
    }

    private static int _$1(int ... args) {
        for (int i : args) {
            if (i == -1) continue;
            return i;
        }
        return -1;
    }

    private void _$8(Token[] tokens, int start, int next, StringBuffer dqlBuffer) {
        int i;
        int byCount;
        if (tokens[start].isKeyWord("SELECT")) {
            dqlBuffer.append("SELECT ");
            ++start;
        } else {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        start = this._$7(tokens, start, next, dqlBuffer);
        int colStart = start = this._$6(tokens, start, next, dqlBuffer);
        int fromPos = -1;
        int groupByPos = -1;
        int havingPos = -1;
        int orderPos = -1;
        int limitPos = -1;
        for (int i2 = start; i2 < next; ++i2) {
            Token token = tokens[i2];
            if (token.isKeyWord()) {
                if (fromPos == -1 && token.equals("FROM")) {
                    fromPos = i2;
                    continue;
                }
                if (groupByPos == -1 && token.equals("GROUP")) {
                    groupByPos = i2;
                    continue;
                }
                if (havingPos == -1 && token.equals("HAVING")) {
                    havingPos = i2;
                    continue;
                }
                if (orderPos == -1 && token.equals("ORDER")) {
                    orderPos = i2;
                    continue;
                }
                if (orderPos != -1 || !token.equals("LIMIT")) continue;
                limitPos = i2;
                break;
            }
            if (token.getType() != '(') continue;
            i2 = Tokenizer.scanParen(tokens, i2, next);
        }
        if (fromPos == -1 && fromPos < 0) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.lessTable"));
        }
        int fromEnd = SQL._$1(groupByPos, orderPos, limitPos, next);
        this._$3(tokens, fromPos, fromEnd);
        if (groupByPos != -1) {
            int groupByEnd = SQL._$1(havingPos, orderPos, limitPos, next);
            this._$2(tokens, groupByPos, groupByEnd);
        }
        this._$5(tokens, colStart, fromPos, dqlBuffer);
        dqlBuffer.append(" FROM ");
        dqlBuffer.append(this._$4.getTable().getName());
        dqlBuffer.append(" AS ");
        dqlBuffer.append(this._$4.getAliasName());
        if (this._$3 != null) {
            dqlBuffer.append(" WHERE ");
            this._$2(this._$3.getTokens(), this._$3.getStart(), this._$3.getNext(), false, dqlBuffer);
        }
        if ((byCount = this._$2.size()) > 0) {
            dqlBuffer.append(" BY ");
            for (i = 0; i < byCount; ++i) {
                if (i > 0) {
                    dqlBuffer.append(',');
                }
                dqlBuffer.append(this._$2.get(i).toDql());
            }
        }
        if (havingPos != -1) {
            dqlBuffer.append(" HAVING ");
            int havingEnd = SQL._$1(orderPos, limitPos, next);
            this._$2(tokens, havingPos + 1, havingEnd, true, dqlBuffer);
        }
        if (orderPos != -1) {
            int orderEnd = SQL._$1(limitPos, next);
            this._$1(tokens, orderPos, orderEnd, dqlBuffer);
        }
        if (limitPos != -1) {
            for (i = limitPos; i < next; ++i) {
                dqlBuffer.append(' ');
                dqlBuffer.append(tokens[i].getString());
            }
        }
    }

    private int _$7(Token[] tokens, int start, int next, StringBuffer dqlBuffer) {
        if (tokens[start].equals("/")) {
            dqlBuffer.append(tokens[start].getString());
            for (int i = start + 1; i < next; ++i) {
                dqlBuffer.append(tokens[i].getString());
                if (!tokens[i].equals("/")) continue;
                dqlBuffer.append(' ');
                return i + 1;
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        return start;
    }

    private int _$6(Token[] tokens, int start, int next, StringBuffer dqlBuffer) {
        Token token = tokens[start];
        if (token.isKeyWord("TOP")) {
            if (++start >= next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + token.getString());
            }
            dqlBuffer.append(token.getString());
            dqlBuffer.append(' ');
            token = tokens[start];
            if (++start >= next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + token.getString());
            }
            dqlBuffer.append(token.getString());
            dqlBuffer.append(' ');
        }
        return start;
    }

    private int _$6(Token[] tokens, int start, int next) {
        if (tokens[start].getType() != '\u0001') {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        String tableName = tokens[start].getString();
        Table table = this._$8.getTableIgnoreCase(tableName);
        if (table == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(tableName + mm.getMessage("syntax.unknownTable") + tokens[start].getPos());
        }
        String aliasName = null;
        if (++start < next) {
            if (tokens[start].getType() == '\u0001') {
                aliasName = tokens[start].getString();
                ++start;
            } else if (tokens[start].isKeyWord("AS")) {
                if (++start == next || tokens[start].getType() != '\u0001') {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
                }
                aliasName = tokens[start].getString();
                ++start;
            }
        }
        TableNode tableNode = new TableNode(table, aliasName, this._$5.size());
        this._$5.add(tableNode);
        return start;
    }

    TableField _$1(String tableName, String fieldName) {
        for (TableNode tableNode : this._$5) {
            Field field = tableNode.getTableField(tableName, fieldName);
            if (field == null) continue;
            return new TableField(tableNode, field);
        }
        return null;
    }

    private void _$1(TableNode tableNode1, ArrayList<String> fieldList1, TableNode tableNode2, ArrayList<String> fieldList2) {
        int j;
        String fieldName;
        int i;
        List<String> fieldList;
        int pkCount;
        Table t1 = tableNode1.getTable();
        Table t2 = tableNode2.getTable();
        if (t2.isPK(fieldList2)) {
            List<String> pkList2 = t2.getPK();
            pkCount = pkList2.size();
            ForeignKeyList fkList1 = t1.getForeignKeyList();
            block0: for (ForeignKey fk1 : fkList1) {
                if (fk1.getRefTable() != t2) continue;
                fieldList = fk1.getFieldNameList();
                for (i = 0; i < pkCount; ++i) {
                    fieldName = fieldList.get(i);
                    j = fieldList1.indexOf(fieldName);
                    if (j == -1 || !pkList2.get(i).equals(fieldList2.get(j))) continue block0;
                }
                if (pkCount == 1) {
                    Field field = (Field)fk1.getFieldList().get(0);
                    tableNode2.setLeftTableNode(tableNode1, field);
                } else {
                    tableNode2.setLeftTableNode(tableNode1, fk1);
                }
                return;
            }
        }
        if (t1.isPK(fieldList1)) {
            List<String> pkList1 = t1.getPK();
            pkCount = pkList1.size();
            ForeignKeyList fkList2 = t2.getForeignKeyList();
            block2: for (ForeignKey fk2 : fkList2) {
                if (fk2.getRefTable() != t1) continue;
                fieldList = fk2.getFieldNameList();
                for (i = 0; i < pkCount; ++i) {
                    fieldName = fieldList.get(i);
                    j = fieldList2.indexOf(fieldName);
                    if (j == -1 || !pkList1.get(i).equals(fieldList1.get(j))) continue block2;
                }
                if (pkCount == 1) {
                    Field field = (Field)fk2.getFieldList().get(0);
                    tableNode1.setLeftTableNode(tableNode2, field);
                } else {
                    tableNode1.setLeftTableNode(tableNode2, fk2);
                }
                return;
            }
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException(mm.getMessage("sql.lessForeignKey"));
    }

    private int _$5(Token[] tokens, int start, int next) {
        ArrayList<String> fieldList2;
        ArrayList<String> fieldList1;
        TableNode table2;
        TableNode table1;
        block30: {
            MessageManager mm;
            ++start;
            table1 = null;
            table2 = this._$5.get(this._$5.size() - 1);
            fieldList1 = new ArrayList<String>();
            fieldList2 = new ArrayList<String>();
            do {
                TableField tableField;
                String rightField;
                MessageManager mm2;
                String leftField;
                MessageManager mm3;
                MessageManager mm4;
                Token token;
                if ((token = tokens[start]).getType() != '\u0001') {
                    mm4 = ParseMessage.get();
                    throw new RQException(mm4.getMessage("syntax.error") + token.getPos());
                }
                if (++start == next) {
                    mm4 = ParseMessage.get();
                    throw new RQException(mm4.getMessage("syntax.error") + token.getPos());
                }
                String leftTable = null;
                if (tokens[start].getType() == '.') {
                    leftTable = token.getString();
                    if (++start == next) {
                        mm3 = ParseMessage.get();
                        throw new RQException(mm3.getMessage("syntax.error") + tokens[start - 1].getPos());
                    }
                    if (tokens[start].getType() != '\u0001') {
                        mm3 = ParseMessage.get();
                        throw new RQException(mm3.getMessage("syntax.error") + tokens[start].getPos());
                    }
                    leftField = tokens[start].getString();
                    if (++start == next) {
                        mm3 = ParseMessage.get();
                        throw new RQException(mm3.getMessage("syntax.error") + tokens[start - 1].getPos());
                    }
                } else {
                    leftField = token.getString();
                }
                if (!tokens[start].equals("=")) {
                    mm3 = ParseMessage.get();
                    throw new RQException(mm3.getMessage("syntax.error") + tokens[start - 1].getPos());
                }
                if (++start == next) {
                    mm3 = ParseMessage.get();
                    throw new RQException(mm3.getMessage("syntax.error") + tokens[start - 1].getPos());
                }
                String rightTable = null;
                token = tokens[start];
                if (token.getType() != '\u0001') {
                    mm2 = ParseMessage.get();
                    throw new RQException(mm2.getMessage("syntax.error") + tokens[start].getPos());
                }
                if (++start < next && tokens[start].getType() == '.') {
                    rightTable = token.getString();
                    if (++start == next) {
                        mm2 = ParseMessage.get();
                        throw new RQException(mm2.getMessage("syntax.error") + tokens[start - 1].getPos());
                    }
                    if (tokens[start].getType() != '\u0001') {
                        mm2 = ParseMessage.get();
                        throw new RQException(mm2.getMessage("syntax.error") + tokens[start].getPos());
                    }
                    rightField = tokens[start].getString();
                    ++start;
                } else {
                    rightField = token.getString();
                }
                Field field = table2.getTableField(rightTable, rightField);
                if (field != null) {
                    rightField = field.getName();
                    if (fieldList2.contains(rightField)) {
                        mm = ParseMessage.get();
                        throw new RQException(leftField + mm.getMessage("sql.joinFieldError"));
                    }
                    fieldList2.add(rightField);
                    if (table1 == null) {
                        tableField = this._$1(leftTable, leftField);
                        if (tableField == null) {
                            MessageManager mm5 = ParseMessage.get();
                            throw new RQException(leftField + mm5.getMessage("sql.joinFieldError"));
                        }
                        table1 = tableField.getTable();
                        leftField = tableField.getFieldName();
                    } else {
                        field = table1.getTableField(leftTable, leftField);
                        if (field == null) {
                            mm = ParseMessage.get();
                            throw new RQException(rightField + mm.getMessage("sql.joinFieldError"));
                        }
                        leftField = field.getName();
                    }
                    if (fieldList1.contains(leftField)) {
                        mm = ParseMessage.get();
                        throw new RQException(leftField + mm.getMessage("sql.joinFieldError"));
                    }
                    fieldList1.add(leftField);
                } else {
                    if (table1 == null) {
                        tableField = this._$1(rightTable, rightField);
                        if (tableField == null) {
                            MessageManager mm6 = ParseMessage.get();
                            throw new RQException(rightField + mm6.getMessage("sql.joinFieldError"));
                        }
                        table1 = tableField.getTable();
                        rightField = tableField.getFieldName();
                    } else {
                        field = table1.getTableField(rightTable, rightField);
                        if (field == null) {
                            mm = ParseMessage.get();
                            throw new RQException(rightField + mm.getMessage("sql.joinFieldError"));
                        }
                        rightField = field.getName();
                    }
                    if (fieldList1.contains(rightField)) {
                        mm = ParseMessage.get();
                        throw new RQException(leftField + mm.getMessage("sql.joinFieldError"));
                    }
                    fieldList1.add(rightField);
                    field = table2.getTableField(leftTable, leftField);
                    if (field == null) {
                        mm = ParseMessage.get();
                        throw new RQException(rightField + mm.getMessage("sql.joinFieldError"));
                    }
                    leftField = field.getName();
                    if (fieldList2.contains(leftField)) {
                        mm = ParseMessage.get();
                        throw new RQException(leftField + mm.getMessage("sql.joinFieldError"));
                    }
                    fieldList2.add(leftField);
                }
                if (start == next || !tokens[start].isKeyWord("AND")) break block30;
            } while (++start != next);
            mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        this._$1(table1, fieldList1, table2, fieldList2);
        return start;
    }

    private JoinRelation _$4(Token[] tokens, int start, int next) {
        String rightField;
        String leftField;
        if (next - start < 3) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        Token token = tokens[start];
        if (token.getType() != '\u0001') {
            return null;
        }
        String leftTable = null;
        if (tokens[++start].getType() == '.') {
            leftTable = token.getString();
            if (tokens[++start].getType() != '\u0001') {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
            }
            leftField = tokens[start].getString();
            if (++start == next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
        } else {
            leftField = token.getString();
        }
        if (!tokens[start].equals("=")) {
            return null;
        }
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        String rightTable = null;
        token = tokens[start];
        if (token.getType() != '\u0001') {
            return null;
        }
        if (++start < next && tokens[start].getType() == '.') {
            rightTable = token.getString();
            if (++start == next) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
            if (tokens[start].getType() != '\u0001') {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
            }
            rightField = tokens[start].getString();
            ++start;
        } else {
            rightField = token.getString();
        }
        TableField leftTableField = this._$1(leftTable, leftField);
        if (leftTableField == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(leftField + mm.getMessage("sql.joinFieldError"));
        }
        TableField rightTableField = this._$1(rightTable, rightField);
        if (rightTableField == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(rightField + mm.getMessage("sql.joinFieldError"));
        }
        return new JoinRelation(leftTableField, rightTableField);
    }

    private void _$1(Token[] tokens, int start, int next, ArrayList<JoinRelation> relationList, ArrayList<Token> where) {
        int pos;
        if (start == next) {
            return;
        }
        boolean hasParen = false;
        while (start < next && tokens[start].getType() == '(' && (pos = Tokenizer.scanParen(tokens, start, next)) + 1 == next) {
            next = pos;
            hasParen = true;
            if (++start != next) continue;
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        IntArrayList andPosList = new IntArrayList();
        for (int i = start; i < next; ++i) {
            if (tokens[i].getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next);
                continue;
            }
            if (tokens[i].isKeyWord("AND")) {
                andPosList.addInt(i);
                continue;
            }
            if (!tokens[i].isKeyWord("OR")) continue;
            if (hasParen) {
                --start;
                ++next;
            }
            if (where.size() > 0) {
                Token token = new Token('\u0000', "AND", tokens[start - 1].getPos(), "AND");
                where.add(token);
            }
            for (int j = start; j < next; ++j) {
                where.add(tokens[j]);
            }
            return;
        }
        int andCount = andPosList.size();
        if (andCount > 0) {
            for (int i = 0; i < andCount; ++i) {
                int pos2 = andPosList.getInt(i);
                this._$1(tokens, start, pos2, relationList, where);
                start = pos2 + 1;
            }
            this._$1(tokens, start, next, relationList, where);
            return;
        }
        JoinRelation joinRelation = this._$4(tokens, start, next);
        if (joinRelation != null) {
            relationList.add(joinRelation);
        } else {
            if (hasParen) {
                --start;
                ++next;
            }
            if (where.size() > 0) {
                Token token = new Token('\u0000', "AND", tokens[start - 1].getPos(), "AND");
                where.add(token);
            }
            for (int j = start; j < next; ++j) {
                where.add(tokens[j]);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _$3(Token[] tokens, int start, int next) {
        block15: {
            block18: {
                boolean[] signs;
                int relationCount;
                ArrayList<Token> whereList;
                ArrayList<JoinRelation> relationList;
                block17: {
                    block16: {
                        if (++start == next || tokens[start].getType() != '\u0001') {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
                        }
                        if ((start = this._$6(tokens, start, next)) == next) break block15;
                        if (tokens[start].getType() != ',') break block16;
                        while ((start = this._$6(tokens, start + 1, next)) < next && tokens[start].getType() == ',') {
                        }
                        if (start == next || !tokens[start].isKeyWord("WHERE")) {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
                        }
                        relationList = new ArrayList<JoinRelation>();
                        whereList = new ArrayList<Token>();
                        this._$1(tokens, ++start, next, relationList, whereList);
                        relationCount = relationList.size();
                        if (relationCount == 0) {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
                        }
                        signs = new boolean[relationCount];
                        break block17;
                    }
                    if (tokens[start].isKeyWord("JOIN")) break block18;
                    if (start < next) {
                        if (!tokens[start].isKeyWord("WHERE")) {
                            MessageManager mm = ParseMessage.get();
                            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
                        }
                        this._$3 = new TokenArray(tokens, start + 1, next);
                    }
                    break block15;
                }
                for (int i = 0; i < relationCount; ++i) {
                    if (signs[i]) continue;
                    JoinRelation joinRelation = relationList.get(i);
                    ArrayList<String> fieldList1 = new ArrayList<String>();
                    ArrayList<String> fieldList2 = new ArrayList<String>();
                    TableNode table1 = joinRelation.getLeftTable();
                    TableNode table2 = joinRelation.getRightTable();
                    fieldList1.add(joinRelation.getLeftTableField());
                    fieldList2.add(joinRelation.getRightTableField());
                    for (int j = i + 1; j < relationCount; ++j) {
                        JoinRelation tmp = relationList.get(j);
                        if (!joinRelation.isSameTable(tmp)) continue;
                        signs[j] = true;
                        fieldList1.add(tmp.getLeftTableField());
                        fieldList2.add(tmp.getRightTableField());
                    }
                    this._$1(table1, fieldList1, table2, fieldList2);
                }
                int whereCount = whereList.size();
                if (whereCount > 0) {
                    Token[] whereTokens = new Token[whereCount];
                    whereList.toArray(whereTokens);
                    this._$3 = new TokenArray(whereTokens, 0, whereCount);
                }
                break block15;
            }
            do {
                if ((start = this._$6(tokens, start + 1, next)) != next && tokens[start].isKeyWord("ON")) continue;
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
            } while ((start = this._$5(tokens, start, next)) < next && tokens[start].isKeyWord("JOIN"));
            if (start < next) {
                if (!tokens[start].isKeyWord("WHERE")) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
                }
                this._$3 = new TokenArray(tokens, start + 1, next);
            }
        }
        Iterator<TableNode> i$ = this._$5.iterator();
        while (i$.hasNext()) {
            TableNode tableNode = i$.next();
            if (tableNode.getLeftTableNode() != null) continue;
            if (this._$4 != null) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.invalidJoinRelation"));
            }
            this._$4 = tableNode;
        }
        return;
    }

    private void _$2(Token[] tokens, int start, int next) {
        if (++start == next || !tokens[start].equals("BY")) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        while (start < next) {
            GroupBy groupByNode;
            int comma = Tokenizer.scanComma(tokens, start, next);
            if (comma < 0) {
                groupByNode = new GroupBy(tokens, start, next);
                groupByNode.analyse(this);
                this._$2.add(groupByNode);
                return;
            }
            groupByNode = new GroupBy(tokens, start, comma);
            groupByNode.analyse(this);
            this._$2.add(groupByNode);
            start = comma + 1;
            if (start != next) continue;
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
    }

    private void _$5(Token[] tokens, int start, int next, StringBuffer dqlBuffer) {
        while (start < next) {
            int comma = Tokenizer.scanComma(tokens, start, next);
            if (comma < 0) {
                this._$4(tokens, start, next, dqlBuffer);
                return;
            }
            this._$4(tokens, start, comma, dqlBuffer);
            dqlBuffer.append(',');
            start = comma + 1;
            if (start != next) continue;
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
    }

    private GroupBy _$1(Token[] tokens, int start, int next) {
        for (GroupBy groupBy : this._$2) {
            if (!groupBy.isEquals(tokens, start, next)) continue;
            return groupBy;
        }
        return null;
    }

    private void _$1(String name) {
        this._$6.add(name);
    }

    private void _$4(Token[] tokens, int start, int next, StringBuffer dqlBuffer) {
        GroupBy groupBy;
        Token alias;
        String aliasName = null;
        if (next - 1 > start && (alias = tokens[next - 1]).getType() == '\u0001') {
            Token prevToken = tokens[next - 2];
            if (prevToken.isKeyWord("AS")) {
                next -= 2;
                aliasName = alias.getString();
            } else if (!prevToken.canHaveRightExp()) {
                --next;
                aliasName = alias.getString();
            }
        }
        if ((groupBy = this._$1(tokens, start, next)) == null) {
            this._$2(tokens, start, next, false, dqlBuffer);
        } else {
            String dql = groupBy.toDql();
            dqlBuffer.append(dql);
        }
        if (aliasName != null) {
            this._$1(aliasName);
            dqlBuffer.append(" AS ");
            dqlBuffer.append(aliasName);
        }
    }

    private static void _$1(String fnName, String paramExp, StringBuffer out) {
        String[] params;
        fnName = fnName.toLowerCase();
        if (paramExp == null || paramExp.length() == 0) {
            params = new String[]{};
        } else {
            ArgumentTokenizer arg = new ArgumentTokenizer(paramExp);
            ArrayList<String> argList = new ArrayList<String>();
            while (arg.hasNext()) {
                argList.add(arg.next());
            }
            params = new String[argList.size()];
            argList.toArray(params);
        }
        String exp = FunInfoManager.getFunctionExp((String)"ESPROC", (String)fnName, (String[])params);
        if (exp != null) {
            out.append(exp);
        } else {
            out.append(fnName);
            out.append('(');
            out.append(paramExp);
            out.append(')');
        }
    }

    private void _$2(Token[] tokens, int start, int next, boolean canRefAliasName, StringBuffer dqlBuffer) {
        StringBuffer sb = new StringBuffer();
        for (int i = start; i < next; ++i) {
            int end;
            Token token = tokens[i];
            if (token.getType() == '\u0001') {
                MessageManager mm;
                int pos = i + 1;
                if (pos < next && tokens[pos].getType() == '(') {
                    int end2 = Tokenizer.scanParen(tokens, pos, next);
                    String fnName = token.getString();
                    if (Tokenizer.isGatherFunction(fnName)) {
                        sb.append(this._$4.getAliasName());
                        sb.append('.');
                        sb.append(fnName.toLowerCase());
                        sb.append('(');
                        if (end2 - pos == 2 && tokens[pos + 1].equals("*") && fnName.equalsIgnoreCase("count")) {
                            sb.append("1");
                        } else {
                            this._$2(tokens, pos + 1, end2, canRefAliasName, sb);
                        }
                        sb.append(')');
                    } else {
                        StringBuffer paramBuffer = new StringBuffer();
                        this._$2(tokens, pos + 1, end2, canRefAliasName, paramBuffer);
                        String paramExp = paramBuffer.toString();
                        SQL._$1(fnName, paramExp, sb);
                    }
                    i = end2;
                    continue;
                }
                if (pos < next && tokens[pos].getType() == '.') {
                    if (++pos == next) {
                        MessageManager mm2 = ParseMessage.get();
                        throw new RQException(mm2.getMessage("syntax.error") + tokens[next - 1].getPos());
                    }
                    TableField tableField = this._$1(token.getString(), tokens[pos].getString());
                    if (tableField == null) {
                        mm = ParseMessage.get();
                        throw new RQException(token.getString() + mm.getMessage("field.notExist"));
                    }
                    tableField.toDql(sb);
                    i = pos;
                    continue;
                }
                TableField tableField = this._$1(null, token.getString());
                if (tableField == null) {
                    mm = ParseMessage.get();
                    throw new RQException(token.getString() + mm.getMessage("field.notExist"));
                }
                tableField.toDql(sb);
                continue;
            }
            if (token.getType() == '(') {
                end = Tokenizer.scanParen(tokens, i, next);
                sb.append('(');
                this._$2(tokens, i + 1, end, canRefAliasName, sb);
                sb.append(')');
                i = end;
                continue;
            }
            if (token.isKeyWord("AND")) {
                dqlBuffer.append(sb);
                dqlBuffer.append("&&");
                sb.setLength(0);
                continue;
            }
            if (token.isKeyWord("OR")) {
                dqlBuffer.append(sb);
                dqlBuffer.append("||");
                sb.setLength(0);
                continue;
            }
            if (tokens[i].isKeyWord("NOT")) {
                if (i + 1 == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                }
                token = tokens[i + 1];
                if (!(token.isKeyWord("LIKE") || token.isKeyWord("IN") || token.isKeyWord("BETWEEN"))) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                }
                dqlBuffer.append('!');
                continue;
            }
            if (token.isKeyWord("LIKE")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                end = Tokenizer.scanLogicalOperator(tokens, i, next);
                if (end == -1) {
                    end = next;
                }
                dqlBuffer.append("like@s(");
                dqlBuffer.append(sb);
                dqlBuffer.append(',');
                this._$2(tokens, i, end, canRefAliasName, dqlBuffer);
                dqlBuffer.append(')');
                sb.setLength(0);
                i = end - 1;
                continue;
            }
            if (token.isKeyWord("IN")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                if (tokens[i].getType() != '(') {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                }
                end = Tokenizer.scanParen(tokens, i, next);
                dqlBuffer.append('[');
                this._$2(tokens, i + 1, end, canRefAliasName, dqlBuffer);
                dqlBuffer.append(']');
                dqlBuffer.append(".contain(");
                dqlBuffer.append(sb);
                dqlBuffer.append(')');
                sb.setLength(0);
                i = end;
                continue;
            }
            if (token.isKeyWord("BETWEEN")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                end = Tokenizer.scanKeyWord("AND", tokens, i, next);
                if (end == -1) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                }
                dqlBuffer.append("between(");
                dqlBuffer.append(sb);
                dqlBuffer.append(',');
                this._$2(tokens, i, end, canRefAliasName, dqlBuffer);
                dqlBuffer.append(':');
                i = end + 1;
                if (i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                end = Tokenizer.scanLogicalOperator(tokens, i, next);
                if (end == -1) {
                    end = next;
                }
                this._$2(tokens, i, end, canRefAliasName, dqlBuffer);
                dqlBuffer.append(')');
                sb.setLength(0);
                i = end;
                continue;
            }
            if (token.isKeyWord("CASE")) {
                i = this._$1(tokens, i, next, canRefAliasName, sb);
                continue;
            }
            if (token.isKeyWord("IS")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                if (tokens[i].isKeyWord("NULL")) {
                    sb.append("==null");
                    continue;
                }
                if (!tokens[i].isKeyWord("NOT")) continue;
                if (++i == next || !tokens[i].isKeyWord("NULL")) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                sb.append("!=null");
                continue;
            }
            if (token.equals("=")) {
                sb.append("==");
                continue;
            }
            if (token.equals("<")) {
                if (i + 1 < next && tokens[i + 1].equals(">")) {
                    sb.append("!=");
                    ++i;
                    continue;
                }
                sb.append("<");
                continue;
            }
            sb.append(token.getString());
        }
        dqlBuffer.append(sb);
    }

    static void _$3(Token[] tokens, int start, int next, StringBuffer dqlBuffer) {
        StringBuffer sb = new StringBuffer();
        for (int i = start; i < next; ++i) {
            int end;
            Token token = tokens[i];
            if (token.getType() == '\u0001') {
                int pos = i + 1;
                if (pos < next && tokens[pos].getType() == '(') {
                    int end2 = Tokenizer.scanParen(tokens, pos, next);
                    String fnName = token.getString();
                    StringBuffer paramBuffer = new StringBuffer();
                    SQL._$3(tokens, pos + 1, end2, paramBuffer);
                    String paramExp = paramBuffer.toString();
                    SQL._$1(fnName, paramExp, sb);
                    i = end2;
                    continue;
                }
                if (pos < next && tokens[pos].getType() == '.') {
                    if (++pos == next) {
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("syntax.error") + tokens[next - 1].getPos());
                    }
                    sb.append(token.getString());
                    sb.append('.');
                    sb.append(tokens[pos].getString());
                    i = pos;
                    continue;
                }
                sb.append(token.getString());
                continue;
            }
            if (token.getType() == '(') {
                end = Tokenizer.scanParen(tokens, i, next);
                sb.append('(');
                SQL._$3(tokens, i + 1, end, sb);
                sb.append(')');
                i = end;
                continue;
            }
            if (token.isKeyWord("AND")) {
                dqlBuffer.append(sb);
                dqlBuffer.append("&&");
                sb.setLength(0);
                continue;
            }
            if (token.isKeyWord("OR")) {
                dqlBuffer.append(sb);
                dqlBuffer.append("||");
                sb.setLength(0);
                continue;
            }
            if (tokens[i].isKeyWord("NOT")) {
                if (i + 1 == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                }
                token = tokens[i + 1];
                if (!(token.isKeyWord("LIKE") || token.isKeyWord("IN") || token.isKeyWord("BETWEEN"))) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                }
                dqlBuffer.append('!');
                continue;
            }
            if (token.isKeyWord("LIKE")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                end = Tokenizer.scanLogicalOperator(tokens, i, next);
                if (end == -1) {
                    end = next;
                }
                dqlBuffer.append("like@s(");
                dqlBuffer.append(sb);
                dqlBuffer.append(',');
                SQL._$3(tokens, i, end, dqlBuffer);
                dqlBuffer.append(')');
                sb.setLength(0);
                i = end - 1;
                continue;
            }
            if (token.isKeyWord("IN")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                if (tokens[i].getType() != '(') {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                }
                end = Tokenizer.scanParen(tokens, i, next);
                dqlBuffer.append('[');
                SQL._$3(tokens, i + 1, end, dqlBuffer);
                dqlBuffer.append(']');
                dqlBuffer.append(".contain(");
                dqlBuffer.append(sb);
                dqlBuffer.append(')');
                sb.setLength(0);
                i = end;
                continue;
            }
            if (token.isKeyWord("BETWEEN")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                end = Tokenizer.scanKeyWord("AND", tokens, i, next);
                if (end == -1) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                }
                dqlBuffer.append("between(");
                dqlBuffer.append(sb);
                dqlBuffer.append(',');
                SQL._$3(tokens, i, end, dqlBuffer);
                dqlBuffer.append(':');
                i = end + 1;
                if (i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                end = Tokenizer.scanLogicalOperator(tokens, i, next);
                if (end == -1) {
                    end = next;
                }
                SQL._$3(tokens, i, end, dqlBuffer);
                dqlBuffer.append(')');
                sb.setLength(0);
                i = end;
                continue;
            }
            if (token.isKeyWord("CASE")) {
                i = SQL._$2(tokens, i, next, sb);
                continue;
            }
            if (token.isKeyWord("IS")) {
                if (++i == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                if (tokens[i].isKeyWord("NULL")) {
                    sb.append("==null");
                    continue;
                }
                if (!tokens[i].isKeyWord("NOT")) continue;
                if (++i == next || !tokens[i].isKeyWord("NULL")) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                sb.append("!=null");
                continue;
            }
            if (token.equals("=")) {
                sb.append("==");
                continue;
            }
            if (token.equals("<")) {
                if (i + 1 < next && tokens[i + 1].equals(">")) {
                    sb.append("!=");
                    ++i;
                    continue;
                }
                sb.append("<");
                continue;
            }
            sb.append(token.getString());
        }
        dqlBuffer.append(sb);
    }

    private int _$1(Token[] tokens, int start, int next, boolean canRefAliasName, StringBuffer dqlBuffer) {
        int i;
        int pos;
        block10: {
            if (++start == next || tokens[start].isKeyWord("WHEN")) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
            pos = Tokenizer.scanKeyWord("WHEN", tokens, start + 1, next);
            if (pos == -1) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
            }
            dqlBuffer.append("case(");
            this._$2(tokens, start, pos, canRefAliasName, dqlBuffer);
            start = pos + 1;
            block0: while (true) {
                if (start == next || tokens[start].isKeyWord("THEN")) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
                }
                pos = Tokenizer.scanKeyWord("THEN", tokens, start + 1, next);
                if (pos == -1) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
                }
                dqlBuffer.append(',');
                this._$2(tokens, start, pos, canRefAliasName, dqlBuffer);
                dqlBuffer.append(':');
                for (i = start = pos + 1; i < next; ++i) {
                    if (tokens[i].isKeyWord("WHEN")) {
                        this._$2(tokens, start, i, canRefAliasName, dqlBuffer);
                        start = i + 1;
                        continue block0;
                    }
                    if (!tokens[i].isKeyWord("ELSE")) {
                        if (tokens[i].getType() != '(') continue;
                        i = Tokenizer.scanParen(tokens, i, next);
                        continue;
                    }
                    break block10;
                }
                break;
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        this._$2(tokens, start, i, canRefAliasName, dqlBuffer);
        start = i + 1;
        if (start == next || tokens[start].isKeyWord("END")) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        pos = Tokenizer.scanKeyWord("END", tokens, start + 1, next);
        if (pos == -1) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        dqlBuffer.append(';');
        this._$2(tokens, start, pos, canRefAliasName, dqlBuffer);
        dqlBuffer.append(')');
        return pos;
    }

    private static int _$2(Token[] tokens, int start, int next, StringBuffer dqlBuffer) {
        int i;
        int pos;
        block10: {
            if (++start == next || tokens[start].isKeyWord("WHEN")) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
            }
            pos = Tokenizer.scanKeyWord("WHEN", tokens, start + 1, next);
            if (pos == -1) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
            }
            dqlBuffer.append("case(");
            SQL._$3(tokens, start, pos, dqlBuffer);
            start = pos + 1;
            block0: while (true) {
                if (start == next || tokens[start].isKeyWord("THEN")) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
                }
                pos = Tokenizer.scanKeyWord("THEN", tokens, start + 1, next);
                if (pos == -1) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
                }
                dqlBuffer.append(',');
                SQL._$3(tokens, start, pos, dqlBuffer);
                dqlBuffer.append(':');
                for (i = start = pos + 1; i < next; ++i) {
                    if (tokens[i].isKeyWord("WHEN")) {
                        SQL._$3(tokens, start, i, dqlBuffer);
                        start = i + 1;
                        continue block0;
                    }
                    if (!tokens[i].isKeyWord("ELSE")) {
                        if (tokens[i].getType() != '(') continue;
                        i = Tokenizer.scanParen(tokens, i, next);
                        continue;
                    }
                    break block10;
                }
                break;
            }
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        SQL._$3(tokens, start, i, dqlBuffer);
        start = i + 1;
        if (start == next || tokens[start].isKeyWord("END")) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        pos = Tokenizer.scanKeyWord("END", tokens, start + 1, next);
        if (pos == -1) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start].getPos());
        }
        dqlBuffer.append(';');
        SQL._$3(tokens, start, pos, dqlBuffer);
        dqlBuffer.append(')');
        return pos;
    }

    private void _$1(Token[] tokens, int start, int next, StringBuffer dqlBuffer) {
        if (++start == next || !tokens[start].equals("BY")) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        if (++start == next) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("syntax.error") + tokens[start - 1].getPos());
        }
        dqlBuffer.append(" ORDER BY ");
        int i = start;
        while (true) {
            if (i == next) {
                if (start == next) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i - 1].getPos());
                }
                this._$2(tokens, start, next, true, dqlBuffer);
                break;
            }
            Token token = tokens[i];
            if (token.getType() == '(') {
                i = Tokenizer.scanParen(tokens, i, next) + 1;
                continue;
            }
            if (token.isKeyWord("ASC") || token.isKeyWord("DESC")) {
                if (start == i) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                }
                this._$2(tokens, start, i, true, dqlBuffer);
                dqlBuffer.append(' ');
                dqlBuffer.append(token.getString());
                if (++i == next || !tokens[i].isComma()) break;
                dqlBuffer.append(',');
                start = ++i;
                continue;
            }
            if (token.isComma()) {
                if (start == i) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("syntax.error") + tokens[i].getPos());
                }
                this._$2(tokens, start, i, true, dqlBuffer);
                dqlBuffer.append(',');
                start = ++i;
                continue;
            }
            ++i;
        }
    }

    public static String test(String lmdFile, String strSql) throws Exception {
        Context ctx = new Context();
        LogicMetaData lmd = IOUtil.readLogicMetaData(lmdFile);
        lmd.prepare(ctx);
        SQL sql = new SQL(lmd, strSql);
        return sql.toDQL();
    }
}

