/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.metadata;

import com.scudata.cellset.ICellSet;
import com.scudata.common.ICloneable;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Context;
import com.scudata.dm.IQueryable;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.query.dql.DQL;
import com.scudata.dm.query.dql.LogicList;
import com.scudata.dm.query.dql.Tokenizer;
import com.scudata.dm.query.metadata.ErrorData;
import com.scudata.dm.query.metadata.Field;
import com.scudata.dm.query.metadata.FieldList;
import com.scudata.dm.query.metadata.ForeignKey;
import com.scudata.dm.query.metadata.IJSONObject;
import com.scudata.dm.query.metadata.LevelFunction;
import com.scudata.dm.query.metadata.LevelFunctionList;
import com.scudata.dm.query.metadata.PseudoTable;
import com.scudata.dm.query.metadata.Table;
import com.scudata.dm.query.metadata.TableList;
import com.scudata.dm.query.resources.ParseMessage;
import com.scudata.dm.query.utils.JsonUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicMetaData
implements IJSONObject,
ICloneable,
Externalizable,
IQueryable {
    private static final long serialVersionUID = 1L;
    private TableList _$7 = new TableList();
    private List<PseudoTable> _$6 = new ArrayList<PseudoTable>();
    private transient Context _$5 = null;
    private transient TableList _$4 = new TableList();
    private transient boolean _$3 = false;
    private Table _$2;
    private Table _$1;

    public static boolean equalSymbol(String src, String dest) {
        return src.equalsIgnoreCase(dest);
    }

    public TableList getTableList() {
        return this._$7;
    }

    public void setTableList(TableList list) {
        this._$7 = list;
    }

    public List<PseudoTable> getPseudoTableList() {
        return this._$6;
    }

    public void setPseudoTableList(List<PseudoTable> pseudoTableList) {
        this._$6 = pseudoTableList;
    }

    public List<ErrorData> prepare(Context ctx) {
        this._$5 = ctx;
        this._$3 = true;
        this._$4.clear();
        ArrayList<ErrorData> result = new ArrayList<ErrorData>();
        try {
            for (PseudoTable pseudoTable : this._$6) {
                if (pseudoTable.prepare(result, ctx)) continue;
                this._$3 = false;
            }
            for (Table table : this._$7) {
                if (table.reset(this, result)) continue;
                this._$3 = false;
            }
            for (Table table : this._$7) {
                for (Field field : table.getFieldList()) {
                    field.setTable(table);
                }
                FieldList pkFieldList = new FieldList();
                for (String pkName : table.getPK()) {
                    Field field = table.getFieldByName(pkName);
                    if (field != null) {
                        field.setPrimary(true);
                        pkFieldList.add(field);
                        continue;
                    }
                    this._$3 = false;
                    MessageManager mm = ParseMessage.get();
                    String msg = mm.getMessage("config.keyNotFound", (Object)table.getName(), (Object)pkName);
                    ErrorData error = new ErrorData(1, table, msg);
                    result.add(error);
                }
                table.setPKFieldList(pkFieldList);
                for (ForeignKey fk : table.getForeignKeyList()) {
                    fk.setTable(table);
                    FieldList fkFieldList = new FieldList();
                    for (String fkFieldName : fk.getFieldNameList()) {
                        Field field = table.getFieldByName(fkFieldName);
                        if (field != null) {
                            if (!field.getForeignKeyList().contains(fk)) {
                                field.getForeignKeyList().add(fk);
                            }
                            if (fkFieldList.contains(field)) continue;
                            fkFieldList.add(field);
                            continue;
                        }
                        this._$3 = false;
                        MessageManager mm = ParseMessage.get();
                        String msg = mm.getMessage("config.fkFieldError", (Object)table.getName(), (Object)fk.getName(), (Object)fkFieldName);
                        ErrorData error = new ErrorData(2, table, msg);
                        result.add(error);
                    }
                    fk.setFieldList(fkFieldList);
                    String refTableName = fk.getRefTableName();
                    Table refTable = this.getTableByName(refTableName);
                    if (refTable != null) {
                        fk.setRefTable(refTable);
                        if (!refTable.getForeignKeyRefList().contains(fk)) {
                            refTable.getForeignKeyRefList().add(fk);
                        }
                        FieldList fkRefFieldList = new FieldList();
                        for (String fkRefFieldName : fk.getRefFieldNameList()) {
                            Field field = refTable.getFieldByName(fkRefFieldName);
                            if (field != null) {
                                if (!field.getForeignKeyRefList().contains(fk)) {
                                    field.getForeignKeyRefList().add(fk);
                                }
                                if (fkRefFieldList.contains(field)) continue;
                                fkRefFieldList.add(field);
                                continue;
                            }
                            this._$3 = false;
                            MessageManager mm = ParseMessage.get();
                            String msg = mm.getMessage("config.fkRefFieldError", (Object)table.getName(), (Object)fk.getName(), (Object)fkRefFieldName);
                            ErrorData error = new ErrorData(2, table, msg);
                            result.add(error);
                        }
                        fk.setRefFieldList(fkRefFieldList);
                        continue;
                    }
                    this._$3 = false;
                    MessageManager mm = ParseMessage.get();
                    String msg = mm.getMessage("config.fkRefTableError", (Object)table.getName(), (Object)fk.getName(), (Object)refTableName);
                    ErrorData error = new ErrorData(2, table, msg);
                    result.add(error);
                }
            }
            for (Table table : this._$7) {
                if (table.isDim() && !this._$4.contains(table)) {
                    this._$4.add(table);
                }
                for (Field field : table.getFieldList()) {
                    field._$1(result);
                }
            }
            for (Table table : this._$7) {
                for (Field field : table.getFieldList()) {
                    Field dimField = field.getDim();
                    if (dimField == null || dimField == field) continue;
                    for (LevelFunction lf : field.getLevelFunctionList()) {
                        if (lf == null || dimField.getLevelFunctionList().contains(lf)) continue;
                        dimField.getLevelFunctionList().add(lf);
                    }
                    field.getLevelFunctionList().clear();
                }
            }
            for (Table dimTable : this._$4) {
                LevelFunctionList levelList = dimTable.getPKField().getLevelFunctionList();
                if (levelList == null) continue;
                for (LevelFunction lvf : levelList) {
                    ErrorData error;
                    String msg;
                    MessageManager mm;
                    lvf._$1(dimTable.getPKField());
                    String destTableName = lvf.getDestTableName();
                    Table destTable = this.getTableByName(destTableName);
                    if (destTable != null) {
                        if (destTable.getPKCount() != 1) {
                            this._$3 = false;
                            mm = ParseMessage.get();
                            msg = mm.getMessage("config.levelFunctionError", (Object)dimTable.getName(), (Object)lvf.getName());
                            error = new ErrorData(3, lvf, msg);
                            result.add(error);
                            continue;
                        }
                        if (!destTable.isDim()) {
                            destTable = destTable.getPKField().getDim().getTable();
                            lvf.setDestTableName(destTable.getName());
                        }
                        lvf._$2(destTable.getPKField());
                        if (destTable.getPKField().getLevelFunctionRefList().contains(lvf)) continue;
                        destTable.getPKField().getLevelFunctionRefList().add(lvf);
                        continue;
                    }
                    this._$3 = false;
                    mm = ParseMessage.get();
                    msg = mm.getMessage("config.levelFunctionError", (Object)dimTable.getName(), (Object)lvf.getName());
                    error = new ErrorData(3, lvf, msg);
                    result.add(error);
                }
            }
            TableList tmpTableList = new TableList();
            tmpTableList.addAll(this._$7);
            while (!tmpTableList.isEmpty()) {
                Table table;
                table = (Table)tmpTableList.get(0);
                if (table == null) continue;
                TableList sameDimTableList = new TableList();
                table._$2(sameDimTableList);
                table._$6(sameDimTableList);
                for (Table sameDim : sameDimTableList) {
                    sameDim._$6(sameDimTableList);
                }
                tmpTableList.removeAll(sameDimTableList);
            }
            for (Table table : this._$7) {
                TableList masterTableList = new TableList();
                table._$1(masterTableList);
                table._$5(masterTableList);
                for (Table master : masterTableList) {
                    if (master.getDetailTableList().contains(table)) continue;
                    master.getDetailTableList().add(table);
                }
            }
            for (Table table : this._$7) {
                TableList foreignKeyTableList = table._$2();
                List<List<Object>> genericForeignKeyList = table._$1(true, 1, 0);
                List<List<Object>> genericFieldList = table._$1(1);
                table._$3(foreignKeyTableList);
                table._$2(genericForeignKeyList);
                table._$1(genericFieldList);
            }
            this._$1(result);
        }
        catch (Exception e) {
            this._$3 = false;
            Logger.error((Object)e);
            ErrorData error = new ErrorData(10, null, "Exception: " + e.getMessage());
            result.add(error);
        }
        this._$1();
        return result;
    }

    private void _$1(List<ErrorData> result) {
        for (Table table : this._$7) {
            table._$1();
        }
        for (Table table : this._$7) {
            ErrorData error;
            String msg;
            Object srcObj = table.getSourceObject();
            FieldList pkList = table.getPKFieldList();
            if (!(srcObj instanceof com.scudata.dm.Table) || pkList == null || pkList.size() <= 0) continue;
            com.scudata.dm.Table t = (com.scudata.dm.Table)srcObj;
            int count = pkList.size();
            String[] pkNames = new String[count];
            for (int i = 0; i < count; ++i) {
                Field field = (Field)pkList.get(i);
                pkNames[i] = field.getSource();
            }
            if (table.isSeqKey()) {
                if (count == 1) {
                    t.setPrimary(pkNames, "n");
                    t.createIndexTable(null);
                    continue;
                }
                MessageManager mm = ParseMessage.get();
                msg = mm.getMessage("config.seqKeyError", (Object)table.getName());
                error = new ErrorData(1, table, msg);
                result.add(error);
                continue;
            }
            if (table.isHasTimeKey()) {
                if (count > 1) {
                    t.setPrimary(pkNames, "t");
                    t.createIndexTable(null);
                    continue;
                }
                MessageManager mm = ParseMessage.get();
                msg = mm.getMessage("config.timeKeyError", (Object)table.getName());
                error = new ErrorData(1, table, msg);
                result.add(error);
                continue;
            }
            t.setPrimary(pkNames, null);
            t.createIndexTable(null);
        }
    }

    public Context getContext() {
        return this._$5;
    }

    public TableList getDimList() {
        return this._$4;
    }

    public Table getTableByName(String tableName) {
        for (Table table : this._$7) {
            if (!table.isEquals(tableName)) continue;
            return table;
        }
        return null;
    }

    public Table getTableIgnoreCase(String tableName) {
        for (Table table : this._$7) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        return null;
    }

    public Table getDim(String name) {
        for (Table table : this._$4) {
            if (!table.isEquals(name)) continue;
            return table;
        }
        return null;
    }

    public Object getSourceObject(String pseudoName) {
        if (pseudoName == null || this._$6 == null || this._$6.isEmpty()) {
            return null;
        }
        for (PseudoTable pt : this._$6) {
            if (!pseudoName.equals(pt.getName())) continue;
            return pt.getSourceObject();
        }
        return null;
    }

    public PseudoTable getPseudoTable(String name) {
        if (name == null || this._$6 == null) {
            return null;
        }
        for (PseudoTable pt : this._$6) {
            if (!name.equals(pt.getName())) continue;
            return pt;
        }
        return null;
    }

    public Object deepClone() {
        LogicMetaData lmd = new LogicMetaData();
        if (this._$7 != null) {
            lmd._$7 = (TableList)this._$7.deepClone();
        }
        if (this._$6 != null) {
            List<PseudoTable> list = lmd._$6;
            for (PseudoTable pseudoTable : this._$6) {
                list.add((PseudoTable)pseudoTable.deepClone());
            }
        }
        return lmd;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._$7 = (TableList)in.readObject();
        this._$6 = (List)in.readObject();
        for (Table table : this._$7) {
            if (table == null) continue;
            table._$1(this);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this._$7);
        out.writeObject(this._$6);
    }

    @Override
    public void setParamsFromJson(String json) {
        if (!StringUtils.isValidString((Object)json)) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.invalidJSON") + json);
        }
        JSONObject jo = null;
        try {
            jo = new JSONObject(json);
        }
        catch (JSONException ex) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.invalidJSON") + json, (Throwable)ex);
        }
        this.setParamsFromJson(jo);
    }

    @Override
    public void setParamsFromJson(JSONObject jo) {
        int i;
        JSONArray ja;
        try {
            ja = jo.getJSONArray("tableList");
            if (ja != null) {
                for (i = 0; i < ja.length(); ++i) {
                    Table table = new Table(this);
                    table.setParamsFromJson(JsonUtils.getJSONObject(ja.get(i)));
                    this._$7.add(table);
                }
            }
        }
        catch (JSONException je) {
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        try {
            ja = jo.getJSONArray("pseudoTableList");
            if (ja != null) {
                for (i = 0; i < ja.length(); ++i) {
                    PseudoTable pseudoTable = new PseudoTable();
                    pseudoTable.setParamsFromJson(JsonUtils.getJSONObject(ja.get(i)));
                    this._$6.add(pseudoTable);
                }
            }
        }
        catch (JSONException je) {
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String toJsonString() throws JSONException {
        JSONObject jo = new JSONObject();
        JsonUtils.setList(jo, "tableList", this._$7);
        JsonUtils.setList(jo, "pseudoTableList", this._$6);
        return jo.toString();
    }

    public boolean getReady() {
        return this._$3;
    }

    public static byte getTypeBySQLType(int type) {
        switch (type) {
            case 4: {
                return 1;
            }
            case 5: {
                return 3;
            }
            case -5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 91: {
                return 8;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 10;
            }
            case 12: {
                return 11;
            }
            case 16: {
                return 12;
            }
            case -2: {
                return 62;
            }
        }
        return 0;
    }

    public Object query(String sql, Object[] params, ICellSet cs, Context ctx) {
        ArrayList<Object> list = null;
        if (params != null) {
            list = new ArrayList<Object>(params.length);
            for (Object obj : params) {
                list.add(obj);
            }
        }
        return this.query(sql, list, cs, ctx);
    }

    public Object query(String sql, ArrayList<Object> params, ICellSet cs, Context ctx) {
        char c = ' ';
        for (int i = 0; i < sql.length() && Character.isWhitespace(c = (char)sql.charAt(i)); ++i) {
        }
        if (c == 's' || c == 'S') {
            DQL dql = new DQL(this, ctx, sql, params);
            Object val = dql.execute();
            if (val instanceof ICursor) {
                return ((ICursor)val).fetch();
            }
            return val;
        }
        if (c == 'l' || c == 'L') {
            LogicList logicList = new LogicList(sql, this);
            return logicList.toTable();
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException(mm.getMessage("syntax.error") + 0);
    }

    public void prepareForSearch(Context ctx) {
        this._$5 = ctx;
        this._$4.clear();
        for (Table table : this._$7) {
            table.resetForSearch(this);
        }
        for (Table table : this._$7) {
            for (Field field : table.getFieldList()) {
                field.setTable(table);
            }
            FieldList pkFieldList = new FieldList();
            for (String pkName : table.getPK()) {
                Field field = table.getFieldByName(pkName);
                if (field != null) {
                    field.setPrimary(true);
                    pkFieldList.add(field);
                    continue;
                }
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("config.keyNotFound", (Object)table.getName(), (Object)pkName));
            }
            table.setPKFieldList(pkFieldList);
            for (ForeignKey fk : table.getForeignKeyList()) {
                fk.setTable(table);
                FieldList fkFieldList = new FieldList();
                for (String fkFieldName : fk.getFieldNameList()) {
                    Field field = table.getFieldByName(fkFieldName);
                    if (field != null) {
                        if (!field.getForeignKeyList().contains(fk)) {
                            field.getForeignKeyList().add(fk);
                        }
                        if (fkFieldList.contains(field)) continue;
                        fkFieldList.add(field);
                        continue;
                    }
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("config.fkFieldError", (Object)table.getName(), (Object)fk.getName(), (Object)fkFieldName));
                }
                fk.setFieldList(fkFieldList);
                String refTableName = fk.getRefTableName();
                Table refTable = this.getTableByName(refTableName);
                if (refTable != null) {
                    fk.setRefTable(refTable);
                    if (!refTable.getForeignKeyRefList().contains(fk)) {
                        refTable.getForeignKeyRefList().add(fk);
                    }
                    FieldList fkRefFieldList = new FieldList();
                    for (String fkRefFieldName : fk.getRefFieldNameList()) {
                        Field field = refTable.getFieldByName(fkRefFieldName);
                        if (field != null) {
                            if (!field.getForeignKeyRefList().contains(fk)) {
                                field.getForeignKeyRefList().add(fk);
                            }
                            if (fkRefFieldList.contains(field)) continue;
                            fkRefFieldList.add(field);
                            continue;
                        }
                        MessageManager mm = ParseMessage.get();
                        throw new RQException(mm.getMessage("config.fkRefFieldError", (Object)table.getName(), (Object)fk.getName(), (Object)fkRefFieldName));
                    }
                    fk.setRefFieldList(fkRefFieldList);
                    continue;
                }
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("config.fkRefTableError", (Object)table.getName(), (Object)fk.getName(), (Object)refTableName));
            }
        }
        for (Table table : this._$7) {
            if (table.isDim() && !this._$4.contains(table)) {
                this._$4.add(table);
            }
            for (Field field : table.getFieldList()) {
                field._$1();
            }
        }
        for (Table table : this._$7) {
            for (Field field : table.getFieldList()) {
                Field dimField = field.getDim();
                if (dimField == null || dimField == field) continue;
                for (LevelFunction lf : field.getLevelFunctionList()) {
                    if (lf == null || dimField.getLevelFunctionList().contains(lf)) continue;
                    dimField.getLevelFunctionList().add(lf);
                }
                field.getLevelFunctionList().clear();
            }
        }
        for (Table dimTable : this._$4) {
            LevelFunctionList levelList = dimTable.getPKField().getLevelFunctionList();
            if (levelList == null) continue;
            for (LevelFunction lvf : levelList) {
                lvf._$1(dimTable.getPKField());
                String destTableName = lvf.getDestTableName();
                Table destTable = this.getTableByName(destTableName);
                if (destTable == null || destTable.getPKCount() != 1) {
                    MessageManager mm = ParseMessage.get();
                    throw new RQException(mm.getMessage("config.levelFunctionError", (Object)dimTable.getName(), (Object)lvf.getName()));
                }
                if (!destTable.isDim()) {
                    destTable = destTable.getPKField().getDim().getTable();
                    lvf.setDestTableName(destTable.getName());
                }
                lvf._$2(destTable.getPKField());
                if (destTable.getPKField().getLevelFunctionRefList().contains(lvf)) continue;
                destTable.getPKField().getLevelFunctionRefList().add(lvf);
            }
        }
        TableList tmpTableList = new TableList();
        tmpTableList.addAll(this._$7);
        while (!tmpTableList.isEmpty()) {
            Table table;
            table = (Table)tmpTableList.get(0);
            if (table == null) continue;
            TableList sameDimTableList = new TableList();
            table._$2(sameDimTableList);
            table._$6(sameDimTableList);
            for (Table sameDim : sameDimTableList) {
                sameDim._$6(sameDimTableList);
            }
            tmpTableList.removeAll(sameDimTableList);
        }
        for (Table table : this._$7) {
            TableList masterTableList = new TableList();
            table._$1(masterTableList);
            table._$5(masterTableList);
            for (Table master : masterTableList) {
                if (master.getDetailTableList().contains(table)) continue;
                master.getDetailTableList().add(table);
            }
        }
        for (Table table : this._$7) {
            TableList foreignKeyTableList = table._$2();
            List<List<Object>> genericForeignKeyList = table._$1(true, 1, 0);
            List<List<Object>> genericFieldList = table._$1(1);
            table._$3(foreignKeyTableList);
            table._$2(genericForeignKeyList);
            table._$1(genericFieldList);
        }
        this._$1();
        this._$3 = true;
    }

    private void _$1() {
        TableList dimList = this._$4;
        int size = dimList.size();
        block4: for (int i = 0; i < size; ++i) {
            Table dimTable = (Table)dimList.get(i);
            int type = dimTable.getDimType();
            switch (type) {
                case 6: {
                    this._$2 = dimTable;
                    continue block4;
                }
                case 5: {
                    this._$1 = dimTable;
                    continue block4;
                }
            }
        }
    }

    public String toString(Timestamp date) {
        if (this._$2 == null || this._$2.getDimFormatExp() == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("search.lessDateDimFormatExp"));
        }
        String exp = this._$2.getDimFormatExp();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        exp = Tokenizer.replace(exp, "?1", Integer.toString(year), true);
        exp = Tokenizer.replace(exp, "?2", Integer.toString(month), true);
        exp = Tokenizer.replace(exp, "?3", Integer.toString(day), true);
        exp = Tokenizer.replace(exp, "?4", Integer.toString(hour), true);
        exp = Tokenizer.replace(exp, "?5", Integer.toString(minute), true);
        exp = Tokenizer.replace(exp, "?6", Integer.toString(second), true);
        return exp;
    }

    public String toString(Date date) {
        if (this._$1 == null || this._$1.getDimFormatExp() == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("search.lessDateDimFormatExp"));
        }
        String exp = this._$1.getDimFormatExp();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        exp = Tokenizer.replace(exp, "?1", Integer.toString(year), true);
        exp = Tokenizer.replace(exp, "?2", Integer.toString(month), true);
        exp = Tokenizer.replace(exp, "?3", Integer.toString(day), true);
        return exp;
    }
}

