/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.metadata;

import com.scudata.common.CellLocation;
import com.scudata.common.Escape;
import com.scudata.common.ICloneable;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.query.metadata.ErrorData;
import com.scudata.dm.query.metadata.IJSONObject;
import com.scudata.dm.query.metadata.PseudoField;
import com.scudata.dm.query.resources.ParseMessage;
import com.scudata.dm.query.utils.JsonUtils;
import com.scudata.pseudo.PseudoColumn;
import com.scudata.pseudo.PseudoDefination;
import com.scudata.util.Variant;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoTable
extends PseudoDefination
implements IJSONObject,
ICloneable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final String _$4 = "pseudoOpt";
    private String _$3 = "v";
    private transient Object _$2 = null;
    private transient com.scudata.pseudo.PseudoTable _$1 = null;

    public PseudoTable() {
    }

    public PseudoTable(com.scudata.pseudo.PseudoTable pt) {
        PseudoDefination pd = pt.getPd();
        this.setName(pd.getName());
        this.setFile(pd.getFile());
        this.setZone(pd.getZone());
        this.setKey(pd.getKey());
        this.setKeys(pd.getKeys());
        List<PseudoColumn> columns = pd.getColumns();
        if (columns == null) {
            this.setColumns(null);
        } else {
            ArrayList<PseudoColumn> pcs = new ArrayList<PseudoColumn>();
            for (PseudoColumn col : columns) {
                PseudoField pf = new PseudoField(col);
                pcs.add(pf);
            }
            this.setColumns(pcs);
        }
    }

    public boolean prepare(List<ErrorData> result, Context ctx) {
        Record rec = this._$1(true, ctx, result);
        if (rec == null) {
            return false;
        }
        int parallelNum = Env.getCursorParallelNum();
        this._$1 = com.scudata.pseudo.PseudoTable.create((BaseRecord)rec, parallelNum, this._$3, ctx);
        this._$2 = this._$1;
        return true;
    }

    public String[] getExportSpl(int row) {
        String[] exps = new String[3];
        Record rec = this._$1(false, null, null);
        Sequence seq = new Sequence();
        seq.add((Object)rec);
        String pseudoJson = this._$1(seq);
        exps[0] = "=" + pseudoJson;
        exps[1] = "=pseudo";
        if (StringUtils.isValidString((Object)this._$3)) {
            exps[1] = exps[1] + "@" + this._$3;
        }
        exps[1] = exps[1] + "(" + CellLocation.getCellId((int)row, (int)1) + ")";
        String name = this.getName();
        exps[2] = "/" + name;
        return exps;
    }

    public String getPseudoOption() {
        return this._$3;
    }

    public void setPseudoOption(String pseudoOption) {
        this._$3 = pseudoOption;
    }

    public Object getSourceObject() {
        return this._$2;
    }

    public com.scudata.pseudo.PseudoTable getPseudoTable() {
        return this._$1;
    }

    @Override
    public Object deepClone() {
        PseudoTable pt = new PseudoTable();
        pt.setName(this.getName());
        pt.setFile(this.getFile());
        pt.setZone(this.getZone());
        pt.setColumns(this.getColumns());
        return pt;
    }

    private String _$1(Sequence seq) {
        StringBuffer sb = new StringBuffer(1024);
        sb.append('[');
        int len = seq.length();
        for (int i = 1; i <= len; ++i) {
            if (i > 1) {
                sb.append(',');
            }
            this._$1(seq.getMem(i), sb, true);
        }
        sb.append(']');
        return sb.toString();
    }

    private void _$1(Object obj, StringBuffer sb, boolean addQuote) {
        if (obj == null) {
            sb.append("null");
        } else if (obj instanceof Record) {
            Record r = (Record)obj;
            String[] names = r.getFieldNames();
            Object[] vals = r.getFieldValues();
            sb.append('{');
            int fcount = vals.length;
            for (int f = 0; f < fcount; ++f) {
                if (f > 0) {
                    sb.append(',');
                }
                sb.append(names[f]);
                sb.append(':');
                this._$1(vals[f], sb, true);
            }
            sb.append('}');
        } else if (obj instanceof Sequence) {
            Sequence seq = (Sequence)obj;
            sb.append('[');
            int len = seq.length();
            for (int i = 1; i <= len; ++i) {
                if (i > 1) {
                    sb.append(',');
                }
                this._$1(seq.getMem(i), sb, true);
            }
            sb.append(']');
        } else if (obj instanceof String) {
            String str = (String)obj;
            if (addQuote) {
                str = Escape.addEscAndQuote((String)str);
            }
            sb.append(str);
        } else if (obj instanceof Date) {
            String str = Variant.toString((Object)obj);
            if (addQuote) {
                str = Escape.addEscAndQuote((String)str);
            }
            sb.append(str);
        } else {
            sb.append(Variant.toString((Object)obj));
        }
    }

    private Record _$1(boolean isPrepare, Context ctx, List<ErrorData> result) {
        List<PseudoColumn> columns = this.getColumns();
        Sequence colSeq = new Sequence();
        if (columns != null) {
            for (PseudoColumn pc : columns) {
                if (!(pc instanceof PseudoField)) continue;
                PseudoField pf = (PseudoField)pc;
                pf._$1(this);
                if (isPrepare && !pf.prepare(result, ctx)) {
                    return null;
                }
                colSeq.add((Object)pf.getDefineRecord(!isPrepare));
            }
        }
        String name = this.getName();
        Object file = this.getFile();
        if (file instanceof String) {
            String fileName = (String)file;
            fileName = fileName.replaceAll("\\\\\\\\", "/");
            fileName = fileName.replaceAll("\\\\", "/");
            file = fileName;
        }
        Record rec = this._$1() ? new Record(new DataStruct(new String[]{"name", "file", "key", "column"}), new Object[]{name, file, this.getKey(), colSeq}) : new Record(new DataStruct(new String[]{"name", "file", "zone", "column"}), new Object[]{name, file, this.getZone(), colSeq});
        return rec;
    }

    private boolean _$1() {
        String fileName = (String)this.getFile();
        return fileName != null && fileName.toLowerCase().endsWith("btx");
    }

    private boolean _$1(String[] pk1, String[] pk2) {
        if (pk1 == null && pk2 != null) {
            return false;
        }
        if (pk2 == null) {
            return false;
        }
        if (pk1.length != pk2.length) {
            return false;
        }
        for (int i = 0; i < pk1.length; ++i) {
            if (pk1[i].equals(pk2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.setName((String)in.readObject());
        this.setFile(in.readObject());
        this.setZone((Sequence)in.readObject());
        this.setKey((String)in.readObject());
        this.setColumns((List)in.readObject());
        Object tmp = in.readObject();
        this._$3 = tmp == null ? null : (String)tmp;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.getName());
        out.writeObject(this.getFile());
        out.writeObject(this.getZone());
        out.writeObject(this.getKey());
        out.writeObject(this.getColumns());
        out.writeObject(this._$3);
    }

    @Override
    public String toJsonString() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put(_$4, (Object)this._$3);
        jo.put("name", (Object)this.getName());
        jo.put("file", this.getFile());
        Sequence zone = this.getZone();
        if (zone != null) {
            try {
                jo.put("zone", (Object)JsonUtils.toJSONArray(zone));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        jo.put("key", (Object)this.getKey());
        JsonUtils.setList(jo, "column", this.getColumns());
        return jo.toString();
    }

    @Override
    public void setParamsFromJson(String json) {
        if (!StringUtils.isValidString((Object)json)) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.invalidJSON") + json);
        }
        JSONObject jo = null;
        try {
            jo = new JSONObject(json);
        }
        catch (JSONException ex) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.invalidJSON") + json, (Throwable)ex);
        }
        this.setParamsFromJson(jo);
    }

    @Override
    public void setParamsFromJson(JSONObject jo) {
        int i;
        JSONArray ja;
        if (jo == null) {
            return;
        }
        try {
            this._$3 = !jo.has(_$4) ? "v" : JsonUtils.getString(jo, _$4);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.setName(JsonUtils.getString(jo, "name"));
        this.setFile(JsonUtils.getObject(jo, "file"));
        try {
            ja = jo.getJSONArray("zone");
            if (ja != null) {
                Sequence seq = new Sequence();
                for (i = 0; i < ja.length(); ++i) {
                    seq.add((Object)ja.getInt(i));
                }
                this.setZone(seq);
            }
        }
        catch (JSONException je) {
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
        this.setKey(JsonUtils.getString(jo, "key"));
        try {
            ja = jo.getJSONArray("column");
            if (ja != null) {
                ArrayList<PseudoColumn> fieldList = new ArrayList<PseudoColumn>();
                for (i = 0; i < ja.length(); ++i) {
                    PseudoField fd = new PseudoField();
                    fd.setParamsFromJson(JsonUtils.getJSONObject(ja.get(i)));
                    fieldList.add(fd);
                }
                this.setColumns(fieldList);
            }
        }
        catch (JSONException je) {
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), (Throwable)e);
        }
    }
}

