/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.query.sqlplus.lIlIllllIlIIllII;
import com.scudata.resources.ParseMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class IlIIIlllIllIIIlI {
    public static final char KEYWORD = '\u0000';
    public static final char IDENT = '\u0001';
    public static final char NUMBER = '\u0002';
    public static final char STRING = '\u0003';
    public static final char OPERATOR = '\u0004';
    public static final char LPAREN = '(';
    public static final char RPAREN = ')';
    public static final char COMMA = ',';
    public static final char DOT = '.';
    public static final char PARAMMARK = '?';
    public static final char OPTIONMARK = '@';
    private static final String _$6 = "+-*/=<>&|^%!~";
    private static final String[] _$5 = new String[]{"AVG", "COUNT", "MAX", "MIN", "SUM"};
    public static final String COL_AS = " ";
    public static final String TABLE_AS = " ";
    private static final String[] _$4 = new String[]{"AND", "OR", "LIKE", "NOT"};
    private static final String[] _$3 = new String[]{"ALL", "AND", "AS", "ASC", "BETWEEN", "BOTTOM", "BY", "CALL", "CASE", "CREATE", "CROSS", "DESC", "DISTINCT", "DROP", "ELSE", "END", "EXCEPT", "EXISTS", "FETCH", "FIRST", "FROM", "FULL", "GROUP", "HAVING", "IN", "INNER", "INTERSECT", "INTO", "IS", "JOIN", "LEFT", "LIKE", "LIMIT", "MINUS", "NOT", "NULL", "OFFSET", "ON", "ONLY", "OR", "ORDER", "OUTER", "RECURSIVE", "RIGHT", "ROWS", "SELECT", "TABLE", "TEMP", "TEMPORARY", "THEN", "TO", "TOP", "UNION", "WHEN", "WHERE", "WITH"};
    private static final String[] _$2 = new String[]{"DEPTH", "DIM", "FIELD", "FOREIGN", "KEY", "LAYER", "LIST", "METADATA", "OF", "PRIMARY", "SUB", "TABLE", "TYPE"};
    private static final Map<String, String> _$1 = new HashMap<String, String>();

    IlIIIlllIllIIIlI() {
    }

    public static int scanMergeKeyWord(lIlIllllIlIIllII[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            if (tokens[i].isMergeKeyWord()) {
                return i;
            }
            if (tokens[i].getType() != '(') continue;
            i = IlIIIlllIllIIIlI.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static int scanByDataKeyWord(lIlIllllIlIIllII[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            lIlIllllIlIIllII token = tokens[i];
            if (token.getType() == '\u0000') {
                if (token.equals("BY")) {
                    return i;
                }
                if (!token.equals("FROM") && !token.equals("HAVING") && !token.equals("ORDER")) continue;
                return -1;
            }
            if (tokens[i].getType() != '(') continue;
            i = IlIIIlllIllIIIlI.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static int scanKeyWord(String key, lIlIllllIlIIllII[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            if (tokens[i].isKeyWord(key)) {
                return i;
            }
            if (tokens[i].getType() != '(') continue;
            i = IlIIIlllIllIIIlI.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static int scanLogicalOperator(lIlIllllIlIIllII[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            if (tokens[i].isKeyWord("AND") || tokens[i].isKeyWord("OR")) {
                return i;
            }
            if (tokens[i].getType() != '(') continue;
            i = IlIIIlllIllIIIlI.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static int lastScanKeyWord(String key, lIlIllllIlIIllII[] tokens, int start, int next) {
        for (int i = next - 1; i >= start; --i) {
            if (tokens[i].isKeyWord(key)) {
                return i;
            }
            if (tokens[i].getType() != ')') continue;
            i = IlIIIlllIllIIIlI.lastScanParen(tokens, start, i);
        }
        return -1;
    }

    public static int scanKeyWords(String[] keys, lIlIllllIlIIllII[] tokens, int start, int next) {
        int keyCount = keys.length;
        for (int i = start; i < next; ++i) {
            lIlIllllIlIIllII token = tokens[i];
            if (token.getType() == '(') {
                i = IlIIIlllIllIIIlI.scanParen(tokens, i, next);
                continue;
            }
            if (token.getType() != '\u0000') continue;
            for (int k = 0; k < keyCount; ++k) {
                if (!token.equals(keys[k])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int scanComma(lIlIllllIlIIllII[] tokens, int start, int next) {
        for (int i = start; i < next; ++i) {
            char type = tokens[i].getType();
            if (type == ',') {
                return i;
            }
            if (type != '(') continue;
            i = IlIIIlllIllIIIlI.scanParen(tokens, i, next);
        }
        return -1;
    }

    public static int scanParen(lIlIllllIlIIllII[] tokens, int start, int next) {
        int deep = 0;
        for (int i = start + 1; i < next; ++i) {
            if (tokens[i].getType() == '(') {
                ++deep;
                continue;
            }
            if (tokens[i].getType() != ')') continue;
            if (deep == 0) {
                return i;
            }
            --deep;
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException("(,)" + mm.getMessage("mark.notMatch"));
    }

    public static int lastScanParen(lIlIllllIlIIllII[] tokens, int start, int end) {
        int deep = 0;
        for (int i = end - 1; i >= start; --i) {
            if (tokens[i].getType() == '(') {
                if (deep == 0) {
                    return i;
                }
                --deep;
                continue;
            }
            if (tokens[i].getType() != ')') continue;
            ++deep;
        }
        MessageManager mm = ParseMessage.get();
        throw new RQException("(,)" + mm.getMessage("mark.notMatch"));
    }

    public static int scanKeyWords(lIlIllllIlIIllII[] tokens, int start, int next, String[] keys, int index) {
        int keyCount = keys.length;
        for (int i = start; i < next; ++i) {
            lIlIllllIlIIllII token = tokens[i];
            if (token.getType() == '(') {
                i = IlIIIlllIllIIIlI.scanParen(tokens, i, next);
                continue;
            }
            if (token.getType() != '\u0000') continue;
            for (int k = index; k < keyCount; ++k) {
                if (!token.equals(keys[k])) continue;
                return i;
            }
        }
        return next;
    }

    public static String[] getStrings(lIlIllllIlIIllII[] tokens, int start, int next) {
        String[] ts = new String[next - start];
        for (int i = start; i < next; ++i) {
            ts[i - start] = tokens[i].getString();
        }
        return ts;
    }

    public static boolean isGatherFunction(String name) {
        name = name.toUpperCase();
        return IlIIIlllIllIIIlI._$1(name, _$5);
    }

    public static boolean isOperatorKeyWord(String name) {
        return IlIIIlllIllIIIlI._$1(name, _$4);
    }

    public static boolean isSQLKeyWord(String id) {
        return IlIIIlllIllIIIlI._$1(id, _$3);
    }

    public static boolean isListKeyWord(String id) {
        return IlIIIlllIllIIIlI._$1(id, _$2);
    }

    private static boolean _$1(String id, String[] keyWords) {
        int len = keyWords.length;
        for (int i = 0; i < len; ++i) {
            if (!keyWords[i].equals(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    public static boolean isIdentifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch);
    }

    public static lIlIllllIlIIllII[] parseSQL(String command) {
        int curIndex = 0;
        command = command.trim();
        int cmdLen = command.length();
        ArrayList<lIlIllllIlIIllII> tokenList = new ArrayList<lIlIllllIlIIllII>();
        while (curIndex < cmdLen) {
            lIlIllllIlIIllII token;
            String id;
            MessageManager mm;
            lIlIllllIlIIllII token2;
            String id2;
            char ch = command.charAt(curIndex);
            if (Character.isWhitespace(ch)) {
                ++curIndex;
                continue;
            }
            if (ch == '[' || ch == ']' || ch == '{' || ch == '}' || ch == ':' || ch == '\\' || ch == '~') {
                lIlIllllIlIIllII token3 = new lIlIllllIlIIllII(ch, "" + ch, curIndex, "" + ch);
                tokenList.add(token3);
                ++curIndex;
                continue;
            }
            if (ch == '@') {
                int next = IlIIIlllIllIIIlI._$1(command, curIndex + 1);
                id2 = command.substring(curIndex, next);
                token2 = new lIlIllllIlIIllII(ch, id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (IlIIIlllIllIIIlI.isIdentifierStart(ch)) {
                lIlIllllIlIIllII token4;
                int next = IlIIIlllIllIIIlI._$1(command, curIndex + 1);
                id2 = command.substring(curIndex, next);
                String upId = id2.toUpperCase();
                if (IlIIIlllIllIIIlI.isSQLKeyWord(upId)) {
                    token4 = new lIlIllllIlIIllII('\u0000', upId, curIndex, id2);
                    tokenList.add(token4);
                } else {
                    token4 = new lIlIllllIlIIllII('\u0001', id2, curIndex, id2);
                    tokenList.add(token4);
                }
                curIndex = next;
                continue;
            }
            if (Character.isDigit(ch)) {
                int next = IlIIIlllIllIIIlI.scanNumber(command, curIndex + 1);
                id2 = command.substring(curIndex, next);
                token2 = new lIlIllllIlIIllII('\u0002', id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '.') {
                int next = IlIIIlllIllIIIlI.scanNumber(command, curIndex);
                id2 = command.substring(curIndex, next);
                if (next > curIndex + 1) {
                    token2 = new lIlIllllIlIIllII('\u0002', id2, curIndex, id2);
                    tokenList.add(token2);
                } else {
                    token2 = new lIlIllllIlIIllII(ch, id2, curIndex, id2);
                    tokenList.add(token2);
                }
                curIndex = next;
                continue;
            }
            if (ch == '\'') {
                int next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    mm = ParseMessage.get();
                    throw new RQException("\",\"" + mm.getMessage("mark.notMatch"));
                }
                id2 = '\"' + command.substring(curIndex + 1, ++next - 1) + '\"';
                token2 = new lIlIllllIlIIllII('\u0003', id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '\"') {
                int next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                id2 = '\'' + command.substring(curIndex + 1, ++next - 1) + '\'';
                token2 = new lIlIllllIlIIllII('\u0001', id2, curIndex, id2);
                tokenList.add(token2);
                curIndex = next;
                continue;
            }
            if (ch == '?') {
                id = command.substring(curIndex, curIndex + 1);
                token = new lIlIllllIlIIllII('?', null, curIndex, id);
                tokenList.add(token);
                ++curIndex;
                continue;
            }
            if (_$6.indexOf(ch) != -1) {
                id = command.substring(curIndex, curIndex + 1);
                token = new lIlIllllIlIIllII('\u0004', id, curIndex, id);
                tokenList.add(token);
                ++curIndex;
                continue;
            }
            if (ch == '(' || ch == ')' || ch == ',') {
                id = command.substring(curIndex, curIndex + 1);
                token = new lIlIllllIlIIllII(ch, id, curIndex, id);
                tokenList.add(token);
                ++curIndex;
                continue;
            }
            MessageManager mm2 = ParseMessage.get();
            throw new RQException(mm2.getMessage("syntax.error") + curIndex);
        }
        int size = tokenList.size();
        lIlIllllIlIIllII[] tokens = new lIlIllllIlIIllII[size];
        tokenList.toArray(tokens);
        return tokens;
    }

    public static int getLogicSqlStart(String command) {
        int curIndex = 0;
        int cmdLen = command.length();
        while (curIndex < cmdLen) {
            MessageManager mm;
            int next;
            char ch = command.charAt(curIndex);
            if (Character.isWhitespace(ch)) {
                ++curIndex;
                continue;
            }
            if (Character.isJavaIdentifierStart(ch)) {
                next = IlIIIlllIllIIIlI._$1(command, curIndex + 1);
                String id = command.substring(curIndex, next).toUpperCase();
                if (id.equals("SELECT") || id.equals("WITH") || id.equals("CREATE") || id.equals("DROP")) {
                    return curIndex;
                }
                curIndex = next;
                continue;
            }
            if (Character.isDigit(ch)) {
                curIndex = IlIIIlllIllIIIlI.scanNumber(command, curIndex + 1);
                continue;
            }
            if (ch == '\"') {
                next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                curIndex = next + 1;
                continue;
            }
            if (ch == '\'') {
                next = Sentence.scanQuotation((String)command, (int)curIndex);
                if (next < 0) {
                    mm = ParseMessage.get();
                    throw new RQException("','" + mm.getMessage("mark.notMatch"));
                }
                curIndex = next + 1;
                continue;
            }
            ++curIndex;
        }
        return -1;
    }

    private static int _$1(String command, int start) {
        char ch;
        int len = command.length();
        if (start == len) {
            return start;
        }
        if (command.charAt(start) == '\'') {
            if ((start = Sentence.scanQuotation((String)command, (int)start)) < 0) {
                MessageManager mm = ParseMessage.get();
                throw new RQException("','" + mm.getMessage("mark.notMatch"));
            }
            if (++start == len) {
                return start;
            }
            char ch2 = command.charAt(start);
            if (IlIIIlllIllIIIlI.isIdentifierPart(ch2)) {
                MessageManager mm = ParseMessage.get();
                throw new RQException(mm.getMessage("syntax.error") + start);
            }
            return start;
        }
        while (start < len && IlIIIlllIllIIIlI.isIdentifierPart(ch = command.charAt(start))) {
            ++start;
        }
        return start;
    }

    public static int scanNumber(String command, int start) {
        int len = command.length();
        while (start < len && Character.isDigit(command.charAt(start))) {
            ++start;
        }
        if (start < len && command.charAt(start) == '.') {
            ++start;
            while (start < len && Character.isDigit(command.charAt(start))) {
                ++start;
            }
        }
        return start;
    }

    public static String replace(String str, char s, String r, boolean ignoreQuote) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(128 + len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (!(ignoreQuote || ch != '\'' && ch != '\"')) {
                int pos = Sentence.scanQuotation((String)str, (int)i);
                if (pos == -1) {
                    sb.append(str.substring(i));
                    break;
                }
                sb.append(str.substring(i, pos + 1));
                i = pos;
                continue;
            }
            if (ch == s) {
                sb.append(r);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String replaceTable(String str, String tableName, String exp) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(128 + len);
        int subLen = tableName.length();
        if (tableName == null || exp == null) {
            MessageManager mm = ParseMessage.get();
            throw new RQException(mm.getMessage("config.error"));
        }
        int i = 0;
        while (i < len) {
            int next;
            if (i + subLen >= len) {
                sb.append(str.substring(i));
                break;
            }
            char ch = str.charAt(i);
            if (IlIIIlllIllIIIlI.isIdentifierStart(ch) || ch == '\"') {
                next = IlIIIlllIllIIIlI._$1(str, i);
                if (next - i == subLen && str.charAt(next) == '.' && str.regionMatches(true, i, tableName, 0, subLen)) {
                    sb.append(exp);
                } else {
                    sb.append(str.substring(i, next));
                }
                i = next;
                continue;
            }
            if (ch == '\'') {
                int pos = Sentence.scanQuotation((String)str, (int)i);
                if (pos == -1) {
                    sb.append(str.substring(i));
                    break;
                }
                sb.append(str.substring(i, pos + 1));
                i = pos + 1;
                continue;
            }
            if (ch == '.') {
                sb.append(ch);
                if (!IlIIIlllIllIIIlI.isIdentifierStart(ch = str.charAt(++i)) && ch != '\"') continue;
                next = IlIIIlllIllIIIlI._$1(str, i);
                sb.append(str.substring(i, next));
                i = next;
                continue;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static String replace(String str, String sub, String exp, boolean ignoreQuote) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(128 + len);
        int subLen = sub.length();
        int i = 0;
        while (i < len) {
            if (i + subLen - 1 > len) {
                sb.append(str.substring(i));
                break;
            }
            char ch = str.charAt(i);
            if (!(ignoreQuote || ch != '\'' && ch != '\"')) {
                int pos = Sentence.scanQuotation((String)str, (int)i);
                if (pos == -1) {
                    sb.append(str.substring(i));
                    break;
                }
                sb.append(str.substring(i, pos + 1));
                i = pos + 1;
                continue;
            }
            if (str.regionMatches(true, i, sub, 0, subLen)) {
                sb.append(exp);
                i += subLen;
                continue;
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static boolean isOperator(String ch) {
        return ch.length() == 1 && _$6.indexOf(ch) != -1;
    }

    public static String parseFunction(String name) {
        String funcName = _$1.get(name.toUpperCase());
        if (funcName == null) {
            funcName = name.toLowerCase();
        }
        return funcName;
    }

    static {
        _$1.put("ABS", "abs");
        _$1.put("ACOS", "acos");
        _$1.put("ACOSH", "acosh");
        _$1.put("ASIN", "asin");
        _$1.put("ASINH", "asinh");
        _$1.put("ATAN", "atan");
        _$1.put("ATANH", "atanh");
        _$1.put("CEIL", "ceil");
        _$1.put("COMBIN", "combin");
        _$1.put("COS", "cos");
        _$1.put("COSH", "cosh");
        _$1.put("EXP", "exp");
        _$1.put("FACT", "fact");
        _$1.put("FLOOR", "floor");
        _$1.put("GCD", "gcd");
        _$1.put("INF", "inf");
        _$1.put("LCM", "lcm");
        _$1.put("LG", "lg");
        _$1.put("LN", "ln");
        _$1.put("PERMUT", "permut");
        _$1.put("PI", "pi");
        _$1.put("POWER", "power");
        _$1.put("RAND", "rand");
        _$1.put("ROUND", "round");
        _$1.put("SIN", "sin");
        _$1.put("SINH", "sinh");
        _$1.put("SQRT", "sqrt");
        _$1.put("TAN", "tan");
        _$1.put("TANH", "tanh");
        _$1.put("DECIMAL", "decimal");
        _$1.put("FLOAT", "float");
        _$1.put("IFNUMBER", "ifnumber");
        _$1.put("INT", "int");
        _$1.put("LONG", "long");
        _$1.put("NUMBER", "number");
        _$1.put("CONCAT", "concat");
        _$1.put("FILL", "fill");
        _$1.put("ISALPHA", "isalpha");
        _$1.put("ISDIGIT", "isdigit");
        _$1.put("ISLOWER", "islower");
        _$1.put("ISUPPER", "isupper");
        _$1.put("LEN", "len");
        _$1.put("LIKE", "like");
        _$1.put("LOWER", "lower");
        _$1.put("MD5", "md5");
        _$1.put("MID", "mid");
        _$1.put("POS", "pos");
        _$1.put("RANDS", "rands");
        _$1.put("REPLACE", "replace");
        _$1.put("STRING", "string");
        _$1.put("TRIM", "trim");
        _$1.put("UPPER", "upper");
        _$1.put("URLENCODE", "urlencode");
        _$1.put("IFSTRING", "ifstring");
        _$1.put("AGE", "age");
        _$1.put("DATE", "date");
        _$1.put("DATETIME", "datetime");
        _$1.put("DAY", "day");
        _$1.put("DAYS", "days");
        _$1.put("DEQ", "deq");
        _$1.put("ELAPSE", "elapse");
        _$1.put("HOUR", "hour");
        _$1.put("INTERVAL", "interval");
        _$1.put("MILLISECOND", "millisecond");
        _$1.put("MINUTE", "minute");
        _$1.put("MONTH", "month");
        _$1.put("NOW", "now");
        _$1.put("PDATE", "pdate");
        _$1.put("SECOND", "second");
        _$1.put("TIME", "time");
        _$1.put("WORKDAY", "workday");
        _$1.put("YEAR", "year");
        _$1.put("IFDATE", "ifdate");
        _$1.put("IFTIME", "iftime");
        _$1.put("IF", "if");
        _$1.put("CASE", "case");
    }
}

