/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.MultipathCursors;
import com.scudata.dm.query.sqlplus.And;
import com.scudata.dm.query.sqlplus.ITable;
import com.scudata.dm.query.sqlplus.ImplicitJoin;
import com.scudata.dm.query.sqlplus.Select;
import com.scudata.expression.Expression;
import com.scudata.util.CursorUtil;
import java.util.ArrayList;
import java.util.List;

class Join
extends ITable {
    private ITable left;
    private ITable right;
    private Type type;
    private Select.Exp on;
    private ArrayList<ITable> tableList = new ArrayList();
    private ArrayList<Select.Exp> leftExpList = new ArrayList();
    private ArrayList<Select.Exp> rightExpList = new ArrayList();
    private ArrayList<Select.Exp> leftFilterList = new ArrayList();
    private ArrayList<Select.Exp> rightFilterList = new ArrayList();
    private ArrayList<Select.Exp> xjoinFilterList = new ArrayList();
    private ITable sortedTable = null;

    public Join(Select select, Type type) {
        super(select);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Select.Exp getOn() {
        return this.on;
    }

    public void setOn(Select.Exp on) {
        this.on = on;
    }

    @Override
    public ITable getSortedTable() {
        return this.sortedTable;
    }

    public ITable getLeft() {
        return this.left;
    }

    public void setLeft(ITable left) {
        this.left = left;
    }

    public ITable getRight() {
        return this.right;
    }

    public void setRight(ITable right) {
        this.right = right;
    }

    @Override
    public DataStruct getDataStruct() {
        throw new RuntimeException();
    }

    @Override
    public void getAllTables(ArrayList<ITable> tableList) {
        this.left.getAllTables(tableList);
        this.right.getAllTables(tableList);
    }

    @Override
    public ITable getTable(String tableName) {
        ITable table = this.left.getTable(tableName);
        if (table != null) {
            return table;
        }
        return this.right.getTable(tableName);
    }

    @Override
    public ITable getTable(String tableName, String fieldName) {
        ITable table = this.left.getTable(tableName, fieldName);
        if (table != null) {
            return table;
        }
        return this.right.getTable(tableName, fieldName);
    }

    @Override
    public void addUsedField(String fieldName) {
        throw new RuntimeException();
    }

    private String[] createJoinFieldNames(ArrayList<ITable> tableList) {
        int count = tableList.size();
        String[] names = new String[count];
        String name = this.createJoinFieldName();
        int i = 0;
        while (i < count) {
            names[i] = String.valueOf(name) + "_" + (i + 1);
            ++i;
        }
        return names;
    }

    private Sequence xjoin(ArrayList<ITable> tableList) {
        String[] names = this.createJoinFieldNames(tableList);
        int count = tableList.size();
        Sequence[] datas = new Sequence[count];
        int i = 0;
        while (i < count) {
            Object data = tableList.get(i).getData();
            if (data instanceof Sequence) {
                datas[i] = (Sequence)data;
            } else if (data instanceof ICursor) {
                datas[i] = ((ICursor)data).fetch();
            }
            ++i;
        }
        i = 0;
        while (i < count) {
            tableList.get(i).setJoinFieldName(names[i]);
            ++i;
        }
        Context ctx = this.select.getContext();
        return Sequence.xjoin((Sequence[])datas, null, null, (String[])names, null, (Context)ctx);
    }

    private Select.Exp parseWhere(Select.Exp where) {
        if (where == null) {
            return null;
        }
        List<And> andList = where.splitAnd();
        ArrayList<Select.Exp> resultList = new ArrayList<Select.Exp>();
        boolean sign = true;
        for (And and : andList) {
            if (and.isSingleTable(this.right)) {
                this.rightFilterList.add(and.getExp());
                sign = false;
                continue;
            }
            if (and.containTable(this.right)) {
                resultList.add(and.getExp());
                continue;
            }
            this.leftFilterList.add(and.getExp());
            sign = false;
        }
        if (sign) {
            return where;
        }
        return this.select.toAndExp(resultList);
    }

    private void parseOn() {
        this.getAllTables(this.tableList);
        if (this.on == null) {
            return;
        }
        List<And> andList = this.on.splitAnd();
        for (And and : andList) {
            if (and.isSingleTable(this.right)) {
                this.rightFilterList.add(and.getExp());
                continue;
            }
            if (and.containTable(this.right)) {
                Select.Exp exp = and.getExp();
                this.xjoinFilterList.add(exp);
                if (this.leftExpList == null || exp.splitJionExp(this.tableList, this.leftExpList, this.rightExpList)) continue;
                this.leftExpList = null;
                this.rightExpList = null;
                continue;
            }
            this.leftFilterList.add(and.getExp());
        }
    }

    private Object leftJoin(Select.Exp where) {
        Sequence[] sequences;
        this.parseOn();
        Object leftData = this.getLeftData();
        Object rightData = this.getRightData();
        Context ctx = this.select.getContext();
        String joinFieldName = this.createJoinFieldName();
        Expression[] leftJoinExps = null;
        Expression[] rightJoinExps = null;
        if (this.leftExpList != null && this.leftExpList.size() > 0) {
            int fcount = this.leftExpList.size();
            leftJoinExps = new Expression[fcount];
            rightJoinExps = new Expression[fcount];
            int i = 0;
            while (i < fcount) {
                String spl = this.leftExpList.get(i).toSPL();
                leftJoinExps[i] = new Expression(ctx, spl);
                spl = this.rightExpList.get(i).toSPL();
                rightJoinExps[i] = new Expression(ctx, spl);
                ++i;
            }
        }
        if (leftJoinExps == null) {
            Sequence leftSeq = Join.toSequence(leftData);
            if (leftSeq == null) {
                return null;
            }
            Sequence rightSeq = Join.toSequence(rightData);
            sequences = new Sequence[]{leftSeq, rightSeq};
            String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
            Expression[] exps = new Expression[2];
            this.left.setJoinFieldName(names[0]);
            if (this.xjoinFilterList.size() > 0) {
                exps[1] = Join.toExpression(this.xjoinFilterList, ctx);
            }
            Table result = Sequence.xjoin((Sequence[])sequences, (Expression[])exps, null, (String[])names, (String)"1", (Context)ctx);
            this.right.setJoinFieldName(names[1]);
            if (where == null) {
                return result;
            }
            String spl = where.toSPL();
            Expression exp = new Expression(ctx, spl);
            return result.select(exp, null, ctx);
        }
        if (this.right.isPrimaryKey(rightJoinExps)) {
            ICursor leftCursor = Join.toCursor(leftData);
            if (leftCursor == null) {
                return null;
            }
            Expression[][] exps = new Expression[][]{leftJoinExps};
            Expression[][] codeExps = new Expression[][]{rightJoinExps};
            Expression[][] newExps = new Expression[][]{{new Expression("~")}};
            String[][] newNames = new String[][]{{joinFieldName}};
            if (this.right.isSortedFields(rightJoinExps) && this.left.isSortedFields(leftJoinExps)) {
                ICursor rightCursor = Join.toCursor(rightData);
                if (rightCursor == null) {
                    rightCursor = new MemoryCursor(null);
                }
                ICursor[] cursors = new ICursor[]{rightCursor};
                leftCursor = (ICursor)leftCursor.mergeJoinx(null, (Expression[][])exps, cursors, (Expression[][])codeExps, (Expression[][])newExps, newNames, null, ctx);
            } else {
                Sequence rightSequence = Join.toSequence(rightData);
                Sequence[] codes = new Sequence[]{rightSequence};
                leftCursor = (ICursor)leftCursor.join(null, null, (Expression[][])exps, codes, (Expression[][])codeExps, (Expression[][])newExps, newNames, null, ctx);
            }
            this.primaryKey = this.left.getPrimaryKey();
            this.sortedFieldNames = this.left.getSortedFieldNames();
            this.sortedTable = this.left.getSortedTable();
            this.right.setJoinFieldName(joinFieldName);
            if (where == null) {
                return leftCursor;
            }
            String spl = where.toSPL();
            Expression exp = new Expression(ctx, spl);
            return leftCursor.select(null, exp, null, ctx);
        }
        if (this.right.isSortedFields(rightJoinExps) && this.left.isSortedFields(leftJoinExps)) {
            ICursor leftCursor = Join.toCursor(leftData);
            if (leftCursor == null) {
                return null;
            }
            ICursor rightCursor = Join.toCursor(rightData);
            if (rightCursor == null) {
                rightCursor = new MemoryCursor(null);
            }
            ICursor[] cursors = new ICursor[]{leftCursor, rightCursor};
            String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
            Expression[][] exps = new Expression[][]{leftJoinExps, rightJoinExps};
            ICursor cs = CursorUtil.joinx((ICursor[])cursors, (String[])names, (Expression[][])exps, (String)"1", (Context)ctx);
            this.left.setJoinFieldName(names[0]);
            this.right.setJoinFieldName(names[1]);
            if (where == null) {
                return cs;
            }
            String spl = where.toSPL();
            Expression exp = new Expression(ctx, spl);
            return cs.select(null, exp, null, ctx);
        }
        Sequence leftSeq = Join.toSequence(leftData);
        if (leftSeq == null) {
            return null;
        }
        Sequence rightSeq = Join.toSequence(rightData);
        sequences = new Sequence[]{leftSeq, rightSeq};
        String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
        Expression[][] exps = new Expression[][]{leftJoinExps, rightJoinExps};
        Table result = Sequence.join((Sequence[])sequences, (Expression[][])exps, (String[])names, (String)"1", (Context)ctx);
        this.left.setJoinFieldName(names[0]);
        this.right.setJoinFieldName(names[1]);
        if (where == null) {
            return result;
        }
        String spl = where.toSPL();
        Expression exp = new Expression(ctx, spl);
        return result.select(exp, null, ctx);
    }

    private Object fullJoin(Select.Exp where) {
        this.parseOn();
        Object leftData = this.getLeftData();
        Object rightData = this.getRightData();
        Context ctx = this.select.getContext();
        String joinFieldName = this.createJoinFieldName();
        Expression[] leftJoinExps = null;
        Expression[] rightJoinExps = null;
        if (this.leftExpList != null && this.leftExpList.size() > 0) {
            int fcount = this.leftExpList.size();
            leftJoinExps = new Expression[fcount];
            rightJoinExps = new Expression[fcount];
            int i = 0;
            while (i < fcount) {
                String spl = this.leftExpList.get(i).toSPL();
                leftJoinExps[i] = new Expression(ctx, spl);
                spl = this.rightExpList.get(i).toSPL();
                rightJoinExps[i] = new Expression(ctx, spl);
                ++i;
            }
        }
        if (leftJoinExps == null) {
            throw new RQException("Unidentifiable full join.");
        }
        if (this.right.isSortedFields(rightJoinExps) && this.left.isSortedFields(leftJoinExps)) {
            ICursor rightCursor;
            ICursor leftCursor = Join.toCursor(leftData);
            if (leftCursor == null) {
                leftCursor = new MemoryCursor(null);
            }
            if ((rightCursor = Join.toCursor(rightData)) == null) {
                rightCursor = new MemoryCursor(null);
            }
            ICursor[] cursors = new ICursor[]{leftCursor, rightCursor};
            String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
            Expression[][] exps = new Expression[][]{leftJoinExps, rightJoinExps};
            ICursor cs = CursorUtil.joinx((ICursor[])cursors, (String[])names, (Expression[][])exps, (String)"f", (Context)ctx);
            this.left.setJoinFieldName(names[0]);
            this.right.setJoinFieldName(names[1]);
            if (where == null) {
                return cs;
            }
            String spl = where.toSPL();
            Expression exp = new Expression(ctx, spl);
            return cs.select(null, exp, null, ctx);
        }
        Sequence leftSeq = Join.toSequence(leftData);
        Sequence rightSeq = Join.toSequence(rightData);
        Sequence[] sequences = new Sequence[]{leftSeq, rightSeq};
        String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
        Expression[][] exps = new Expression[][]{leftJoinExps, rightJoinExps};
        Table result = Sequence.join((Sequence[])sequences, (Expression[][])exps, (String[])names, (String)"f", (Context)ctx);
        this.left.setJoinFieldName(names[0]);
        this.right.setJoinFieldName(names[1]);
        if (where == null) {
            return result;
        }
        String spl = where.toSPL();
        Expression exp = new Expression(ctx, spl);
        return result.select(exp, null, ctx);
    }

    static Object doFilter(Object data, String filter, Context ctx) {
        if (data instanceof Sequence) {
            Sequence seq = (Sequence)data;
            Expression exp = new Expression(ctx, filter);
            return seq.select(exp, null, ctx);
        }
        if (data instanceof ICursor) {
            ICursor cursor = (ICursor)data;
            Expression exp = new Expression(ctx, filter);
            return cursor.select(null, exp, null, ctx);
        }
        return null;
    }

    static ICursor toCursor(Object data) {
        if (data instanceof Sequence) {
            Sequence seq = (Sequence)data;
            return seq.cursor();
        }
        if (data instanceof ICursor) {
            return (ICursor)data;
        }
        return null;
    }

    static Sequence toSequence(Object data) {
        if (data instanceof Sequence) {
            return (Sequence)data;
        }
        if (data instanceof ICursor) {
            ICursor cursor = (ICursor)data;
            return cursor.fetch();
        }
        return null;
    }

    static Expression toExpression(ArrayList<Select.Exp> expList, Context ctx) {
        String spl = null;
        for (Select.Exp exp : expList) {
            spl = spl == null ? exp.toSPL() : String.valueOf(spl) + "&&" + exp.toSPL();
        }
        return new Expression(ctx, spl);
    }

    private String createJoinFieldName() {
        return "join" + this.hashCode();
    }

    private Object getLeftData() {
        Select.Exp filter = this.select.toAndExp(this.leftFilterList);
        return this.left.getData(filter);
    }

    private Object getRightData() {
        Select.Exp filter = this.select.toAndExp(this.rightFilterList);
        return this.right.getData(filter);
    }

    private boolean isSortedFields(Object data, Expression[] exps) {
        String[] sortedFieldNames;
        if (data instanceof MultipathCursors) {
            data = ((MultipathCursors)data).getCursors()[0];
        }
        if (data instanceof ICursor) {
            DataStruct ds;
            sortedFieldNames = ((ICursor)data).getSortFields();
            if (sortedFieldNames == null && (ds = ((ICursor)data).getDataStruct()) != null) {
                sortedFieldNames = ds.getPrimary();
            }
        } else {
            return false;
        }
        if (exps == null || sortedFieldNames == null || sortedFieldNames.length < exps.length) {
            return false;
        }
        int count = exps.length;
        boolean[] signs = new boolean[count];
        DataStruct ds = new DataStruct(sortedFieldNames);
        Expression[] expressionArray = exps;
        int n = exps.length;
        int n2 = 0;
        while (n2 < n) {
            Expression exp = expressionArray[n2];
            int findex = exp.getFieldIndex(ds);
            if (findex == -1 || findex >= count || signs[findex]) {
                return false;
            }
            signs[findex] = true;
            ++n2;
        }
        return true;
    }

    private Object innerJoin(Select.Exp where) {
        Expression[][] codeExps;
        Sequence[] sequences;
        where = this.parseWhere(where);
        this.parseOn();
        Object leftData = this.getLeftData();
        Object rightData = this.getRightData();
        Context ctx = this.select.getContext();
        String joinFieldName = this.createJoinFieldName();
        Expression[] leftJoinExps = null;
        Expression[] rightJoinExps = null;
        if (this.leftExpList != null && this.leftExpList.size() > 0) {
            int fcount = this.leftExpList.size();
            leftJoinExps = new Expression[fcount];
            rightJoinExps = new Expression[fcount];
            int i = 0;
            while (i < fcount) {
                String spl = this.leftExpList.get(i).toSPL();
                leftJoinExps[i] = new Expression(ctx, spl);
                spl = this.rightExpList.get(i).toSPL();
                rightJoinExps[i] = new Expression(ctx, spl);
                ++i;
            }
        }
        this.left.getPrimaryKey();
        this.right.getPrimaryKey();
        if (leftJoinExps == null) {
            Sequence leftSeq = Join.toSequence(leftData);
            if (leftSeq == null) {
                return null;
            }
            Sequence rightSeq = Join.toSequence(rightData);
            if (rightSeq == null) {
                return null;
            }
            sequences = new Sequence[]{leftSeq, rightSeq};
            String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
            Expression[] exps = new Expression[2];
            this.left.setJoinFieldName(names[0]);
            if (this.xjoinFilterList.size() > 0) {
                exps[1] = Join.toExpression(this.xjoinFilterList, ctx);
            }
            Table result = Sequence.xjoin((Sequence[])sequences, (Expression[])exps, null, (String[])names, null, (Context)ctx);
            this.right.setJoinFieldName(names[1]);
            if (where == null) {
                return result;
            }
            String spl = where.toSPL();
            Expression exp = new Expression(ctx, spl);
            return result.select(exp, null, ctx);
        }
        if (this.right.isPrimaryKey(rightJoinExps)) {
            ICursor leftCursor = Join.toCursor(leftData);
            if (leftCursor == null) {
                return null;
            }
            Expression[][] exps = new Expression[][]{leftJoinExps};
            codeExps = new Expression[][]{rightJoinExps};
            Expression[][] newExps = new Expression[][]{{new Expression("~")}};
            String[][] newNames = new String[][]{{joinFieldName}};
            if (this.isSortedFields(rightData, rightJoinExps) && this.isSortedFields(leftData, leftJoinExps)) {
                ICursor rightCursor = Join.toCursor(rightData);
                if (rightCursor == null) {
                    return null;
                }
                ICursor[] cursors = new ICursor[]{rightCursor};
                leftCursor = (ICursor)leftCursor.mergeJoinx(null, (Expression[][])exps, cursors, (Expression[][])codeExps, (Expression[][])newExps, newNames, "i", ctx);
            } else {
                Sequence rightSequence = Join.toSequence(rightData);
                if (rightSequence == null) {
                    return null;
                }
                Sequence[] codes = new Sequence[]{rightSequence};
                leftCursor = (ICursor)leftCursor.join(null, null, (Expression[][])exps, codes, (Expression[][])codeExps, (Expression[][])newExps, newNames, "i", ctx);
            }
            this.primaryKey = this.left.getPrimaryKey();
            this.sortedFieldNames = this.left.getSortedFieldNames();
            this.sortedTable = this.left.getSortedTable();
            this.right.setJoinFieldName(joinFieldName);
            if (where == null) {
                return leftCursor;
            }
            String spl = where.toSPL();
            Expression exp = new Expression(ctx, spl);
            return leftCursor.select(null, exp, null, ctx);
        }
        if (this.left.isPrimaryKey(leftJoinExps)) {
            ICursor rightCursor = Join.toCursor(rightData);
            if (rightCursor == null) {
                return null;
            }
            Expression[][] exps = new Expression[][]{rightJoinExps};
            codeExps = new Expression[][]{leftJoinExps};
            Expression[][] newExps = new Expression[][]{{new Expression("~")}};
            String[][] newNames = new String[][]{{joinFieldName}};
            if (this.isSortedFields(rightData, rightJoinExps) && this.isSortedFields(leftData, leftJoinExps)) {
                ICursor leftCursor = Join.toCursor(leftData);
                if (leftCursor == null) {
                    return null;
                }
                ICursor[] cursors = new ICursor[]{leftCursor};
                rightCursor = (ICursor)rightCursor.mergeJoinx(null, (Expression[][])exps, cursors, (Expression[][])codeExps, (Expression[][])newExps, newNames, "i", ctx);
            } else {
                Sequence leftSequence = Join.toSequence(leftData);
                if (leftSequence == null) {
                    return null;
                }
                Sequence[] codes = new Sequence[]{leftSequence};
                rightCursor = (ICursor)rightCursor.join(null, null, (Expression[][])exps, codes, (Expression[][])codeExps, (Expression[][])newExps, newNames, "i", ctx);
            }
            this.primaryKey = this.right.getPrimaryKey();
            this.sortedFieldNames = this.right.getSortedFieldNames();
            this.sortedTable = this.right.getSortedTable();
            this.left.setJoinFieldName(joinFieldName);
            if (where == null) {
                return rightCursor;
            }
            String spl = where.toSPL();
            Expression exp = new Expression(ctx, spl);
            return rightCursor.select(null, exp, null, ctx);
        }
        if (this.isSortedFields(rightData, rightJoinExps) && this.isSortedFields(leftData, leftJoinExps)) {
            ICursor leftCursor = Join.toCursor(leftData);
            if (leftCursor == null) {
                return null;
            }
            ICursor rightCursor = Join.toCursor(rightData);
            if (rightCursor == null) {
                return null;
            }
            ICursor[] cursors = new ICursor[]{leftCursor, rightCursor};
            String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
            Expression[][] exps = new Expression[][]{leftJoinExps, rightJoinExps};
            ICursor cs = CursorUtil.joinx((ICursor[])cursors, (String[])names, (Expression[][])exps, null, (Context)ctx);
            this.left.setJoinFieldName(names[0]);
            this.right.setJoinFieldName(names[1]);
            if (where == null) {
                return cs;
            }
            String spl = where.toSPL();
            Expression exp = new Expression(ctx, spl);
            return cs.select(null, exp, null, ctx);
        }
        Sequence leftSeq = Join.toSequence(leftData);
        if (leftSeq == null) {
            return null;
        }
        Sequence rightSeq = Join.toSequence(rightData);
        if (rightSeq == null) {
            return null;
        }
        sequences = new Sequence[]{leftSeq, rightSeq};
        String[] names = new String[]{String.valueOf(joinFieldName) + "_1", String.valueOf(joinFieldName) + "_2"};
        Expression[][] totalExps = new Expression[][]{leftJoinExps, rightJoinExps};
        Table result = Sequence.join((Sequence[])sequences, (Expression[][])totalExps, (String[])names, null, (Context)ctx);
        this.left.setJoinFieldName(names[0]);
        this.right.setJoinFieldName(names[1]);
        if (where == null) {
            return result;
        }
        String spl = where.toSPL();
        Expression exp = new Expression(ctx, spl);
        return result.select(exp, null, ctx);
    }

    private Object implicitJoin(Select.Exp where) {
        int rightIndex;
        ITable rightTable;
        int j;
        ITable rightTable2;
        ITable leftTable;
        int tableCount;
        this.getAllTables(this.tableList);
        if (where == null) {
            return this.xjoin(this.tableList);
        }
        if (this.tableList.size() == 2) {
            Join join = new Join(this.select, Type.INNER);
            join.setLeft(this.left);
            join.setRight(this.right);
            join.setOn(where);
            Object result = join.getData();
            this.primaryKey = join.getPrimaryKey();
            this.sortedFieldNames = join.getSortedFieldNames();
            this.sortedTable = join.getSortedTable();
            return result;
        }
        Context ctx = this.select.getContext();
        ArrayList<Select.FieldNode> fieldList = new ArrayList<Select.FieldNode>();
        where.getFields(fieldList);
        List<And> andList = where.splitAnd();
        String totalFilter = null;
        ArrayList<ImplicitJoin> joinList = new ArrayList<ImplicitJoin>();
        for (ITable table : this.tableList) {
            table.clearFilter();
        }
        block1: for (And and : andList) {
            String spl;
            if (!and.isTable(this.tableList)) continue;
            List<ITable> andTables = and.getTableList();
            tableCount = andTables.size();
            if (tableCount == 0) {
                spl = and.getExp().toSPL();
                if (totalFilter == null) {
                    totalFilter = spl;
                    continue;
                }
                totalFilter = String.valueOf(totalFilter) + "&&" + spl;
                continue;
            }
            if (tableCount == 1) {
                spl = and.getExp().toSPL();
                andTables.get(0).addFilter(spl);
                continue;
            }
            if (tableCount == 2) {
                ImplicitJoin join2;
                for (ImplicitJoin join2 : joinList) {
                    if (join2.putJoinRelation(and)) continue block1;
                }
                join2 = new ImplicitJoin(and);
                joinList.add(join2);
                continue;
            }
            Sequence result = this.xjoin(this.tableList);
            if (result == null) {
                return null;
            }
            String spl2 = where.toSPL();
            Expression exp = new Expression(ctx, spl2);
            return result.select(exp, null, ctx);
        }
        for (ImplicitJoin join : joinList) {
            join.analyzeDimTable();
        }
        ArrayList<ImplicitJoin> unknownJoinList = new ArrayList<ImplicitJoin>();
        int joinCount = joinList.size();
        int i = joinCount - 1;
        while (i >= 0) {
            ImplicitJoin join = (ImplicitJoin)joinList.get(i);
            if (!join.isRightDimTable()) {
                leftTable = join.getLeftTable();
                rightTable2 = join.getRightTable();
                j = 0;
                while (j < i) {
                    ImplicitJoin prevJoin = (ImplicitJoin)joinList.get(i);
                    if (leftTable != null && (leftTable == prevJoin.getLeftTable() || leftTable == prevJoin.getRightTable())) {
                        leftTable = null;
                    } else if (rightTable2 != null && (rightTable2 == prevJoin.getLeftTable() || rightTable2 == prevJoin.getRightTable())) {
                        rightTable2 = null;
                    }
                    ++j;
                }
                if (leftTable == null && rightTable2 == null) {
                    unknownJoinList.add(join);
                    joinList.remove(i);
                    --joinCount;
                }
            }
            --i;
        }
        i = 0;
        while (i < joinCount) {
            ImplicitJoin join = (ImplicitJoin)joinList.get(i);
            leftTable = join.getLeftTable();
            rightTable2 = join.getRightTable();
            j = 0;
            while (j < joinCount) {
                if (j != i) {
                    ImplicitJoin join2 = (ImplicitJoin)joinList.get(j);
                    if (join2.getLeftTable() == rightTable2) {
                        join.addRightTableJoin(join2);
                    } else if (join2.getLeftTable() == leftTable) {
                        join.addLeftTableJoin(join2);
                    }
                }
                ++j;
            }
            ++i;
        }
        String joinFieldName = this.createJoinFieldName();
        tableCount = this.tableList.size();
        Object[] datas = new Object[tableCount];
        block8: while (joinCount > 1) {
            int i2 = 0;
            while (i2 < joinCount) {
                block37: {
                    int rightIndex2;
                    ImplicitJoin join = (ImplicitJoin)joinList.get(i2);
                    rightTable = join.getRightTable();
                    int j2 = 0;
                    while (j2 < joinCount) {
                        if (j2 == i2 || ((ImplicitJoin)joinList.get(j2)).getLeftTable() != rightTable) {
                            ++j2;
                            continue;
                        }
                        break block37;
                    }
                    ITable leftTable2 = join.getLeftTable();
                    int leftIndex = this.tableList.indexOf(leftTable2);
                    if (datas[leftIndex] == null) {
                        datas[leftIndex] = leftTable2.getData();
                    }
                    if (datas[rightIndex2 = this.tableList.indexOf(rightTable)] == null) {
                        datas[rightIndex2] = rightTable.getData();
                    }
                    String fname = String.valueOf(joinFieldName) + "_" + joinCount;
                    datas[leftIndex] = join.join(datas[leftIndex], datas[rightIndex2], fname, ctx);
                    if (datas[leftIndex] == null) {
                        return null;
                    }
                    joinList.remove(i2);
                    --joinCount;
                    continue block8;
                }
                ++i2;
            }
        }
        ImplicitJoin join = (ImplicitJoin)joinList.get(0);
        ITable leftTable3 = join.getLeftTable();
        rightTable = join.getRightTable();
        int leftIndex = this.tableList.indexOf(leftTable3);
        if (datas[leftIndex] == null) {
            datas[leftIndex] = leftTable3.getData();
            if (join.isRightDimTable()) {
                this.primaryKey = leftTable3.getPrimaryKey();
                this.sortedFieldNames = leftTable3.getSortedFieldNames();
                this.sortedTable = leftTable3.getSortedTable();
            }
        }
        if (datas[rightIndex = this.tableList.indexOf(rightTable)] == null) {
            datas[rightIndex] = rightTable.getData();
        }
        String fname = String.valueOf(joinFieldName) + "_" + joinCount;
        Object result = join.join(datas[leftIndex], datas[rightIndex], fname, ctx);
        if (unknownJoinList.size() > 0) {
            String filter = null;
            for (ImplicitJoin unknownJoin : unknownJoinList) {
                ArrayList<And> list = unknownJoin.getAndList();
                for (And and : list) {
                    Select.Exp exp = and.getExp();
                    String spl = exp.toSPL();
                    filter = filter == null ? spl : String.valueOf(spl) + "&&" + filter;
                }
            }
            return Join.doFilter(result, filter, ctx);
        }
        return result;
    }

    @Override
    public Object getData(Select.Exp where) {
        if (this.type == Type.INNER) {
            return this.innerJoin(where);
        }
        if (this.type == Type.LEFT) {
            return this.leftJoin(where);
        }
        if (this.type == Type.FULL) {
            return this.fullJoin(where);
        }
        return this.implicitJoin(where);
    }

    @Override
    public void setJoinFieldName(String fieldName) {
        this.left.setJoinFieldName(fieldName);
        this.right.setJoinFieldName(fieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INNER,
        LEFT,
        FULL,
        IMPLICIT;

    }
}

