/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ConjxCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.query.sqlplus.IQuery;
import com.scudata.expression.Expression;
import com.scudata.util.CursorUtil;
import java.util.List;

class SetOperation
extends IQuery {
    private IQuery left;
    private IQuery right;
    private Type type;

    public SetOperation(Type type) {
        this.type = type;
    }

    @Override
    public IQuery dup() {
        SetOperation query = new SetOperation(this.type);
        query.left = this.left.dup();
        query.right = this.right.dup();
        return query;
    }

    public IQuery getLeft() {
        return this.left;
    }

    public void setLeft(IQuery left) {
        this.left = left;
    }

    public IQuery getRight() {
        return this.right;
    }

    public void setRight(IQuery right) {
        this.right = right;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void setColumnNames(List<String> columnNames) {
        this.left.setColumnNames(columnNames);
        this.right.setColumnNames(columnNames);
    }

    @Override
    public DataStruct getDataStruct() {
        DataStruct ds = this.left.getDataStruct();
        if (ds != null) {
            return ds;
        }
        return this.right.getDataStruct();
    }

    @Override
    public String[] getPrimaryKey() {
        return null;
    }

    @Override
    public String[] getSortedFieldNames() {
        return null;
    }

    @Override
    public Object execute() {
        Sequence seq2;
        Sequence seq1;
        Object data1 = this.left.execute();
        Object data2 = this.right.execute();
        if (data1 == null) {
            if (this.type == Type.UNIONALL || this.type == Type.UNION) {
                return data2;
            }
            return null;
        }
        if (data2 == null) {
            if (this.type == Type.INTERSECT) {
                return null;
            }
            return data1;
        }
        if (this.type == Type.UNIONALL) {
            ICursor[] cursors;
            if (data1 instanceof Sequence) {
                Sequence seq12 = (Sequence)data1;
                if (data2 instanceof Sequence) {
                    return seq12.append((Sequence)data2);
                }
                MemoryCursor cs1 = new MemoryCursor(seq12);
                cursors = new ICursor[]{cs1, (ICursor)data2};
            } else {
                ICursor cs1 = (ICursor)data1;
                if (data2 instanceof Sequence) {
                    MemoryCursor cs2 = new MemoryCursor((Sequence)data2);
                    cursors = new ICursor[]{cs1, cs2};
                } else {
                    cursors = new ICursor[]{cs1, (ICursor)data2};
                }
            }
            return new ConjxCursor(cursors);
        }
        if (data1 instanceof Sequence) {
            seq1 = (Sequence)data1;
        } else {
            seq1 = ((ICursor)data1).fetch();
            if (seq1 == null) {
                if (this.type == Type.UNION) {
                    return data2;
                }
                return null;
            }
        }
        if (data2 instanceof Sequence) {
            seq2 = (Sequence)data2;
        } else {
            seq2 = ((ICursor)data2).fetch();
            if (seq2 == null) {
                if (this.type == Type.INTERSECT) {
                    return null;
                }
                return seq1;
            }
        }
        Context ctx = new Context();
        Expression exp1 = new Expression(ctx, "~.array()");
        Expression exp2 = new Expression(ctx, "~.array()");
        if (this.type == Type.UNION) {
            return CursorUtil.union((Sequence)seq1, (Sequence)seq2, (Expression[])new Expression[]{exp1, exp2}, (Context)ctx);
        }
        if (this.type == Type.INTERSECT) {
            return CursorUtil.isect((Sequence)seq1, (Sequence)seq2, (Expression[])new Expression[]{exp1, exp2}, (Context)ctx);
        }
        return CursorUtil.diff((Sequence)seq1, (Sequence)seq2, (Expression[])new Expression[]{exp1, exp2}, (Context)ctx);
    }

    @Override
    public String toSPL() {
        String leftSPL = this.left.toSPL();
        String rightSPL = this.right.toSPL();
        if (this.type == Type.UNIONALL) {
            return "[" + leftSPL + "," + rightSPL + "].conj()";
        }
        String opt = "o";
        opt = this.type == Type.UNION ? String.valueOf(opt) + "u" : (this.type == Type.INTERSECT ? String.valueOf(opt) + "i" : String.valueOf(opt) + "d");
        return "[" + leftSPL + "," + rightSPL + "].merge@" + opt + "(~.array())";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        UNION,
        UNIONALL,
        INTERSECT,
        MINUS;

    }
}

