/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.query.sqlplus.ITable;
import com.scudata.dm.query.sqlplus.Select;
import com.scudata.expression.Expression;
import com.scudata.pseudo.Pseudo;

class TableNode
extends ITable {
    private String name;
    private Pseudo pseudo;
    private String[] fieldNames;
    private boolean[] fieldSigns;

    public TableNode(Select select, String tableName, Pseudo pseudo) {
        super(select);
        this.name = tableName;
        this.pseudo = (Pseudo)((Object)pseudo.clone(select.getContext()));
        this.primaryKey = pseudo.getPrimaryKey();
        this.sortedFieldNames = pseudo.getSortedColNames();
        this.fieldNames = pseudo.getDataStruct().getFieldNames();
        this.fieldSigns = new boolean[this.fieldNames.length];
    }

    Pseudo getPseudo() {
        return this.pseudo;
    }

    void setPseudo(Pseudo pseudo) {
        this.pseudo = pseudo;
    }

    @Override
    public DataStruct getDataStruct() {
        return this.pseudo.getDataStruct();
    }

    @Override
    public ITable getTable(String tableName, String fieldName) {
        if (tableName != null) {
            if (this.aliasName != null) {
                if (Select.isEquals(this.aliasName, tableName)) {
                    return this;
                }
                return null;
            }
            if (Select.isEquals(this.name, tableName)) {
                return this;
            }
            return null;
        }
        DataStruct ds = this.getDataStruct();
        int findex = Select.getFieldIndex(ds, fieldName);
        if (findex != -1) {
            return this;
        }
        return null;
    }

    @Override
    public ITable getTable(String tableName) {
        if (this.aliasName != null) {
            if (Select.isEquals(this.aliasName, tableName)) {
                return this;
            }
            return null;
        }
        if (Select.isEquals(this.name, tableName)) {
            return this;
        }
        return null;
    }

    @Override
    public void addUsedField(String fieldName) {
        if (fieldName == null) {
            int f = 0;
            int fcount = this.fieldSigns.length;
            while (f < fcount) {
                this.fieldSigns[f] = true;
                ++f;
            }
            return;
        }
        String[] fieldNames = this.fieldNames;
        int f = 0;
        int fcount = fieldNames.length;
        while (f < fcount) {
            if (Select.isEquals(fieldNames[f], fieldName)) {
                this.fieldSigns[f] = true;
                return;
            }
            ++f;
        }
        throw new RuntimeException();
    }

    @Override
    public Object getData() {
        Pseudo pseudo = this.pseudo;
        if (this.filter != null) {
            Context ctx = this.select.getContext();
            Expression exp = new Expression(ctx, this.filter);
            pseudo = (Pseudo)pseudo.select(null, exp, null, ctx);
        }
        String[] fieldNames = this.fieldNames;
        boolean[] fieldSigns = this.fieldSigns;
        int fcount = fieldNames.length;
        int selectCount = 0;
        boolean[] blArray = fieldSigns;
        int n = fieldSigns.length;
        int n2 = 0;
        while (n2 < n) {
            boolean sign = blArray[n2];
            if (sign) {
                ++selectCount;
            }
            ++n2;
        }
        String[] selectFields = new String[selectCount];
        int i = 0;
        int q = 0;
        while (i < fcount) {
            if (fieldSigns[i]) {
                selectFields[q++] = fieldNames[i];
            }
            ++i;
        }
        return pseudo.cursor(null, selectFields);
    }

    @Override
    public Object getData(Select.Exp where) {
        Pseudo pseudo = this.pseudo;
        if (where != null) {
            String spl = where.toSPL();
            Context ctx = this.select.getContext();
            Expression exp = new Expression(ctx, spl);
            pseudo = (Pseudo)pseudo.select(null, exp, null, ctx);
        } else if (this.filter != null) {
            Context ctx = this.select.getContext();
            Expression exp = new Expression(ctx, this.filter);
            pseudo = (Pseudo)pseudo.select(null, exp, null, ctx);
        }
        String[] fieldNames = this.fieldNames;
        boolean[] fieldSigns = this.fieldSigns;
        int fcount = fieldNames.length;
        int selectCount = 0;
        boolean[] blArray = fieldSigns;
        int n = fieldSigns.length;
        int n2 = 0;
        while (n2 < n) {
            boolean sign = blArray[n2];
            if (sign) {
                ++selectCount;
            }
            ++n2;
        }
        String[] selectFields = new String[selectCount];
        int i = 0;
        int q = 0;
        while (i < fcount) {
            if (fieldSigns[i]) {
                selectFields[q++] = fieldNames[i];
            }
            ++i;
        }
        return pseudo.cursor(null, selectFields);
    }
}

