/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.sqlplus;

import com.scudata.dm.query.sqlplus.Tokenizer;

final class Token {
    private String id;
    private String origin;
    private int pos;
    private char type;

    public Token(char type, String id, int pos, String origin) {
        this.type = type;
        this.id = id;
        this.pos = pos;
        this.origin = origin;
    }

    public boolean isKeyWord() {
        return this.type == '\u0000';
    }

    public boolean isNumber() {
        return this.type == '\u0002';
    }

    public int getPos() {
        return this.pos;
    }

    public void setType(char type) {
        this.type = type;
    }

    public char getType() {
        return this.type;
    }

    public void setString(String str) {
        this.id = str;
    }

    public void setOriginString(String str) {
        this.origin = str;
    }

    public String getString() {
        return this.id;
    }

    public String getOriginString() {
        return this.origin;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Token other) {
        return this.id.equals(other.id);
    }

    public boolean equals(String str) {
        return this.id.equals(str);
    }

    public boolean equalsIgnoreCase(String str) {
        return this.id.equalsIgnoreCase(str);
    }

    public boolean canHaveRightExp() {
        if (this.type == '\u0004' || this.type == '.') {
            return true;
        }
        return this.type == '\u0000' && Tokenizer.isOperatorKeyWord(this.id);
    }

    public boolean isKeyWord(String str) {
        return this.type == '\u0000' && this.id.equals(str);
    }

    public boolean isMergeKeyWord() {
        if (this.type != '\u0000') {
            return false;
        }
        return this.id.equals("UNION") || this.id.equals("INTERSECT") || this.id.equals("EXCEPT") || this.id.equals("MINUS");
    }

    public boolean isComma() {
        return this.type == ',';
    }

    public boolean isFromEnd() {
        if (this.type != '\u0000') {
            return false;
        }
        return this.id.equals("HAVING") || this.id.equals("ORDER") || this.id.equals("LIMIT") || this.id.equals("UNION");
    }

    public boolean isHavingEnd() {
        if (this.type != '\u0000') {
            return false;
        }
        return this.id.equals("ORDER") || this.id.equals("LIMIT");
    }

    public String getLevelName() {
        return this.id.substring(1);
    }

    public String getTableName() {
        return this.id.substring(1);
    }

    public void toExpression(StringBuffer out) {
        if (this.type == '\u0000') {
            if (this.id.equals("AND")) {
                out.append("&&");
            } else if (this.id.equals("OR")) {
                out.append("||");
            } else if (this.id.equals("NULL")) {
                out.append(" null ");
            } else {
                out.append(this.origin);
            }
        } else if (this.type == '?') {
            out.append(this.id);
        } else {
            out.append(this.origin);
        }
    }
}

