/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.utils;

import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.dm.query.metadata.DataMaintenanceTable;
import com.scudata.dm.query.metadata.Dictionary;
import com.scudata.dm.query.metadata.IJSONObject;
import com.scudata.dm.query.metadata.LogicMetaData;
import com.scudata.dm.query.metadata.Visibility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    public static LogicMetaData getLogicMetaDataFromJson(String json) throws JSONException {
        if (!StringUtils.isValidString((Object)json)) {
            return null;
        }
        LogicMetaData lmd = new LogicMetaData();
        lmd.setParamsFromJson(json);
        return lmd;
    }

    public static Dictionary getDictionaryFromJson(String json) throws JSONException {
        if (!StringUtils.isValidString((Object)json)) {
            return null;
        }
        Dictionary dct = new Dictionary();
        dct.setParamsFromJson(json);
        return dct;
    }

    public static Visibility getVisibilityFromJson(String json) throws JSONException {
        if (!StringUtils.isValidString((Object)json)) {
            return null;
        }
        Visibility vsb = new Visibility();
        vsb.setParamsFromJson(json);
        return vsb;
    }

    public static DataMaintenanceTable getDataMaintenanceTableFromJson(String json) throws JSONException {
        if (!StringUtils.isValidString((Object)json)) {
            return null;
        }
        DataMaintenanceTable table = new DataMaintenanceTable();
        table.setParamsFromJson(json);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJsonToStream(OutputStream os, String json) throws IOException {
        OutputStreamWriter ow = null;
        BufferedWriter bw = null;
        try {
            ow = new OutputStreamWriter(os, "UTF-8");
            bw = new BufferedWriter(ow);
            bw.write(json);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
            if (ow != null) {
                try {
                    ow.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readJsonFromStream(InputStream is) throws IOException {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String s;
            byte[] BOM = new byte[3];
            is.read(BOM);
            StringBuffer buf = new StringBuffer();
            if (BOM[0] != -17 || BOM[1] != -69 || BOM[2] != -65) {
                buf.append(new String(BOM, "UTF-8"));
            }
            isr = new InputStreamReader(is, "UTF-8");
            br = new BufferedReader(isr);
            while ((s = br.readLine()) != null) {
                buf.append(s);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void setList(JSONObject jo, String key, List list) {
        if (list != null) {
            try {
                jo.put(key, (Object)JsonUtils.toJSONArray(list));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public static void setStringArray(JSONObject jo, String key, String[] strs) {
        if (strs != null) {
            try {
                jo.put(key, (Object)JsonUtils.toJSONArray(strs));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public static JSONObject getJSONObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        try {
            return new JSONObject(o.toString());
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static Object getObject(JSONObject jo, String key) {
        try {
            return jo.get(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static String getString(JSONObject jo, String key) {
        try {
            return jo.getString(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static int getInt(JSONObject jo, String key) {
        try {
            return jo.getInt(key);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public static long getLong(JSONObject jo, String key) {
        try {
            return jo.getLong(key);
        }
        catch (JSONException e) {
            return 0L;
        }
    }

    public static byte getByte(JSONObject jo, String key) {
        try {
            return (byte)jo.getInt(key);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public static boolean getBoolean(JSONObject jo, String key) {
        try {
            return jo.getBoolean(key);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public static JSONArray toJSONArray(List list) {
        if (list != null) {
            JSONArray array = new JSONArray();
            for (Object o : list) {
                if (o == null) {
                    array.put(JSONObject.NULL);
                    continue;
                }
                if (o instanceof IJSONObject) {
                    try {
                        array.put((Object)new JSONObject(((IJSONObject)o).toJsonString()));
                    }
                    catch (Exception e) {}
                    continue;
                }
                array.put(o);
            }
            return array;
        }
        return null;
    }

    public static JSONArray toJSONArray(String[] strs) {
        if (strs != null) {
            JSONArray array = new JSONArray();
            for (String o : strs) {
                if (o == null) {
                    array.put((Object)"");
                    continue;
                }
                array.put((Object)o);
            }
            return array;
        }
        return null;
    }

    public static JSONArray toJSONArray(Sequence seq) {
        if (seq != null) {
            JSONArray array = new JSONArray();
            int len = seq.length();
            for (int i = 1; i <= len; ++i) {
                Object o = seq.get(i);
                if (o == null) {
                    array.put(JSONObject.NULL);
                    continue;
                }
                if (o instanceof IJSONObject) {
                    try {
                        array.put((Object)new JSONObject(((IJSONObject)o).toJsonString()));
                    }
                    catch (Exception e) {}
                    continue;
                }
                array.put(o);
            }
            return array;
        }
        return null;
    }
}

