/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm.query.utils;

import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Escape;
import com.scudata.common.StringUtils;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Section {
    public static final short POS_UP = 1;
    public static final short POS_DOWN = 2;
    public static final short POS_TOP = 3;
    public static final short POS_BOTTOM = 4;
    public Vector sections = new Vector();
    private boolean _$1 = false;

    public Section() {
        this(false);
    }

    public Section(boolean allowSameSection) {
        this._$1 = allowSameSection;
    }

    public Section(Vector items) {
        this(items, false);
    }

    public Section(Vector items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        this.sections = (Vector)items.clone();
    }

    public Section(Set items) {
        this(items, false);
    }

    public Section(Set items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        Iterator all = items.iterator();
        while (all.hasNext()) {
            this.sections.add(all.next());
        }
    }

    public Section(Object[] items) {
        this(items, false);
    }

    public Section(Object[] items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            this.sections.add(items[i]);
        }
    }

    public Section(String items) {
        this(items, false);
    }

    public Section(String items, boolean allowSameSection) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        this.unionSection(items);
    }

    public Section(String items, char delim) {
        this(items, delim, false);
    }

    public Section(String items, char delim, boolean allowSameSection) {
        this(items, delim, allowSameSection, true);
    }

    public Section(String items, char delim, boolean allowSameSection, boolean removeEscape) {
        this(allowSameSection);
        if (items == null) {
            return;
        }
        this.unionSection(items, delim, removeEscape);
    }

    public void unionSection(String items) {
        this.unionSection(items, ',');
    }

    public void unionSection(String items, char delim) {
        this.unionSection(items, delim, true);
    }

    public void unionSection(String items, char delim, boolean removeEscape) {
        if (items == null) {
            return;
        }
        ArgumentTokenizer st = new ArgumentTokenizer(items, delim);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (removeEscape) {
                s = Escape.removeEscAndQuote((String)s);
            }
            this.addSection(s);
        }
    }

    public void addSection(String item) {
        if (!StringUtils.isValidString((Object)item)) {
            return;
        }
        if (this._$1 || !this.sections.contains(item)) {
            this.sections.add(item);
        }
    }

    public void insertSection(String item, int beforeIndex) {
        if (!StringUtils.isValidString((Object)item)) {
            return;
        }
        if (this._$1 || !this.sections.contains(item)) {
            this.sections.insertElementAt(item, beforeIndex);
        }
    }

    public void removeSection(String items) {
        if (items == null) {
            return;
        }
        ArgumentTokenizer st = new ArgumentTokenizer(items, ',');
        while (st.hasMoreTokens()) {
            this.sections.remove(st.nextToken());
        }
    }

    public Object remove(int index) {
        return this.sections.remove(index);
    }

    public void unionSection(Section items) {
        this.unionSection(items.toString());
    }

    public String toSectionString() {
        StringBuffer buf = new StringBuffer(1024);
        for (int i = 0; i < this.sections.size(); ++i) {
            buf.append(',');
            buf.append(Escape.addEscAndQuote((String)((String)this.sections.get(i))));
        }
        if (buf.length() == 0) {
            return "";
        }
        return buf.substring(1);
    }

    public String toString() {
        return this.toString(',');
    }

    public String toString(char delim) {
        StringBuffer buf = new StringBuffer(1024);
        for (int i = 0; i < this.sections.size(); ++i) {
            buf.append(delim);
            buf.append(this.sections.get(i));
        }
        if (buf.length() == 0) {
            return "";
        }
        return buf.substring(1);
    }

    public String getSection(int i) {
        if (this.sections.size() == 0) {
            return "";
        }
        if (i < 0 || i >= this.sections.size()) {
            return "";
        }
        return this.sections.get(i).toString();
    }

    public String get(int i) {
        return this.getSection(i);
    }

    public int indexOf(String section) {
        return this.sections.indexOf(section);
    }

    public Section extractSubSection(int[] indexes) {
        Section sRtn = new Section();
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] >= this.sections.size()) continue;
            sRtn.unionSection((String)this.sections.get(indexes[i]));
        }
        return sRtn;
    }

    public void replaceSection(int index, String newItem) {
        this.sections.set(index, newItem);
    }

    public int rePositionSection(int index, short posCMD) {
        return 1;
    }

    public boolean containsSection(String item) {
        return this.sections.contains(item);
    }

    public int countSection() {
        return this.sections.size();
    }

    public int size() {
        return this.sections.size();
    }

    public int clear() {
        this.sections.clear();
        return 1;
    }

    public Vector toVector() {
        return this.sections;
    }

    public String[] toStringArray() {
        Object[] oa = this.sections.toArray();
        String[] sa = new String[oa.length];
        for (int i = 0; i < oa.length; ++i) {
            sa[i] = ((String)oa[i]).trim();
        }
        return sa;
    }
}

